/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAssociationRoleNameMap;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRPropertyElementTypeScope;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRType;
import java.util.ArrayList;

public class ClassTypeFlatteningPostProcessor {
    private static final String PATH_SEPARATOR = " | ";
    private MIRStoreModel model = null;
    private ArrayList<MIRClass> classesToKill = new ArrayList();
    private ArrayList<MIRFeature> featuresToKill = new ArrayList();
    private short position;

    public ClassTypeFlatteningPostProcessor(MIRStoreModel mIRStoreModel) {
        this.model = mIRStoreModel;
    }

    public void process() {
        for (MIRDesignPackage mIRPackage : this.model.getDesignPackages()) {
            this.processPackage(mIRPackage);
        }
        for (MIRDataPackage mIRDataPackage : this.model.getDataPackages()) {
            if (!mIRDataPackage.isInstanceOf((short)72)) continue;
            this.processPackage(mIRDataPackage);
        }
        this.cleanClasses();
    }

    private void processPackage(MIRDesignPackage mIRDesignPackage) {
        for (MIRNamespaceElement mIRNamespaceElement : mIRDesignPackage.getNamespaceElements()) {
            if (mIRNamespaceElement.getElementType() != 13) continue;
            MIRClass mIRClass = (MIRClass)mIRNamespaceElement;
            if (mIRClass.getClassType() == null) {
                this.processEntryClass(mIRClass);
                continue;
            }
            this.classesToKill.add(mIRClass);
        }
    }

    private void processPackage(MIRDataPackage mIRDataPackage) {
        for (MIRNamespaceElement mIRNamespaceElement : mIRDataPackage.getNamespaceElements()) {
            if (mIRNamespaceElement.getElementType() != 13) continue;
            MIRClass mIRClass = (MIRClass)mIRNamespaceElement;
            if (mIRClass.getClassType() == null) {
                this.processEntryClass(mIRClass);
                continue;
            }
            this.classesToKill.add(mIRClass);
        }
    }

    private void processEntryClass(MIRClass mIRClass) {
        this.position = 1;
        for (MIRFeature mIRFeature : mIRClass.getFeatureByPosition()) {
            this.processFeatureRecurcive(mIRClass, mIRFeature, mIRFeature.getName(), mIRFeature.getPhysicalName());
        }
    }

    private void processFeatureRecurcive(MIRClass mIRClass, MIRFeature mIRFeature, String string, String string2) {
        MIRType mIRType = mIRFeature.getType();
        if (this.isComplexType(mIRType)) {
            MIRClassType mIRClassType;
            MIRNamespaceElement mIRNamespaceElement;
            this.featuresToKill.add(mIRFeature);
            if (mIRFeature.getType() instanceof MIRDerivedType) {
                mIRNamespaceElement = (MIRDerivedType)mIRFeature.getType();
                mIRClassType = (MIRClassType)((MIRDerivedType)mIRNamespaceElement).getArrayOfType();
            } else {
                mIRClassType = (MIRClassType)mIRType;
            }
            mIRNamespaceElement = mIRClassType.getAssociatedClass();
            while (((MIRClass)mIRNamespaceElement).getAssociationRoles().iterator().hasNext()) {
                MIRAssociationRole mIRAssociationRole = (MIRAssociationRole)((MIRClass)mIRNamespaceElement).getAssociationRoles().iterator().next();
                mIRAssociationRole.removeAssociatedClass();
                mIRAssociationRole.addAssociatedClass(mIRClass);
            }
            for (MIRFeature mIRFeature2 : ((MIRClassifier)mIRNamespaceElement).getFeatureByPosition()) {
                this.processFeatureRecurcive(mIRClass, mIRFeature2, string + PATH_SEPARATOR + mIRFeature2.getName(), string2 + PATH_SEPARATOR + mIRFeature2.getPhysicalName());
            }
        } else {
            this.copyFeature(mIRClass, mIRFeature, string, string2);
        }
    }

    private boolean isComplexType(MIRType mIRType) {
        return mIRType instanceof MIRClassType || mIRType instanceof MIRDerivedType && ((MIRDerivedType)mIRType).getArrayOfType() instanceof MIRClassType;
    }

    private void copyUdps(MIRModelObject mIRModelObject, MIRModelObject mIRModelObject2) {
        while (mIRModelObject.getPropertyValues().iterator().hasNext()) {
            MIRPropertyValue mIRPropertyValue = (MIRPropertyValue)mIRModelObject.getPropertyValues().iterator().next();
            MIRPropertyType mIRPropertyType = mIRPropertyValue.getPropertyType();
            MIRPropertyElementTypeScope mIRPropertyElementTypeScope = MIRUdpLib.fetchPropertyElementTypeScope(this.model, mIRModelObject2.getElementType(), true);
            if (!mIRPropertyType.getPropertyElementTypeScope().equals(mIRPropertyElementTypeScope)) {
                mIRPropertyType.removePropertyElementTypeScope();
                mIRPropertyType.addPropertyElementTypeScope(mIRPropertyElementTypeScope);
            }
            mIRPropertyValue.removeElement();
            mIRModelObject2.addPropertyValue(mIRPropertyValue);
        }
    }

    private void copyFeature(MIRClass mIRClass, MIRFeature mIRFeature, String string, String string2) {
        if (mIRFeature.getClassifier() != mIRClass) {
            Object object;
            MIRAttribute mIRAttribute = (MIRAttribute)mIRFeature.clone();
            this.copyUdps(mIRFeature, mIRAttribute);
            mIRAttribute.setName(string);
            short s = this.position;
            this.position = (short)(s + 1);
            mIRAttribute.setPosition(s);
            mIRAttribute.addType(mIRFeature.getType());
            if (!mIRFeature.getPhysicalName().equals("")) {
                mIRAttribute.setPhysicalName(string2);
            }
            mIRClass.addFeature(mIRAttribute);
            while (((MIRAttribute)mIRFeature).getSourceOfAssociationRoleNameMaps().iterator().hasNext()) {
                object = (MIRAssociationRoleNameMap)((MIRAttribute)mIRFeature).getSourceOfAssociationRoleNameMaps().iterator().next();
                ((MIRAssociationRoleNameMap)object).removeSourceAttribute();
                mIRAttribute.addSourceOfAssociationRoleNameMap((MIRAssociationRoleNameMap)object);
            }
            while (((MIRAttribute)mIRFeature).getDestinationOfAssociationRoleNameMaps().iterator().hasNext()) {
                object = (MIRAssociationRoleNameMap)((MIRAttribute)mIRFeature).getDestinationOfAssociationRoleNameMaps().iterator().next();
                ((MIRAssociationRoleNameMap)object).removeDestinationAttribute();
                mIRAttribute.addDestinationOfAssociationRoleNameMap((MIRAssociationRoleNameMap)object);
            }
            for (MIRKey mIRKey : ((MIRAttribute)mIRFeature).getKeys()) {
                Object object2;
                MIRKey mIRKey2;
                MIRKey mIRKey3;
                MIRKey mIRKey4 = (MIRKey)mIRKey.clone();
                mIRKey4.addAssociatedClass(mIRClass);
                mIRAttribute.addKey(mIRKey4);
                if (mIRKey4 instanceof MIRCandidateKey) {
                    mIRKey3 = (MIRCandidateKey)mIRKey4;
                    mIRKey2 = (MIRCandidateKey)mIRKey;
                    while (((MIRCandidateKey)mIRKey2).getForeignKeys().iterator().hasNext()) {
                        object2 = (MIRForeignKey)((MIRCandidateKey)mIRKey2).getForeignKeys().iterator().next();
                        ((MIRForeignKey)object2).removeCandidateKey();
                        ((MIRCandidateKey)mIRKey3).addForeignKey((MIRForeignKey)object2);
                    }
                }
                if (!(mIRKey4 instanceof MIRForeignKey)) continue;
                mIRKey3 = (MIRForeignKey)mIRKey4;
                mIRKey2 = (MIRForeignKey)mIRKey;
                ((MIRForeignKey)mIRKey3).addCandidateKey(((MIRForeignKey)mIRKey2).getCandidateKey());
                for (MIRAssociationRoleNameMap mIRAssociationRoleNameMap : ((MIRForeignKey)mIRKey2).getAssociationRoleNameMaps()) {
                    MIRAssociationRoleNameMap mIRAssociationRoleNameMap2 = (MIRAssociationRoleNameMap)mIRAssociationRoleNameMap.clone();
                    if (mIRAssociationRoleNameMap.getSourceAttribute().equals(mIRFeature)) {
                        mIRAssociationRoleNameMap2.addSourceAttribute(mIRAttribute);
                        mIRAssociationRoleNameMap2.addDestinationAttribute(mIRAssociationRoleNameMap.getDestinationAttribute());
                    } else {
                        mIRAssociationRoleNameMap2.addSourceAttribute(mIRAssociationRoleNameMap.getSourceAttribute());
                        mIRAssociationRoleNameMap2.addDestinationAttribute(mIRAttribute);
                    }
                    ((MIRForeignKey)mIRKey3).addAssociationRoleNameMap(mIRAssociationRoleNameMap2);
                }
                object2 = ((MIRForeignKey)mIRKey2).getAssociationRole();
                if (((MIRForeignKey)mIRKey2).getAssociationRole() == null) continue;
                ((MIRAssociationRole)object2).removeForeignKey();
                ((MIRAssociationRole)object2).addForeignKey((MIRForeignKey)mIRKey3);
                ((MIRAssociationRole)object2).removeAssociatedClass();
                ((MIRAssociationRole)object2).addAssociatedClass(mIRClass);
            }
        } else {
            mIRFeature.setName(string);
            short s = this.position;
            this.position = (short)(s + 1);
            mIRFeature.setPosition(s);
            if (!mIRFeature.getPhysicalName().equals("")) {
                mIRFeature.setPhysicalName(string2);
            }
        }
    }

    private void cleanClasses() {
        for (MIRFeature mIRModelObject : this.featuresToKill) {
            mIRModelObject.delete();
        }
        for (MIRClass mIRClass : this.classesToKill) {
            mIRClass.getClassType().delete();
            mIRClass.delete();
        }
    }
}

