/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.util.impl;

import com.sas.midtier.components.container.util.impl.ComponentsUtil;
import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.SASProfileInterface;
import com.sas.services.ServiceException;
import com.sas.services.session.LockingException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.webapp.util.SessionFacade;
import com.sas.webapp.util.res.RB;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionFacadeImpl
implements SessionFacade,
Serializable,
HttpSessionBindingListener {
    private static final long serialVersionUID = 423787210423189031L;
    private static final String _loggingContext = SessionFacadeImpl.class.getName();
    private transient HttpSession _session;
    protected transient ServletContext _servletContext;
    private Map _map;
    private UserContextInterface _userContext;
    private UserContextInterface _privUserContext;
    private SessionContextInterface _localSessionContext;
    private SessionContextInterface _remoteSessionContext;
    private Object _localSessionLock;
    private static final String SESSION_LOCKID = "SESSION_LOCKID.com.sas.services.session.SessionContextInterface";
    private Locale _locale;

    public SessionFacadeImpl(HttpSession session) {
        this._session = session;
        this._servletContext = this._session.getServletContext();
        session.setAttribute("SESSION_FACADE", (Object)this);
    }

    public static SessionFacade getSessionFacade(HttpSession session) {
        SessionFacade retval = (SessionFacade)session.getAttribute("SESSION_FACADE");
        return retval;
    }

    @Override
    public String getSessionId() {
        if (this._session != null) {
            return this._session.getId();
        }
        return "no.session";
    }

    @Override
    public UserContextInterface getUserContext() {
        return this._userContext;
    }

    @Override
    public void setUserContext(UserContextInterface userContext) {
        if (this._userContext != null) {
            String msg = RB.getStringResource("wai.user.context.not.null.txt", Locale.getDefault());
            this.getLogger().error(msg);
        } else {
            this._userContext = userContext;
        }
    }

    @Override
    public SessionContextInterface getLocalSessionContext() {
        return this._localSessionContext;
    }

    @Override
    public SessionContextInterface getRemoteSessionContext() {
        return this._remoteSessionContext;
    }

    @Override
    public void setLocalSessionContext(SessionContextInterface localSessionContext) throws IllegalStateException, RemoteException {
        if (this._localSessionContext != null) {
            String msg = RB.getStringResource("wai.sessionContext.not.null.txt", Locale.getDefault());
            this.getLogger().error(msg);
        } else {
            this._localSessionContext = localSessionContext;
            this._localSessionLock = this._localSessionContext.lock(SESSION_LOCKID);
        }
    }

    @Override
    public void setRemoteSessionContext(SessionContextInterface remoteSessionContext) throws IllegalStateException, RemoteException {
        if (this._remoteSessionContext != null) {
            String msg = RB.getStringResource("wai.remoteSessionContext.not.null.txt", Locale.getDefault());
            this.getLogger().error(msg);
        } else {
            this._remoteSessionContext = remoteSessionContext;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getUserContext() == null && this.getLocalSessionContext() == null;
    }

    @Override
    public SASProfileInterface getProfile() {
        SASProfileInterface sasProfile = null;
        UserContextInterface userContext = this.getUserContext();
        try {
            if (userContext != null && userContext.getProfile() != null) {
                sasProfile = (SASProfileInterface)userContext.getProfile().getProfile("SAS");
            }
        }
        catch (ServiceException e) {
            String msg = RB.getStringResource("wai.unable.to.get.sasProfile.txt", Locale.getDefault());
            this.getLogger().error(msg);
        }
        catch (RemoteException e) {
            String msg = RB.getStringResource("wai.unable.to.get.sasProfile.txt", Locale.getDefault());
            this.getLogger().error(msg);
        }
        return sasProfile;
    }

    @Override
    public void refreshProfile() throws RemoteException, ServiceException {
        this.getProfile().refresh();
    }

    public void valueBound(HttpSessionBindingEvent arg0) {
    }

    public void valueUnbound(HttpSessionBindingEvent arg0) {
        this.destroy();
    }

    @Override
    public void destroy() {
        try {
            if (this._localSessionContext != null) {
                if (this._localSessionLock != null) {
                    this._localSessionContext.unlock(this._localSessionLock);
                }
                try {
                    this._localSessionContext.destroy();
                }
                catch (LockingException lockingException) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this._userContext != null) {
                this._userContext.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this._privUserContext != null) {
                this._privUserContext.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._localSessionContext = null;
        this._localSessionLock = null;
        this._remoteSessionContext = null;
        this._userContext = null;
        this._privUserContext = null;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    @Override
    public Logger getUserLogger() throws RemoteException {
        Logger retval = null;
        if (this._userContext != null) {
            retval = LogManager.getLogger((Class)this._userContext.getClass());
        }
        return retval;
    }

    protected Object getAttribute(String attrName) {
        Object retval = null;
        if (this._session != null) {
            retval = this._session.getAttribute(attrName);
        } else if (this._map != null) {
            retval = this._map.get(attrName);
        } else {
            String msg = RB.getStringResource("wai.session.and.map.not.set.txt", Locale.getDefault());
            throw new IllegalStateException(msg);
        }
        return retval;
    }

    protected void setAttribute(String attrName, Object attrVal) {
        if (this._session != null) {
            this._session.setAttribute(attrName, attrVal);
        } else if (this._map != null) {
            this._map.put(attrName, attrVal);
        } else {
            String msg = RB.getStringResource("wai.session.and.map.not.set.txt", Locale.getDefault());
            throw new IllegalStateException(msg);
        }
    }

    private Logger getLogger() {
        Logger retval = null;
        retval = this._userContext != null ? LogManager.getLogger((Class)this._userContext.getClass()) : (Logger)ComponentsUtil.locateComponent(Logger.class, (ServletContext)this._servletContext);
        return retval;
    }

    public void setBrowserLocale(Locale browserLocale) {
        try {
            SASProfileInterface profile = this.getProfile();
            if (profile != null) {
                profile.setClientLocale(browserLocale);
            }
        }
        catch (RemoteException e) {
            this._servletContext.log(e.getMessage(), (Throwable)e);
        }
        catch (ConfigurationPropertiesException e) {
            this._servletContext.log(e.getMessage(), (Throwable)e);
        }
    }
}

