/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.themes;

import com.sas.webapp.i18n.RB;
import com.sas.webapp.themes.Image;
import com.sas.webapp.themes.Style;
import com.sas.webapp.themes.Template;
import com.sas.webapp.themes.ThemeConstants;
import com.sas.webapp.themes.ThemeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class Theme
implements ThemeConstants,
Serializable {
    static final long serialVersionUID = 7957820733157915083L;
    public static final String RB_KEY = "Theme.";
    private String uriPath;
    private HashMap map = null;
    private HashMap directories = null;
    private HashMap imageMap = null;
    private HashMap styleMap = null;
    private HashMap templateMap = null;
    private static final int SBSIZE = 100;
    private static final String keyConstant = "Theme.illegalconstant.txt";

    public Theme() {
    }

    public Theme(Map inMap) {
        this.setMap(inMap);
    }

    public void setMap(Map inMap) {
        Theme.checkForNull(inMap);
        this.map = new HashMap(inMap);
        this.directories = new HashMap((Map)this.map.get("directories"));
        this.imageMap = new HashMap((Map)this.map.get("imageMap"));
        this.styleMap = new HashMap((Map)this.map.get("styleMap"));
        this.templateMap = new HashMap((Map)this.map.get("templateMap"));
    }

    public String getName() {
        this.checkState();
        return (String)this.map.get("name");
    }

    public String getLabel() {
        this.checkState();
        return (String)this.map.get("label");
    }

    public String getDescription() {
        this.checkState();
        return (String)this.map.get("description");
    }

    public String getURIPath() {
        String mapVal;
        this.checkState();
        if (this.uriPath == null && (mapVal = (String)this.map.get("uripath")) != null) {
            String URLPrefix = (String)this.map.get("URLprefix");
            this.uriPath = URLPrefix != null ? URLPrefix + "/" + mapVal : mapVal;
        }
        return this.uriPath;
    }

    public String getDevice() {
        this.checkState();
        return (String)this.map.get("device");
    }

    public Image getImage(String name) {
        Image image = null;
        String[] array = (String[])this.imageMap.get(name);
        if (array != null) {
            image = new Image();
            image.setName(array[0]);
            image.setDescription(array[1]);
            image.setPath(array[2]);
            image.setAppliesTo(array[3]);
            image.setAltTextKey(array[4]);
            image.setWidth(array[5]);
            image.setHeight(array[6]);
            StringBuffer sb = new StringBuffer(100).append(this.getURIPath());
            sb.append("/");
            if (image.getPath() != null) {
                sb.append(image.getPath());
            } else {
                sb.append(this.getDirectory("IMAGE"));
            }
            sb.append("/").append(array[7]);
            image.setFile(sb.toString());
        }
        return image;
    }

    public Style getStyle(String name) {
        Style style = null;
        String[] array = (String[])this.styleMap.get(name);
        if (array != null) {
            style = new Style();
            style.setName(array[0]);
            style.setDescription(array[1]);
            style.setOrder(Integer.valueOf(array[2]));
            style.setMediaType(array[3]);
            StringBuffer sb = new StringBuffer(100).append(this.getURIPath());
            sb.append("/").append(this.getDirectory("STYLE")).append("/");
            sb.append(array[4]);
            style.setFile(sb.toString());
        }
        return style;
    }

    public Style getStyle(String name, boolean check) throws ThemeException {
        if (check) {
            if (this.isValidName("STYLE", name)) {
                return this.getStyle(name);
            }
            throw this.newThemeException(name);
        }
        return this.getStyle(name);
    }

    public Image getImage(String name, boolean check) throws ThemeException {
        if (check) {
            if (this.isValidName("IMAGE", name)) {
                return this.getImage(name);
            }
            throw this.newThemeException(name);
        }
        return this.getImage(name);
    }

    public Template getTemplate(String name, boolean check) throws ThemeException {
        if (check) {
            if (this.isValidName("TEMPLATE", name)) {
                return this.getTemplate(name);
            }
            throw this.newThemeException(name);
        }
        return this.getTemplate(name);
    }

    public Template getTemplate(String name) {
        Template template = null;
        String[] array = (String[])this.templateMap.get(name);
        if (array != null) {
            template = new Template();
            template.setName(array[0]);
            template.setDescription(array[1]);
            template.setMarkupLanguage(array[2]);
            StringBuffer sb = new StringBuffer(100).append(this.getURIPath());
            sb.append("/").append(this.getDirectory("TEMPLATE")).append("/");
            sb.append(array[3]);
            template.setFile(sb.toString());
        }
        return template;
    }

    public Collection getStyleSheets(String media) {
        Theme.checkForNull(media);
        if (!Theme.checkMediaType(media)) {
            String key = "Theme.illegalmedia.txt";
            throw new IllegalArgumentException(RB.getStringResource(key));
        }
        Collection output = null;
        if (this.styleMap != null && !this.styleMap.isEmpty()) {
            TreeMap<String, String> tree = new TreeMap<String, String>();
            Collection coll = this.styleMap.values();
            for (String[] element : coll) {
                if (!element[3].equalsIgnoreCase(media)) continue;
                Style style = this.getStyle(element[0]);
                tree.put(element[2], style.getFile());
            }
            if (!tree.isEmpty()) {
                output = tree.values();
            }
        }
        return output;
    }

    public boolean isValidName(String type, String name) {
        Theme.checkForNull(type);
        Theme.checkForNull(name);
        boolean result = false;
        if (type.equals("IMAGE")) {
            String nameWithoutPeriod = null;
            if (name.indexOf(".") >= 0) {
                nameWithoutPeriod = name.substring(0, name.lastIndexOf(46));
            }
            if (this.imageMap == null) {
                result = false;
            } else {
                result = this.imageMap.containsKey(name);
                if (!result && nameWithoutPeriod != null) {
                    result = this.imageMap.containsKey(nameWithoutPeriod);
                }
                if (!result) {
                    for (String aKey : this.imageMap.keySet()) {
                        if (aKey.equals(name)) {
                            result = true;
                        } else {
                            if (nameWithoutPeriod == null || !aKey.equals(nameWithoutPeriod)) continue;
                            result = true;
                        }
                        break;
                    }
                }
            }
        } else if (type.equals("STYLE")) {
            result = this.styleMap == null ? false : this.styleMap.containsKey(name);
        } else if (type.equals("TEMPLATE")) {
            result = this.templateMap == null ? false : this.templateMap.containsKey(name);
        } else {
            throw new IllegalArgumentException(RB.getStringResource(keyConstant));
        }
        return result;
    }

    public String getDirectory(String type) {
        this.checkState();
        Theme.checkForNull(type);
        if (!Theme.checkElementType(type)) {
            throw new IllegalArgumentException(RB.getStringResource(keyConstant));
        }
        return (String)this.directories.get(type);
    }

    public Collection getImageNames() {
        Set output = null;
        if (this.imageMap != null && !this.imageMap.isEmpty()) {
            output = this.imageMap.keySet();
        }
        return output;
    }

    public Collection getStyleNames() {
        Set output = null;
        if (this.styleMap != null && !this.styleMap.isEmpty()) {
            output = this.styleMap.keySet();
        }
        return output;
    }

    public Collection getTemplateNames() {
        Set output = null;
        if (this.templateMap != null && !this.templateMap.isEmpty()) {
            output = this.templateMap.keySet();
        }
        return output;
    }

    public String toString() {
        this.checkState();
        return this.getName() + " " + this.getLabel();
    }

    public Collection getAllImages() {
        ArrayList<Image> allImages = null;
        Collection names = this.getImageNames();
        if (names != null) {
            allImages = new ArrayList<Image>();
            Iterator it = names.iterator();
            while (it.hasNext()) {
                Image image = this.getImage((String)it.next());
                allImages.add(image);
            }
        }
        return allImages;
    }

    public Collection getAllStyles() {
        ArrayList<Style> allStyles = null;
        Collection names = this.getStyleNames();
        if (names != null) {
            allStyles = new ArrayList<Style>();
            Iterator it = names.iterator();
            while (it.hasNext()) {
                Style style = this.getStyle((String)it.next());
                allStyles.add(style);
            }
        }
        return allStyles;
    }

    public Collection getAllTemplates() {
        ArrayList<Template> allTemplates = null;
        Collection names = this.getTemplateNames();
        if (names != null) {
            allTemplates = new ArrayList<Template>();
            Iterator it = names.iterator();
            while (it.hasNext()) {
                Template template = this.getTemplate((String)it.next());
                allTemplates.add(template);
            }
        }
        return allTemplates;
    }

    public String getFullPath(String type) {
        String slash = "/";
        String path = this.getURIPath() + slash + this.getDirectory(type) + slash;
        return path;
    }

    public String getVersion() {
        this.checkState();
        return (String)this.map.get("version");
    }

    private static boolean checkElementType(String type) {
        boolean result = false;
        if (type.equals("IMAGE") || type.equals("STYLE") || type.equals("TEMPLATE")) {
            result = true;
        }
        return result;
    }

    private static boolean checkMediaType(String type) {
        boolean result = false;
        if (type.equals("SCREEN") || type.equals("PRINTER") || type.equals("ALL")) {
            result = true;
        }
        return result;
    }

    private static void checkForNull(Object arg) {
        if (arg == null) {
            throw new NullPointerException(RB.getStringResource(RB_KEY, "nullarg.txt"));
        }
    }

    private ThemeException newThemeException(String value) {
        String key = "Theme.error.000.txt";
        Object[] val = new Object[]{value};
        ThemeException te = new ThemeException("com.sas.webapp.i18n.Resources", key, val, this.getClass().getClassLoader());
        return te;
    }

    private void checkState() {
        if (this.map == null) {
            String key = "Theme.error.001.txt";
            throw new IllegalStateException(RB.getStringResource(key));
        }
    }
}

