/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.themes;

import com.sas.common.util.MetadataUtil;
import com.sas.common.util.ThemesRegistryInfo;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.webapp.i18n.RB;
import com.sas.webapp.themes.ThemeException;
import com.sas.webapp.themes.ThemesFactory;
import com.sas.webapp.themes.ThemesFactoryInitializer;
import com.sas.webapp.themes.util.ThemesDescriptorFetcher;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultThemesFactoryInitializer
implements ThemesFactoryInitializer {
    private final String _loggingContext = this.getClass().getName();
    static final int STATE_INIT = 0;
    static final int STATE_RUNNING = 1;
    static final int STATE_COMPLETED = 2;
    protected ThemesFactory _factory;
    private UserContextInterface _user;
    private int _maxRetries = 20;
    private int _retryWait = 4000;
    private int _socketTimeout = 30000;
    protected int _currentState = 0;
    private boolean _isLastFetcher = false;

    @Override
    public void setThemesFactory(ThemesFactory factory, UserContextInterface userContext) {
        this._factory = factory;
        this._user = userContext;
        this._factory.setInitializer(this);
    }

    @Override
    public ThemesFactory getThemesFactory() {
        return this._factory;
    }

    @Override
    public void init() throws ThemeException, RemoteException {
        this._currentState = 1;
        Map regisMap = null;
        try {
            regisMap = MetadataUtil.getThemesRegistry((List)MetadataUtil.findThemeMetadata((UserContextInterface)this._user));
        }
        catch (ServiceException s) {
            throw new ThemeException(s.getMessage(), s);
        }
        catch (RemoteException r) {
            throw new ThemeException(r.getMessage(), r);
        }
        Set set = regisMap.keySet();
        if (!set.isEmpty()) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                ThemesRegistryInfo info = (ThemesRegistryInfo)regisMap.get(iter.next());
                boolean bl = this._isLastFetcher = !iter.hasNext();
                if (info == null) continue;
                this.startFetcher(info, this._maxRetries, this._retryWait, LogManager.getLogger((Class)this._user.getClass()));
            }
        } else {
            String errorMsg = RB.getStringResource("ThemesFactory.emptyregistry.txt", Locale.getDefault());
            LogManager.getLogger((Class)this._user.getClass()).error("\n\n\n" + errorMsg + "\n\n\n", (Object)this._loggingContext);
            throw new ThemeException(errorMsg);
        }
    }

    @Override
    public boolean isFinished() {
        return this._currentState == 2;
    }

    @Override
    public boolean isRunning() {
        return this._currentState == 1;
    }

    @Override
    public void setParams(Map params) throws IllegalArgumentException {
        try {
            this._user = (UserContextInterface)params.get("metadataUser");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        if (this._user == null) {
            throw new IllegalArgumentException();
        }
        block7: for (int x = 0; x < 3; ++x) {
            Object param = null;
            switch (x) {
                case 0: {
                    param = params.get("maxRetries");
                    if (param == null) continue block7;
                    if (param instanceof String) {
                        this._maxRetries = Integer.parseInt(param);
                        continue block7;
                    }
                    if (!(param instanceof Integer)) continue block7;
                    this._maxRetries = param;
                    continue block7;
                }
                case 1: {
                    param = params.get("retryPause");
                    if (param == null) continue block7;
                    if (param instanceof String) {
                        this._retryWait = Integer.parseInt(param);
                        continue block7;
                    }
                    if (!(param instanceof Integer)) continue block7;
                    this._retryWait = param;
                    continue block7;
                }
                case 2: {
                    param = params.get("socketTimeout");
                    if (param == null) continue block7;
                    if (param instanceof String) {
                        this._socketTimeout = Integer.parseInt(param);
                        continue block7;
                    }
                    if (!(param instanceof Integer)) continue block7;
                    this._socketTimeout = param;
                }
            }
        }
    }

    @Override
    public void initTaskComplete() {
        if (this._isLastFetcher) {
            this._factory.finish();
            this._currentState = 2;
        }
    }

    @Override
    public void waitForFinish() {
        if (this._currentState == 0) {
            return;
        }
        while (this._currentState != 2) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void startFetcher(ThemesRegistryInfo info, int _maxRetries, int _retryWait, Logger logger) {
        ThemesDescriptorFetcher fetcher = new ThemesDescriptorFetcher(this, info, _maxRetries, _retryWait, logger);
        fetcher.run();
    }

    public int getSocketTimeout() {
        return this._socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this._socketTimeout = socketTimeout;
    }
}

