/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.themes;

import com.sas.midtier.components.container.util.impl.ComponentsUtil;
import com.sas.util.SimpleTemplate2;
import com.sas.webapp.i18n.RB;
import com.sas.webapp.servlet.util.ServletUtil;
import com.sas.webapp.themes.Image;
import com.sas.webapp.themes.Template;
import com.sas.webapp.themes.Theme;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.logging.log4j.Logger;

public final class BannerGenerator {
    private String globalMenu;
    private String breadCrumb1;
    private String breadCrumb2;
    private String breadCrumb3;
    private String preferencesMenu;
    private String searchMenu;
    private String logoffMenu;
    private String helpMenu;
    private String bannerTitle;
    private String bannerBackground;
    private String logo;
    private String templateString;
    private String secondaryTemplateString;
    private String userRole;
    public static final String RB_KEY = "BannerGenerator.";

    public BannerGenerator() {
    }

    public BannerGenerator(Theme theme, ServletContext context) throws IOException {
        this.setUpFromTheme(theme, context);
    }

    public BannerGenerator(Theme theme) throws IOException {
        this.setUpFromTheme(theme, null);
    }

    public String getBannerTitle() {
        return this.bannerTitle;
    }

    public String getBreadCrumb1() {
        return this.breadCrumb1;
    }

    public String getGlobalMenu() {
        return this.globalMenu;
    }

    public String getBreadCrumb2() {
        return this.breadCrumb2;
    }

    public String getBreadCrumb3() {
        return this.breadCrumb3;
    }

    public String getHelpMenu() {
        return this.helpMenu;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getLogoffMenu() {
        return this.logoffMenu;
    }

    public String getPreferencesMenu() {
        return this.preferencesMenu;
    }

    public String getSearchMenu() {
        return this.searchMenu;
    }

    public String getTemplateString() {
        return this.templateString;
    }

    public String getSecondaryTemplateString() {
        return this.secondaryTemplateString;
    }

    public void setBannerTitle(String string) {
        this.bannerTitle = string;
    }

    public void setBreadCrumb1(String string) {
        this.breadCrumb1 = string;
    }

    public void setGlobalMenu(String string) {
        this.globalMenu = string;
    }

    public void setBreadCrumb2(String string) {
        this.breadCrumb2 = string;
    }

    public void setBreadCrumb3(String string) {
        this.breadCrumb3 = string;
    }

    public void setHelpMenu(String string) {
        this.helpMenu = string;
    }

    public void setLogo(String string) {
        this.logo = string;
    }

    public void setLogoffMenu(String string) {
        this.logoffMenu = string;
    }

    public void setPreferencesMenu(String string) {
        this.preferencesMenu = string;
    }

    public void setSearchMenu(String string) {
        this.searchMenu = string;
    }

    public void setTemplateString(Template template, ServletContext context) throws IOException {
        BannerGenerator.checkForNull(template, "template");
        String tString = null;
        URL url = new URL(template.getFile());
        Logger logger = null;
        if (context != null) {
            logger = (Logger)ComponentsUtil.locateComponent(Logger.class, (ServletContext)context);
        }
        tString = ServletUtil.getThemeFileAsString(logger, url);
        this.setTemplateString(tString);
    }

    public void setTemplateString(String string) {
        this.templateString = string;
    }

    public void setSecondaryTemplateString(Template template, ServletContext context) throws IOException {
        BannerGenerator.checkForNull(template, "template");
        String tString = null;
        URL url = new URL(template.getFile());
        Logger logger = null;
        if (context != null) {
            logger = (Logger)ComponentsUtil.locateComponent(Logger.class, (ServletContext)context);
        }
        tString = ServletUtil.getThemeFileAsString(logger, url);
        this.setSecondaryTemplateString(tString);
    }

    public void setSecondaryTemplateString(String string) {
        this.secondaryTemplateString = string;
    }

    public String getBannerBackground() {
        return this.bannerBackground;
    }

    public void setBannerBackground(String string) {
        this.bannerBackground = string;
    }

    public void setUpFromTheme(Theme theme, ServletContext context) throws IOException {
        BannerGenerator.checkForNull(theme, "theme");
        if (theme.isValidName("TEMPLATE", "genericBanner")) {
            this.setTemplateString(theme.getTemplate("genericBanner"), context);
        }
        if (theme.isValidName("TEMPLATE", "secondarymenu")) {
            this.setSecondaryTemplateString(theme.getTemplate("secondarymenu"), context);
        }
        if (theme.isValidName("IMAGE", "logo")) {
            this.setLogo(theme.getImage("logo"));
        }
        if (theme.isValidName("IMAGE", "banner_background")) {
            this.setBannerBackground(theme.getImage("banner_background"));
        }
    }

    public void setLogo(Image image) {
        BannerGenerator.checkForNull(image, "image");
        StringBuffer buf = new StringBuffer(200);
        buf.append("<img src=\"").append(image.getFile()).append("\" width=\"").append(image.getWidth()).append("\" height=\"").append(image.getHeight()).append("\" border=\"0\" alt=\"" + image.getName() + "\" title=\"" + image.getName() + "\"/>");
        this.setLogo(buf.toString());
    }

    public void setBannerBackground(Image image) {
        BannerGenerator.checkForNull(image, "image");
        this.setBannerBackground(image.getFile());
    }

    public String toString() {
        if (this.getTemplateString() == null) {
            return null;
        }
        HashMap<String, String> dictionary = new HashMap<String, String>();
        if (this.getBreadCrumb1() != null) {
            dictionary.put("BREADCRUMB1", this.getBreadCrumb1());
        }
        if (this.getBreadCrumb2() != null) {
            dictionary.put("BREADCRUMB2", this.getBreadCrumb2());
        }
        if (this.getBreadCrumb3() != null) {
            dictionary.put("BREADCRUMB3", this.getBreadCrumb3());
        }
        if (this.getBannerBackground() != null) {
            dictionary.put("BANNER_BACKGROUND", this.getBannerBackground());
        }
        if (this.getBannerTitle() != null) {
            dictionary.put("BANNER_TITLE", this.getBannerTitle());
        }
        if (this.getLogo() != null) {
            dictionary.put("LOGO", this.getLogo());
        }
        if (this.getHelpMenu() != null) {
            dictionary.put("HELP_MENU", this.getHelpMenu());
        }
        if (this.getGlobalMenu() != null) {
            dictionary.put("GLOBAL_MENU", this.getGlobalMenu());
        }
        if (this.getLogoffMenu() != null) {
            dictionary.put("LOGOFF_MENU", this.getLogoffMenu());
        }
        if (this.getPreferencesMenu() != null) {
            dictionary.put("PREFERENCES_MENU", this.getPreferencesMenu());
        }
        if (this.getSearchMenu() != null) {
            dictionary.put("SEARCH_MENU", this.getSearchMenu());
        }
        if (this.getUserRole() != null) {
            dictionary.put("BANNER_USER_ROLE", this.getUserRole());
        }
        String tString = null;
        tString = this.getSecondaryTemplateString() != null ? this.getTemplateString() + this.getSecondaryTemplateString() : this.getTemplateString();
        SimpleTemplate2 t = new SimpleTemplate2(tString, dictionary);
        StringBuffer banner = new StringBuffer("<div id=\"banner\" class=\"bannerBackground\">");
        banner.append(t.format());
        return banner.toString();
    }

    private static void checkForNull(Object param, String name) {
        if (param == null) {
            throw new NullPointerException(MessageFormat.format(RB.getStringResource("general.nullparameter.fmt.txt"), name));
        }
    }

    public final String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String role, Locale locale) {
        BannerGenerator.checkForNull(locale, "locale");
        BannerGenerator.checkForNull(role, "role");
        this.userRole = MessageFormat.format(RB.getStringResource("BannerGenerator.role.marker.txt", locale), role);
    }
}

