/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.util;

import com.sas.midtier.components.container.util.impl.ComponentsUtil;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.webapp.ServicesFacade;
import com.sas.webapp.i18n.RB;
import com.sas.webapp.servlet.util.FileCache;
import com.sas.webapp.servlet.util.SASTemporaryLogger;
import com.sas.webapp.themes.Theme;
import com.sas.webapp.themes.ThemeException;
import com.sas.webapp.themes.ThemesFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServletUtil {
    public static final String RB_KEY = "ServletUtil.";
    private static final FileCache _fileCache = new FileCache();
    private static final Map _resourceLocks = new Hashtable();
    public static final String THEME_FALLBACK = "default";
    private static String THEME_PROXY_HOST = "sas.theme.http.proxyHost";
    private static String THEME_PROXY_PORT = "sas.theme.http.proxyPort";
    private static String _loggingContext = ServletUtil.class.getName();
    public static final String PRIV_USERID = "metadata-privilegeduserid";

    private ServletUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getFileAsString(ServletContext context, String filePath) throws IOException {
        Logger logger = (Logger)ComponentsUtil.locateComponent(Logger.class, (ServletContext)context);
        ServletUtil.checkForNull(context, "context");
        ServletUtil.checkForNull(filePath, "filePath");
        String retval = _fileCache.findFile(filePath);
        InputStream is = null;
        if (retval == null) {
            is = context.getResourceAsStream(filePath);
            try {
                if (is != null) {
                    retval = ServletUtil.readString(is);
                    _fileCache.addFile(filePath, retval);
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    logger.error(RB.getStringResource("ThemesFactory.IOException.txt"), (Object)ServletUtil.class.getName());
                }
            }
        }
        return retval;
    }

    public static String getFileAsString(URL url) throws IOException {
        return ServletUtil.getFileAsString(null, url);
    }

    public static String getFileAsString(Logger logger, URL url) throws IOException {
        return ServletUtil.getFileAsString(logger, url, false);
    }

    public static String getThemeFileAsString(Logger logger, URL url) throws IOException {
        return ServletUtil.getFileAsString(logger, url, true);
    }

    public static String getThemeFileAsString(URL url) throws IOException {
        return ServletUtil.getFileAsString(null, url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileAsString(Logger logger, URL url, boolean useThemeProxyIfEnabled) throws IOException {
        Object mutex;
        String retval;
        ServletUtil.checkForNull(url, "url");
        String urlKey = url.toString();
        if (logger != null) {
            logger.debug("Getting file: " + urlKey, (Object)ServletUtil.class.getName());
        }
        if ((retval = _fileCache.findFile(urlKey)) != null) {
            return retval;
        }
        Object object = mutex = ServletUtil.obtainUrlMutex(urlKey);
        synchronized (object) {
            retval = _fileCache.findFile(urlKey);
            if (retval == null) {
                retval = ServletUtil.readUrl(url, logger, useThemeProxyIfEnabled);
                _fileCache.addFile(urlKey, retval);
                if (logger != null) {
                    logger.debug("read file: " + url, (Object)ServletUtil.class.getName());
                }
            }
        }
        return retval;
    }

    public static Theme getTheme(UserContextInterface uc, ServletContext servletContext, String themeName) throws ThemeException, RemoteException {
        ServletUtil.checkForNull(themeName, "themeName");
        ThemesFactory tf = ThemesFactory.getInstance(uc, servletContext);
        if (tf.isValidTheme(themeName)) {
            return tf.getTheme(themeName);
        }
        if (tf.isValidTheme(THEME_FALLBACK)) {
            String msg = MessageFormat.format(RB.getStringResource("general.invalidtheme.fmt.txt"), themeName);
            LogManager.getLogger((Class)uc.getClass()).warn(msg, (Object)ServletUtil.class.getName());
            return tf.getTheme(THEME_FALLBACK);
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource("general.invalidtheme.fmt.txt"), themeName));
    }

    private static String readString(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer(256);
        char[] tmp = new char[1024];
        InputStreamReader r = new InputStreamReader(in);
        int readsize = -1;
        while ((readsize = r.read(tmp)) > -1) {
            buf.append(tmp, 0, readsize);
        }
        return buf.toString();
    }

    private static void checkForNull(Object param, String name) {
        if (param == null) {
            throw new NullPointerException(MessageFormat.format(RB.getStringResource("general.nullparameter.fmt.txt"), name));
        }
    }

    private static synchronized Object obtainUrlMutex(String url) {
        Object retval = _resourceLocks.get(url);
        if (retval == null) {
            retval = new Object();
            _resourceLocks.put(url, retval);
        }
        return retval;
    }

    public static SASTemporaryLogger DebugMetadataXMLToLogger() throws RemoteException {
        return ServletUtil.CreateNewTemporaryLogger("com.sas.metadata.xml", Level.DEBUG);
    }

    public static SASTemporaryLogger CreateNewTemporaryLogger(String whichClass, Level debugLevel) throws RemoteException {
        SASTemporaryLogger logger = null;
        Logger loggerInternal = LogManager.getLogger((String)whichClass);
        logger = new SASTemporaryLogger(loggerInternal, debugLevel);
        return logger;
    }

    public static String buildFullURL(HttpServletRequest request, String path) {
        StringBuffer buf = new StringBuffer();
        buf.append(request.getScheme()).append("://");
        buf.append(request.getServerName()).append(":");
        buf.append(request.getServerPort()).append(request.getContextPath());
        buf.append(path);
        return buf.toString();
    }

    private static String readUrl(URL url, Logger logger, boolean useThemeProxyIfEnabled) throws IOException {
        return ServletUtil.readUrl(url, 1, 0, null, logger, useThemeProxyIfEnabled);
    }

    public static String readUrl(URL url, int maxTries, int sleepTime, String subnet, Logger logger, boolean useThemeProxyIfEnabled) throws IOException {
        String retval = null;
        int tries = 0;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String host = url.getHost();
        boolean abortLoop = false;
        String proxyHost = null;
        String proxyPortStr = null;
        boolean useProxy = false;
        int proxyPort = 0;
        if (subnet != null) {
            try {
                InetAddress clientInterface = null;
                if (subnet != null) {
                    clientInterface = ServletUtil.locateInterface(subnet);
                    proxyHost = clientInterface.getHostAddress();
                    proxyPort = ServletUtil.getRandomClientPort();
                    useProxy = true;
                }
            }
            catch (SocketException e) {
                ServletUtil.logError(logger, e, url.toString());
            }
        } else if (useThemeProxyIfEnabled) {
            proxyHost = System.getProperty(THEME_PROXY_HOST);
            proxyPortStr = System.getProperty(THEME_PROXY_PORT);
            if (proxyHost != null && proxyPortStr != null) {
                try {
                    proxyPort = Integer.parseInt(proxyPortStr);
                    useProxy = true;
                }
                catch (NumberFormatException e) {
                    ServletUtil.logError(logger, THEME_PROXY_HOST + "=" + proxyHost);
                    ServletUtil.logError(logger, e, THEME_PROXY_PORT + "=" + proxyPort);
                    useThemeProxyIfEnabled = false;
                }
            } else {
                useThemeProxyIfEnabled = false;
                if (proxyHost != null && proxyPortStr == null || proxyHost == null && proxyPortStr != null) {
                    ServletUtil.logError(logger, THEME_PROXY_HOST + "=" + proxyHost);
                    ServletUtil.logError(logger, THEME_PROXY_PORT + "=" + proxyPort);
                }
            }
        }
        HttpUriRequest httpUriRequest = null;
        while (tries < maxTries) {
            if (tries > 0) {
                logger.debug(_loggingContext + " tries:" + tries, (Object)_loggingContext);
            }
            try {
                String protocol;
                RequestBuilder requestBuilder = RequestBuilder.get((String)url.toString());
                if (useProxy) {
                    HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                    RequestConfig requestConfig = RequestConfig.custom().setProxy(proxy).build();
                    requestBuilder.setConfig(requestConfig);
                }
                if (null == (protocol = url.getProtocol())) {
                    protocol = "http";
                }
                char leadingChar = host.toLowerCase().charAt(0);
                boolean needHostHeader = true;
                if (leadingChar == 'l' && host.equalsIgnoreCase("localhost")) {
                    needHostHeader = false;
                } else if (leadingChar >= '0' && leadingChar <= '9') {
                    needHostHeader = false;
                }
                if (needHostHeader) {
                    StringBuilder hostHeader = new StringBuilder();
                    int port = url.getPort();
                    if (port == -1) {
                        if ("http".equalsIgnoreCase(protocol)) {
                            port = 80;
                        } else if ("https".equalsIgnoreCase(protocol)) {
                            port = 443;
                        }
                    }
                    hostHeader.append(url.getHost()).append(":").append(port);
                    requestBuilder.setHeader("Host", hostHeader.toString());
                }
                httpUriRequest = requestBuilder.build();
                HttpResponse httpResponse = client.execute(httpUriRequest);
                switch (httpResponse.getStatusLine().getStatusCode()) {
                    case 200: {
                        HttpEntity entity = httpResponse.getEntity();
                        retval = EntityUtils.toString((HttpEntity)entity);
                        abortLoop = true;
                        break;
                    }
                    case 404: {
                        retval = null;
                        ServletUtil.logError(logger, "ERROR 404 url: " + url.toString());
                        ++tries;
                        break;
                    }
                    default: {
                        retval = null;
                        ++tries;
                    }
                }
                if (abortLoop) {
                    break;
                }
            }
            catch (IOException e) {
                retval = null;
                ServletUtil.logError(logger, e, "url: " + url.toString());
                ++tries;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                ServletUtil.logError(logger, e, "url: " + url.toString());
            }
        }
        if (retval == null) {
            ServletUtil.logError(logger, "resource not found: url: " + url.toString());
        }
        return retval;
    }

    private static int getRandomClientPort() {
        Random r = new Random(System.currentTimeMillis());
        long range = 24001L;
        long fraction = (long)((double)range * r.nextDouble());
        return (int)(fraction + 24000L);
    }

    private static InetAddress locateInterface(String subnet) throws SocketException {
        InetAddress retval = null;
        Enumeration<NetworkInterface> outer = NetworkInterface.getNetworkInterfaces();
        block0: while (outer.hasMoreElements()) {
            NetworkInterface ni = outer.nextElement();
            Enumeration<InetAddress> inner = ni.getInetAddresses();
            while (inner.hasMoreElements()) {
                InetAddress addr = inner.nextElement();
                String textAddr = addr.getHostAddress();
                if (!textAddr.startsWith(subnet)) continue;
                retval = addr;
                continue block0;
            }
        }
        return retval;
    }

    private static void logError(Logger logger, String message) {
        if (logger != null) {
            logger.error(message);
        }
    }

    private static void logError(Logger logger, Exception e, String message) {
        if (logger != null) {
            if (e.getLocalizedMessage() != null) {
                logger.error(e.getLocalizedMessage() + " " + message);
            } else {
                logger.error(e + " " + message);
            }
        }
    }

    public static UserContextInterface getPrivUserContext(HttpServletRequest request) throws InitializationException, RemoteException, ServiceException {
        UserServiceInterface userService = ServicesFacade.getUserService();
        String privuser = request.getSession(true).getServletContext().getInitParameter(PRIV_USERID);
        if (privuser == null) {
            throw new IllegalArgumentException();
        }
        UserContextInterface retval = userService.getUser(privuser);
        return retval;
    }
}

