/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class UrlReplayBlockerFilter
implements Filter {
    private static final int MAX_AGE_MINUTES = 120;
    private static final long MAX_AGE_MSEC = 0x6DDD00L;
    private static Map _sessionMappings = Collections.synchronizedMap(new LinkedHashMap());
    private static long _nextExpireTime = 0L;
    private static boolean _isLessSecure;
    private static boolean _isDebugMode;
    private static String INIT_PARAM_LESS_SECURE;
    private static String INIT_PARAM_DEBUG_MODE;
    private static String REQUEST_PROCESSED;

    public void init(FilterConfig config) throws ServletException {
        _isLessSecure = Boolean.parseBoolean(config.getInitParameter(INIT_PARAM_LESS_SECURE));
        _isDebugMode = Boolean.parseBoolean(config.getInitParameter(INIT_PARAM_DEBUG_MODE));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String sessionRequestKey;
        HttpServletRequest httpRequest = null;
        HttpServletResponse httpResponse = null;
        try {
            httpRequest = (HttpServletRequest)request;
            httpResponse = (HttpServletResponse)response;
        }
        catch (ClassCastException e) {
            chain.doFilter(request, response);
            return;
        }
        String sessionKey = httpRequest.getParameter("saspfs_sessionid");
        if (sessionKey == null) {
            chain.doFilter(request, response);
            return;
        }
        String alreadyProcessedRequest = (String)httpRequest.getAttribute(REQUEST_PROCESSED);
        if (alreadyProcessedRequest != null) {
            chain.doFilter(request, response);
            return;
        }
        httpRequest.setAttribute(REQUEST_PROCESSED, (Object)"true");
        if (_isDebugMode) {
            System.out.println("UrlReplayBlockerFilter: " + httpRequest.getRequestURI() + "?" + httpRequest.getQueryString());
        }
        if ((sessionRequestKey = httpRequest.getParameter("saspfs_sessionrequest")) == null) {
            if (_isLessSecure) {
                chain.doFilter(request, response);
                return;
            }
            if (_isDebugMode) {
                System.out.println("UrlReplayBlockerFilter: sessionRequestKey=null,_isLessSecure=false,sessionKey=" + sessionKey);
            }
            this.showError(httpRequest, httpResponse);
            return;
        }
        if (this.isReplayAttempt(sessionKey, sessionRequestKey)) {
            if (_isDebugMode) {
                System.out.println("UrlReplayBlockerFilter: isReplayAttempt,sessionRequestKey=" + sessionKey + ",sessionRequestKey=" + sessionRequestKey);
            }
            this.showError(httpRequest, httpResponse);
            return;
        }
        chain.doFilter(request, response);
    }

    private void showError(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        httpResponse.sendError(403);
        StringBuffer sb = new StringBuffer();
        sb.append("** UrlReplayBlockerFilter: SECURITY ACCESS VIOLATION **").append("\n  The requested URL (").append(httpRequest.getContextPath()).append(httpRequest.getServletPath()).append("\n  can only be directly accessed from another SAS application, typically the SAS Information Delivery Portal");
        System.err.println(sb.toString());
    }

    private boolean isReplayAttempt(String sessionKey, String sessionRequestKey) {
        boolean retval = false;
        Holder holder = (Holder)_sessionMappings.get(sessionKey);
        if (holder == null) {
            this.addMapping(sessionKey, sessionRequestKey);
        } else if (holder.contains(sessionRequestKey)) {
            retval = true;
        } else {
            holder.addSessionRequestId(sessionRequestKey);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMapping(String sessionKey, String sessionRequestKey) {
        Map map = _sessionMappings;
        synchronized (map) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis > _nextExpireTime) {
                Iterator iter = _sessionMappings.values().iterator();
                while (iter.hasNext()) {
                    Holder holder = (Holder)iter.next();
                    if (holder.isExpired(currentTimeMillis)) {
                        iter.remove();
                        continue;
                    }
                    _nextExpireTime = holder.getExpireTime();
                    break;
                }
            }
            if (_sessionMappings.size() > 10000) {
                _sessionMappings.clear();
            }
            Holder holder = new Holder(sessionKey);
            holder.addSessionRequestId(sessionRequestKey);
            if (_sessionMappings.isEmpty()) {
                _nextExpireTime = holder.getExpireTime();
            }
            _sessionMappings.put(sessionKey, holder);
        }
    }

    static {
        INIT_PARAM_LESS_SECURE = "less-secure";
        INIT_PARAM_DEBUG_MODE = "debug-mode";
        REQUEST_PROCESSED = "UrlReplayBlockerFilter_request_processed";
    }

    private static class Holder {
        long _expireTime = System.currentTimeMillis() + 0x6DDD00L;
        String _sessionId;
        Set _sessionRequestIds = new HashSet();

        Holder(String sessionId) {
            this._sessionId = sessionId;
        }

        public boolean contains(String sessionRequestId) {
            return this._sessionRequestIds.contains(sessionRequestId);
        }

        public long getExpireTime() {
            return this._expireTime;
        }

        public String getSessionId() {
            return this._sessionId;
        }

        public void addSessionRequestId(String sessionRequestId) {
            this._sessionRequestIds.add(sessionRequestId);
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this._expireTime;
        }

        public boolean isExpired(long currentTimeMillis) {
            return currentTimeMillis > this._expireTime;
        }
    }
}

