/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.filters;

import com.sas.webapp.servlet.filters.HttpFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class SetCharacterEncodingFilter
extends HttpFilter {
    protected String encoding = null;
    protected FilterConfig filterConfig = null;
    protected boolean ignore = true;

    @Override
    public void destroy() {
        super.destroy();
        this.encoding = null;
        this.filterConfig = null;
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String encoding;
        if ((this.ignore || request.getCharacterEncoding() == null) && (encoding = this.selectEncoding((ServletRequest)request)) != null) {
            request.setCharacterEncoding(encoding);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
        String value = filterConfig.getInitParameter("ignore");
        this.ignore = value == null ? true : (value.equalsIgnoreCase("true") ? true : value.equalsIgnoreCase("yes"));
    }

    protected String selectEncoding(ServletRequest request) {
        if (request != null) {
            // empty if block
        }
        return this.encoding;
    }
}

