/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.filters;

import com.sas.webapp.servlet.filters.HttpFilter;
import com.sas.webapp.servlet.filters.RequestOverrideWrapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class RequestOverrideFilter
extends HttpFilter {
    public static final String PROTOCOL_PARAM = "protocol";
    public static final String HOST_PARAM = "host";
    public static final String PORT_PARAM = "port";
    private String _protocol;
    private String _host;
    private int _port = -1;

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this._protocol = config.getInitParameter(PROTOCOL_PARAM);
        this._host = config.getInitParameter(HOST_PARAM);
        if (config.getInitParameter(PORT_PARAM) != null) {
            try {
                this._port = Integer.parseInt(config.getInitParameter(PORT_PARAM));
            }
            catch (NumberFormatException e) {
                this._port = -1;
            }
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!this.hasProcessed((HttpServletRequest)request) && this.useOverrides()) {
            request = new RequestOverrideWrapper((HttpServletRequest)request, this._protocol, this._host, this._port);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean useOverrides() {
        return this._protocol != null || this._host != null || this._port > -1;
    }
}

