/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.filters;

import com.sas.services.security.Challenger;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.webapp.servlet.filters.HttpFilter;
import com.sas.webapp.util.security.MidTierAuthCallbackHandler;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import javax.security.auth.callback.CallbackHandler;

public class AuthenticationFilter
extends HttpFilter {
    private String _userContextToken;
    private String _authFailureUrl;

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this._userContextToken = config.getInitParameter("user-context-token");
        this._authFailureUrl = config.getInitParameter("auth-failure-action");
        if (this._userContextToken == null) {
            throw new ServletException("Missing user-context-token init parameter");
        }
        if (this._authFailureUrl == null) {
            throw new ServletException("Missing auth-failure-action init parameter");
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session = request.getSession(true);
        Object userContextToken = session.getAttribute(this._userContextToken);
        UserContextInterface user = null;
        if (userContextToken instanceof SessionContextInterface) {
            user = ((SessionContextInterface)userContextToken).getUserContext();
        } else if (userContextToken instanceof UserContextInterface) {
            user = (UserContextInterface)userContextToken;
        }
        if (user != null) {
            user.setChallengeCallbackHandler((RemoteCallbackHandler)new Challenger((CallbackHandler)new MidTierAuthCallbackHandler((ServletRequest)request, this._authFailureUrl)));
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

