/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.remote.session;

import com.sas.webapp.remote.session.RemoteHttpSession;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class SessionFactory {
    private static SessionFactory _instance = new SessionFactory();
    private static final long MAX_ID_VALUE = 100000000L;
    private Map _hosts = new Hashtable();
    private String _idBase = String.valueOf(SessionFactory.class.hashCode());
    private long _idCounter = 0L;

    private SessionFactory() {
    }

    public static SessionFactory getInstance() {
        return _instance;
    }

    public RemoteHttpSession getSession(HttpServletRequest request) {
        RemoteHttpSession retval;
        String rootHost;
        if (this._hosts == null) {
            return null;
        }
        String rootSessionId = (String)request.getAttribute("saspfs_http_root_session_id");
        if (rootSessionId == null) {
            rootSessionId = request.getParameter("saspfs_http_root_session_id");
        }
        if ((rootHost = (String)request.getAttribute("saspfs_http_root_session_host")) == null) {
            rootHost = request.getParameter("saspfs_http_root_session_host");
        }
        if ((retval = this.getSession(request.getSession(), rootHost, rootSessionId)) != null) {
            retval.setLastAccessedTime(System.currentTimeMillis());
        }
        return retval;
    }

    public HttpSession invalidateSession(String rootHost, String rootSessionId) {
        Map sessions;
        HttpSession retval = null;
        if (this._hosts != null && (sessions = (Map)this._hosts.get(rootHost)) != null) {
            retval = (HttpSession)sessions.remove(rootSessionId);
            if (sessions.size() == 0) {
                this._hosts.remove(rootHost);
            }
        }
        return retval;
    }

    public void harvestSessions(long timeout) {
        ArrayList hosts = new ArrayList();
        hosts.addAll(this._hosts.keySet());
        for (String host : hosts) {
            Map sessions = (Map)this._hosts.get(host);
            this.harvestSessions(sessions, timeout);
        }
    }

    public void destroy() {
        this._hosts.clear();
        this._hosts = null;
    }

    private synchronized RemoteHttpSession getSession(HttpSession session, String rootHost, String rootSessionId) {
        RemoteHttpSession retval;
        HashMap<String, RemoteHttpSession> sessions = (HashMap<String, RemoteHttpSession>)this._hosts.get(rootHost);
        if (sessions == null) {
            sessions = new HashMap<String, RemoteHttpSession>();
            this._hosts.put(rootHost, sessions);
        }
        if ((retval = (RemoteHttpSession)sessions.get(rootSessionId)) == null) {
            retval = this.createSession(session);
            retval.setRootHost(rootHost);
            retval.setRootSessionId(rootSessionId);
            sessions.put(rootSessionId, retval);
        }
        return retval;
    }

    private RemoteHttpSession createSession(HttpSession session) {
        long currentTime = System.currentTimeMillis();
        RemoteHttpSession retval = new RemoteHttpSession();
        retval.setCreateTime(currentTime);
        retval.setLastAccessedTime(currentTime);
        retval.setId(this.generateId());
        retval.setServletContext(session.getServletContext());
        return retval;
    }

    private synchronized String generateId() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._idBase);
        buf.append(this._idCounter++);
        if (this._idCounter > 100000000L) {
            this._idCounter = 0L;
        }
        return buf.toString();
    }

    private void harvestSessions(Map sessions, long timeout) {
        ArrayList sessionIds = new ArrayList();
        ArrayList<RemoteHttpSession> toInvalidate = new ArrayList<RemoteHttpSession>();
        sessionIds.addAll(sessions.keySet());
        Iterator iter = sessionIds.iterator();
        long currentTime = System.currentTimeMillis();
        while (iter.hasNext()) {
            String sessionId = (String)iter.next();
            RemoteHttpSession session = (RemoteHttpSession)sessions.get(sessionId);
            if (session == null || currentTime - session.getLastAccessedTime() <= timeout) continue;
            toInvalidate.add(session);
        }
        if (toInvalidate.size() > 0) {
            for (RemoteHttpSession session : toInvalidate) {
                if (session == null) continue;
                this.invalidateSession(session.getRootHost(), session.getRootSessionId());
                Enumeration enumerator = session.getAttributeNames();
                while (enumerator.hasMoreElements()) {
                    String key = (String)enumerator.nextElement();
                    session.removeAttribute(key);
                }
            }
            toInvalidate.clear();
        }
    }
}

