/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.remote.session;

import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.events.broker.InvalidEventTypeException;
import com.sas.services.events.broker.ListenerInterface;
import com.sas.services.webapp.ServicesFacade;
import com.sas.webapp.remote.session.RemoteRequestWrapper;
import com.sas.webapp.remote.session.RootSessionDestructionListener;
import com.sas.webapp.remote.session.SessionFactory;
import com.sas.webapp.remote.session.SessionHarvester;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.rmi.RemoteException;

public class RemoteSessionFilter
implements Filter {
    private RootSessionDestructionListener _listener;
    private boolean _isInitialized;
    private long _eventTimeout;
    private long _sessionTimeout;

    public void init(FilterConfig config) throws ServletException {
        this._eventTimeout = -1L;
        this._sessionTimeout = -1L;
        String listenerClassName = config.getInitParameter("listener-type");
        String sessionTimeout = config.getInitParameter("session-timeout");
        if (sessionTimeout == null) {
            throw new ServletException("session-timeout must be specified");
        }
        try {
            this._sessionTimeout = Long.valueOf(sessionTimeout);
        }
        catch (NumberFormatException e) {
            throw new ServletException("Invalid session-timeout specified");
        }
        this._listener = listenerClassName != null ? this.createListener(listenerClassName) : null;
        if (this._listener != null) {
            String eventTimeout = config.getInitParameter("event-timeout");
            if (eventTimeout == null) {
                throw new ServletException("event-timeout must be specified");
            }
            try {
                this._eventTimeout = Long.valueOf(eventTimeout);
            }
            catch (NumberFormatException e) {
                throw new ServletException("Invalid event-timeout specified");
            }
        }
    }

    private RootSessionDestructionListener createListener(String className) throws ServletException {
        try {
            Class<?> klass = this.getClass().getClassLoader().loadClass(className);
            return (RootSessionDestructionListener)klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void init() throws InitializationException, RemoteException, ServiceException {
        if (this._isInitialized) {
            return;
        }
        if (this._listener != null) {
            this.setupEventListener();
            this.setupHarvestThread(true);
        } else {
            this.setupHarvestThread(false);
        }
        this._isInitialized = true;
    }

    private void setupEventListener() throws InitializationException, RemoteException, ServiceException {
        EventBrokerServiceInterface eventBroker = null;
        eventBroker = ServicesFacade.getRemoteEventBrokerService();
        try {
            eventBroker.addEventListener("sas.http.root.session.event", 0, (ListenerInterface)this._listener);
        }
        catch (RemoteException e) {
            this._listener = null;
            throw e;
        }
        catch (InvalidEventTypeException e) {
            if (this._listener != null) {
                this._listener = null;
            }
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private void setupHarvestThread(boolean areEventsEnabled) {
        SessionHarvester h = new SessionHarvester();
        h.setSessionTimeout(this._sessionTimeout);
        h.setEventTimeout(this._eventTimeout);
        if (areEventsEnabled) {
            h.setListener(this._listener);
        }
        Thread t = new Thread((Runnable)h, h.getClass().getName());
        t.setDaemon(true);
        t.start();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String rootSessionId = (String)request.getAttribute("saspfs_http_root_session_id");
        if (rootSessionId == null) {
            rootSessionId = request.getParameter("saspfs_http_root_session_id");
        }
        if (rootSessionId != null) {
            if (!this._isInitialized) {
                try {
                    this.init();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ((HttpServletResponse)response).sendError(500);
                    return;
                }
            }
            RemoteRequestWrapper wrapper = new RemoteRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)wrapper, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        try {
            EventBrokerServiceInterface eventBroker = ServicesFacade.getRemoteEventBrokerService();
            eventBroker.removeEventListener("sas.http.root.session.event", 0, (ListenerInterface)this._listener);
        }
        catch (RemoteException remoteException) {
        }
        catch (InitializationException initializationException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        SessionFactory.getInstance().destroy();
    }
}

