/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.remote.session;

import com.sas.midtier.components.container.util.impl.ComponentsUtil;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.webapp.ServicesFacade;
import com.sas.webapp.components.configuration.ApplicationConfiguration;
import com.sas.webapp.components.services.ServicesManager;
import com.sas.webapp.components.services.TrustedOmrUser;
import com.sas.webapp.contextsharing.WebappContextParams;
import com.sas.webapp.remote.session.res.RB;
import com.sas.webapp.util.SessionFacade;
import com.sas.webapp.util.impl.SessionFacadeImpl;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;

public class RemoteContextManager {
    private static final String CREATED_SESSIONFACADE = "RemoteContextManager.CREATED_SESSIONFACADE";

    public static SessionFacade getSessionFacade(HttpServletRequest request) throws ServiceException, RemoteException {
        HttpSession session = request.getSession(true);
        SessionFacade retval = SessionFacadeImpl.getSessionFacade(session);
        if (retval == null || retval.getUserContext() == null) {
            RemoteContextManager remoteContextManager = new RemoteContextManager();
            retval = remoteContextManager.initSessionFacade(request);
            session.setAttribute(CREATED_SESSIONFACADE, (Object)"true");
        }
        return retval;
    }

    public static void cleanupSessionFacade(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        boolean created = Boolean.valueOf((String)session.getAttribute(CREATED_SESSIONFACADE));
        if (created) {
            session.removeAttribute("SESSION_FACADE");
            session.removeAttribute(CREATED_SESSIONFACADE);
            session.removeAttribute("saspfs_sessionrequest");
        }
    }

    public static Map getContextSharingMap(HttpServletRequest request) {
        SessionContextInterface remoteSessionContext;
        Map retval = null;
        retval = (Map)request.getAttribute("saspfs_sessionrequest");
        if (retval == null && (remoteSessionContext = (SessionContextInterface)request.getSession().getAttribute("com.sas.services.session.remote.SessionContextInterface")) != null) {
            String key = request.getParameter("saspfs_sessionrequest");
            try {
                retval = (Map)remoteSessionContext.getAttribute(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (retval == null) {
            retval = (Map)request.getSession().getAttribute("saspfs_sessionrequest");
        } else {
            request.getSession().setAttribute("saspfs_sessionrequest", (Object)retval);
        }
        return retval;
    }

    public static WebappContextParams getWebappContextParams(HttpServletRequest request) throws Exception {
        WebappContextParams retval = null;
        UserContextInterface privlUserContext = RemoteContextManager.getTrustedUserContext(request);
        retval = new WebappContextParams(privlUserContext, request);
        return retval;
    }

    public static SessionContextInterface getRemoteSessionContext(HttpServletRequest request) throws ServiceException, RemoteException {
        SessionContextInterface retval = null;
        HttpSession session = request.getSession(true);
        retval = (SessionContextInterface)session.getAttribute("com.sas.services.session.remote.SessionContextInterface");
        if (retval == null) {
            SessionFacade sf = SessionFacadeImpl.getSessionFacade(session);
            if (sf == null) {
                sf = new SessionFacadeImpl(session);
            }
            if ((retval = sf.getRemoteSessionContext()) == null) {
                RemoteContextManager remoteContextManager = new RemoteContextManager();
                retval = remoteContextManager.lookupRemoteSessionContext(request);
                sf.setRemoteSessionContext(retval);
            }
        }
        return retval;
    }

    public static String setupBackUrl(HttpServletRequest request, String backUrl) throws Exception {
        String retval = null;
        SessionContextInterface sessionContext = RemoteContextManager.getRemoteSessionContext(request);
        WebappContextParams params = new WebappContextParams(sessionContext, backUrl);
        params.setParamRequestSource(request.getContextPath());
        retval = params.getURL();
        return retval;
    }

    public static String getSSOUrl(HttpServletRequest request, String targetUrl, String backToUrl, String backToLabel, String backToToolTip) throws Exception {
        String retval = null;
        SessionContextInterface sessionContext = RemoteContextManager.getRemoteSessionContext(request);
        WebappContextParams params = new WebappContextParams(sessionContext, targetUrl);
        params.setParamRequestSource(request.getContextPath());
        ArrayList<String> backToUrlList = null;
        if (backToUrl != null) {
            backToUrlList = new ArrayList<String>();
            backToUrlList.add(backToUrl);
            params.setParamRequestBackurlList(backToUrlList);
        }
        ArrayList<String> backToLabelList = null;
        if (backToLabel != null) {
            backToLabelList = new ArrayList<String>();
            backToLabelList.add(backToLabel);
            params.setParamRequestBacklabelList(backToLabelList);
        }
        ArrayList<String> backToToolTipList = null;
        if (backToToolTip != null) {
            backToToolTipList = new ArrayList<String>();
            backToToolTipList.add(backToToolTip);
            params.setParamRequestBackdescriptionList(backToToolTipList);
        }
        retval = params.getURL();
        return retval;
    }

    private SessionFacade initSessionFacade(HttpServletRequest request) throws ServiceException, RemoteException {
        HttpSession session = request.getSession();
        SessionFacadeImpl retval = new SessionFacadeImpl(session);
        SessionContextInterface localSessionContext = null;
        try {
            SessionContextInterface remoteSessionContext = this.lookupRemoteSessionContext(request);
            UserContextInterface remoteUserContext = remoteSessionContext.getUserContext();
            localSessionContext = this.createLocalFromRemoteUserContext(request, remoteSessionContext, remoteUserContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("Could not create local UserContext from a remote UserContext");
        }
        retval.setLocalSessionContext(localSessionContext);
        UserContextInterface localUserContext = localSessionContext.getUserContext();
        retval.setUserContext(localUserContext);
        return retval;
    }

    private SessionContextInterface lookupRemoteSessionContext(HttpServletRequest request) throws ServiceException, RemoteException {
        SessionContextInterface retval = null;
        retval = (SessionContextInterface)request.getSession().getAttribute("com.sas.services.session.remote.SessionContextInterface");
        if (retval == null) {
            UserContextInterface trustedUserContext = RemoteContextManager.getTrustedUserContext(request);
            retval = this.lookupRemoteSessionContextBySessionId(request, trustedUserContext);
        }
        if (retval == null) {
            String msg = RB.getStringResource("error.remote.sessioncontext.null.txt", request.getLocale());
            throw new RemoteException(msg);
        }
        return retval;
    }

    private SessionContextInterface lookupRemoteSessionContextBySessionId(HttpServletRequest request, UserContextInterface trustedUserContext) throws ServiceException, RemoteException {
        SessionContextInterface retval = null;
        String remoteSessionId = request.getParameter("saspfs_sessionid");
        if (remoteSessionId == null) {
            String msg = RB.getStringResource("error.sessioncontext.id.missing.txt", request.getLocale());
            System.out.println(msg);
            throw new IllegalArgumentException(msg);
        }
        SessionServiceInterface remoteSessionService = this.getRemoteSessionService(request);
        retval = remoteSessionService.getSessionContext(trustedUserContext, remoteSessionId);
        return retval;
    }

    private SessionContextInterface createLocalFromRemoteUserContext(HttpServletRequest request, SessionContextInterface remoteSessionContext, UserContextInterface remoteUserContext) throws ServiceException, RemoteException {
        SessionContextInterface retval = null;
        UserServiceInterface localUserService = this.getLocalUserService(request);
        UserContextInterface localUser = localUserService.fromByteArray(remoteUserContext.toByteArray());
        SessionServiceInterface localSessionService = this.getLocalSessionService(request);
        retval = localSessionService.newSessionContext(localUser);
        return retval;
    }

    private SessionServiceInterface getLocalSessionService(HttpServletRequest request) throws ServiceException, RemoteException {
        SessionServiceInterface retval = null;
        ServicesManager servicesManager = (ServicesManager)ComponentsUtil.locateComponent(ServicesManager.class, (HttpServletRequest)request);
        retval = servicesManager != null ? servicesManager.getSessionService() : ServicesFacade.getSessionService();
        return retval;
    }

    private UserServiceInterface getLocalUserService(HttpServletRequest request) throws ServiceException, RemoteException {
        UserServiceInterface retval = null;
        ServicesManager servicesManager = (ServicesManager)ComponentsUtil.locateComponent(ServicesManager.class, (HttpServletRequest)request);
        retval = servicesManager != null ? servicesManager.getUserService() : ServicesFacade.getUserService();
        return retval;
    }

    private static UserContextInterface getTrustedUserContext(HttpServletRequest request) throws ServiceException, RemoteException {
        String trustedUserId;
        ApplicationConfiguration appConfig;
        TrustedOmrUser trustedOmrUser;
        UserContextInterface retval = null;
        if (retval == null && (trustedOmrUser = (TrustedOmrUser)ComponentsUtil.locateComponent(TrustedOmrUser.class, (ServletContext)request.getSession().getServletContext())) != null) {
            retval = trustedOmrUser.getUserContext();
        }
        if (retval == null && (appConfig = (ApplicationConfiguration)ComponentsUtil.locateComponent(ApplicationConfiguration.class, (ServletContext)request.getSession().getServletContext())) != null && (trustedUserId = appConfig.getValueFromMap("omr-connection", "omr-user")) != null) {
            UserServiceInterface remoteUserService = null;
            try {
                remoteUserService = RemoteContextManager.getRemoteUserService(request);
            }
            catch (Exception e) {
                throw new ServiceException("Could not obtain a Remote UserService");
            }
            retval = remoteUserService.getUser(trustedUserId);
        }
        return retval;
    }

    private static UserServiceInterface getRemoteUserService(HttpServletRequest request) throws ServiceException, RemoteException {
        UserServiceInterface retval = null;
        ServicesManager servicesManager = (ServicesManager)ComponentsUtil.locateComponent(ServicesManager.class, (HttpServletRequest)request);
        retval = servicesManager != null ? servicesManager.getRemoteUserService() : ServicesFacade.getRemoteUserService();
        return retval;
    }

    private SessionServiceInterface getRemoteSessionService(HttpServletRequest request) throws ServiceException, RemoteException {
        SessionServiceInterface retval = null;
        ServicesManager servicesManager = (ServicesManager)ComponentsUtil.locateComponent(ServicesManager.class, (HttpServletRequest)request);
        retval = servicesManager != null ? servicesManager.getRemoteSessionService() : ServicesFacade.getRemoteSessionService();
        return retval;
    }
}

