/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.input.screening;

import com.sas.common.util.InputScreener;
import com.sas.webapp.input.screening.ScreenUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;

public class ScreeningProxy
implements InvocationHandler {
    private Object _target;

    public ScreeningProxy(Object target) {
        this._target = target;
    }

    protected boolean doesMethodNeedScreening(Method method) {
        boolean retval = false;
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes != null && paramTypes.length > 0) {
            for (int x = 0; x < paramTypes.length; ++x) {
                if (paramTypes[x].equals(String.class)) {
                    retval = true;
                } else if (paramTypes[x].isArray() && paramTypes[x].getComponentType().equals(String.class)) {
                    retval = true;
                }
                if (retval) break;
            }
        }
        return retval;
    }

    protected Object[] screenArgs(String methodName, Class[] paramTypes, Object[] args) {
        if (methodName != null) {
            // empty if block
        }
        Object[] retval = new Object[args.length];
        for (int x = 0; x < paramTypes.length; ++x) {
            if (paramTypes[x].equals(String.class)) {
                retval[x] = InputScreener.screen((String)((String)args[x]));
                continue;
            }
            if (paramTypes[x].isArray() && paramTypes[x].getComponentType().equals(String.class)) {
                String[] tempRef = (String[])args[x];
                if (tempRef == null) {
                    retval[x] = null;
                    continue;
                }
                String[] tempValues = new String[tempRef.length];
                for (int y = 0; y < tempRef.length; ++y) {
                    tempValues[y] = InputScreener.screen((String)tempRef[y]);
                }
                retval[x] = tempValues;
                continue;
            }
            retval[x] = args[x];
        }
        return retval;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (proxy != null) {
            // empty if block
        }
        Object returnValue = null;
        if (!this.doesMethodNeedScreening(method)) {
            returnValue = method.invoke(this._target, args);
        } else {
            Object[] filteredArgs = this.screenArgs(method.getName(), method.getParameterTypes(), args);
            returnValue = method.invoke(this._target, filteredArgs);
        }
        if (returnValue != null) {
            if (ScreenUtils.isScreenable(returnValue)) {
                returnValue = ScreenUtils.createScreeningProxy(returnValue);
            } else if (returnValue instanceof List) {
                returnValue = ScreenUtils.createScreeningProxy((List)returnValue);
            }
        }
        return returnValue;
    }
}

