/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.components.services.impl;

import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.storedprocess.StoredProcessServiceInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.webapp.SessionHelper;
import com.sas.webapp.components.services.ServicesInitializer;
import com.sas.webapp.components.services.ServicesManager;
import java.rmi.RemoteException;

public class StandaloneServicesManager
implements ServicesManager {
    private static final Class[] USER_SERVICE = new Class[]{UserServiceInterface.class};
    private static final Class[] SESSION_SERVICE = new Class[]{SessionServiceInterface.class};
    private static final Class[] INFORMATION_SERVICE = new Class[]{InformationServiceInterface.class};
    private static final Class[] AUTHENTICATION_SERVICE = new Class[]{AuthenticationServiceInterface.class};
    private static final Class[] STOREDPROCESS_SERVICE = new Class[]{StoredProcessServiceInterface.class};
    private ServicesInitializer _initializer;

    public StandaloneServicesManager(ServicesInitializer servicesInitializer) {
        this._initializer = servicesInitializer;
    }

    @Override
    public UserServiceInterface getUserService() throws RemoteException, InitializationException, ServiceException {
        return (UserServiceInterface)this.getLocalServiceInterface(USER_SERVICE);
    }

    @Override
    public SessionServiceInterface getSessionService() throws RemoteException, InitializationException, ServiceException {
        return (SessionServiceInterface)this.getLocalServiceInterface(SESSION_SERVICE);
    }

    @Override
    public InformationServiceInterface getInformationService() throws RemoteException, InitializationException, ServiceException {
        return (InformationServiceInterface)this.getLocalServiceInterface(INFORMATION_SERVICE);
    }

    @Override
    public AuthenticationServiceInterface getAuthenticationService() throws RemoteException, InitializationException, ServiceException {
        return (AuthenticationServiceInterface)this.getLocalServiceInterface(AUTHENTICATION_SERVICE);
    }

    @Override
    public StoredProcessServiceInterface getStoredProcessService() throws RemoteException, InitializationException, ServiceException {
        return (StoredProcessServiceInterface)this.getLocalServiceInterface(STOREDPROCESS_SERVICE);
    }

    @Override
    public IntelligentQueryMetadataServiceInterface newIQService() throws ServiceException, MetadataException {
        return IntelligentQueryMetadataServiceFactory.newService();
    }

    @Override
    public SessionServiceInterface getRemoteSessionService() throws RemoteException, InitializationException, ServiceException {
        return (SessionServiceInterface)this.getRemoteServiceInterface(SESSION_SERVICE);
    }

    @Override
    public UserServiceInterface getRemoteUserService() throws RemoteException, InitializationException, ServiceException {
        return (UserServiceInterface)this.getRemoteServiceInterface(USER_SERVICE);
    }

    @Override
    public InformationServiceInterface getRemoteInformationService() throws RemoteException, InitializationException, ServiceException {
        return (InformationServiceInterface)this.getRemoteServiceInterface(INFORMATION_SERVICE);
    }

    @Override
    public EventBrokerServiceInterface getRemoteEventBrokerService() throws RemoteException, InitializationException, ServiceException {
        RemoteServiceInterface retval = null;
        Class<EventBrokerServiceInterface> EVENTBROKER_SERVICE_INTERFACE_CLASS = EventBrokerServiceInterface.class;
        Class[] EVENTBROKER_SERVICE = new Class[]{EVENTBROKER_SERVICE_INTERFACE_CLASS};
        retval = this.getRemoteServiceInterface(EVENTBROKER_SERVICE);
        if (retval != null) {
            return (EventBrokerServiceInterface)retval;
        }
        return null;
    }

    private RemoteServiceInterface getLocalServiceInterface(Class[] desiredClass) throws RemoteException, InitializationException, ServiceException {
        DiscoveryServiceInterface dsi = this._initializer.getDefaultDiscoveryService();
        RemoteServiceInterface rsi = null;
        try {
            rsi = dsi.findService(new ServiceTemplate(desiredClass, this._initializer.getLocalServiceAttributes()));
        }
        catch (ServiceNotAvailableException e) {
            throw new ServiceException(e.toString());
        }
        RemoteServiceInterface retval = rsi.getServiceProxy();
        if (retval == null) {
            retval = rsi;
        }
        return retval;
    }

    private RemoteServiceInterface getRemoteServiceInterface(Class[] desiredClass) throws RemoteException, InitializationException, ServiceException {
        DiscoveryServiceInterface dsi = this._initializer.getDefaultDiscoveryService();
        return dsi.findService(new ServiceTemplate(desiredClass, this._initializer.getRemoteServiceAttributes()));
    }

    @Override
    public SessionContextInterface newSessionContext(SessionContextInterface sourceSession, UserServiceInterface userService, SessionServiceInterface sessionService, InformationServiceInterface infoService) throws ServiceException, RemoteException {
        if (infoService != null) {
            // empty if block
        }
        return new SessionHelper().newSession(sourceSession, userService, sessionService);
    }

    public SessionContextInterface newSessionContext(SessionContextInterface sourceSession, UserServiceInterface userService, SessionServiceInterface sessionService) throws ServiceException, RemoteException {
        return new SessionHelper().newSession(sourceSession, userService, sessionService);
    }
}

