/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.components.impl;

import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.webapp.components.UserContextFactory;
import com.sas.webapp.components.services.ServicesManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UserContextFactoryImpl
implements UserContextFactory {
    private static final String USERID_NODE = "userid";
    private static final String PASSWORD_NODE = "password";
    private static final String DOMAIN_NODE = "domain";
    private ServicesManager _servicesManager;
    private Logger _logger;
    private String _configFile = "named-users.xml";
    private Map _userEntries = new HashMap();

    public UserContextFactoryImpl(ServicesManager servicesManager, Logger logger) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        this._servicesManager = servicesManager;
        this._logger = logger;
        this.init();
    }

    public UserContextFactoryImpl(ServicesManager servicesManager, String configFile) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        this._servicesManager = servicesManager;
        this._configFile = configFile;
        this.init();
    }

    @Override
    public List getNames() {
        ArrayList retval = new ArrayList();
        retval.addAll(this._userEntries.keySet());
        return retval;
    }

    @Override
    public UserContextInterface create(String name) throws InitializationException, RemoteException, ServiceException {
        UserContextInterface retval = null;
        UserEntry entry = (UserEntry)this._userEntries.get(name);
        if (entry != null) {
            UserServiceInterface userService = this._servicesManager.getUserService();
            try {
                retval = userService.newUser(entry.userId, entry.password, entry.domain);
            }
            catch (UserInitializationException e) {
                Throwable t = e.getRootException();
                this._logger.error(t.getMessage(), (Object)UserContextFactory.class.getName(), (Object)t);
                throw e;
            }
        }
        return retval;
    }

    private void init() throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream configFileStream = cl.getResourceAsStream(this._configFile);
        if (configFileStream == null) {
            throw new FileNotFoundException(this._configFile);
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(false);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document doc = null;
        doc = builder.parse(configFileStream);
        NodeList users = doc.getElementsByTagName("user");
        int length = users.getLength();
        for (int x = 0; x < length; ++x) {
            Element user;
            String key;
            if (users.item(x).getNodeType() != 1 || (key = (user = (Element)users.item(x)).getAttribute("name")) == null || key.trim().length() == 0) continue;
            String userId = null;
            String password = null;
            String domain = null;
            NodeList children = user.getChildNodes();
            if (children == null || children.getLength() == 0) continue;
            int size = children.getLength();
            for (int y = 0; y < size; ++y) {
                Element child;
                if (children.item(y).getNodeType() != 1 || (child = (Element)children.item(y)).getNodeType() != 1) continue;
                String tagName = child.getTagName();
                if (USERID_NODE.equals(tagName)) {
                    userId = child.getNodeValue();
                } else if (PASSWORD_NODE.equals(tagName)) {
                    password = child.getNodeValue();
                } else if (DOMAIN_NODE.equals(tagName)) {
                    domain = child.getNodeValue();
                }
                if (userId != null && password != null && domain != null) break;
            }
            userId = userId.trim();
            password = password.trim();
            domain = domain.trim();
            if (userId.length() == 0 || password.length() == 0 || domain.length() == 0) continue;
            UserEntry entry = new UserEntry(key, userId, password, domain);
            this._userEntries.put(entry.key, entry);
        }
    }

    private class UserEntry {
        String key;
        String userId;
        String password;
        String domain;

        UserEntry(String key, String userId, String password, String domain) {
            this.key = key;
            this.userId = userId;
            this.password = password;
            this.domain = domain;
        }
    }
}

