/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.components.impl;

import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.webapp.components.services.ServicesManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.picocontainer.Disposable;

public class LoggerImpl
implements Disposable,
Serializable {
    private static final long serialVersionUID = 768780380433211834L;
    private Logger _defaultLogger = LogManager.getLogger((String)"com.sas.webapp");

    public LoggerImpl(ServicesManager servicesManager) throws InitializationException, RemoteException, ServiceException {
    }

    public LoggerImpl() throws InitializationException, RemoteException, ServiceException {
    }

    private boolean isLoggingLevelEnabled_UseGeneric(Level whichLevel) {
        boolean retVal = false;
        Logger logger = this.getDefaultLogger();
        if (logger != null) {
            retVal = logger.isEnabled(whichLevel);
        }
        return retVal;
    }

    public boolean isDebugEnabled_UseGeneric() {
        return this.isLoggingLevelEnabled_UseGeneric(Level.DEBUG);
    }

    public boolean isWarnEnabled_UseGeneric() {
        return this.isLoggingLevelEnabled_UseGeneric(Level.WARN);
    }

    public boolean isErrorEnabled_UseGeneric() {
        return this.isLoggingLevelEnabled_UseGeneric(Level.ERROR);
    }

    public boolean isInfoEnabled_UseGeneric() {
        return this.isLoggingLevelEnabled_UseGeneric(Level.INFO);
    }

    private boolean isLoggingLevelEnabled(String loggingContext, SessionContextInterface sessionContext, Level whichLevel) {
        boolean retVal = false;
        Logger logger = this.getLogger(sessionContext, null);
        if (logger != null) {
            retVal = logger.isEnabled(whichLevel);
        }
        return retVal;
    }

    private boolean isLoggingLevelEnabled(String loggingContext, UserContextInterface userContext, Level whichLevel) {
        boolean retVal = false;
        Logger logger = this.getLogger(null, userContext);
        if (logger != null) {
            retVal = logger.isEnabled(whichLevel);
        }
        return retVal;
    }

    public boolean isDebugEnabled(String debugContext, SessionContextInterface sessionContext) {
        return this.isLoggingLevelEnabled(debugContext, sessionContext, Level.DEBUG);
    }

    public boolean isDebugEnabled(String debugContext, UserContextInterface userContext) {
        return this.isLoggingLevelEnabled(debugContext, userContext, Level.DEBUG);
    }

    public boolean isWarnEnabled(String warnContext, SessionContextInterface sessionContext) {
        return this.isLoggingLevelEnabled(warnContext, sessionContext, Level.WARN);
    }

    public boolean isWarnEnabled(String warnContext, UserContextInterface userContext) {
        return this.isLoggingLevelEnabled(warnContext, userContext, Level.WARN);
    }

    public boolean isErrorEnabled(String errorContext, SessionContextInterface sessionContext) {
        return this.isLoggingLevelEnabled(errorContext, sessionContext, Level.WARN);
    }

    public boolean isErrorEnabled(String errorContext, UserContextInterface userContext) {
        return this.isLoggingLevelEnabled(errorContext, userContext, Level.ERROR);
    }

    public boolean isInfoEnabled(String infoContext, SessionContextInterface sessionContext) {
        return this.isLoggingLevelEnabled(infoContext, sessionContext, Level.ERROR);
    }

    public boolean isInfoEnabled(String infoContext, UserContextInterface userContext) {
        return this.isLoggingLevelEnabled(infoContext, userContext, Level.ERROR);
    }

    private void log(String output, String loggingContext, Level logLevel, SessionContextInterface sessionContext, Throwable throwable) {
        if (this.isLoggingLevelEnabled(loggingContext, sessionContext, logLevel)) {
            Logger logger = this.getLogger(sessionContext, null);
            if (logger != null) {
                if (throwable != null) {
                    logger.log(logLevel, output, (Object)loggingContext, (Object)throwable);
                } else {
                    logger.log(logLevel, output, (Object)loggingContext);
                }
            } else {
                this.logToStdErr(loggingContext, output);
            }
        }
    }

    private void log(String output, String loggingContext, Level logLevel, UserContextInterface userContext, Throwable throwable) {
        if (this.isLoggingLevelEnabled(loggingContext, userContext, logLevel)) {
            Logger logger = this.getLogger(null, userContext);
            if (logger != null) {
                if (throwable != null) {
                    logger.log(logLevel, output, (Object)loggingContext, (Object)throwable);
                } else {
                    logger.log(logLevel, output, (Object)loggingContext);
                }
            } else {
                this.logToStdErr(loggingContext, output);
            }
        }
    }

    public void debug(String output, String loggingContext, SessionContextInterface sessionContext) {
        this.log(output, loggingContext, Level.DEBUG, sessionContext, null);
    }

    public void debug(String output, String loggingContext, Throwable throwable, SessionContextInterface sessionContext) {
        this.log(output, loggingContext, Level.DEBUG, sessionContext, throwable);
    }

    public void debug_UseGeneric(String output, String debugContext) {
        this.debug(output, debugContext, (SessionContextInterface)null);
    }

    public void debug_UseGeneric(String output, String debugContext, Throwable throwable) {
        this.debug(output, debugContext, throwable, (SessionContextInterface)null);
    }

    public void debug(String output, String debugContext, UserContextInterface userContext) {
        this.log(output, debugContext, Level.DEBUG, userContext, null);
    }

    public void debug(String output, String debugContext, Throwable throwable, UserContextInterface userContext) {
        this.log(output, debugContext, Level.DEBUG, userContext, throwable);
    }

    public void warn(String output, String loggingContext, SessionContextInterface sessionContext) {
        this.log(output, loggingContext, Level.WARN, sessionContext, null);
    }

    public void warn(String output, String loggingContext, Throwable throwable, SessionContextInterface sessionContext) {
        this.log(output, loggingContext, Level.WARN, sessionContext, throwable);
    }

    public void warn_UseGeneric(String output, String loggingContext) {
        this.warn(output, loggingContext, (SessionContextInterface)null);
    }

    public void warn_UseGeneric(String output, String loggingContext, Throwable throwable) {
        this.warn(output, loggingContext, throwable, (SessionContextInterface)null);
    }

    public void warn(String output, String loggingContext, UserContextInterface userContext) {
        this.log(output, loggingContext, Level.WARN, userContext, null);
    }

    public void warn(String output, String loggingContext, Throwable throwable, UserContextInterface userContext) {
        this.log(output, loggingContext, Level.WARN, userContext, throwable);
    }

    public void error(String output, String loggingContext, SessionContextInterface sessionContext) {
        this.log(output, loggingContext, Level.ERROR, sessionContext, null);
    }

    public void error(String output, String loggingContext, Throwable throwable, SessionContextInterface sessionContext) {
        this.log(output, loggingContext, Level.ERROR, sessionContext, throwable);
    }

    public void error_UseGeneric(String output, String loggingContext) {
        this.error(output, loggingContext, (SessionContextInterface)null);
    }

    public void error_UseGeneric(String output, String loggingContext, Throwable throwable) {
        this.error(output, loggingContext, throwable, (SessionContextInterface)null);
    }

    public void error(String output, String loggingContext, UserContextInterface userContext) {
        this.log(output, loggingContext, Level.ERROR, userContext, null);
    }

    public void error(String output, String loggingContext, Throwable throwable, UserContextInterface userContext) {
        this.log(output, loggingContext, Level.ERROR, userContext, throwable);
    }

    public void info(String output, String loggingContext, SessionContextInterface sessionContext) {
        this.log(output, loggingContext, Level.INFO, sessionContext, null);
    }

    public void info(String output, String loggingContext, Throwable throwable, SessionContextInterface sessionContext) {
        this.log(output, loggingContext, Level.INFO, sessionContext, throwable);
    }

    public void info_UseGeneric(String output, String loggingContext) {
        this.info(output, loggingContext, (SessionContextInterface)null);
    }

    public void info_UseGeneric(String output, String loggingContext, Throwable throwable) {
        this.info(output, loggingContext, throwable, (SessionContextInterface)null);
    }

    public void info(String output, String loggingContext, UserContextInterface userContext) {
        this.log(output, loggingContext, Level.INFO, userContext, null);
    }

    public void info(String output, String loggingContext, Throwable throwable, UserContextInterface userContext) {
        this.log(output, loggingContext, Level.INFO, userContext, throwable);
    }

    public void debugStackTrace(String debugContext, Throwable t, SessionContextInterface sessionContext) {
        try {
            if (sessionContext == null) {
                this.error_UseGeneric(t.getMessage(), debugContext, t);
            } else {
                Logger logger = this.getLogger(sessionContext, null);
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(t.getMessage(), (Object)debugContext, (Object)t);
                } else if (logger == null) {
                    this.logToStdErr(debugContext, t.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logToStdErr(debugContext, t.getMessage());
        }
    }

    public void debugStackTrace_UseGeneric(String debugContext, Throwable t) {
        this.debugStackTrace(debugContext, t, (SessionContextInterface)null);
    }

    public void debugStackTrace(String debugContext, Throwable t, UserContextInterface userContext) {
        if (userContext == null) {
            this.debugStackTrace_UseGeneric(debugContext, t);
        } else {
            try {
                this.debugStackTrace(debugContext, t, userContext.getSessionContext());
            }
            catch (RemoteException e) {
                this.debugStackTrace_UseGeneric(debugContext, t);
            }
        }
    }

    public void dispose() {
    }

    private Logger getLogger(SessionContextInterface sessionContext, UserContextInterface userContext) {
        Logger retVal = null;
        try {
            if (userContext != null) {
                retVal = LogManager.getLogger((Class)userContext.getClass());
            }
            if (retVal == null && sessionContext != null) {
                UserContextInterface userContextInner = sessionContext.getUserContext();
                retVal = userContextInner != null ? LogManager.getLogger((Class)userContextInner.getClass()) : LogManager.getLogger((Class)sessionContext.getClass());
            }
            if (retVal == null) {
                retVal = this.getDefaultLogger();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private Logger getDefaultLogger() {
        return this._defaultLogger;
    }

    private void logToStdErr(String context, String output) {
        System.err.println(context + ": " + output);
    }
}

