/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.components.configuration.impl;

import com.sas.midtier.components.container.StorageContext;
import com.sas.webapp.components.configuration.ApplicationConfiguration;
import com.sas.webapp.components.configuration.TypeConversion;
import com.sas.webapp.components.configuration.impl.ConfigParser;
import com.sas.webapp.components.configuration.impl.ConfigurationCreator;
import com.sas.webapp.components.configuration.impl.NamedList;
import com.sas.webapp.components.configuration.impl.NamedMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class XMLAppConfiguration
implements ApplicationConfiguration {
    private Map _maps = new HashMap();
    private Map _lists = new HashMap();
    private Map _params = new HashMap();
    private List _tempLists = new ArrayList();
    private List _tempMaps = new ArrayList();

    public XMLAppConfiguration(String fileName, StorageContext context) throws IOException, SAXException {
        ConfigurationCreator creator = new ConfigurationCreator(this);
        ConfigParser.parse(context, fileName, creator);
    }

    public void addMap(NamedMap map) {
        this._tempMaps.add(map);
    }

    public void addParam(String name, String value) {
        this._params.put(name, value);
    }

    public void addList(NamedList list) {
        this._tempLists.add(list);
    }

    public void freeze() {
        for (NamedMap map : this._tempMaps) {
            this._maps.put(map.getName(), Collections.unmodifiableMap(map));
        }
        this._tempMaps.clear();
        for (NamedList list : this._tempLists) {
            this._lists.put(list.getName(), Collections.unmodifiableList(list));
        }
        this._tempLists.clear();
    }

    @Override
    public Map getMap(String name) {
        return (Map)this._maps.get(name);
    }

    @Override
    public List getList(String name) {
        return (List)this._lists.get(name);
    }

    @Override
    public String getValueFromMap(String mapName, String valueName) {
        return (String)this.getValueFromMap(mapName, valueName, null);
    }

    @Override
    public Object getValueFromMap(String mapName, String valueName, TypeConversion conversion) {
        Map map = this.getMap(mapName);
        Object retval = null;
        String tmp = null;
        if (map != null) {
            tmp = (String)map.get(valueName);
        }
        if (tmp != null) {
            retval = this.performConversion(tmp, conversion);
        }
        return retval;
    }

    @Override
    public String getValueFromList(String listName, int index) {
        return (String)this.getValueFromList(listName, index, null);
    }

    @Override
    public Object getValueFromList(String listName, int index, TypeConversion conversion) {
        List list = this.getList(listName);
        Object retval = null;
        String tmp = null;
        if (list != null) {
            tmp = (String)list.get(index);
        }
        if (tmp != null) {
            retval = this.performConversion(tmp, conversion);
        }
        return retval;
    }

    @Override
    public String getValue(String valueName) {
        return (String)this.getValue(valueName, null);
    }

    @Override
    public Object getValue(String valueName, TypeConversion conversion) {
        String tmp = (String)this._params.get(valueName);
        Object retval = null;
        if (tmp != null) {
            retval = this.performConversion(tmp, conversion);
        }
        return retval;
    }

    private Object performConversion(String value, TypeConversion conversion) {
        Object retval = null;
        if (conversion != null) {
            if (conversion.equals(TypeConversion.INT)) {
                retval = Integer.valueOf(value);
            } else if (conversion.equals(TypeConversion.LONG)) {
                retval = Long.valueOf(value);
            } else if (conversion.equals(TypeConversion.DOUBLE)) {
                retval = Double.valueOf(value);
            } else if (conversion.equals(TypeConversion.BOOLEAN)) {
                retval = value.equals("true") || value.equals("t") || value.equals("yes") || value.equals("y") || value.equals("on") ? Boolean.TRUE : Boolean.FALSE;
            }
        } else {
            retval = value;
        }
        return retval;
    }
}

