/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.acls.domain.AccessControlEntryImpl;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.DefaultPermissionGrantingStrategy;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AuditableAcl;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.OwnershipAcl;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.UnloadedSidException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class AclImpl
implements Acl,
MutableAcl,
AuditableAcl,
OwnershipAcl {
    private Acl parentAcl;
    private transient AclAuthorizationStrategy aclAuthorizationStrategy;
    private transient PermissionGrantingStrategy permissionGrantingStrategy;
    private final List<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
    private ObjectIdentity objectIdentity;
    private Serializable id;
    private Sid owner;
    private List<Sid> loadedSids = null;
    private boolean entriesInheriting = true;

    public AclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy, AuditLogger auditLogger) {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)id, (String)"Id required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        Assert.notNull((Object)auditLogger, (String)"AuditLogger required");
        this.objectIdentity = objectIdentity;
        this.id = id;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.permissionGrantingStrategy = new DefaultPermissionGrantingStrategy(auditLogger);
    }

    public AclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy, PermissionGrantingStrategy grantingStrategy, Acl parentAcl, List<Sid> loadedSids, boolean entriesInheriting, Sid owner) {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)id, (String)"Id required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        Assert.notNull((Object)owner, (String)"Owner required");
        this.objectIdentity = objectIdentity;
        this.id = id;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.parentAcl = parentAcl;
        this.loadedSids = loadedSids;
        this.entriesInheriting = entriesInheriting;
        this.owner = owner;
        this.permissionGrantingStrategy = grantingStrategy;
    }

    private AclImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAce(int aceIndex) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        this.verifyAceIndexExists(aceIndex);
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            this.aces.remove(aceIndex);
        }
    }

    private void verifyAceIndexExists(int aceIndex) {
        if (aceIndex < 0) {
            throw new NotFoundException("aceIndex must be greater than or equal to zero");
        }
        if (aceIndex >= this.aces.size()) {
            throw new NotFoundException("aceIndex must refer to an index of the AccessControlEntry list. List size is " + this.aces.size() + ", index was " + aceIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAce(int atIndexLocation, Permission permission, Sid sid, boolean granting) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        Assert.notNull((Object)permission, (String)"Permission required");
        Assert.notNull((Object)sid, (String)"Sid required");
        if (atIndexLocation < 0) {
            throw new NotFoundException("atIndexLocation must be greater than or equal to zero");
        }
        if (atIndexLocation > this.aces.size()) {
            throw new NotFoundException("atIndexLocation must be less than or equal to the size of the AccessControlEntry collection");
        }
        AccessControlEntryImpl ace = new AccessControlEntryImpl(null, this, sid, permission, granting, false, false);
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            this.aces.add(atIndexLocation, ace);
        }
    }

    @Override
    public List<AccessControlEntry> getEntries() {
        return new ArrayList<AccessControlEntry>(this.aces);
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    @Override
    public ObjectIdentity getObjectIdentity() {
        return this.objectIdentity;
    }

    @Override
    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    @Override
    public boolean isGranted(List<Permission> permission, List<Sid> sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
        Assert.notEmpty(permission, (String)"Permissions required");
        Assert.notEmpty(sids, (String)"SIDs required");
        if (!this.isSidLoaded(sids)) {
            throw new UnloadedSidException("ACL was not loaded for one or more SID");
        }
        return this.permissionGrantingStrategy.isGranted(this, permission, sids, administrativeMode);
    }

    @Override
    public boolean isSidLoaded(List<Sid> sids) {
        if (this.loadedSids == null || sids == null || sids.size() == 0) {
            return true;
        }
        for (Sid sid : sids) {
            boolean found = false;
            for (Sid loadedSid : this.loadedSids) {
                if (!sid.equals(loadedSid)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEntriesInheriting(boolean entriesInheriting) {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        this.entriesInheriting = entriesInheriting;
    }

    @Override
    public void setOwner(Sid newOwner) {
        this.aclAuthorizationStrategy.securityCheck(this, 0);
        Assert.notNull((Object)newOwner, (String)"Owner required");
        this.owner = newOwner;
    }

    @Override
    public Sid getOwner() {
        return this.owner;
    }

    @Override
    public void setParent(Acl newParent) {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        Assert.isTrue((newParent == null || !newParent.equals(this) ? 1 : 0) != 0, (String)"Cannot be the parent of yourself");
        this.parentAcl = newParent;
    }

    @Override
    public Acl getParentAcl() {
        return this.parentAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAce(int aceIndex, Permission permission) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        this.verifyAceIndexExists(aceIndex);
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            AccessControlEntryImpl ace = (AccessControlEntryImpl)this.aces.get(aceIndex);
            ace.setPermission(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAuditing(int aceIndex, boolean auditSuccess, boolean auditFailure) {
        this.aclAuthorizationStrategy.securityCheck(this, 1);
        this.verifyAceIndexExists(aceIndex);
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            AccessControlEntryImpl ace = (AccessControlEntryImpl)this.aces.get(aceIndex);
            ace.setAuditSuccess(auditSuccess);
            ace.setAuditFailure(auditFailure);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AclImpl)) {
            return false;
        }
        AclImpl other = (AclImpl)obj;
        boolean result = true;
        result = result && this.aces.equals(other.aces);
        result = result && ObjectUtils.nullSafeEquals((Object)this.parentAcl, (Object)other.parentAcl);
        result = result && ObjectUtils.nullSafeEquals((Object)this.objectIdentity, (Object)other.objectIdentity);
        result = result && ObjectUtils.nullSafeEquals((Object)this.id, (Object)other.id);
        result = result && ObjectUtils.nullSafeEquals((Object)this.owner, (Object)other.owner);
        result = result && this.entriesInheriting == other.entriesInheriting;
        result = result && ObjectUtils.nullSafeEquals(this.loadedSids, other.loadedSids);
        return result;
    }

    public int hashCode() {
        int result = this.parentAcl != null ? this.parentAcl.hashCode() : 0;
        result = 31 * result + this.aclAuthorizationStrategy.hashCode();
        result = 31 * result + (this.permissionGrantingStrategy != null ? this.permissionGrantingStrategy.hashCode() : 0);
        result = 31 * result + (this.aces != null ? this.aces.hashCode() : 0);
        result = 31 * result + this.objectIdentity.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.loadedSids != null ? this.loadedSids.hashCode() : 0);
        result = 31 * result + (this.entriesInheriting ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AclImpl[");
        sb.append("id: ").append(this.id).append("; ");
        sb.append("objectIdentity: ").append(this.objectIdentity).append("; ");
        sb.append("owner: ").append(this.owner).append("; ");
        int count = 0;
        for (AccessControlEntry ace : this.aces) {
            if (++count == 1) {
                sb.append("\n");
            }
            sb.append(ace).append("\n");
        }
        if (count == 0) {
            sb.append("no ACEs; ");
        }
        sb.append("inheriting: ").append(this.entriesInheriting).append("; ");
        sb.append("parent: ").append(this.parentAcl == null ? "Null" : this.parentAcl.getObjectIdentity().toString());
        sb.append("; ");
        sb.append("aclAuthorizationStrategy: ").append(this.aclAuthorizationStrategy).append("; ");
        sb.append("permissionGrantingStrategy: ").append(this.permissionGrantingStrategy);
        sb.append("]");
        return sb.toString();
    }
}

