/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.metadata.logical.scheduler.visuals.PromptUtilities;
import com.sas.metadata.remote.MdException;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.visuals.swing.FlowTablePanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class FlowPropertiesDependenciesTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(FlowPropertiesDependenciesTab.class);
    private FlowTablePanel m_pnlFlowTablePanel;
    private Frame m_frame;
    private DeployedFlow m_flow;
    private String m_message = "";
    private boolean m_readFromServer = false;
    private boolean m_madeConnection = false;
    private Scheduler m_scheduler;

    public FlowPropertiesDependenciesTab(Frame frame, DeployedFlow flow) throws SchedulerException {
        this.m_frame = frame;
        this.m_flow = flow;
        this.setHelpProduct("shared");
        this.setHelpTopic("depend_tab");
        this.initialize();
        if (this.m_pnlFlowTablePanel == null) {
            String message = null;
            message = this.m_message == null ? m_bundle.getString("FlowPropertiesDependenciesTab.unableTocreateTableview.txt") : MetaUtilities.messageString((String)m_bundle.getString("FlowPropertiesDependenciesTab.unableTocreateTableview.fmt"), (Object)this.m_message);
            throw new SchedulerException(message, FlowPropertiesDependenciesTab.class, "FlowPropertiesDependenciesTab.unableTocreateTableview.fmt", new Object[]{this.m_message});
        }
        this.layOutWidgets();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_pnlFlowTablePanel.saveSettingsAndCleanUp();
        this.m_pnlFlowTablePanel = null;
        this.m_frame = null;
        this.m_flow = null;
        this.m_message = null;
        if (this.m_madeConnection && this.m_scheduler != null) {
            this.m_scheduler.closeConnection();
        }
    }

    public void initialize() {
        block9: {
            try {
                this.m_scheduler = this.m_flow.getSchedulingServer();
                if (this.m_flow.areTimeEvents() && !this.m_scheduler.isConnected()) {
                    int connected = this.m_scheduler.makeConnection((PromptCallbackInterface)new PromptUtilities());
                    if (connected == 1) {
                        this.m_madeConnection = true;
                    } else {
                        MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("FlowPropertiesDependenciesTab.UnableToConnectToScheduler.txt"), (String)m_bundle.getString("FlowPropertiesDependenciesTab.Title.txt"), (int)2);
                    }
                }
                FlowInfo info = this.m_flow.getInfo();
                this.m_pnlFlowTablePanel = new FlowTablePanel(info);
            }
            catch (SchedulerException ex) {
                this.m_pnlFlowTablePanel = null;
                this.m_message = ex.getLocalizedMessage();
            }
            catch (MdException ex) {
                this.m_pnlFlowTablePanel = null;
                this.m_message = ex.getLocalizedMessage();
            }
            catch (RemoteException ex) {
                this.m_pnlFlowTablePanel = null;
                this.m_message = ex.getLocalizedMessage();
            }
            catch (NullPointerException ex) {
                this.m_pnlFlowTablePanel = null;
                ex.printStackTrace();
                this.m_message = m_bundle.getString("FlowPropertiesDependenciesTab.UnableToReadFlowInformation.txt");
            }
            catch (RuntimeException ex) {
                this.m_pnlFlowTablePanel = null;
                ex.printStackTrace();
                this.m_message = ex.getLocalizedMessage();
                if (this.m_message != null) break block9;
                this.m_message = ex.toString();
            }
        }
    }

    private void layOutWidgets() {
        GridBagConstraints table_gbc = new GridBagConstraints(0, 0, 7, 10, 100.0, 100.0, 18, 1, new Insets(15, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlFlowTablePanel, table_gbc);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    public void populateStore() {
        if (this.isStorePopulated()) {
            return;
        }
        this.setListeningForChanges(false);
        this.setStorePopulated(true);
        this.setListeningForChanges(true);
    }

    public void moveDataToView() {
        this.setDataChanged(false);
    }

    public void moveDataToStore() {
    }

    public boolean validateData() {
        return this.m_pnlFlowTablePanel.validateData();
    }

    public void onParentCancel() {
        super.onParentCancel();
        this.m_readFromServer = true;
    }

    public void onParentOK() {
        super.onParentOK();
        this.m_readFromServer = false;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (bDataChanged) {
            try {
                if (this.m_readFromServer) {
                    this.m_flow.refresh();
                }
                this.m_scheduler = this.m_flow.getSchedulingServer();
                if (this.m_scheduler.isConnected()) {
                    this.m_pnlFlowTablePanel.refreshData(this.m_flow.getInfo());
                } else {
                    this.m_scheduler.makeConnection((PromptCallbackInterface)new PromptUtilities());
                    this.m_pnlFlowTablePanel.refreshData(this.m_flow.getInfo());
                    this.m_madeConnection = true;
                }
            }
            catch (SchedulerException ex) {
                MessageUtil.displayMessage(null, (String)ex.getLocalizedMessage(), (String)m_bundle.getString("FlowPropertiesDependenciesTab.Title.txt"), (int)2);
                return;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((Exception)((Object)ex), (String)m_bundle.getString("FlowPropertiesDependenciesTab.Title.txt"), (int)2);
                return;
            }
            catch (RemoteException ex) {
                return;
            }
        }
        super.setDataChanged(bDataChanged);
    }
}

