/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowImportItem;
import com.sas.metadata.logical.scheduler.visuals.FlowPropertiesAttributesTab;
import com.sas.metadata.promotion.DependentObjectsProviderInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.SchedulerException;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FlowPromotionOptionsPanel
extends AbstractPromotionPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(FlowPromotionOptionsPanel.class);
    private TriStateCheckBox m_ckbSchedule;
    private JComboBox m_queues;
    private JLabel m_lblqueues;
    private boolean m_isImport;
    private boolean m_dataChanged;
    private DeployedFlowImportItem m_target;
    private SimpleLogicalObjectInterface[] m_aItems;

    public FlowPromotionOptionsPanel(int iPromotionType) {
        this.m_isImport = iPromotionType == 1;
        String ckbText = m_bundle.getString("FlowPromotionOptionsPanel.ckbSchedule.txt");
        this.m_ckbSchedule = new TriStateCheckBox(Util.getLabelWithoutMnemonic((String)ckbText));
        this.m_ckbSchedule.setMnemonic(Util.getDisplayedMnemonic((String)ckbText));
        this.m_ckbSchedule.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)ckbText));
        this.m_ckbSchedule.setToolTipText(m_bundle.getString("FlowPromotionOptionsPanel.ckbSchedule.ToolTip.txt"));
        this.m_ckbSchedule.setCycleEnabled(false);
        this.m_ckbSchedule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowPromotionOptionsPanel.this.m_dataChanged = true;
            }
        });
        this.m_queues = new JComboBox();
        this.m_queues.setToolTipText(m_bundle.getString("FlowPropertiesAttributesTab.Queues.ToolTip.txt"));
        String queueText = m_bundle.getString("FlowPropertiesAttributesTab.Queues.txt");
        this.m_lblqueues = new JLabel(Util.getLabelWithoutMnemonic((String)queueText));
        this.m_lblqueues.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)queueText));
        this.m_lblqueues.setLabelFor(this.m_queues);
        this.m_queues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FlowPromotionOptionsPanel.this.m_target.setQueue((String)FlowPromotionOptionsPanel.this.m_queues.getSelectedItem());
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_ckbSchedule, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_lblqueues, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_queues, new GridBagConstraints(1, 1, 6, 1, 100.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 10.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void loadComponent(Object sourceData, Object targetData) {
        if (sourceData instanceof DependentObjectsProviderInterface) {
            TargetConnectionInterface target;
            DependentObjectsProviderInterface dopi = (DependentObjectsProviderInterface)sourceData;
            List topLevelObjects = dopi.getDependentObjects();
            Vector items = new Vector();
            for (Object obj : topLevelObjects) {
                if (!(obj instanceof DeployedFlowImportItem)) continue;
                items.add(obj);
            }
            Scheduler scheduler = null;
            Factory factory = null;
            ImportItemInterface[] flows = new ImportItemInterface[items.size()];
            for (int x = 0; x < items.size(); ++x) {
                DeployedFlowImportItem flowItem = (DeployedFlowImportItem)((Object)items.get(x));
                flows[x] = flowItem;
                if (x != 0) continue;
                factory = flowItem.getTypeInterface().getObjectFactory().getFactory();
            }
            if (targetData instanceof TargetConnectionInterface && (target = (TargetConnectionInterface)targetData).getMetadataObject() instanceof ServerComponent) {
                try {
                    ServerComponent sc = (ServerComponent)target.getMetadataObject();
                    String classid = sc.getClassIdentifier();
                    if (classid != null && classid.length() > 0) {
                        scheduler = MetaUtilities.getSchedulingServer((ServerComponent)sc);
                    } else if (factory != null) {
                        String id = sc.getFQID();
                        String repos = "A0000001." + id.substring(0, 8);
                        sc = MetaUtilities.getSchedulerServer((String)id, (MdStore)factory.getScratchStore(), (String)repos);
                        scheduler = MetaUtilities.getSchedulingServer((ServerComponent)sc);
                    }
                }
                catch (RemoteException e) {
                    scheduler = null;
                }
                catch (MdException e) {
                    scheduler = null;
                }
            }
            this.populateImportOptions(flows, scheduler, false);
        }
    }

    public void populateImportOptions(ImportItemInterface[] aItems, Scheduler scheduler, boolean resetSchedule) {
        this.m_aItems = aItems;
        int numItems = aItems.length;
        if (resetSchedule) {
            for (int i = 0; i < numItems; ++i) {
                ((DeployedFlowImportItem)aItems[i]).setSchedule(false);
            }
            this.m_ckbSchedule.setSelectedValue(0);
        } else {
            this.m_ckbSchedule.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
        }
        if (scheduler != null) {
            this.m_target = (DeployedFlowImportItem)aItems[0];
            if (scheduler != null && scheduler.areQueues()) {
                this.m_queues.setEnabled(true);
                Frame frame = this.m_target.getTypeInterface().getObjectFactory().getFactory().getFrame();
                try {
                    FlowPropertiesAttributesTab.resetQueues(frame, null, this.m_queues, this.m_lblqueues, scheduler, false);
                    this.m_queues.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            FlowPromotionOptionsPanel.this.m_target.setQueue((String)FlowPromotionOptionsPanel.this.m_queues.getSelectedItem());
                        }
                    });
                }
                catch (SchedulerException se) {
                    this.m_queues.setEnabled(false);
                }
            }
        } else {
            this.m_queues.setEnabled(false);
        }
    }

    public void saveSettings() {
        if (!this.m_dataChanged) {
            return;
        }
        for (int i = 0; i < this.m_aItems.length; ++i) {
            if (!this.m_isImport) continue;
            ((DeployedFlowImportItem)this.m_aItems[i]).setSchedule(this.m_ckbSchedule.isSelected());
        }
        this.m_dataChanged = false;
    }

    private int determineCheckBoxState(SimpleLogicalObjectInterface[] aItems) {
        for (int i = 0; i < this.m_aItems.length; ++i) {
            ((DeployedFlowImportItem)this.m_aItems[i]).setSchedule(false);
        }
        return 0;
    }

    public String getLabel() {
        return m_bundle.getString("FlowPromotionOptionsPanel.TabLabel.txt");
    }
}

