/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.schedulingservers;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchedulingServers {
    static final Logger log = Logger.getLogger(SchedulingServers.class.getName());
    private List<?> m_servers;
    private int m_selectedServerIndex;

    public SchedulingServers(int type, MdStore objStore, String reposID) throws MdException, RemoteException {
        log.fine("constructor called");
        this.m_servers = MetaUtilities.getSchedulerServers((int)type, (MdStore)objStore, (String)reposID);
        if (this.m_servers == null) {
            this.m_servers = Collections.EMPTY_LIST;
        }
    }

    public int size() {
        return this.m_servers.size();
    }

    public ServerComponent get(int serverIndex) {
        return (ServerComponent)this.m_servers.get(serverIndex);
    }

    public ServerComponent[] getServers() {
        log.fine("entering");
        ServerComponent[] retVal = this.m_servers.toArray(new ServerComponent[0]);
        if (log.isLoggable(Level.FINE)) {
            for (int i = 0; i < retVal.length; ++i) {
                log.fine("servers[" + i + "] = " + retVal[i]);
            }
        }
        return retVal;
    }

    public void setSelectedIndex(int index) {
        this.m_selectedServerIndex = index;
    }

    public int getSelectedIndex() {
        return this.m_selectedServerIndex;
    }
}

