/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.job;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.scheduler.job.DeployedJobLogicalObject;
import com.sas.metadata.logical.scheduler.job.DeployedJobType;
import com.sas.metadata.logical.scheduler.visuals.JobGeneralPropertyTab;
import com.sas.metadata.logical.scheduler.visuals.JobSchedulingDetailsTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.workspace.WAPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;

public class DeployedJobLogicalObjectFactory
implements ObjectFactoryInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobLogicalObjectFactory.class);
    private Action[] NO_ACTIONS = new Action[0];
    private TypeInterface m_type;
    private Factory m_factory;
    private MdObjectStore m_store;

    public DeployedJobLogicalObjectFactory(Factory factory) {
        this.m_type = DeployedJobType.getInstance(this);
        this.m_factory = factory;
    }

    public DeployedJobLogicalObjectFactory(Factory factory, TypeInterface type) {
        this.m_type = type;
        this.m_factory = factory;
    }

    public Factory getFactory() {
        return this.m_factory;
    }

    public TypeInterface getType() {
        return this.m_type;
    }

    public MdObjectStore getStore() throws RemoteException {
        if (this.m_store == null) {
            this.m_store = this.m_factory.getScratchStore();
        }
        return this.m_store;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root mdo) throws RemoteException {
        return new DeployedJobLogicalObject((JFJob)mdo, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogicalObjectInterface> getAllObjects(String sRepositoryFQID) throws MdException, RemoteException {
        if (sRepositoryFQID == null) {
            return new ArrayList<LogicalObjectInterface>();
        }
        MdFactory factory = this.m_factory.getMdFactory();
        MdObjectStore tempstore = factory.createObjectStore(null, "DeployedJobLogicalObjectFactory");
        String options = "<XMLSelect search=\"*[@PublicType='" + this.m_type.getPublicType() + "']\"/>";
        ArrayList<LogicalObjectInterface> list = new ArrayList<LogicalObjectInterface>();
        try {
            MdOMIUtil omiUtil = this.getFactory().getOMIUtil();
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)tempstore, sRepositoryFQID, this.m_type.getMetadataType(), 388, options);
            for (Root root : objects) {
                list.add(this.createItemFromMetadataObject(root));
            }
        }
        finally {
            tempstore.dispose();
        }
        return list;
    }

    public Action[] getActions(LogicalObjectInterface lobData, Root mdoData, Config config) {
        return this.NO_ACTIONS;
    }

    public Action[] getActions(LogicalObjectInterface[] aLogicalObjects, Root[] aObjects, Config config) {
        return this.NO_ACTIONS;
    }

    public List<WAPropertyTab> getPropertyTabs(LogicalObjectInterface lob, Root mdo, Config config) throws RemoteException, MdException {
        ArrayList<WAPropertyTab> tabList = new ArrayList<WAPropertyTab>();
        Frame frame = this.m_factory.getFrame();
        DeployedJob job = null;
        DeployedFlow flow = null;
        try {
            MdObjectStore store = this.m_factory.getScratchStore();
            String repos = "A0000001." + mdo.getId().substring(0, 8);
            job = new DeployedJob(MetaUtilities.getJFJob((String)mdo.getId(), (MdStore)store, (String)repos));
        }
        catch (SchedulerException se) {
            throw new IllegalArgumentException(MetaUtilities.messageString((String)m_bundle.getString("DeployedJobLogicalObjectFactory.UnableToDisplayProperties.fmt"), (Object)se.getLocalizedMessage()));
        }
        if (job != null) {
            JobSchedulingDetailsTab tab2 = new JobSchedulingDetailsTab(frame, job, flow, flow != null);
            tab2.setName(m_bundle.getString("DeployedJobLogicalObjectFactory.SchedulingDetailsTab.Name.txt"));
            JobGeneralPropertyTab tab1 = new JobGeneralPropertyTab(frame, job, mdo);
            tab1.setName(m_bundle.getString("DeployedJobLogicalObjectFactory.GeneralTab.Name.txt"));
            tabList.add((WAPropertyTab)tab1);
            if (lob.isReadCompatible()) {
                tabList.add(tab2);
            }
        }
        tabList.trimToSize();
        return tabList;
    }
}

