/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.job;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.MoveDisallowedCause;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.scheduler.common.Utilities;
import com.sas.metadata.logical.scheduler.job.DeployedJobLogicalObjectFactory;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class DeployedJobLogicalObject
extends LogicalObject
implements MemberInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobLogicalObject.class);
    private TypeInterface m_type;

    public DeployedJobLogicalObject(JFJob mdoDeployedJob, DeployedJobLogicalObjectFactory factory) throws RemoteException {
        super((Root)mdoDeployedJob, factory.getType(), factory.getFactory());
        this.m_type = factory.getType();
        this.setCompatibility(new UsageVersion(1, 0), new UsageVersion(2, 0));
    }

    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException {
        LogicalTypeException lte;
        MdObjectStore tempstore = null;
        try {
            List flows;
            MdFactory factory = Utilities.getMdFactory(false);
            tempstore = factory.createObjectStore(null, "DeployedJobDelete");
            String repos = "A0000001." + super.getID().substring(0, 8);
            JFJob jfjob = MetaUtilities.getJFJob((String)super.getID(), (String)"<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)tempstore, (String)repos);
            oui.updateProgress(MetaUtilities.messageString((String)m_bundle.getString("DeployedJobLogicalObject.Deleting.Msg.fmt"), (Object)jfjob.getName()));
            DeployedJob job = new DeployedJob(jfjob);
            int choice = 0;
            if (oui.isUserInteractionSupported() && (flows = job.getListofFlows()).size() > 0) {
                choice = oui.displayMessage(m_bundle.getString("DeployedJobLogicalObject.Deleting.Title.txt"), MetaUtilities.messageString((String)m_bundle.getString("DeployedJobLogicalObject.Deleting.MessageText.fmt"), (Object)job.getName(), (Object)flows), 3, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
            }
            if (choice == 0) {
                job.removeAll();
                boolean rc = job.delete();
                if (rc) {
                    job.commitChangesWithNoValidation();
                }
                boolean bl = rc;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SchedulerException se) {
            lte = new LogicalTypeException(se.getMessage());
            throw lte;
        }
        catch (RemoteException re) {
            lte = new LogicalTypeException(re.getMessage());
            throw lte;
        }
        catch (MdException mde) {
            lte = new LogicalTypeException(mde.getMessage());
            throw lte;
        }
        finally {
            if (tempstore != null) {
                try {
                    tempstore.dispose();
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    public void rename(String newName, OperationUserInteractionInterface oui) throws LogicalTypeException {
        if (newName.equals(this.getName())) {
            return;
        }
        MdObjectStore tempstore = null;
        try {
            MdFactory factory = Utilities.getMdFactory(false);
            tempstore = factory.createObjectStore(null, "DeployedJobRename");
            String repos = "A0000001." + super.getID().substring(0, 8);
            JFJob jfjob = MetaUtilities.getJFJob((String)super.getID(), (MdStore)tempstore, (String)repos);
            oui.updateProgress(MetaUtilities.messageString((String)m_bundle.getString("DeployedJobLogicalObject.Renaming.Msg.fmt"), (Object)jfjob.getName(), (Object)newName));
            jfjob.setName(newName);
            jfjob.updateMetadataAll();
            this.refresh((Root)jfjob);
        }
        catch (SchedulerException se) {
            LogicalTypeException lte = new LogicalTypeException(se.getMessage());
            throw lte;
        }
        catch (RemoteException re) {
            LogicalTypeException lte = new LogicalTypeException(re.getMessage());
            throw lte;
        }
        catch (MdException mde) {
            LogicalTypeException lte = new LogicalTypeException(mde.getMessage());
            throw lte;
        }
        finally {
            if (tempstore != null) {
                try {
                    tempstore.dispose();
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    public void move(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        MoveDisallowedCause cause = this.checkMoveAllowed(targetFolder);
        if (cause != null) {
            throw new UnsupportedOperationException(cause.toString());
        }
        MdObjectStore tempstore = null;
        try {
            MdFactory factory = Utilities.getMdFactory(false);
            tempstore = factory.createObjectStore(null, "DeployedJobMove");
            String repos = "A0000001." + super.getID().substring(0, 8);
            JFJob jfjob = MetaUtilities.getJFJob((String)super.getID(), (MdStore)tempstore, (String)repos);
            DeployedJob job = new DeployedJob(jfjob);
            Tree target = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject((LogicalObjectInterface)targetFolder, (MdObjectStore)tempstore);
            job.setFolder(target);
            job.commitChangesWithNoValidation();
            this.refresh((Root)jfjob);
        }
        catch (SchedulerException se) {
            LogicalTypeException lte = new LogicalTypeException(se.getMessage());
            throw lte;
        }
        catch (RemoteException re) {
            LogicalTypeException lte = new LogicalTypeException(re.getMessage());
            throw lte;
        }
        catch (MdException mde) {
            LogicalTypeException lte = new LogicalTypeException(mde.getMessage());
            throw lte;
        }
        finally {
            if (tempstore != null) {
                try {
                    tempstore.dispose();
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    public Icon getIcon() {
        return this.m_type.getIcon(1);
    }
}

