/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.job;

import com.sas.io.InputStreamAdapter;
import com.sas.iom.SAS.IFileService;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.job.JobConnectionType;
import com.sas.metadata.logical.scheduler.batchservers.BatchServerContextValidator;
import com.sas.metadata.logical.scheduler.common.DeploymentDirectoryConnectionType;
import com.sas.metadata.logical.scheduler.common.Utilities;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowImportListener;
import com.sas.metadata.logical.scheduler.job.DeployedJobImportItem;
import com.sas.metadata.logical.scheduler.job.DeployedJobImportNameValidator;
import com.sas.metadata.logical.scheduler.visuals.DeployedJobPromotionOptionsPanel;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.services.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class DeployedJobImportListener
extends AbstractImportListener
implements NotificationListener,
PromotionOptionsInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobImportListener.class);
    protected static final Class[] CONNECTION_TYPES = new Class[]{AppServerConnectionType.class, JobConnectionType.class, DeploymentDirectoryConnectionType.class};
    private MdObjectStore m_store;
    private String m_repos;
    private DeployedJobPromotionOptionsPanel _optionsPanel;

    public DeployedJobImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new DeployedJobImportItem(name, id, type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public void initialize(ImportOperationInterface operation) {
        super.addValidatorInterface((ConnectionValidatorInterface)new BatchServerContextValidator());
        this.m_repos = operation.getRepositoryID();
        try {
            this.m_store = operation.getStore().getFactory().createObjectStore(null, "DeployedJobImportListener");
        }
        catch (RemoteException e) {
            this.m_store = operation.getStore();
        }
    }

    public int analyzeObjectsToImport(ImportOperationInterface importHandler, List objects) throws MetadataPromotionException {
        if (importHandler.isProjectRepository()) {
            throw new MetadataPromotionException(m_bundle.getString("DeployedJobImportListener.ProjectRepos.txt"));
        }
        importHandler.addNotificationListener((NotificationListener)this);
        return 0;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface operation) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface operation) {
        if (this._optionsPanel == null) {
            this._optionsPanel = new DeployedJobPromotionOptionsPanel(operation.getPromotionType());
        }
        this._optionsPanel.populateImportOptions(items, operation.getPropertiesFile());
        return this._optionsPanel;
    }

    public void saveSettings() {
        this._optionsPanel.saveSettings();
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) {
        return 0;
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        int rc = 0;
        boolean batchmode = operation.isBatchProcess() || operation.getPromotionType() == 2;
        try {
            for (ImportItemInterface importItem : objects) {
                Map contentMap = operation.getContentHandler().getTextContent(importItem.getID());
                for (Map.Entry element : contentMap.entrySet()) {
                    String content;
                    int charsRead;
                    char[] dataBuffer;
                    StringBuffer buffer;
                    Reader in;
                    String key = (String)element.getKey();
                    String targetId = importItem.getTargetID();
                    JFJob jfjob = MetaUtilities.getJFJob((String)targetId, (String)"<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)this.m_store, (String)this.m_repos);
                    DeployedJob djob = new DeployedJob(jfjob);
                    if ("###SCHJOBSRC###".equals(key)) {
                        if (this.includeContentForItem(importItem, operation)) {
                            in = (Reader)element.getValue();
                            buffer = new StringBuffer();
                            dataBuffer = new char[1024];
                            charsRead = in.read(dataBuffer);
                            while (charsRead > 0) {
                                buffer.append(dataBuffer, 0, charsRead);
                                charsRead = in.read(dataBuffer);
                            }
                            content = buffer.toString();
                            File srcFile = djob.getSourceCode();
                            if (srcFile == null) continue;
                            Job job = djob.getJobObject();
                            String srcName = srcFile.getFileName();
                            String srcExt = srcFile.getFileExtension();
                            if (srcExt != null && srcExt.length() > 0) {
                                srcName = srcExt.startsWith(".") ? srcName + srcExt : srcName + "." + srcExt;
                            }
                            Directory directory = null;
                            if (srcFile.getDirectories().size() != 0) {
                                try {
                                    directory = (Directory)srcFile.getDirectories().get(0);
                                }
                                catch (ArrayIndexOutOfBoundsException ex) {
                                    operation.getLogger().error((Object)ex.toString(), (Throwable)ex);
                                    rc = 8;
                                }
                            }
                            try {
                                IFileService rio = Utilities.getFileServer(operation.getSessionContext(), jfjob, batchmode);
                                int os = CommandUtilities.getTargetOSForBatchServer((ServerComponent)djob.getBatchServer());
                                String srcfile = CommandUtilities.createFullPath((String)directory.getDirectoryName(), (String)srcName, (int)os);
                                CommandUtilities.saveToRemoteFile((IFileService)rio, (String)srcfile, (int)os, (String)content);
                            }
                            catch (Exception ex) {
                                operation.getLogger().error((Object)ex.toString(), (Throwable)ex);
                                rc = 8;
                            }
                            if (job != null && job.getIsUserDefined() == 0) {
                                operation.getLogger().info((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobImportListener.NotUserWrittenJob.fmt"), (Object)djob.getName()));
                                continue;
                            }
                            operation.getLogger().info((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobImportListener.CopyingUserWrittenJob.fmt"), (Object)djob.getName(), (Object)directory.getName()));
                            continue;
                        }
                        operation.getLogger().info((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobImportListener.NoSourceFileImported.fmt"), (Object)djob.getName()));
                        continue;
                    }
                    if (!"###SCHJOBJCL###".equals(key)) continue;
                    in = (Reader)element.getValue();
                    buffer = new StringBuffer();
                    dataBuffer = new char[1024];
                    charsRead = in.read(dataBuffer);
                    while (charsRead > 0) {
                        buffer.append(dataBuffer, 0, charsRead);
                        charsRead = in.read(dataBuffer);
                    }
                    content = buffer.toString();
                    File jclFile = djob.getJCL();
                    if (jclFile == null) continue;
                    String jclName = jclFile.getFileName();
                    String jclExt = jclFile.getFileExtension();
                    if (jclExt != null && jclExt.length() > 0) {
                        jclName = jclExt.startsWith(".") ? jclName + jclExt : jclName + "." + jclExt;
                    }
                    Directory directory = null;
                    if (jclFile.getDirectories().size() != 0) {
                        try {
                            directory = (Directory)jclFile.getDirectories().get(0);
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            operation.getLogger().error((Object)ex.toString(), (Throwable)ex);
                            rc = 8;
                        }
                    }
                    try {
                        IFileService rio = Utilities.getFileServer(operation.getSessionContext(), jfjob, batchmode);
                        String jclfile = CommandUtilities.createFullPath((String)directory.getDirectoryName(), (String)jclName, (int)2);
                        CommandUtilities.saveToRemoteFile((IFileService)rio, (String)jclfile, (int)2, (String)content);
                    }
                    catch (Exception ex) {
                        operation.getLogger().error((Object)ex.toString(), (Throwable)ex);
                        rc = 8;
                    }
                    operation.getLogger().info((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobImportListener.CopyingJobJCL.fmt"), (Object)djob.getName(), (Object)(directory != null ? directory.getName() : "")));
                }
            }
        }
        catch (SchedulerException se) {
            operation.getLogger().error((Object)se.toString());
            operation.getLogger().debug((Object)se);
            rc = 8;
        }
        catch (MdException mde) {
            operation.getLogger().error((Object)mde.toString());
            operation.getLogger().debug((Object)mde);
            rc = 8;
        }
        return rc;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        MetadataPromotionException ex = null;
        MdObjectStore store = null;
        try {
            store = this.m_store.getFactory().createObjectStore(null, "DeployedJob_updateObjects");
        }
        catch (RemoteException e) {
            store = this.m_store;
        }
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            MetadataPromotionException e;
            try {
                ImportItemInterface importItem = (ImportItemInterface)i.next();
                ContentHandlerInterface handler = operation.getContentHandler();
                int version = handler.getPackageVersion();
                Map contentMap = null;
                contentMap = version < 9200 ? handler.getBinaryContent(importItem.getID()) : handler.getTextContent(importItem.getID());
                String targetId = importItem.getTargetID();
                JFJob jfjob = MetaUtilities.getJFJob((String)targetId, (String)"<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)store, (String)this.m_repos);
                for (Map.Entry element : contentMap.entrySet()) {
                    String name;
                    String[] tokens;
                    char subtype;
                    String key = (String)element.getKey();
                    if (!"###SCHJOB###".equals(key)) continue;
                    Reader in = null;
                    if (version < 9200) {
                        InputStreamAdapter file = (InputStreamAdapter)element.getValue();
                        in = new InputStreamReader((InputStream)file);
                    } else {
                        in = (Reader)element.getValue();
                    }
                    StringBuffer buffer = new StringBuffer();
                    char[] dataBuffer = new char[1024];
                    int charsRead = in.read(dataBuffer);
                    while (charsRead > 0) {
                        buffer.append(dataBuffer, 0, charsRead);
                        charsRead = in.read(dataBuffer);
                    }
                    String batchServerClassid = null;
                    ServerComponent batchServer = null;
                    if (buffer.charAt(0) == '\r' && buffer.charAt(1) == '\n') {
                        subtype = buffer.charAt(1);
                        batchServerClassid = MetaUtilities.replaceString((String)buffer.toString().substring(2), (String)"\r\n", (String)"");
                        if (batchServerClassid.contains(":::")) {
                            tokens = batchServerClassid.split(":::");
                            batchServerClassid = tokens[0];
                            name = tokens[1];
                            batchServer = DeployedJobImportListener.findServerComponentForJob(jfjob, batchServerClassid, name, subtype);
                        } else {
                            batchServer = CommandUtilities.findServerComponentForJob((JFJob)jfjob, (String)batchServerClassid, (int)subtype);
                        }
                    } else {
                        subtype = buffer.charAt(0);
                        batchServerClassid = MetaUtilities.replaceString((String)buffer.toString().substring(1), (String)"\r\n", (String)"");
                        if (batchServerClassid.contains(":::")) {
                            tokens = batchServerClassid.split(":::");
                            batchServerClassid = tokens[0];
                            name = tokens[1];
                            batchServer = DeployedJobImportListener.findServerComponentForJob(jfjob, batchServerClassid, name, subtype);
                        } else {
                            batchServer = CommandUtilities.findServerComponentForJob((JFJob)jfjob, (String)batchServerClassid, (int)subtype);
                        }
                    }
                    if (batchServer != null) {
                        jfjob.getTargetSpecifications().clear();
                        jfjob.getTargetSpecifications().add((Object)batchServer);
                        break;
                    }
                    CommandUtilities.setServerComponentPropertyForJob((JFJob)jfjob, (String)batchServerClassid);
                    String batchTypeStr = BatchServerInfo.getTypeName((int)BatchServerInfo.getType((String)batchServerClassid));
                    String appServer = CommandUtilities.getAppServerName((JFJob)jfjob);
                    if (appServer == null) {
                        appServer = "";
                    }
                    operation.getLogger().error((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobImportListener.NoBatchServer.fmt"), (Object)batchTypeStr, (Object)appServer, (Object)jfjob.getName()));
                    rc = 8;
                    break;
                }
                store.updatedMetadataAll();
            }
            catch (IOException ioe) {
                e = new MetadataPromotionException(ioe.toString());
                ex.initCause((Throwable)ioe);
                ex = e;
            }
            catch (TransportException te) {
                e = new MetadataPromotionException(te.toString());
                ex.initCause((Throwable)te);
                ex = e;
            }
            catch (SchedulerException se) {
                e = new MetadataPromotionException(se.toString());
                ex.initCause((Throwable)se);
                ex = e;
            }
            catch (MdException mde) {
                e = new MetadataPromotionException(mde.toString());
                ex.initCause((Throwable)mde);
                ex = e;
            }
        }
        if (ex != null) {
            operation.getLogger().error((Object)ex.getMessage(), ex.getCause());
            operation.getLogger().debug((Object)ex, ex.getCause());
            return 8;
        }
        try {
            if (store != this.m_store) {
                store.dispose();
            }
        }
        catch (RemoteException re) {
            operation.getLogger().error((Object)re.toString());
            operation.getLogger().debug((Object)re);
            return 8;
        }
        return 0;
    }

    public ImportNameValidatorInterface getNameValidatorInterface() {
        return new DeployedJobImportNameValidator();
    }

    public void notify(NotificationEvent event) {
        switch (event.getEventType()) {
            case 200: {
                Utilities.clearFileServerCache();
                if (this.m_store == null) break;
                try {
                    this.m_store.updatedMetadataAll();
                    this.m_store.dispose();
                    this.m_store = null;
                }
                catch (RemoteException e) {
                    Log log = Log.getInstance((String)DeployedFlowImportListener.class.getName());
                    log.error((Object)e.toString(), (Throwable)e);
                }
                catch (MdException e) {
                    Log log = Log.getInstance((String)DeployedFlowImportListener.class.getName());
                    log.error((Object)e.toString(), (Throwable)e);
                }
                break;
            }
        }
    }

    private boolean includeContentForItem(ImportItemInterface importItem, ImportOperationInterface operation) {
        boolean includeContent = true;
        String exclude = operation.getPropertiesFile().getProperty(importItem.getID() + "_ExcludeContent");
        if (exclude != null && exclude.equalsIgnoreCase("true")) {
            includeContent = false;
        } else if (!((DeployedJobImportItem)importItem).getIncludeContent()) {
            includeContent = false;
        }
        return includeContent;
    }

    private static ServerComponent findServerComponentForJob(JFJob job, String classid, String name, int subtype) throws RemoteException, MdException {
        if (classid == null) {
            return null;
        }
        AssociationList cl = job.getComputeLocations();
        if (cl.size() == 0) {
            return null;
        }
        ServerComponent first = null;
        ServerComponent scontext = (ServerComponent)cl.get(0);
        if (scontext instanceof ServerContext) {
            AssociationList usingComponents = scontext.getUsingComponents();
            for (LogicalServer logicalServer : usingComponents) {
                String classID = logicalServer.getClassIdentifier();
                if (classid.compareTo(classID) != 0) continue;
                AssociationList components = logicalServer.getUsingComponents();
                for (ServerComponent sc : components) {
                    if (classID.equalsIgnoreCase("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8") || classID.equalsIgnoreCase("d6644527-7a09-4fe2-8bac-1caca2f6a46c") || classID.equalsIgnoreCase("a1ff485f-9e44-4c82-90b5-062916cfa9b9")) {
                        if (first == null) {
                            first = sc;
                        }
                        if (name == null || name.compareTo(sc.getName()) != 0) continue;
                        return sc;
                    }
                    if (!classID.equalsIgnoreCase("0069e914-b58c-4094-a686-a87df433ec4b")) continue;
                    if (subtype != 0) {
                        if (sc == null || MetaUtilities.getBatchServerSubType((ServerComponent)sc) != subtype) continue;
                        if (first == null) {
                            first = sc;
                        }
                        if (name == null || name.compareTo(sc.getName()) != 0) continue;
                        return sc;
                    }
                    if (first == null) {
                        first = sc;
                    }
                    if (name == null || name.compareTo(sc.getName()) != 0) continue;
                    return sc;
                }
            }
        } else {
            return scontext;
        }
        return first;
    }
}

