/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.job;

import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class DeployedJobConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface {
    private static final String TYPE_NAME = "Deployed Job";
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobConnectionType.class);
    private List<SourceConnectionInterface> _deployedJobConnections;

    public DeployedJobConnectionType(PromotionInterface promotionOperation) {
        super(promotionOperation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public String getLocalizedTypeName() {
        return m_bundle.getString("DeployedJobConnectionType.ConnectionType.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.scheduler.visuals.DeployedJobConnectionPanel";
    }

    public List<SourceConnectionInterface> getSourceConnections() {
        if (this._deployedJobConnections == null) {
            List jobConnectionPoints = this._connectionManager.getConnections(ConnectionObjectType.PublicType, "DeployedJob");
            this._deployedJobConnections = new ArrayList<SourceConnectionInterface>(jobConnectionPoints.size());
            for (ConnectionPointInterface pt : jobConnectionPoints) {
                if ("SCHEDULER_JOB".compareTo(DeployedJobConnectionType.getTransformRole(pt)) != 0) continue;
                SourceConnectionInterface sourceConnection = this.createSourceConnection(pt, pt.getName());
                this._deployedJobConnections.add(sourceConnection);
            }
        }
        return this._deployedJobConnections;
    }

    public List<TargetConnectionInterface> getTargetConnections() throws MdException, RemoteException {
        MdObjectStore store = this._operation.getStore();
        List targetDeployedJobs = MetaUtilities.getDeployedJobObjects((MdObjectStore)store, (String)this._operation.getRepositoryID());
        ArrayList<TargetConnectionInterface> tables = new ArrayList<TargetConnectionInterface>(targetDeployedJobs.size());
        for (CMetadata deployedJob : targetDeployedJobs) {
            tables.add(this.createTargetConnection(deployedJob, deployedJob.getName()));
        }
        return tables;
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return false;
    }

    public static String getTransformRole(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int startIndex = searchAttribute.indexOf("TransformRole");
        if (startIndex > -1) {
            int len = startIndex + "TransformRole".length() + 2;
            return searchAttribute.substring(len, searchAttribute.indexOf("'", len));
        }
        return null;
    }

    public static String getAssociatedServerName(ConnectionPointInterface pt) {
        int index;
        String searchAttribute = pt.getSourceSearchString();
        int startIndex = searchAttribute.indexOf("ComputeLocations");
        if (startIndex > -1 && (index = searchAttribute.indexOf("@Name='", startIndex)) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf("'", index + 7));
        }
        return null;
    }
}

