/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.flow;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowLogicalObject;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowType;
import com.sas.metadata.logical.scheduler.visuals.FlowGeneralPropertyTab;
import com.sas.metadata.logical.scheduler.visuals.FlowPropertiesAttributesTab;
import com.sas.metadata.logical.scheduler.visuals.FlowPropertiesDependenciesTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.workspace.WAPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;

public class DeployedFlowLogicalObjectFactory
implements ObjectFactoryInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedFlowLogicalObjectFactory.class);
    private Action[] NO_ACTIONS = new Action[0];
    private TypeInterface m_type;
    private Factory m_factory;
    private MdObjectStore m_store;
    private HashMap<String, Action[]> m_actions = new HashMap();

    public DeployedFlowLogicalObjectFactory(Factory factory) {
        this.m_type = DeployedFlowType.getInstance(this);
        this.m_factory = factory;
    }

    public DeployedFlowLogicalObjectFactory(Factory factory, TypeInterface type) {
        this.m_type = type;
        this.m_factory = factory;
    }

    public Factory getFactory() {
        return this.m_factory;
    }

    public TypeInterface getType() {
        return this.m_type;
    }

    public MdObjectStore getStore() throws RemoteException {
        if (this.m_store == null || this.m_store.getFactory() == null) {
            this.m_store = this.m_factory.getMdFactory().createObjectStore(null, "DeployedFlowLogicalObjectFactory");
        }
        return this.m_store;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root mdo) throws RemoteException {
        return new DeployedFlowLogicalObject((JFJob)mdo, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogicalObjectInterface> getAllObjects(String sRepositoryFQID) throws MdException, RemoteException {
        if (sRepositoryFQID == null) {
            return new ArrayList<LogicalObjectInterface>();
        }
        MdFactory factory = this.m_factory.getMdFactory();
        MdObjectStore tempstore = factory.createObjectStore();
        String options = "<XMLSelect search=\"*[@PublicType='" + this.m_type.getPublicType() + "']\"/>";
        ArrayList<LogicalObjectInterface> list = new ArrayList<LogicalObjectInterface>();
        try {
            MdOMIUtil omiUtil = this.getFactory().getOMIUtil();
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)tempstore, sRepositoryFQID, this.m_type.getMetadataType(), 388, options);
            for (Root root : objects) {
                list.add(this.createItemFromMetadataObject(root));
            }
        }
        finally {
            tempstore.dispose();
        }
        return list;
    }

    public Action[] getActions(LogicalObjectInterface lobData, Root mdoData, Config config) {
        Action[] actions;
        if (mdoData instanceof Tree) {
            return this.NO_ACTIONS;
        }
        JFJob jfjob = null;
        String id = null;
        try {
            id = mdoData != null ? mdoData.getId() : lobData.getID();
            actions = this.m_actions.get(id);
            if (actions != null) {
                return actions;
            }
            MdObjectStore store = this.getStore();
            String repos = "A0000001." + id.substring(0, 8);
            jfjob = MetaUtilities.getJFJob((String)id, (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)store, (String)repos);
        }
        catch (SchedulerException actions2) {
        }
        catch (RemoteException actions2) {
        }
        catch (MdException actions2) {
            // empty catch block
        }
        if (jfjob != null) {
            actions = new Action[1];
            this.m_actions.put(id, actions);
            return actions;
        }
        return this.NO_ACTIONS;
    }

    public Action[] getActions(LogicalObjectInterface[] aLogicalObjects, Root[] aObjects, Config config) {
        int num = aLogicalObjects.length;
        for (int index = 0; index < num; ++index) {
            LogicalObjectInterface obj = aLogicalObjects[index];
            if (obj instanceof DeployedFlowLogicalObject) continue;
            return this.NO_ACTIONS;
        }
        JFJob[] dflows = new JFJob[num];
        String id = null;
        for (int index = 0; index < num; ++index) {
            try {
                String repos;
                id = aObjects[index] != null ? aObjects[index].getId() : aLogicalObjects[index].getID();
                Action[] actions = this.m_actions.get(id);
                if (actions != null) {
                    return actions;
                }
                MdObjectStore store = this.getStore();
                JFJob jfjob = MetaUtilities.getJFJob((String)id, (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)store, (String)(repos = "A0000001." + id.substring(0, 8)));
                if (jfjob == null) continue;
                dflows[index] = jfjob;
                continue;
            }
            catch (SchedulerException se) {
                dflows = null;
                continue;
            }
            catch (RemoteException re) {
                dflows = null;
                continue;
            }
            catch (MdException mde) {
                dflows = null;
            }
        }
        if (dflows != null && dflows.length > 0) {
            Action[] actions = new Action[1];
            this.m_actions.put(id, actions);
            return actions;
        }
        return this.NO_ACTIONS;
    }

    public List<WAPropertyTab> getPropertyTabs(LogicalObjectInterface lob, Root mdo, Config config) throws RemoteException, MdException {
        ArrayList<WAPropertyTab> tabList = new ArrayList<WAPropertyTab>();
        Frame frame = this.m_factory.getFrame();
        DeployedFlow dflow = null;
        JFJob jfjob = null;
        try {
            MdObjectStore store = this.m_factory.getScratchStore();
            String repos = "A0000001." + mdo.getId().substring(0, 8);
            jfjob = MetaUtilities.getJFJob((String)mdo.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)store, (String)repos);
            dflow = new DeployedFlow(jfjob, store);
        }
        catch (SchedulerException se) {
            throw new IllegalArgumentException(MetaUtilities.messageString((String)m_bundle.getString("DeployedFlowLogicalObjectFactory.UnableToDisplayProperties.fmt"), (Object)se.getLocalizedMessage()));
        }
        if (dflow != null) {
            FlowGeneralPropertyTab tab1 = new FlowGeneralPropertyTab(frame, dflow, (Root)jfjob);
            tab1.setName(m_bundle.getString("DeployedFlowLogicalObjectFactory.GeneralTab.Name.txt"));
            tabList.add((WAPropertyTab)tab1);
            if (lob.isReadCompatible()) {
                FlowPropertiesAttributesTab tab2 = null;
                try {
                    tab2 = new FlowPropertiesAttributesTab(frame, dflow);
                    tab2.setName(m_bundle.getString("DeployedFlowLogicalObjectFactory.FlowPropertiesAttributesTab.Name.txt"));
                    tabList.add(tab2);
                }
                catch (SchedulerException schedulerException) {
                    // empty catch block
                }
                try {
                    FlowPropertiesDependenciesTab tab3 = new FlowPropertiesDependenciesTab(frame, dflow);
                    tab3.setName(m_bundle.getString("DeployedFlowLogicalObjectFactory.FlowPropertiesDependenciesTab.Name.txt"));
                    tabList.add(tab3);
                    if (tab2 != null) {
                        tab2.setDependentTab(tab3);
                    }
                }
                catch (SchedulerException schedulerException) {
                    // empty catch block
                }
            }
        }
        tabList.trimToSize();
        return tabList;
    }
}

