/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.flow;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.MoveDisallowedCause;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.scheduler.common.Utilities;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowLogicalObjectFactory;
import com.sas.metadata.logical.scheduler.visuals.PromptUtilities;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class DeployedFlowLogicalObject
extends LogicalObject
implements MemberInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedFlowLogicalObject.class);
    private TypeInterface m_type;

    public DeployedFlowLogicalObject(JFJob mdoDeployedFlow, DeployedFlowLogicalObjectFactory factory) throws RemoteException {
        super((Root)mdoDeployedFlow, factory.getType(), factory.getFactory());
        this.m_type = factory.getType();
        this.setCompatibility(new UsageVersion(1, 0), new UsageVersion(2, 0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException {
        LogicalTypeException lte;
        MdObjectStore tempstore = null;
        try {
            List flows;
            MdFactory factory = Utilities.getMdFactory(false);
            tempstore = factory.createObjectStore(null, "DeployedFlowDelete");
            String repos = "A0000001." + super.getID().substring(0, 8);
            JFJob jfjob = MetaUtilities.getJFJob((String)super.getID(), (String)"<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)tempstore, (String)repos);
            oui.updateProgress(MetaUtilities.messageString((String)m_bundle.getString("DeployedFlowLogicalObject.Deleting.Msg.fmt"), (Object)jfjob.getName()));
            DeployedFlow flow = new DeployedFlow(jfjob, tempstore);
            int choice = 0;
            if (oui.isUserInteractionSupported() && (flows = flow.getListofFlows()).size() > 0) {
                choice = oui.displayMessage(m_bundle.getString("DeployedFlowLogicalObject.Deleting.Title.txt"), MetaUtilities.messageString((String)m_bundle.getString("DeployedFlowLogicalObject.Deleting.MessageText.fmt"), (Object)flow.getName(), (Object)flows), 3, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
            }
            if (choice == 0) {
                flow.removeThisSubFlowFromAllFlows();
                PromptUtilities prompts = new PromptUtilities();
                ServerUtilities serverUtil = new ServerUtilities(MetaUtilities.getSessionContext(), MetaUtilities.getUserContext());
                serverUtil.setPromptCallbackInterface((PromptCallbackInterface)prompts);
                serverUtil.setDefaultMdStore(tempstore);
                serverUtil.setDefaultMdRepository(repos);
                ServerFlowInfo info = new ServerFlowInfo(flow.getInfo(), serverUtil, (PromptCallbackInterface)prompts);
                if (info.isFlowSubmitted()) {
                    if (Utilities.connectToSchedlingServer(info, serverUtil, !oui.isUserInteractionSupported()) == 1 && serverUtil.deleteScheduledFlow(info) == 0) {
                        flow.commitChangesWithNoValidation();
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                if (serverUtil.deleteUnscheduledFlow(info) == 0) {
                    flow.commitChangesWithNoValidation();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SchedulerException se) {
            lte = new LogicalTypeException(se.getMessage());
            throw lte;
        }
        catch (RemoteException re) {
            lte = new LogicalTypeException(re.getMessage());
            throw lte;
        }
        catch (MdException mde) {
            lte = new LogicalTypeException(mde.getMessage());
            throw lte;
        }
        finally {
            if (tempstore != null) {
                try {
                    tempstore.dispose();
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    public void rename(String newName, OperationUserInteractionInterface oui) throws LogicalTypeException {
        if (newName.equals(this.getName())) {
            return;
        }
        MdObjectStore tempstore = null;
        try {
            MdFactory factory = Utilities.getMdFactory(false);
            tempstore = factory.createObjectStore(null, "DeployedFlowRename");
            String repos = "A0000001." + super.getID().substring(0, 8);
            JFJob jfjob = MetaUtilities.getJFJob((String)super.getID(), (MdStore)tempstore, (String)repos);
            oui.updateProgress(MetaUtilities.messageString((String)m_bundle.getString("DeployedFlowLogicalObject.Renaming.Msg.fmt"), (Object)jfjob.getName(), (Object)newName));
            boolean doit = true;
            if (DeployedFlow.isFlowSubmitted((JFJob)jfjob)) {
                if (oui.isUserInteractionSupported()) {
                    int response = oui.displayMessage(m_bundle.getString("DeployedFlowLogicalObject.Renaming.Title.txt"), m_bundle.getString("DeployedFlowLogicalObject.FlowSubmitted.Remove.txt"), 3, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
                    if (0 == response) {
                        DeployedFlow flow = new DeployedFlow(jfjob, tempstore);
                        try {
                            String runnowname;
                            String flowname;
                            Scheduler scheduler = flow.getSchedulingServer();
                            boolean rc = scheduler.connectToSchedulingServer((PromptCallbackInterface)new PromptUtilities());
                            if (!rc || !scheduler.removeFlow(flow.getInfo())) {
                                oui.displayMessage(m_bundle.getString("DeployedFlowLogicalObject.Renaming.Title.txt"), m_bundle.getString("DeployedFlowLogicalObject.UnableToRemoveFromScheduler.txt"), 1, OperationUserInteractionInterface.OK_CHOICE_SET);
                            }
                            if ((flowname = scheduler.genFlowName(flow.getInfo())).compareTo(runnowname = scheduler.runNowName(flowname)) != 0) {
                                try {
                                    scheduler.removeFlow(runnowname);
                                }
                                catch (SchedulerException se) {
                                    Workspace.getDefaultLogger().debug((Object)se.getMessage());
                                }
                            }
                        }
                        catch (UnsupportedOperationException ex) {
                            oui.displayMessage(m_bundle.getString("DeployedFlowLogicalObject.Renaming.Title.txt"), m_bundle.getString("DeployedFlowLogicalObject.UnableToRemoveFromScheduler.txt"), 1, OperationUserInteractionInterface.OK_CHOICE_SET);
                        }
                        catch (SchedulerException ex) {
                            oui.displayMessage(m_bundle.getString("DeployedFlowLogicalObject.Renaming.Title.txt"), m_bundle.getString("DeployedFlowLogicalObject.UnableToRemoveFromScheduler.txt"), 1, OperationUserInteractionInterface.OK_CHOICE_SET);
                        }
                        flow.setFlowSubmitted(false);
                        doit = true;
                    } else {
                        doit = false;
                    }
                } else {
                    RuntimeException ex = new RuntimeException(m_bundle.getString("DeployedFlowLogicalObject.UnableToRemoveFromScheduler.txt"));
                    ex.printStackTrace();
                    doit = true;
                }
            } else {
                doit = true;
            }
            if (doit) {
                jfjob.setName(newName);
                jfjob.updateMetadataAll();
                this.refresh((Root)jfjob);
            }
        }
        catch (SchedulerException se) {
            LogicalTypeException lte = new LogicalTypeException(se.getMessage());
            throw lte;
        }
        catch (RemoteException re) {
            LogicalTypeException lte = new LogicalTypeException(re.getMessage());
            throw lte;
        }
        catch (MdException mde) {
            LogicalTypeException lte = new LogicalTypeException(mde.getMessage());
            throw lte;
        }
        finally {
            if (tempstore != null) {
                try {
                    tempstore.dispose();
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    public void move(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        MoveDisallowedCause cause = this.checkMoveAllowed(targetFolder);
        if (cause != null) {
            throw new UnsupportedOperationException(cause.toString());
        }
        MdObjectStore tempstore = null;
        try {
            MdFactory factory = Utilities.getMdFactory(false);
            tempstore = factory.createObjectStore(null, "DeployedFlowDelete");
            String repos = "A0000001." + super.getID().substring(0, 8);
            JFJob jfjob = MetaUtilities.getJFJob((String)super.getID(), (String)"<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)tempstore, (String)repos);
            DeployedFlow flow = new DeployedFlow(jfjob, tempstore);
            Tree target = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject((LogicalObjectInterface)targetFolder, (MdObjectStore)tempstore);
            flow.setFolder(target);
            flow.commitChangesWithNoValidation();
            this.refresh((Root)jfjob);
        }
        catch (SchedulerException se) {
            LogicalTypeException lte = new LogicalTypeException(se.getMessage());
            throw lte;
        }
        catch (RemoteException re) {
            LogicalTypeException lte = new LogicalTypeException(re.getMessage());
            throw lte;
        }
        catch (MdException mde) {
            LogicalTypeException lte = new LogicalTypeException(mde.getMessage());
            throw lte;
        }
        finally {
            if (tempstore != null) {
                try {
                    tempstore.dispose();
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    public Icon getIcon() {
        return this.m_type.getIcon(1);
    }
}

