/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.common;

import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.ServerContext;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class DeploymentDirectoryConnectionType
extends AbstractConnectionType
implements DependentConnectionTypeInterface {
    private static final String TYPE_NAME = "Deployment Directory";
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeploymentDirectoryConnectionType.class);
    private List<SourceConnectionInterface> m_directoryConnections;
    private DependentConnectionMapping m_connectionMap;
    private Map<TargetConnectionInterface, List<TargetConnectionInterface>> m_targetValueMap;

    public DeploymentDirectoryConnectionType(PromotionInterface operation) {
        super(operation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public List<SourceConnectionInterface> getSourceConnections() {
        if (this.m_directoryConnections == null) {
            this.m_directoryConnections = new ArrayList<SourceConnectionInterface>();
            List directories = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "Directory");
            for (ConnectionPointInterface pt : directories) {
                if (!pt.isConnectionForImportType("DeployedJob")) continue;
                String directoryName = this.getDirectoryName(pt);
                SourceConnectionInterface source = this.createSourceConnection(pt, directoryName == null ? pt.getName() : directoryName);
                this.m_directoryConnections.add(source);
            }
        }
        return this.m_directoryConnections;
    }

    public String getLocalizedTypeName() {
        return m_bundle.getString("DeploymentDirectoryConnectionType.Type.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.scheduler.visuals.DeploymentDirectoryConnectionPanel";
    }

    public String getTypeAttributeLabel() {
        return "Directory";
    }

    public List<TargetConnectionInterface> getTargetConnections() throws MdException, RemoteException {
        return new ArrayList<TargetConnectionInterface>();
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return true;
    }

    public DependentConnectionMapping getDependentConnectionMapping() {
        if (this.m_connectionMap == null) {
            this.m_connectionMap = new DependentConnectionMapping();
            ConnectionTypeInterface serverType = this._operation.getConnectionType(AppServerConnectionType.class.getName());
            List serverConnections = serverType.getSourceConnections();
            if (serverConnections == null || serverConnections.size() == 0) {
                return this.m_connectionMap;
            }
            List<SourceConnectionInterface> connections = this.getSourceConnections();
            for (SourceConnectionInterface directoryConnection : connections) {
                String serverName = this.getServerName(directoryConnection);
                SourceConnectionInterface serverConnection = this.getServerConnection(serverType, serverConnections, serverName);
                if (serverConnection == null) continue;
                this.m_connectionMap.addDependentConnection(serverConnection, directoryConnection);
            }
        }
        return this.m_connectionMap;
    }

    public List<TargetConnectionInterface> getTargetValues(SourceConnectionInterface parentConnection) throws MdException, RemoteException {
        TargetConnectionInterface target;
        ArrayList<TargetConnectionInterface> directoryList = new ArrayList<TargetConnectionInterface>();
        ConnectionTypeInterface type = this._operation.getConnectionType(AppServerConnectionType.getTypeClassName());
        if (type != null && (target = type.getTargetConnection(parentConnection)) != null && target.getMetadataObject() instanceof ServerContext) {
            if (this.m_targetValueMap == null) {
                this.m_targetValueMap = new HashMap<TargetConnectionInterface, List<TargetConnectionInterface>>();
            } else if (this.m_targetValueMap.containsKey(target)) {
                return this.m_targetValueMap.get(target);
            }
            MdFactory factory = this._operation.getMetadataFactory();
            int flags = 268;
            String options = "<Templates><ServerContext><DataPackages/></ServerContext><Directory><Properties/></Directory></Templates>";
            ServerContext server = (ServerContext)factory.getOMIUtil().getMetadataAllDepths(target.getMetadataObject(), null, null, options, flags);
            AssociationList directories = server.getDataPackages();
            for (Object obj : directories) {
                if (!(obj instanceof Directory)) continue;
                Directory dir = (Directory)obj;
                directoryList.add(this.createTargetConnection((CMetadata)dir, dir.getName()));
            }
            this.m_targetValueMap.put(target, directoryList);
            return directoryList;
        }
        return new ArrayList<TargetConnectionInterface>();
    }

    public ConnectionTypeInterface getDependentType() {
        return this._operation.getConnectionType(AppServerConnectionType.getTypeClassName());
    }

    private String getDirectoryName(ConnectionPointInterface pt) {
        return PromotionUtil.getAttrValue((String)pt.getSourceSearchString(), (String)"DirectoryName");
    }

    private SourceConnectionInterface getServerConnection(ConnectionTypeInterface serverType, List<SourceConnectionInterface> connections, String serverName) {
        for (SourceConnectionInterface source : connections) {
            if (!serverName.equals(source.getDisplayName())) continue;
            return source;
        }
        return null;
    }

    private String getServerName(SourceConnectionInterface source) {
        int startIndex;
        ConnectionPointInterface pt;
        String searchAttribute;
        int index;
        List connections = source.getConnectionPoints();
        if (connections.size() > 0 && (index = (searchAttribute = (pt = (ConnectionPointInterface)connections.get(0)).getSourceSearchString()).indexOf("@Name='", startIndex = searchAttribute.indexOf("DeployedComponents"))) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }
}

