/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import com.sas.scheduler.api.servers.sasjfs.SASJFSFlowHistory;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SASJFSXMLFactory {
    public static final String XML_Name_Tag = "Name";
    public static final String XML_Id_Tag = "Id";
    public static final String XML_Description_Tag = "Description";
    public static final String XML_Type_Tag = "Type";
    public static final String XML_Value_Tag = "Value";
    public static final String XML_TAG_FLOWHISTORY = "FlowHistory";
    public static final String XML_TAG_HISTORYINFO = "HistoryInfo";
    public static final String XML_TAG_TRIGGERS = "TriggerEvents";
    public static final String XML_Event_Tag = "Event";
    public static final String XML_Events_Tag = "Events";
    public static final String XML_EXECUTE_TYPE = "runNow";
    public static final String XML_TRIGGER_TYPE = "event";
    public static final String XML_TAG_AUTHENTICATION = "Authentication";
    public static final String XML_User_Tag = "User";
    public static final String XML_Password_Tag = "Password";
    public static final String XML_TAG_COMMAND = "Command";
    public static final String XML_ClassId_Tag = "ClassId";
    public static final String XML_Host_Tag = "Host";
    public static final String XML_Port_Tag = "Port";
    public static final String XML_JobExecutionProviderType_Tag = "JobExecutionProvider";
    public static final String XML_RestAPIPath_Tag = "RestAPIPath";
    public static final String XML_FlowOrchHost_Tag = "FlowOrchHost";
    public static final String XML_FlowOrchPort_Tag = "FlowOrchPort";
    public static final String XML_AuthInfoPath_Tag = "AuthInfoPath";
    public static final String XML_FlowOrchCommand_Tag = "FlowOrchCommand";
    public static final String XML_TriggerCommand_Tag = "TriggerCommand";
    public static final String XML_FlowDefId_Tag = "FlowDefId";

    public static String generateXML(SASJFSFlowHistory info) {
        StringBuffer xmlbuffer = new StringBuffer();
        xmlbuffer.append("<FlowHistory>\n");
        String historyString = info.toSerializedForm();
        xmlbuffer.append("HistoryInfo=" + historyString + "");
        xmlbuffer.append("</FlowHistory>\n");
        return xmlbuffer.toString();
    }

    public static String generateSchedulerInfoXML(SchedulerServerInfo sinfo) throws SchedulerException {
        StringBuffer xmlbuffer = new StringBuffer();
        xmlbuffer.append("Name=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getNameDataBinding()) + "\" ");
        xmlbuffer.append("ClassId=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getClassidDataBinding()) + "\" ");
        xmlbuffer.append("Id=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getIdDataBinding()) + "\" ");
        xmlbuffer.append("Description=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getDescriptionDataBinding()) + "\" ");
        xmlbuffer.append("Host=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getHostDataBinding()) + "\" ");
        xmlbuffer.append("Port=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getPortDataBinding()) + "\" ");
        xmlbuffer.append("JobExecutionProvider=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getJobExecutionProvider()) + "\" ");
        xmlbuffer.append("RestAPIPath=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getRestAPIPathDataBinding()) + "\" ");
        xmlbuffer.append("FlowOrchHost=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getFlowOrchHostDataBinding()) + "\" ");
        xmlbuffer.append("FlowOrchPort=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getFlowOrchPortDataBinding()) + "\" ");
        xmlbuffer.append("AuthInfoPath=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getAuthInfoDataBinding()) + "\" ");
        xmlbuffer.append("FlowOrchCommand=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getFlowOrchCommandDataBinding()) + "\" ");
        xmlbuffer.append("TriggerCommand=\"" + SASJFSXMLFactory.reformatQuoteString(sinfo.getTriggerCommandDataBinding()) + "\" ");
        return xmlbuffer.toString();
    }

    public static SASJFSFlowHistory initSASJFSFlowHistoryFromRecord(String historyStr) throws SchedulerException {
        SASJFSFlowHistory hist = new SASJFSFlowHistory(null);
        hist.initFromSerializedForm(historyStr);
        return hist;
    }

    public static String getSASJFSFlowHistoryRecordFromXML(String historyXML) throws SchedulerException {
        String historyString = "";
        Document doc = GeneralUtilities.parseXML((String)historyXML);
        NodeList nodes = doc.getElementsByTagName(XML_TAG_FLOWHISTORY);
        int numNodes = nodes.getLength();
        for (int j = 0; j < numNodes; ++j) {
            Node node = nodes.item(j);
            if (node.getNodeName().compareTo(XML_TAG_FLOWHISTORY) != 0) continue;
            NamedNodeMap map = node.getAttributes();
            historyString = map.getNamedItem(XML_TAG_HISTORYINFO).getNodeValue();
        }
        return historyString;
    }

    public static List<TriggerEventInfo> getTriggersFromXML(String xml) throws SchedulerException {
        ArrayList<TriggerEventInfo> triggerEventInfoList = new ArrayList<TriggerEventInfo>();
        Document doc = GeneralUtilities.parseXML((String)xml);
        Node mainNode = doc.getElementsByTagName(XML_TAG_TRIGGERS).item(0);
        NamedNodeMap map = mainNode.getAttributes();
        NodeList jnodes = mainNode.getChildNodes();
        int numJNodes = jnodes.getLength();
        for (int i = 0; i < numJNodes; ++i) {
            Node jnode = jnodes.item(i);
            String tagname = jnode.getNodeName();
            if (tagname.equals(XML_Event_Tag)) {
                TriggerEventInfo triggerEventInfo;
                String type = map.getNamedItem(XML_Value_Tag).getNodeValue();
                if (type != null && type.equals("TimeEvent")) {
                    triggerEventInfo = new TriggerEventInfo();
                    triggerEventInfo.initFromNode(jnode);
                    triggerEventInfoList.add(triggerEventInfo);
                    continue;
                }
                triggerEventInfo = new TriggerEventInfo("Run Now", null, "RunNow");
                triggerEventInfoList.add(triggerEventInfo);
                continue;
            }
            if (!tagname.equals(XML_Events_Tag)) continue;
            NodeList knodes = jnode.getChildNodes();
            int numKNodes = knodes.getLength();
            for (int k = 0; k < numKNodes; ++k) {
                TriggerEventInfo triggerEventInfo;
                Node knode = knodes.item(k);
                NamedNodeMap map2 = knode.getAttributes();
                tagname = knode.getNodeName();
                if (!tagname.equals(XML_Event_Tag)) continue;
                String type = map2.getNamedItem(XML_Type_Tag).getNodeValue();
                if (type != null && type.equals("Time")) {
                    triggerEventInfo = new TriggerEventInfo();
                    triggerEventInfo.initFromNode(knode);
                    triggerEventInfoList.add(triggerEventInfo);
                    continue;
                }
                triggerEventInfo = new TriggerEventInfo("Run Now", null, "RunNow");
                triggerEventInfoList.add(triggerEventInfo);
            }
        }
        return triggerEventInfoList;
    }

    public static String getTriggerIdFromXML(String xml) throws SchedulerException {
        Document doc = GeneralUtilities.parseXML((String)xml);
        Node mainNode = doc.getElementsByTagName(XML_TAG_TRIGGERS).item(0);
        String tagname = mainNode.getNodeName();
        if (tagname.compareTo(XML_TAG_TRIGGERS) == 0) {
            NamedNodeMap map = mainNode.getAttributes();
            return map.getNamedItem(XML_Id_Tag).getNodeValue();
        }
        return null;
    }

    public static String generateCredentialCheckXML(String user, String password) {
        StringBuffer xmlbuffer = new StringBuffer();
        xmlbuffer.append("<Authentication User=\"" + user + "\" " + XML_Password_Tag + "=\"" + password + "\" />\n");
        return xmlbuffer.toString();
    }

    public static PasswordAuthentication getAuthenticationFromXML(String xml) throws SchedulerException {
        PasswordAuthentication pa = null;
        Document doc = GeneralUtilities.parseXML((String)xml);
        Node mainNode = doc.getElementsByTagName(XML_TAG_AUTHENTICATION).item(0);
        NamedNodeMap cmap = mainNode.getAttributes();
        String user = cmap.getNamedItem(XML_User_Tag).getNodeValue();
        pa = new PasswordAuthentication(user, cmap.getNamedItem(XML_Password_Tag).getNodeValue().toCharArray());
        return pa;
    }

    public static String generateCommandXML(FlowInfo info) {
        StringBuffer xmlbuffer = new StringBuffer();
        SchedulerServerInfo ssi = info.getScheduler();
        if (ssi != null) {
            String command = ssi.buildFlowOrchestratorCommandLine(info.getId());
            xmlbuffer.append("<Command Value=\"" + command + "\" />\n");
        }
        return xmlbuffer.toString();
    }

    public static String getCommandFromXML(String xml) throws SchedulerException {
        Document doc = GeneralUtilities.parseXML((String)xml);
        Node mainNode = doc.getElementsByTagName(XML_TAG_COMMAND).item(0);
        NamedNodeMap map = mainNode.getAttributes();
        String command = map.getNamedItem(XML_Value_Tag).getNodeValue();
        return command;
    }

    public static String getCData(Node node) {
        if (!node.hasChildNodes()) {
            return "";
        }
        NodeList children = node.getChildNodes();
        int listLength = children.getLength();
        StringBuffer data = new StringBuffer();
        for (int i = 0; i < listLength; ++i) {
            Node child = children.item(i);
            if (child == null) continue;
            data.append(child.getNodeValue());
        }
        return data.toString();
    }

    private static String reformatQuoteString(String origString) {
        String formatted = null;
        if (origString != null) {
            formatted = origString.replace("\"", "&quot;").replace("'", "\\'");
        }
        return formatted;
    }
}

