/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSClientSupport;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSUtilities;
import com.sas.scheduler.model.TriggerEventInfo;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsTemplate;

public class OSTriggerClient
extends JMSClientSupport {
    private static final Logger logger = LogManager.getLogger(OSTriggerClient.class);

    public OSTriggerClient(String id, Properties configProperties) throws InterruptedException {
        super(id, configProperties, logger);
    }

    public List<TriggerEventInfo> getTriggerInfo(String flowDefinitionId) {
        List<TriggerEventInfo> triggers = new ArrayList<TriggerEventInfo>();
        if (!flowDefinitionId.isEmpty()) {
            triggers = super.requestTriggerEvents(flowDefinitionId);
        }
        return triggers;
    }

    @Override
    public String getTriggerId(String flowDefinitionId) {
        String triggerId = "";
        if (!flowDefinitionId.isEmpty()) {
            triggerId = super.getTriggerId(flowDefinitionId);
        }
        return triggerId;
    }

    @Override
    public boolean setTriggerId(String flowDefinitionId, String triggerDefinitionId) {
        boolean rc = false;
        if (!flowDefinitionId.isEmpty() && !triggerDefinitionId.isEmpty()) {
            rc = super.setTriggerId(flowDefinitionId, triggerDefinitionId);
        }
        return rc;
    }

    @Override
    public String getFlowOrchestratorCommand() {
        return super.getFlowOrchestratorCommand();
    }

    @Override
    public String getOSCommandPath() {
        return super.getOSCommandPath();
    }

    public int stopOSTriggerService(String id) {
        this.sendResponseToClient(this.m_schedulerRequestQueue, "exit", id, "exit");
        try {
            Message msg = this.receiveRequestFromServer(this.m_schedulerResultsQueue, id, "exit");
            return JMSUtilities.getInt(msg);
        }
        catch (JMSException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return -1;
        }
    }

    public int checkOSTriggerService(String id) {
        block5: {
            this.sendResponseToClient(this.m_schedulerRequestQueue, "status", id, "status");
            try {
                long timeout = 10000L;
                boolean keepListening = true;
                while (keepListening) {
                    Message msg = this.receiveRequestFromServer(this.m_schedulerResultsQueue, id, "status", timeout);
                    if (msg != null) {
                        long dtc = msg.getJMSTimestamp();
                        if (dtc + 2L * timeout < System.currentTimeMillis()) {
                            String messageSelector = "(ID = '" + id + "') AND (CALLER = '" + "status" + "')";
                            this.m_schedulerResultsQueue.receiveSelected(messageSelector);
                            continue;
                        }
                        return JMSUtilities.getInt(msg);
                    }
                    return -1;
                }
            }
            catch (JMSException e) {
                if (!MetaUtilities.isDebug()) break block5;
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue(final String id, final JmsTemplate queue) {
        if (queue == null) {
            return;
        }
        JmsTemplate jmsTemplate = queue;
        synchronized (jmsTemplate) {
            Message message;
            while ((message = (Message)queue.browse((BrowserCallback)new BrowserCallback<Message>(){

                public Message doInJms(Session arg0, QueueBrowser arg1) throws JMSException {
                    Enumeration items = arg1.getEnumeration();
                    while (items.hasMoreElements()) {
                        Object o = items.nextElement();
                        if (!(o instanceof Message)) continue;
                        try {
                            Message msg = (Message)o;
                            String callerId = msg.getStringProperty("ID");
                            if (!id.equals("ALL") && !id.equals(callerId)) continue;
                            String messageSelector = "(ID = '" + callerId + "')";
                            Message msg2 = queue.receiveSelected(messageSelector);
                            return msg2;
                        }
                        catch (JMSException jMSException) {
                        }
                    }
                    return null;
                }
            })) != null) {
            }
        }
    }

    public boolean setServiceId(String id) {
        block3: {
            String authRequestString = "setServiceId_;_" + id;
            this.sendRequestToServer(authRequestString, this.m_id, "setServiceId");
            try {
                Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "setServiceId");
                if (msg != null) {
                    return JMSClientSupport.getBoolean(msg);
                }
            }
            catch (JMSException e) {
                if (!MetaUtilities.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        return false;
    }

    public String getServiceId() {
        block3: {
            String authRequestString = "getServiceId_;_";
            this.sendRequestToServer(authRequestString, this.m_id, "getServiceId");
            try {
                Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getServiceId");
                if (msg != null) {
                    return ((TextMessage)msg).getText();
                }
            }
            catch (JMSException e) {
                if (!MetaUtilities.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }
}

