/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.mq;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.sasjfs.engine.ClientLogger;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSUtilities;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.core.JmsTemplate;

public class JMSServiceSupport
extends JMSUtilities {
    protected ClientLogger m_logger;
    protected ConnectionFactory m_queueFactory;
    private Properties m_configuration;

    public JMSServiceSupport(ClientLogger logger, Properties configuration) {
        this.m_logger = logger != null ? logger : new ClientLogger(){
            String message = "JMSServiceSupportDefaultLogger";
            Logger LOG = LogManager.getLogger((String)this.message);

            @Override
            public void logMessage(Level l, Throwable t) {
                if (l.intValue() >= Level.SEVERE.intValue()) {
                    this.LOG.error(this.message, t);
                } else if (l.intValue() >= Level.WARNING.intValue()) {
                    this.LOG.warn(this.message, t);
                } else if (l.intValue() <= Level.INFO.intValue() && l.intValue() >= Level.CONFIG.intValue()) {
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info(this.message, t);
                    }
                } else if (l.intValue() <= Level.FINE.intValue() && l.intValue() >= Level.FINER.intValue()) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug(this.message, t);
                    }
                } else if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace(this.message, t);
                }
            }

            @Override
            public void logMessage(Level l, String message) {
                if (l.intValue() >= Level.SEVERE.intValue()) {
                    this.LOG.error(message);
                } else if (l.intValue() >= Level.WARNING.intValue()) {
                    this.LOG.warn(message);
                } else if (l.intValue() <= Level.INFO.intValue() && l.intValue() >= Level.CONFIG.intValue()) {
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info(message);
                    }
                } else if (l.intValue() <= Level.FINE.intValue() && l.intValue() >= Level.FINER.intValue()) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug(message);
                    }
                } else if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace(message);
                }
            }
        };
        this.m_configuration = configuration;
        this.m_logger.logMessage(Level.INFO, "SASJFS configuration settings:");
        this.m_logger.logMessage(Level.INFO, "JMS Factory: " + configuration.getProperty("java.naming.factory.initial", "Not configured"));
        this.m_logger.logMessage(Level.INFO, "JMS URL: " + configuration.getProperty("java.naming.provider.url", "Not configured"));
        this.m_logger.logMessage(Level.INFO, "JMS UserID: " + configuration.getProperty("JMSSecurityUserid", "No user"));
        this.m_logger.logMessage(Level.INFO, "JMS Password: " + configuration.getProperty("JMSSecurityPasswd", "No password"));
        this.initialize();
    }

    public Message getMidtierRequestQueueMsg() {
        return this.m_midtierRequestQueue.receive();
    }

    public int getSchedulerResults(String authRequestString, String id, String property) {
        block3: {
            this.sendRequestToServer(authRequestString, id, property);
            try {
                Message msg = this.receiveRequestFromServer(this.m_schedulerResultsQueue, id, property);
                if (msg != null) {
                    return JMSUtilities.getInt(msg);
                }
            }
            catch (JMSException e) {
                if (!MetaUtilities.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static void configureQueue(InitialContext jmsContext, JmsTemplate queueTemplate, String queueName, ClientLogger logger) {
        try {
            queueTemplate.setDefaultDestination((Destination)((Queue)jmsContext.lookup(queueName)));
        }
        catch (NamingException e) {
            logger.logMessage(Level.FINE, "Retrying JMS Queue lookup using TC Server style, called from: " + JMSServiceSupport.findCallingMethod(e, "configureQueue"));
            try {
                queueTemplate.setDefaultDestination((Destination)((Queue)jmsContext.lookup("java:comp/env/" + queueName)));
            }
            catch (NamingException e2) {
                logger.logMessage(Level.FINE, e2);
                logger.logMessage(Level.WARNING, "Unable to lookup JMS queue using either appserver jndi lookup name (okay if running outside an appserver): " + queueName + " OR " + "java:comp/env/" + queueName);
                String queuePrefix = System.getProperty("sas.sasjfs.jms.queuePrefix", "sas.jms.");
                logger.logMessage(Level.INFO, "Creating dynamic queue with name: " + queuePrefix + JMSServiceSupport.getLastSegment(queueName));
                queueTemplate.setDefaultDestinationName(queuePrefix + JMSServiceSupport.getLastSegment(queueName));
            }
        }
    }

    private static String findCallingMethod(Exception e, String childMethodName) {
        try {
            StackTraceElement[] stack = e.getStackTrace();
            boolean foundItem = false;
            for (StackTraceElement stackTraceElement : stack) {
                if (foundItem) {
                    return stackTraceElement.getClassName() + ":" + stackTraceElement.getMethodName();
                }
                if (!stackTraceElement.getMethodName().equals(childMethodName)) continue;
                foundItem = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Unknown caller";
    }

    protected void initJMS(int attempts) {
        if (attempts <= 0) {
            attempts = 1;
        }
        int SLEEP_TIME = 30;
        int LOG_MESSAGE_PER_TRIES = 4;
        int retryCount = 0;
        while (true) {
            block8: {
                try {
                    this.cleanupJMSObjects();
                    InitialContext jmsContext = this.initJMSContext();
                    this.m_bytesQueue = new JmsTemplate(this.m_queueFactory);
                    JMSServiceSupport.configureQueue(jmsContext, this.m_bytesQueue, "jms/scheduler.sasjfs.bytesQueue", this.m_logger);
                    this.m_bytesQueue.setReceiveTimeout(2000L);
                    this.m_bytesQueue.setTimeToLive(86400000L);
                    this.m_bytesQueue.setDeliveryMode(2);
                    this.m_bytesQueue.setExplicitQosEnabled(true);
                    this.m_checkQueue = new JmsTemplate(this.m_queueFactory);
                    JMSServiceSupport.configureQueue(jmsContext, this.m_checkQueue, "jms/scheduler.sasjfs.checkQueue", this.m_logger);
                    this.m_checkQueue.setReceiveTimeout(2000L);
                    this.m_checkQueue.setTimeToLive(86400000L);
                    this.m_checkQueue.setDeliveryMode(2);
                    this.m_checkQueue.setExplicitQosEnabled(true);
                    this.m_stringQueue = new JmsTemplate(this.m_queueFactory);
                    JMSServiceSupport.configureQueue(jmsContext, this.m_stringQueue, "jms/scheduler.sasjfs.stringQueue", this.m_logger);
                    this.m_stringQueue.setReceiveTimeout(2000L);
                    this.m_stringQueue.setTimeToLive(86400000L);
                    this.m_stringQueue.setDeliveryMode(2);
                    this.m_stringQueue.setExplicitQosEnabled(true);
                    this.m_instanceListQueue = new JmsTemplate(this.m_queueFactory);
                    JMSServiceSupport.configureQueue(jmsContext, this.m_instanceListQueue, "jms/scheduler.sasjfs.instancesQueue", this.m_logger);
                    this.m_instanceListQueue.setReceiveTimeout(2000L);
                    this.m_instanceListQueue.setTimeToLive(86400000L);
                    this.m_instanceListQueue.setDeliveryMode(2);
                    this.m_instanceListQueue.setExplicitQosEnabled(true);
                    this.m_instanceQueue = new JmsTemplate(this.m_queueFactory);
                    JMSServiceSupport.configureQueue(jmsContext, this.m_instanceQueue, "jms/scheduler.sasjfs.instanceQueue", this.m_logger);
                    this.m_instanceQueue.setReceiveTimeout(2000L);
                    this.m_instanceQueue.setTimeToLive(86400000L);
                    this.m_instanceQueue.setDeliveryMode(2);
                    this.m_instanceQueue.setExplicitQosEnabled(true);
                    this.m_midtierRequestQueue = new JmsTemplate(this.m_queueFactory);
                    JMSServiceSupport.configureQueue(jmsContext, this.m_midtierRequestQueue, "jms/scheduler.sasjfs.scheduleManagementQueue", this.m_logger);
                    this.m_midtierRequestQueue.setReceiveTimeout(2000L);
                    this.m_midtierRequestQueue.setTimeToLive(86400000L);
                    this.m_midtierRequestQueue.setDeliveryMode(2);
                    this.m_midtierRequestQueue.setExplicitQosEnabled(true);
                    this.m_schedulerRequestQueue = new JmsTemplate(this.m_queueFactory);
                    JMSServiceSupport.configureQueue(jmsContext, this.m_schedulerRequestQueue, "jms/scheduler.sasjfs.schedulerRequestQueue", this.m_logger);
                    this.m_schedulerRequestQueue.setReceiveTimeout(2000L);
                    this.m_schedulerRequestQueue.setTimeToLive(86400000L);
                    this.m_schedulerRequestQueue.setDeliveryMode(2);
                    this.m_schedulerRequestQueue.setExplicitQosEnabled(true);
                    this.m_schedulerResultsQueue = new JmsTemplate(this.m_queueFactory);
                    JMSServiceSupport.configureQueue(jmsContext, this.m_schedulerResultsQueue, "jms/scheduler.sasjfs.schedulerResultsQueue", this.m_logger);
                    this.m_schedulerResultsQueue.setReceiveTimeout(2000L);
                    this.m_schedulerResultsQueue.setTimeToLive(86400000L);
                    this.m_schedulerResultsQueue.setDeliveryMode(2);
                    this.m_schedulerResultsQueue.setExplicitQosEnabled(true);
                    break;
                }
                catch (NamingException e) {
                    if (++retryCount > attempts) {
                        throw new IllegalStateException("Failed to lookup required JMS objects in JNDI.", e);
                    }
                }
                catch (IllegalStateException e) {
                    if (++retryCount <= attempts) break block8;
                    throw e;
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (retryCount % 4 != 0) continue;
            this.m_logger.logMessage(Level.INFO, "Have received " + retryCount + " failures attempting to initialize required JMS objects for Distributed-IP scheduler.");
        }
        this.m_logger.logMessage(Level.INFO, "Successfully initialized required JMS objects for Distributed-IP scheduler.");
    }

    private InitialContext initJMSContext() throws NamingException {
        InitialContext jmsContext = this.initJMSContext(this.m_configuration);
        this.m_queueFactory = JMSServiceSupport.getFactory(jmsContext, "jms/scheduler.sasjfs.scheduleManagementQueue", JMSServiceSupport.getLastSegment("jms/scheduler.sasjfs.scheduleManagementQueue"));
        if (JMSServiceSupport.areCredentialsProvided(this.m_configuration)) {
            this.m_queueFactory = JMSServiceSupport.configureSecurity(this.m_queueFactory, this.m_configuration);
        }
        return jmsContext;
    }

    private void initialize() {
        this.initJMS(60);
    }
}

