/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.mq;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.sasjfs.SASJFSFlowHistory;
import com.sas.scheduler.api.servers.sasjfs.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.sasjfs.engine.JFSScheduleManager;
import com.sas.scheduler.api.servers.sasjfs.engine.SASJFSProperties;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.SASJFSJobInfo;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSUtilities;
import com.sas.scheduler.api.servers.sasjfs.utilities.SASJFSXMLFactory;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.RunHistory;
import com.sas.scheduler.model.ScheduledFlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.model.XMLFactory;
import com.sas.svcs.scheduling.client.CachedObject;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;

public class JMSClientSupport
extends JMSUtilities {
    protected String m_id;
    protected Logger m_logger;
    protected static volatile boolean m_shuttingDown = false;
    public static final String Config_FilePath = "sasjfs.commandLine.filePath";

    public JMSClientSupport(String id, Properties configProperties, Logger logger) throws InterruptedException {
        Runtime.getRuntime().addShutdownHook(new Thread("SASJFS Client-Auto Shutdown"){

            @Override
            public void run() {
                m_shuttingDown = true;
            }
        });
        this.m_id = id;
        this.m_logger = logger != null ? logger : LogManager.getLogger(JMSClientSupport.class);
        if (configProperties != null && configProperties.getProperty("JMSSecurityUserid") == null) {
            int connectionAttemptCount = 0;
            block5: while (true) {
                try {
                    Properties environmentProperties;
                    block6: while (true) {
                        this.m_logger.info("Attempting to get JMS credentials via Gemfire cache");
                        String filePath = configProperties.getProperty(Config_FilePath);
                        if (filePath == null) {
                            this.m_logger.error("Error: no log path specified; gemfire will not be used.");
                            break block5;
                        }
                        File gemfireConfig = new File(filePath, "sasjfs-gemfire-config.xml");
                        if (!gemfireConfig.exists()) {
                            this.m_logger.error("Error: Gemfire config file does not exist.  Client may not operate correctly: " + gemfireConfig.getAbsolutePath());
                            break block5;
                        }
                        FileSystemXmlApplicationContext applicationContext = new FileSystemXmlApplicationContext(gemfireConfig.toURI().toURL().toString());
                        environmentProperties = null;
                        Map schedulingCache = (Map)applicationContext.getBean("schedulingCache");
                        CachedObject cachedObject = new CachedObject();
                        cachedObject.setCache(schedulingCache);
                        cachedObject.setKey("/sas/properties/environment");
                        cachedObject.setClass(Properties.class);
                        cachedObject.setSingleton(false);
                        int cacheAttemptCount = 0;
                        while (true) {
                            if (m_shuttingDown) {
                                System.exit(0);
                            }
                            if ((environmentProperties = (Properties)cachedObject.getObject()) != null) break block6;
                            if (++cacheAttemptCount == 1 || cacheAttemptCount % 15 == 0) {
                                this.m_logger.error("Gemfire cache not available after " + cacheAttemptCount + " attempts.  Retrying.");
                            }
                            if (cacheAttemptCount > 100) continue block6;
                            this.breakUpWait(60000L);
                        }
                        break;
                    }
                    String jmsUser = environmentProperties.getProperty("jms.user");
                    SealedString jmsPassword = environmentProperties.getProperty("jms.password") != null ? new SealedString(environmentProperties.getProperty("jms.password")) : null;
                    this.updateClientProperty(configProperties, "JMSSecurityUserid", jmsUser, "JMS user", true);
                    this.updateClientProperty(configProperties, "JMSSecurityPasswd", jmsPassword != null ? String.valueOf(jmsPassword.getCharacters()) : null, "JMS password", false);
                }
                catch (NoClassDefFoundError e) {
                    this.m_logger.error((Object)e);
                }
                catch (ClassNotFoundException e) {
                    this.m_logger.error((Object)e);
                }
                catch (BeanDefinitionParsingException e) {
                    this.m_logger.error((Object)e);
                }
                catch (Exception e) {
                    if (++connectionAttemptCount == 1 || connectionAttemptCount % 10 == 0) {
                        this.m_logger.error((Object)e);
                        this.m_logger.debug("Connection to Gemfire failed after " + connectionAttemptCount + " attempts.  Retrying.");
                    }
                    this.breakUpWait(60000L);
                    continue;
                }
                break;
            }
            this.m_logger.info("JMS Factory: " + configProperties.getProperty("java.naming.factory.initial", "Not configured"));
            this.m_logger.info("JMS URL: " + configProperties.getProperty("java.naming.provider.url", "Not configured"));
            this.m_logger.info("JMS UserID: " + configProperties.getProperty("JMSSecurityUserid", "No user"));
            this.m_logger.trace("JMS Password: " + configProperties.getProperty("JMSSecurityPasswd", "No password"));
        } else if (configProperties != null) {
            this.m_logger.info("JMS Factory: " + configProperties.getProperty("java.naming.factory.initial", "Not configured"));
            this.m_logger.info("JMS URL: " + configProperties.getProperty("java.naming.provider.url", "Not configured"));
            this.m_logger.info("JMS UserID: " + configProperties.getProperty("JMSSecurityUserid", "No user"));
            this.m_logger.trace("JMS Password: " + configProperties.getProperty("JMSSecurityPasswd", "No password"));
        } else {
            this.m_logger.info("JMS Factory: Not configured");
            this.m_logger.info("JMS URL: Not configured");
            this.m_logger.info("JMS UserID: No user");
            this.m_logger.trace("JMS Password: No password");
        }
        this.initJMS(60000, configProperties);
        this.m_logger.info("SASJFS JMS client is ready.");
    }

    protected void breakUpWait(long timeMS) throws InterruptedException {
        for (long elapsed = 0L; elapsed < timeMS; elapsed += 5000L) {
            Thread.sleep(5000L);
        }
    }

    protected void updateClientProperty(Properties clientProperties, String key, String value, String displayName, boolean show) {
        if (!clientProperties.containsKey(key) && value != null && !value.equals("")) {
            this.m_logger.debug("Found " + displayName + " from Gemfire: " + (show ? value : "<not shown>"));
            clientProperties.setProperty(key, value);
        }
    }

    protected void initJMS(int attempts, Properties configProperties) {
        if (attempts <= 0) {
            attempts = 1;
        }
        int SLEEP_TIME = 30;
        int retryCount = 0;
        while (true) {
            block8: {
                this.cleanupJMSObjects();
                try {
                    InitialContext jmsContext = this.initJMSContext(configProperties);
                    this.m_bytesQueue = new JmsTemplate(this.m_queueFactory);
                    JMSClientSupport.configureQueue(jmsContext, this.m_bytesQueue, "jms/scheduler.sasjfs.bytesQueue", this.m_logger);
                    this.m_bytesQueue.setReceiveTimeout(TIMEOUT);
                    this.m_bytesQueue.setExplicitQosEnabled(true);
                    this.m_bytesQueue.setDeliveryMode(2);
                    this.m_checkQueue = new JmsTemplate(this.m_queueFactory);
                    JMSClientSupport.configureQueue(jmsContext, this.m_checkQueue, "jms/scheduler.sasjfs.checkQueue", this.m_logger);
                    this.m_checkQueue.setReceiveTimeout(TIMEOUT);
                    this.m_checkQueue.setExplicitQosEnabled(true);
                    this.m_checkQueue.setDeliveryMode(2);
                    this.m_stringQueue = new JmsTemplate(this.m_queueFactory);
                    JMSClientSupport.configureQueue(jmsContext, this.m_stringQueue, "jms/scheduler.sasjfs.stringQueue", this.m_logger);
                    this.m_stringQueue.setReceiveTimeout(TIMEOUT);
                    this.m_stringQueue.setExplicitQosEnabled(true);
                    this.m_stringQueue.setDeliveryMode(2);
                    this.m_instanceListQueue = new JmsTemplate(this.m_queueFactory);
                    JMSClientSupport.configureQueue(jmsContext, this.m_instanceListQueue, "jms/scheduler.sasjfs.instancesQueue", this.m_logger);
                    this.m_instanceListQueue.setReceiveTimeout(TIMEOUT);
                    this.m_instanceListQueue.setExplicitQosEnabled(true);
                    this.m_instanceListQueue.setDeliveryMode(2);
                    this.m_instanceQueue = new JmsTemplate(this.m_queueFactory);
                    JMSClientSupport.configureQueue(jmsContext, this.m_instanceQueue, "jms/scheduler.sasjfs.instanceQueue", this.m_logger);
                    this.m_instanceQueue.setReceiveTimeout(TIMEOUT);
                    this.m_instanceQueue.setExplicitQosEnabled(true);
                    this.m_instanceQueue.setDeliveryMode(2);
                    this.m_midtierRequestQueue = new JmsTemplate(this.m_queueFactory);
                    JMSClientSupport.configureQueue(jmsContext, this.m_midtierRequestQueue, "jms/scheduler.sasjfs.scheduleManagementQueue", this.m_logger);
                    this.m_midtierRequestQueue.setExplicitQosEnabled(true);
                    this.m_midtierRequestQueue.setDeliveryMode(2);
                    this.m_schedulerRequestQueue = new JmsTemplate(this.m_queueFactory);
                    JMSClientSupport.configureQueue(jmsContext, this.m_schedulerRequestQueue, "jms/scheduler.sasjfs.schedulerRequestQueue", this.m_logger);
                    this.m_schedulerRequestQueue.setExplicitQosEnabled(true);
                    this.m_schedulerRequestQueue.setDeliveryMode(2);
                    this.m_schedulerResultsQueue = new JmsTemplate(this.m_queueFactory);
                    JMSClientSupport.configureQueue(jmsContext, this.m_schedulerResultsQueue, "jms/scheduler.sasjfs.schedulerResultsQueue", this.m_logger);
                    this.m_schedulerResultsQueue.setExplicitQosEnabled(true);
                    this.m_schedulerResultsQueue.setDeliveryMode(2);
                    break;
                }
                catch (NamingException e) {
                    if (++retryCount > attempts) {
                        throw new IllegalStateException("Failed to lookup required JMS objects in JNDI.", e);
                    }
                }
                catch (IllegalStateException e) {
                    if (++retryCount <= attempts) break block8;
                    throw e;
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_logger.info("Successfully initialized required JMS objects for SASJFS client: " + this.m_id);
    }

    public List<String> getMessageQueues() {
        ArrayList<String> queues = new ArrayList<String>();
        queues.add("jms/scheduler.sasjfs.checkQueue");
        queues.add("jms/scheduler.sasjfs.instanceQueue");
        queues.add("jms/scheduler.sasjfs.instancesQueue");
        queues.add("jms/scheduler.sasjfs.stringQueue");
        queues.add("jms/scheduler.sasjfs.triggerQueue");
        queues.add("jms/scheduler.sasjfs.scheduleManagementQueue");
        queues.add("jms/scheduler.sasjfs.schedulerRequestQueue");
        queues.add("jms/scheduler.sasjfs.schedulerResultsQueue");
        return queues;
    }

    public List<Object> getMessages(String qname, String selector) {
        if (qname == null) {
            return null;
        }
        if (qname.equals("jms/scheduler.sasjfs.bytesQueue")) {
            return super.browseQueue(this.m_bytesQueue, selector);
        }
        if (qname.equals("jms/scheduler.sasjfs.checkQueue")) {
            return super.browseQueue(this.m_checkQueue, selector);
        }
        if (qname.equals("jms/scheduler.sasjfs.instanceQueue")) {
            return super.browseQueue(this.m_instanceQueue, selector);
        }
        if (qname.equals("jms/scheduler.sasjfs.instancesQueue")) {
            return super.browseQueue(this.m_instanceListQueue, selector);
        }
        if (qname.equals("jms/scheduler.sasjfs.stringQueue")) {
            return super.browseQueue(this.m_stringQueue, selector);
        }
        return null;
    }

    public List<TriggerEventInfo> requestTriggerEvents(String flowDefinitionId) {
        List<TriggerEventInfo> triggers = new ArrayList<TriggerEventInfo>();
        if (!flowDefinitionId.isEmpty()) {
            try {
                String triggerXML;
                String authRequestString = "getFlowTrigger_;_" + flowDefinitionId;
                String uniqueID = UUID.randomUUID().toString();
                this.sendRequestToServer(authRequestString, this.m_id, "getTriggerInfo_" + uniqueID);
                Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getTriggerInfo_" + uniqueID);
                if (msg != null && !(triggerXML = ((TextMessage)msg).getText()).isEmpty()) {
                    triggers = SASJFSXMLFactory.getTriggersFromXML(triggerXML);
                }
            }
            catch (RuntimeException e) {
                this.m_logger.debug((Object)e);
                return null;
            }
            catch (JMSException e) {
                this.m_logger.debug((Object)e);
            }
            catch (SchedulerException e) {
                this.m_logger.debug((Object)e);
            }
        }
        return triggers;
    }

    public String getTriggerId(String flowDefinitionId) {
        String triggerId = "";
        if (!flowDefinitionId.isEmpty()) {
            String authRequestString = "getFlowTriggerId_;_" + flowDefinitionId;
            String uniqueID = UUID.randomUUID().toString();
            this.sendRequestToServer(authRequestString, this.m_id, "getTriggerId_" + uniqueID);
            try {
                Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getTriggerId_" + uniqueID);
                if (msg != null) {
                    triggerId = ((TextMessage)msg).getText();
                }
            }
            catch (JMSException e) {
                this.m_logger.debug((Object)e);
            }
        }
        return triggerId;
    }

    public boolean setTriggerId(String flowDefinitionId, String triggerDefinitionId) {
        if (!flowDefinitionId.isEmpty() && !triggerDefinitionId.isEmpty()) {
            String authRequestString = "setTriggerId_;_" + flowDefinitionId + "_;_" + triggerDefinitionId;
            String uniqueID = UUID.randomUUID().toString();
            this.sendRequestToServer(authRequestString, this.m_id, "setTriggerId_" + uniqueID);
            try {
                Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "setTriggerId_" + uniqueID);
                if (msg != null) {
                    return JMSClientSupport.getBoolean(msg);
                }
            }
            catch (JMSException e) {
                this.m_logger.debug((Object)e);
            }
        }
        return false;
    }

    public String getFlowOrchestratorCommand() {
        String authRequestString = "getFlowOrchestratorCommand_;_";
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowOrchestratorCommand_" + uniqueID);
        String serverReturnMsg = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowOrchestratorCommand_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return serverReturnMsg;
    }

    public String getOSTriggerCommand() {
        String authRequestString = "getOSTriggerCommand_;_";
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getOSTriggerCommand_" + uniqueID);
        String serverReturnMsg = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getOSTriggerCommand_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return serverReturnMsg;
    }

    public String getOSCommandPath() {
        String authRequestString = "getCronTabPath_;_";
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getOSCommandPath_" + uniqueID);
        String serverReturnMsg = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getOSCommandPath_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return serverReturnMsg;
    }

    public String setFlowInfo(String flowname, String user, String flowString, boolean runNow) {
        String authRequestString = "saveflow_;_" + flowname + "_;_" + user + "_;_" + flowString + "_;_" + runNow;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "setFlowInfo_" + uniqueID);
        String flowDefinitionId = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "setFlowInfo_" + uniqueID);
            if (msg != null) {
                flowDefinitionId = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return flowDefinitionId;
    }

    public String rescheduleFlowInfo(String flowDefId, String flowString) {
        String authRequestString = "rescheduleflow_;_" + flowString + "_;_" + flowDefId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "rescheduleFlowInfo_" + uniqueID);
        String serverReturnMsg = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "rescheduleFlowInfo_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return serverReturnMsg;
    }

    public boolean deleteFlow(String flowDefId) {
        String authRequestString = "deleteflow_;_" + flowDefId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "deleteFlow_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "deleteFlow_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean holdFlow(String flowDef) {
        String authRequestString = "holdFlowInst_;_" + flowDef;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "holdFlow_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "holdFlow_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean releaseFlow(String flowDef) {
        String authRequestString = "releaseFlowInst_;_" + flowDef;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "releaseFlow_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "releaseFlow_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean killJobInstance(String itemInsId, String user, SealedString pass) {
        String authRequestString = "killRunningJobInst_;_" + itemInsId + "_;_" + user + "_;_" + pass != null ? String.valueOf(pass.getCharacters()) : null;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "killJobInstance_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "killJobInstance_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean killFlowInstance(String flowInst) {
        String authRequestString = "killFlowInst_;_" + flowInst;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "killFlowInstance_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "killFlowInstance_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean resumeFlowInstance(String flowInst) {
        String authRequestString = "resumeFlowInst_;_" + flowInst;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "resumeFlowInstance_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "resumeFlowInstance_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean suspendFlowInstance(String flowInst) {
        String authRequestString = "suspendFlowInst_;_" + flowInst;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "pausedFlowInstance_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "pauseFlowInstance_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public List<FlowHistory> retrieveHistory(String user, String flowDefId, String count) {
        String authRequestString = "getHistory_;_" + user + "_;_" + flowDefId + "_;_" + count;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowHistoryList_" + uniqueID);
        ArrayList<FlowHistory> flowHistories = new ArrayList<FlowHistory>();
        Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowHistoryList_" + uniqueID);
        if (msg != null) {
            try {
                String[] histories;
                String serverReturnMsg = ((TextMessage)msg).getText();
                for (String hist : histories = serverReturnMsg.split("\n")) {
                    flowHistories.add(SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(hist));
                }
            }
            catch (JMSException e) {
                this.m_logger.debug((Object)e);
            }
            catch (SchedulerException e) {
                this.m_logger.debug((Object)e);
            }
            int n = Integer.getInteger(count);
            if (flowHistories != null && flowHistories.size() > n) {
                for (int x = flowHistories.size(); x > n; --x) {
                    flowHistories.set(x, null);
                }
            }
        }
        return flowHistories;
    }

    public List<FlowHistory> getAllFlowHistory(HistorySearchOptions searchOptions) {
        String authRequestString = "getHistory_;_" + searchOptions.toSerializedForm();
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowHistoryList_" + uniqueID);
        ArrayList<FlowHistory> flowHistories = new ArrayList<FlowHistory>();
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowHistoryList_" + uniqueID);
            if (msg != null) {
                String[] histories;
                String serverReturnMsg = ((TextMessage)msg).getText();
                for (String hist : histories = serverReturnMsg.split("\n")) {
                    flowHistories.add(SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(hist));
                }
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        catch (SchedulerException e) {
            this.m_logger.debug((Object)e);
        }
        return flowHistories;
    }

    public List<FlowHistory> getFlowHistory(String userId, String[] flows, int count) {
        String flowString = "";
        for (String flow : flows) {
            flowString = flowString + flow + "_:_";
        }
        String authRequestString = "getFlowsHistory_;_" + userId + "_;_" + flowString + "_;_" + count;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowHistoryList_" + uniqueID);
        ArrayList<FlowHistory> flowHistories = new ArrayList<FlowHistory>();
        try {
            String serverReturnMsg;
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowHistoryList_" + uniqueID);
            if (msg != null && !(serverReturnMsg = ((TextMessage)msg).getText()).isEmpty()) {
                String[] histories;
                for (String hist : histories = serverReturnMsg.split("_:_")) {
                    flowHistories.add(SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(hist));
                }
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        catch (SchedulerException e) {
            this.m_logger.debug((Object)e);
        }
        return flowHistories;
    }

    public SASJFSFlowHistory retrieveFlowHistoryforInstance(String instanceId) {
        String authRequestString = "getFlowHistoryInstance_;_" + instanceId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowInstance_" + uniqueID);
        SASJFSFlowHistory flowHistory = null;
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowInstance_" + uniqueID);
            if (msg != null) {
                String serverReturnMsg = ((TextMessage)msg).getText();
                flowHistory = SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(serverReturnMsg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        catch (SchedulerException e) {
            this.m_logger.debug((Object)e);
        }
        return flowHistory;
    }

    public boolean verifyFlowScheduled(String flowDefId) {
        String authRequestString = "verifyFlowScheduled_;_" + flowDefId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "isFlowScheduled_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "isFlowScheduled_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public Long getFlowInstance(String user, String flowDefId) {
        String authRequestString = "getFlowInstanceId_;_" + user + "_;_" + flowDefId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowInstance_" + uniqueID);
        String serverReturnMsg = "-1L";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowOrchestratorCommand_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return new Long(serverReturnMsg);
    }

    public List<ScheduledFlowInfo> getScheduledFlows(String userId) {
        String authRequestString = "getScheduledFlows_;_" + userId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getScheduledFlows_" + uniqueID);
        ArrayList<ScheduledFlowInfo> flows = new ArrayList<ScheduledFlowInfo>();
        try {
            String serverReturnMsg;
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getScheduledFlows_" + uniqueID);
            if (msg != null && !(serverReturnMsg = ((TextMessage)msg).getText()).isEmpty()) {
                String[] flowXMLs;
                for (String flowXML : flowXMLs = serverReturnMsg.split("_:_")) {
                    FlowInfo info = XMLFactory.initFlowInfoFromXML((String)JFSScheduleManager.formatDatFlowForFlowInfo(flowXML));
                    this.checkScheduledUser(info, userId);
                    ScheduledFlowInfo sinfo = new ScheduledFlowInfo(info.getName(), info.getScheduleDefinitionId(), info.getScheduledUserIdDataBinding(), info.getTriggerId());
                    flows.add(sinfo);
                }
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        catch (SchedulerException e) {
            this.m_logger.debug((Object)e);
        }
        return flows;
    }

    public List<FlowInfo> getAllScheduledFlows() {
        String authRequestString = "getScheduledFlows_;_" + this.m_id;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getScheduledFlows_" + uniqueID);
        ArrayList<FlowInfo> flows = new ArrayList<FlowInfo>();
        try {
            String serverReturnMsg;
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getScheduledFlows_" + uniqueID);
            if (msg != null && !(serverReturnMsg = ((TextMessage)msg).getText()).isEmpty()) {
                String[] flowXMLs;
                for (String flowXML : flowXMLs = serverReturnMsg.split("_:_")) {
                    TriggerEventInfo trigger;
                    this.m_logger.debug("*****: " + flowXML);
                    FlowInfo info = XMLFactory.initFlowInfoFromXML((String)JFSScheduleManager.formatDatFlowForFlowInfo(flowXML));
                    List triggers = info.getAvailableTriggersDataBinding();
                    this.m_logger.debug("*****: number of triggers: " + triggers.size());
                    if (triggers.size() > 1) {
                        this.m_logger.debug("*****: multi triggers supported: " + info.getScheduler().isMultiTriggersSupported());
                        if (info.getScheduler().isMultiTriggersSupported()) {
                            this.m_logger.debug("How do we know whether to OR or AND the events.");
                        }
                        this.m_logger.debug("Only one trigger event is supported. Using the first one found.");
                        trigger = (TriggerEventInfo)triggers.get(0);
                        if (trigger.getName() == null) {
                            trigger.setName(trigger.getEvent().toString());
                        }
                        this.m_logger.debug("*****: using first trigger of multi " + trigger.getClass().getName());
                        info.setActiveTriggerDataBinding(trigger);
                    } else if (triggers.size() == 1) {
                        trigger = (TriggerEventInfo)triggers.get(0);
                        if (trigger.getName() == null) {
                            trigger.setName(trigger.getEvent().toString());
                        }
                        this.m_logger.debug("*****: " + trigger.getClass().getName());
                        info.setActiveTriggerDataBinding(trigger);
                    }
                    this.checkScheduledUser(info, null);
                    flows.add(info);
                }
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        catch (SchedulerException e) {
            this.m_logger.debug((Object)e);
        }
        return flows;
    }

    private void checkScheduledUser(FlowInfo info, String userId) {
        String name = info.getName();
        String user = info.getScheduledUser();
        String defId = info.getFlowDefinitionIdDataBinding();
        this.m_logger.debug("CheckScheduledUser: Flow name: " + name);
        this.m_logger.debug("CheckScheduledUser: Flow id: " + info.getId());
        this.m_logger.debug("CheckScheduledUser: Flow def id: " + defId);
        this.m_logger.debug("CheckScheduledUser: Scheduled user: " + user);
        if (user == null || user.trim().isEmpty()) {
            this.m_logger.debug("CheckScheduledUser: Flow scheduled user: " + user);
            if (defId != null && !defId.trim().isEmpty()) {
                this.m_logger.debug("CheckScheduledUser: Scheduled user is missing, trying to parse the name from: " + defId);
                String[] tokens = defId.split("_" + name);
                if (tokens.length > 0) {
                    user = tokens[0];
                    this.m_logger.debug("CheckScheduledUser: user token is: " + user);
                } else {
                    this.m_logger.debug("CheckScheduledUser: Unable to determine scheduled user.");
                    if (userId != null) {
                        user = userId;
                        this.m_logger.debug("CheckScheduledUser: Assuming the scheduled user is: " + userId);
                    }
                }
            } else {
                this.m_logger.debug("CheckScheduledUser: Unable to determine scheduled user, no definition id.");
                if (userId != null) {
                    user = userId;
                    this.m_logger.debug("CheckScheduledUser: Assuming the scheduled user is: " + userId);
                }
            }
            this.m_logger.debug("CheckScheduledUser: Scheduled user for (" + name + ") is: " + user);
            info.setScheduledUserIdDataBinding(user);
        }
    }

    public List<RunHistory> getRunningJobs(String userId) {
        ArrayList<RunHistory> jobs = new ArrayList<RunHistory>();
        return jobs;
    }

    public String getSGMGResources() {
        String authRequestString = "getSGMGConfig_;_";
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getSGMGResources_" + uniqueID);
        String serverReturnMsg = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getSGMGResources_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return serverReturnMsg;
    }

    public boolean cacheSGMGConfiguration(String user, SealedString pass, String restAPIPath) {
        String authRequestString = "setSGMGConfig_;_" + user + "_;_" + pass != null ? String.valueOf(pass.getCharacters()) : "_;_" + restAPIPath + "_;_" + restAPIPath;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "cacheSGMGConfiguration_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "cacheSGMGConfiguration_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean deleteSGMGConfiguration() {
        String authRequestString = "deleteSGMGConfig_;_";
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "deleteSGMGConfiguration_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "deleteSGMGConfiguration_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public String getStdOut(String flowName, String jobId) {
        String authRequestString = "postRunningJobInst_;_" + flowName + "_;_" + jobId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getStdOut_" + uniqueID);
        String serverReturnMsg = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getStdOut_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return serverReturnMsg;
    }

    public String getStdErr(String flowName, String jobId) {
        String authRequestString = "postRunningJobInst_;_" + flowName + "_;_" + jobId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getStdErr_" + uniqueID);
        String serverReturnMsg = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getStdErr_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return serverReturnMsg;
    }

    public FlowInfo getFlowInfo(String flowDefId, String instanceId, boolean runNow) throws SchedulerException {
        String authRequestString = "getFlow_;_" + flowDefId + "_;_" + runNow + "_;_" + instanceId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowInfo_" + uniqueID);
        FlowInfo flowInfo = null;
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowInfo_" + uniqueID);
            if (msg != null) {
                String serverReturnMsg = ((TextMessage)msg).getText();
                flowInfo = XMLFactory.initFlowInfoFromXML((String)JFSScheduleManager.formatDatFlowForFlowInfo(serverReturnMsg));
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return flowInfo;
    }

    public SASJFSProperties getFlowProperties() throws SchedulerException {
        String authRequestString = "getFlowProp_;_";
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowProp_" + uniqueID);
        SASJFSProperties sasjfsProps = null;
        try {
            String props;
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowProp_" + uniqueID);
            if (msg != null && (props = ((TextMessage)msg).getText()).contains("_;_")) {
                sasjfsProps = SASJFSProperties.getPropertiesFromString(props);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return sasjfsProps;
    }

    public boolean setFlowHistory(String flowDefId, String historyString, String instanceId) {
        String authRequestString = "saveHistory_;_" + flowDefId + "_;_" + historyString + "_;_" + instanceId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "setFlowHistory_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "setFlowHistory_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public PasswordAuthentication retrieveAuthorization(String user) {
        PasswordAuthentication auth = null;
        String authRequestString = "currentUser_;_" + user;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "retrieveAuthorization_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_bytesQueue, this.m_id, "retrieveAuthorization_" + uniqueID);
            if (msg != null) {
                auth = new PasswordAuthentication(user, JMSClientSupport.getChar(msg));
                return auth;
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return null;
    }

    public boolean addRunningJobInstance(String flowName, int jobId) {
        String authRequestString = "postRunningJobInst_;_" + flowName + "_;_" + jobId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "addRunningJobInstance_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "addRunningJobInstance_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean removeRunningJobInstance(String flowName, int jobId) {
        String authRequestString = "removeRunningJobInst_;_" + flowName + "_;_" + jobId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "removeRunningJobInstance_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "removeRunningJobInstance_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean setJobHistory(String flowId, SASJFSJobInfo sasJFSJobInfo) {
        String authRequestString = "postJobHistory_;_" + flowId + "_;_" + sasJFSJobInfo.toSerializedForm();
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "postJobHistory_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "postJobHistory_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public String getFlowState(String flowId) {
        String authRequestString = "flowstate_;_" + flowId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "getFlowState_" + uniqueID);
        String serverReturnMsg = "";
        try {
            Message msg = this.receiveRequestFromServer(this.m_stringQueue, this.m_id, "getFlowState_" + uniqueID);
            if (msg != null) {
                serverReturnMsg = ((TextMessage)msg).getText();
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return serverReturnMsg;
    }

    public boolean isHA() {
        String authRequestString = "isHA_;__;_";
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "isHA_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "isHA_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public boolean isScheduled(String flowId) {
        String authRequestString = "isScheduled_;_" + flowId;
        String uniqueID = UUID.randomUUID().toString();
        this.sendRequestToServer(authRequestString, this.m_id, "isScheduled_" + uniqueID);
        try {
            Message msg = this.receiveRequestFromServer(this.m_checkQueue, this.m_id, "isScheduled_" + uniqueID);
            if (msg != null) {
                return JMSClientSupport.getBoolean(msg);
            }
        }
        catch (JMSException e) {
            this.m_logger.debug((Object)e);
        }
        return false;
    }

    public static List<PasswordAuthentication> getAuthorizationToken(FlowInfo flowInfo, String user, JMSClientSupport client) {
        ArrayList<PasswordAuthentication> paList = new ArrayList<PasswordAuthentication>();
        String type = flowInfo.getScheduler().getJobExecutionProviderDataBinding();
        if (type.equalsIgnoreCase("REST") || type.equalsIgnoreCase("Launcher")) {
            client.m_logger.debug("The following user's authorization is attempting to be retrieved: " + user);
            PasswordAuthentication pa = client.retrieveAuthorization(user);
            if (pa != null) {
                paList.add(pa);
                client.m_logger.debug("Authorization found in metadata.");
            }
            List<PasswordAuthentication> paAuthList = JMSClientSupport.getPasswordFromAuthFile(flowInfo.getScheduler(), user);
            for (int i = 0; i < paAuthList.size(); ++i) {
                paList.add(paAuthList.get(i));
            }
        }
        if (paList.isEmpty()) {
            client.m_logger.debug("Authorization not found in metadata or authinfo file.");
        }
        return paList;
    }

    public static Boolean getBoolean(Message msg) throws JMSException {
        if (msg instanceof StreamMessage) {
            return ((StreamMessage)msg).readBoolean();
        }
        if (msg instanceof ObjectMessage) {
            return (Boolean)((ObjectMessage)msg).getObject();
        }
        try {
            return Boolean.valueOf(msg.toString());
        }
        catch (RuntimeException rte) {
            try {
                throw new JMSException(rte.toString()).initCause((Throwable)rte);
            }
            catch (Throwable e) {
                Logger LOGGER = LogManager.getLogger(JMSClientSupport.class);
                LOGGER.debug(e.getMessage());
                return false;
            }
        }
    }

    public static char[] getChar(Message msg) throws JMSException {
        char[] charArray;
        block13: {
            int byteCount;
            block12: {
                int byteCount2;
                charArray = new char[]{};
                if (!(msg instanceof BytesMessage)) break block12;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] byteBuffer = new byte[4096];
                while ((byteCount2 = ((BytesMessage)msg).readBytes(byteBuffer)) != -1) {
                    baos.write(byteBuffer, 0, byteCount2);
                }
                try {
                    baos.close();
                }
                catch (IOException ioe) {
                    try {
                        throw new JMSException(ioe.toString()).initCause((Throwable)ioe);
                    }
                    catch (Throwable e) {
                        Logger LOGGER = LogManager.getLogger(JMSClientSupport.class);
                        LOGGER.debug(e.getMessage());
                        return charArray;
                    }
                }
                byte[] byteArray = baos.toByteArray();
                charArray = new char[byteArray.length];
                for (int i = 0; i < byteArray.length; ++i) {
                    charArray[i] = (char)(byteArray[i] & 0xFF);
                }
                break block13;
            }
            if (!(msg instanceof StreamMessage)) break block13;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] byteBuffer = new byte[4096];
            while ((byteCount = ((StreamMessage)msg).readBytes(byteBuffer)) != -1) {
                baos.write(byteBuffer, 0, byteCount);
            }
            try {
                baos.close();
            }
            catch (IOException ioe) {
                try {
                    throw new JMSException(ioe.toString()).initCause((Throwable)ioe);
                }
                catch (Throwable e) {
                    Logger LOGGER = LogManager.getLogger(JMSClientSupport.class);
                    LOGGER.debug(e.getMessage());
                    return charArray;
                }
            }
            byte[] byteArray = baos.toByteArray();
            charArray = new char[byteArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                charArray[i] = (char)(byteArray[i] & 0xFF);
            }
        }
        return charArray;
    }

    private static List<PasswordAuthentication> getPasswordFromAuthFile(SchedulerServerInfo ssi, String user) {
        Logger LOGGER = LogManager.getLogger(JMSClientSupport.class);
        String directory = ssi.getAuthInfo();
        ArrayList<PasswordAuthentication> paList = new ArrayList<PasswordAuthentication>();
        String gridHost = "";
        if (ssi.getRestAPIPath() != null) {
            URI gridURI = URI.create(ssi.getRestAPIPath());
            gridHost = gridURI.getHost();
        }
        if (directory == null || directory.equalsIgnoreCase("null") || directory.isEmpty()) {
            directory = System.getProperty("user.home");
        }
        String file = "/.authinfo";
        String filename = directory + file;
        String filename2 = null;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            file = "/_authinfo";
            filename2 = filename;
            filename = directory + file;
            LOGGER.debug("The authorization file is being retrieved from the following location: " + filename);
        }
        try {
            File temp = new File(filename);
            if (!temp.exists()) {
                LOGGER.debug("The authorization file was not found, searching secondary location: " + filename2);
            }
            if (!temp.exists() && filename2 != null && !(temp = new File(filename2)).exists()) {
                LOGGER.debug("The authorization file was not found in any location searched");
            }
            if (!temp.canWrite()) {
                String line;
                LOGGER.debug("Valid Authorization file found.");
                BufferedReader reader = new BufferedReader(new FileReader(temp.getAbsolutePath()));
                LOGGER.debug("Authorization reader established");
                while ((line = reader.readLine()) != null) {
                    LOGGER.debug("Reading line.");
                    if (JMSClientSupport.getParameterValue(line, "host").equalsIgnoreCase(gridHost) && (JMSClientSupport.getParameterValue(line, "user").equalsIgnoreCase("\"" + user + "\"") || JMSClientSupport.getParameterValue(line, "user").equalsIgnoreCase(user))) {
                        LOGGER.debug("Authorization found");
                        paList.add(new PasswordAuthentication(user, JMSClientSupport.getParameterValue(line, "password").toCharArray()));
                    }
                    if (line.contains("default") && (JMSClientSupport.getParameterValue(line, "user").equalsIgnoreCase("\"" + user + "\"") || JMSClientSupport.getParameterValue(line, "user").equalsIgnoreCase(user))) {
                        LOGGER.debug("Authorization found");
                        paList.add(new PasswordAuthentication(user, JMSClientSupport.getParameterValue(line, "password").toCharArray()));
                    }
                    if (line.contains("default")) {
                        LOGGER.debug("Default value found in line: true");
                        LOGGER.debug("User found in line: [" + JMSClientSupport.getParameterValue(line, "user") + "] looking for: " + user);
                    } else {
                        LOGGER.debug("Default value found in line: false");
                        LOGGER.debug("User found in line: [" + JMSClientSupport.getParameterValue(line, "user") + "] looking for: " + user);
                    }
                    if (!JMSClientSupport.getParameterValue(line, "user").equalsIgnoreCase("\"" + user + "\"") && !JMSClientSupport.getParameterValue(line, "user").equalsIgnoreCase(user)) continue;
                    LOGGER.debug("User found in line: true");
                }
                reader.close();
            } else {
                LOGGER.warn("Authinfo file was not found or does not have correct permissions. If using authinfo for authentication make sure file is in user home directory and permissions are not writable.");
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception occurred trying to read: " + file);
            LOGGER.error((Object)e);
        }
        return paList;
    }

    private static String getParameterValue(String line, String parameter) {
        String value = "";
        if (line.contains(parameter) && (line = line.split(parameter)[1]).contains(" ")) {
            value = line.split(" ")[1];
        }
        return value;
    }
}

