/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.SocketFactoryFactory;
import com.sas.scheduler.api.servers.sasjfs.ssl.client.SSLSocketFactoryBuilder;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactory {
    private static final String SSL_PROTOCOL_PROPERTY = "sas.grid.client.ssl.protocol";
    private static final String SSL_PROTOCOL_DEFAULT = "TLSv1.2";
    private static final String SSL_TRUST_MANAGER_ALGORITHM_PROPERTY = "sas.grid.client.ssl.trust-manager-algorithm";
    private static final String SSL_TRUST_MANAGER_ALGORITHM_DEFAULT = "PKIX";
    private static final String SSL_TRUST_STORE_TYPE_PROPERTY = "sas.grid.client.ssl.trust-store-type";
    private static final String SSL_TRUST_STORE_TYPE_DEFAULT = "JKS";
    private static final String SSL_TRUST_STORE_PROPERTY = "sas.joborch.client.ssl.trust-store";
    private static final String SSL_TRUST_STORE_PROPERTY_DEFAULT = "javax.net.ssl.trustStore";
    private static final String SSL_TRUST_STORE_PASSWORD_PROPERTY = "sas.joborch.client.ssl.trust-store-password";
    private static final String SSL_TRUST_STORE_PASSWORD_PROPERTY_DEFAULT = "javax.net.ssl.trustStorePassword";
    private final javax.net.SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactory;

    public SocketFactory(boolean isSSLEnabled) throws Exception {
        if (!isSSLEnabled) {
            SocketFactoryFactory socketFactoryFactory = new SocketFactoryFactory();
            this.socketFactory = socketFactoryFactory.getInstance();
            this.sslSocketFactory = null;
        } else {
            SSLSocketFactoryBuilder sslSocketFactoryBuilder = new SSLSocketFactoryBuilder();
            try {
                String sslProtocol = System.getProperty(SSL_PROTOCOL_PROPERTY) != null ? System.getProperty(SSL_PROTOCOL_PROPERTY) : SSL_PROTOCOL_DEFAULT;
                String sslTrustManagerAlgorithm = System.getProperty(SSL_TRUST_MANAGER_ALGORITHM_PROPERTY) != null ? System.getProperty(SSL_TRUST_MANAGER_ALGORITHM_PROPERTY) : SSL_TRUST_MANAGER_ALGORITHM_DEFAULT;
                String sslTrustStoreType = System.getProperty(SSL_TRUST_STORE_TYPE_PROPERTY) != null ? System.getProperty(SSL_TRUST_STORE_TYPE_PROPERTY) : SSL_TRUST_STORE_TYPE_DEFAULT;
                String sslTrustStorePath = System.getProperty(SSL_TRUST_STORE_PROPERTY) != null ? System.getProperty(SSL_TRUST_STORE_PROPERTY) : SSL_TRUST_STORE_PROPERTY_DEFAULT;
                SealedString sslTrustStorePassword = new SealedString(System.getProperty(SSL_TRUST_STORE_PASSWORD_PROPERTY) != null ? System.getProperty(SSL_TRUST_STORE_PASSWORD_PROPERTY) : SSL_TRUST_STORE_PASSWORD_PROPERTY_DEFAULT);
                this.sslSocketFactory = sslSocketFactoryBuilder.getInstance().sslProtocol(sslProtocol).sslTrustManagerAlgorithm(sslTrustManagerAlgorithm).sslTrustStoreType(sslTrustStoreType).sslTrustStorePath(sslTrustStorePath).sslTrustStorePassword(sslTrustStorePassword).build();
            }
            catch (Exception cause) {
                throw new Exception(cause);
            }
            this.socketFactory = null;
        }
    }

    public Socket createSocket(String host, int port, Boolean sslEnabled) throws IOException {
        if (!sslEnabled.booleanValue()) {
            return this.socketFactory.createSocket(host, port);
        }
        return this.sslSocketFactory.createSocket(host, port);
    }
}

