/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.api.servers.sasjfs.engine.SASJFSProperties;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.AbstractFlowRunnable;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.ExecutionItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowOrchestrator;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowRunner;
import com.sas.scheduler.api.servers.sasjfs.utilities.OSCommand;
import com.sas.scheduler.model.JobInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OSRunnable
extends AbstractFlowRunnable {
    private static final Logger LOGGER = LogManager.getLogger(FlowOrchestrator.class);

    public OSRunnable(ExecutionItem item, SASJFSProperties props, FlowRunner.FlowRunnerCallback cb) {
        super(item, props, null, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._executionItem._sasJFSJobInfo.setStartTime(new Date());
        this._flowRunnerCallback.callbackJobRunning(this._executionItem);
        OSCommand mc_osCommand = new OSCommand(((JobInfo)this._executionItem._info).getCommandLine(), SASJFScheduler.getLogger());
        File stdOut = null;
        PrintStream outputStream = null;
        File stdErr = null;
        PrintStream errorStream = null;
        try {
            stdOut = File.createTempFile("sasjfs-", "-floworch");
            outputStream = new PrintStream(stdOut.getAbsolutePath());
            stdErr = File.createTempFile("sasjfs-", "-floworch_error");
            errorStream = new PrintStream(stdErr.getAbsolutePath());
            this._executionItem._sasJFSJobInfo.setCompletionCode(mc_osCommand.runJob(outputStream, errorStream));
            this._executionItem._sasJFSJobInfo.setStdout(this.writeOutFileToString(stdOut));
            this._executionItem._sasJFSJobInfo.setStderr(this.writeOutFileToString(stdErr));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            outputStream.close();
            errorStream.close();
            if (stdOut != null) {
                stdOut.delete();
            }
            if (stdErr != null) {
                stdErr.delete();
            }
        }
        Process process = mc_osCommand.getProcess();
        this._executionItem._sasJFSJobInfo.setFinishTime(new Date());
        this._flowRunnerCallback.callbackJobCompleted(this._executionItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeOutFileToString(File fileToRead) {
        BufferedReader br = null;
        String line = null;
        String fileOutput = "";
        try {
            br = new BufferedReader(new FileReader(fileToRead.getAbsolutePath()));
            while ((line = br.readLine()) != null) {
                fileOutput = fileOutput + line;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fileOutput;
    }
}

