/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.scheduler.api.servers.sasjfs.floworchestration.ExecutionItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.JobDepChecker;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.SASJFSJobInfo;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.TimeDepExpressionChecker;
import java.util.ArrayList;

public abstract class AbstractDepChecker {
    protected volatile ArrayList<ExecutionItem> _completedItems;
    protected volatile ArrayList<ExecutionItem> _runningItems;
    protected volatile SASJFSJobInfo _depHistory;
    protected String _depTargetName;

    public AbstractDepChecker() {
    }

    public AbstractDepChecker(String depTargetName, String depName, int expEval, ArrayList<ExecutionItem> runningItems, ArrayList<ExecutionItem> completedItems) {
        this._completedItems = completedItems;
        this._runningItems = runningItems;
        if (this instanceof JobDepChecker) {
            this._depHistory = this.getJobHistoryByName(depName, expEval);
        }
        if (this instanceof TimeDepExpressionChecker) {
            this._depHistory = this.getJobHistoryByName(depTargetName, expEval);
        }
        this._depTargetName = depTargetName;
    }

    public boolean jobNameInCompletedItems(String jeiJobName) {
        boolean retval = false;
        for (ExecutionItem item : this._completedItems) {
            if (!item._jobName.equals(jeiJobName)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    protected SASJFSJobInfo getJobHistoryByName(String name, int expEval) {
        for (ExecutionItem item : this._completedItems) {
            if (!item._info.getName().equals(name) && !item._jobName.equals(name)) continue;
            return item._sasJFSJobInfo;
        }
        if (expEval == 4) {
            for (ExecutionItem item : this._runningItems) {
                if (!item._info.getName().equals(name)) continue;
                return item._sasJFSJobInfo;
            }
        }
        return null;
    }
}

