/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.engine;

import com.sas.grid.representations.Job;
import com.sas.grid.representations.ResourceNames;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.sasjfs.SASJFSFlowHistory;
import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.api.servers.sasjfs.engine.ClientLogger;
import com.sas.scheduler.api.servers.sasjfs.engine.DAVPersistence;
import com.sas.scheduler.api.servers.sasjfs.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.sasjfs.engine.SASJFSProperties;
import com.sas.scheduler.api.servers.sasjfs.engine.SyncManager;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.GridService;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSServiceSupport;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSUtilities;
import com.sas.scheduler.api.servers.sasjfs.sgmg.AuthenticationException;
import com.sas.scheduler.api.servers.sasjfs.utilities.CLIHelper;
import com.sas.scheduler.api.servers.sasjfs.utilities.SASJFSXMLFactory;
import com.sas.scheduler.api.servers.sasjfs.utilities.SGMGConfigurationUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.content.document.client.DocumentService;
import com.sas.svcs.content.folder.client.FolderService;
import com.sas.svcs.content.navigation.client.NavigationService;
import com.sas.svcs.dav.client.DAVContentServiceInterface;
import com.sas.util.SasPasswordEncodingException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.UncategorizedJmsException;

public class JFSScheduleManager {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(JFSScheduleManager.class);
    private static final Logger LOGGER = LogManager.getLogger(JFSScheduleManager.class);
    protected static final String FlowFolder = "FlowDef";
    protected static final String RunNowFlowFolder = "RunNowFlowDef";
    protected static final String FlowInstFolder = "FlowInst";
    protected static final String FlowFolderPrefix = "FlowDef_";
    protected static final String RunNowFolderPrefix = "RunNowFlowDef_";
    protected static final String FlowInstFolderPrefix = "FlowInst_";
    protected static final String FlowDefinitionFile = "FlowDef_%s.dat";
    protected static final String FlowInstanceFile = "FlowInst_%s.dat";
    protected static final String RunNowFlowDefinitionFile = "RunNowFlowDef_%s.dat";
    protected static final String SASJFSPropertiesFile = "SASJFSProperties.dat";
    protected static final String FlowHistoryInstances = "FlowHistoryInstances.dat";
    public static final String ARGSEPARATOR = "_;_";
    public static final String PARAMETERSEPARATOR = "_:_";
    public static final String RUNNABLE = "Runnable";
    public static final String KILL = "kill";
    public static final String SUSPEND = "suspend";
    public static final String RESUME = "resume";
    public static final String POSTFLOWXML = "saveflow_;_";
    public static final String RESCHFLOWXML = "rescheduleflow_;_";
    public static final String DELETEFLOWXML = "deleteflow_;_";
    public static final String GETFLOWXML = "getFlow_;_";
    public static final String GETFLOWPROP = "getFlowProp_;_";
    public static final String GETGRIDCRED = "currentUser_;_";
    public static final String POSTFLOWHISTORY = "saveHistory_;_";
    public static final String POSTJOBHISTORY = "postJobHistory_;_";
    public static final String POSTRUNNINGJOBINST = "postRunningJobInst_;_";
    public static final String REMOVERUNNINGJOBINST = "removeRunningJobInst_;_";
    public static final String KILLRUNNINGJOBINST = "killRunningJobInst_;_";
    public static final String GETFLOWHISORY = "getHistory_;_";
    public static final String GETFLOWSHISORY = "getFlowsHistory_;_";
    public static final String GETSCHFLOW = "getScheduledFlows_;_";
    public static final String VERIFYFLOWSCHED = "verifyFlowScheduled_;_";
    public static final String GETFLOWINSTANCEID = "getFlowInstanceId_;_";
    public static final String GETFLOWHISTORYINSTANCE = "getFlowHistoryInstance_;_";
    public static final String GETFLOWTRIGGERID = "getFlowTriggerId_;_";
    public static final String GETFLOWTRIGGER = "getFlowTrigger_;_";
    public static final String GETFLOWID = "getFlowId_;_";
    public static final String SETTRIGGERID = "setTriggerId_;_";
    public static final String GETFLOWORCHCMD = "getFlowOrchestratorCommand_;_";
    public static final String GETTRIGGERCMD = "getOSTriggerCommand_;_";
    public static final String GETCRONTABPATH = "getCronTabPath_;_";
    public static final String GETSGMGCONFIG = "getSGMGConfig_;_";
    public static final String SETSGMGCONFIG = "setSGMGConfig_;_";
    public static final String DELSGMGCONFIG = "deleteSGMGConfig_;_";
    public static final String GETSERVICEID = "getServiceId_;_";
    public static final String SETSERVICEID = "setServiceId_;_";
    public static final String ISHA = "isHA_;_";
    public static final String ISSCHEDULED = "isScheduled_;_";
    public static final String FLOWSTATE = "flowstate_;_";
    public static final String HOLDFLOW = "holdFlowInst_;_";
    public static final String RELEASEFLOW = "releaseFlowInst_;_";
    public static final String KILLFLOWINST = "killFlowInst_;_";
    public static final String SUSPENDFLOWINST = "suspendFlowInst_;_";
    public static final String RESUMEFLOWINST = "resumeFlowInst_;_";
    public static final String FLOWINSTKILLED = "flowInstKilled_;_";
    public static final String FLOWINSTSUSPENDED = "flowInstSuspended_;_";
    public static final String FLOWINSTRESUMED = "flowInstResumed_;_";
    public static final String EXIT = "exit";
    public static final int COMPLETION_CODE_RUNNING = 8;
    private static Map<String, String> m_allFlows = new HashMap<String, String>();
    private static Map<String, String> m_runningFlows = new HashMap<String, String>();
    private static Map<String, ArrayList<String>> m_runningJobsforFlows = new HashMap<String, ArrayList<String>>();
    private static List<String> m_killFlows = new ArrayList<String>();
    private static List<String> m_suspendFlows = new ArrayList<String>();
    private static List<String> m_resumeFlows = new ArrayList<String>();
    private static Map<String, String> m_instanceLookup = new HashMap<String, String>();
    private static Map<Long, String> m_cachedHistory = new HashMap<Long, String>();
    private static Map<String, String> m_inMemoryHistoryHolder = new HashMap<String, String>();
    private static int maxHistories = 9998;
    private static int maxFlowHistories = 24;
    private static int connTimeOut = 10;
    private SASJFScheduler m_scheduler = null;
    private ServerComponent m_sc = null;
    private String m_serviceId = null;
    private SchedulerServerInfo m_schInfo = null;
    private String m_metahost = null;
    private String m_metaport = null;
    private UserContextInterface m_metadataUser = null;
    private MdObjectStore m_store = null;
    private String m_repos = null;
    protected ClientLogger m_clientLogger;
    protected Properties m_config;
    protected DAVPersistence m_persistenceProvider;
    private String sgmgConfigString = "";
    private Thread m_FileEventThread;
    private MdFactorySupplier mdFactorySupplier = new MdFactorySupplier();
    static final int FILE_POLLING_CYCLE = 30000;

    public JFSScheduleManager(SchedulerServerInfo sch, UserContextInterface mdUser, String omrhost, String omrport, ClientLogger logger) {
        this.m_metahost = omrhost;
        this.m_metaport = omrport;
        this.m_metadataUser = mdUser;
        this.m_clientLogger = logger;
        this.m_serviceId = sch.getId() != null ? sch.getId() : "NOTSET";
        try {
            this.initOMR(sch);
            Scheduler scheduler = MetaUtilities.getSchedulerFromName(sch.getName(), (MdStore)this.m_store, this.m_repos);
            if (scheduler == null) {
                this.m_schInfo = sch;
            } else if (scheduler instanceof SASJFScheduler) {
                this.m_scheduler = (SASJFScheduler)scheduler;
                this.m_schInfo = scheduler.getServerComponent();
                if (this.m_schInfo.getHost().equals("DEFAULT")) {
                    TCPIPConnection connection;
                    this.m_schInfo.setHost(sch.getHost());
                    this.m_sc = MetaUtilities.getSchedulerServer(this.m_schInfo, (MdStore)this.m_store, this.m_repos);
                    this.m_serviceId = this.m_schInfo.isUseHADataBinding() ? MetaUtilities.getProperty((Root)this.m_sc, "ServiceId") : JMSUtilities.generatePrimaryId(this.m_schInfo.getFlowOrchestratorHost());
                    AssociationList connections = this.m_sc.getSourceConnections();
                    if (connections != null && connections.size() > 0 && (connection = (TCPIPConnection)connections.get(0)) != null) {
                        connection.setHostName(sch.getHost());
                        this.m_sc.updateMetadataAll();
                    }
                }
                try {
                    List<String> queues = scheduler.getQueues();
                    this.m_schInfo.setQueueListDataBinding(queues);
                }
                catch (Exception e) {
                    LOGGER.debug("Unable to determine queues for:" + this.m_schInfo.getName());
                }
            } else {
                LOGGER.debug("Given wrong scheduler type.");
            }
        }
        catch (RuntimeException rte) {
            LOGGER.error("Constructor: " + rte.getMessage());
        }
        catch (Throwable t) {
            LOGGER.debug("Constructor: " + t.getMessage());
        }
    }

    public void setDavPersistance(DAVContentServiceInterface davContentService, DocumentService documentContentService, FolderService folderContentService, NavigationService navigationContentService) {
        if (davContentService != null && this.m_persistenceProvider == null) {
            try {
                this.m_persistenceProvider = new DAVPersistence(documentContentService, folderContentService, navigationContentService, this.m_clientLogger, "");
            }
            catch (Exception e) {
                this.m_clientLogger.logMessage(Level.SEVERE, e);
            }
        }
        if (this.m_persistenceProvider == null) {
            this.m_clientLogger.logMessage(Level.SEVERE, "No persistence provided via DAV ");
        } else {
            this.persistSASJFSProperties();
        }
    }

    private void initOMR(SchedulerServerInfo sch) {
        try {
            MdFactoryImpl factory = new MdFactoryImpl();
            factory.setDebug(false);
            factory.setLoggingEnabled(false);
            factory.getUtil().setOutputStream((OutputStream)System.out);
            factory.getUtil().setLogStream((OutputStream)System.out);
            factory.makeOMRConnection(this.m_metahost, this.m_metaport, sch.getUsername(), sch.getPassword());
            this.m_repos = null;
            List repositories = factory.getOMIUtil().getRepositories();
            for (int i = 0; i < repositories.size(); ++i) {
                CMetadata repository = (CMetadata)repositories.get(i);
                if (!repository.getName().equalsIgnoreCase("Foundation")) continue;
                this.m_repos = repository.getId();
            }
            if (this.m_repos == null) {
                this.m_repos = ((CMetadata)factory.getOMIUtil().getRepositories().get(0)).getId();
            }
            this.m_store = factory.createObjectStore(null, "SASJFS_ScheduleManager");
        }
        catch (Exception e) {
            LOGGER.debug("intOMR: " + e.getMessage());
        }
    }

    public ClientLogger getLogger() {
        return this.m_clientLogger;
    }

    public void initJMS(Properties config) {
        this.m_config = config;
        JMSServiceSupport jmsSupport = null;
        int jmsFailures = 0;
        Message msg = null;
        String id = "";
        String property = "";
        String inboundMsg = "";
        try {
            jmsSupport = new JMSServiceSupport(this.m_clientLogger, config);
            while (!inboundMsg.equals(EXIT)) {
                try {
                    String flowName;
                    String flowDefId;
                    LOGGER.debug("Server queue m_midtierRequestQueue waiting for client queue inbound message on: " + this.m_config.getProperty("java.naming.provider.url"));
                    msg = jmsSupport.getMidtierRequestQueueMsg();
                    jmsFailures = 0;
                    if (msg != null) {
                        id = msg.getStringProperty("ID");
                        property = msg.getStringProperty("CALLER");
                        inboundMsg = msg instanceof TextMessage ? ((TextMessage)msg).getText() : msg.toString();
                    } else {
                        inboundMsg = "";
                        continue;
                    }
                    LOGGER.debug(String.format("m_midtierRequestQueue received: [%s]", inboundMsg));
                    if (inboundMsg.startsWith(GETFLOWXML)) {
                        String xml = "";
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 4) {
                            flowDefId = tokens[1];
                            boolean runNow = Boolean.parseBoolean(tokens[2]);
                            String instanceId = tokens[3];
                            xml = runNow ? this.getRunNowFlowXML(flowDefId) : this.getFlowXML(flowDefId);
                            m_instanceLookup.put(flowDefId, instanceId);
                        }
                        this.configureSASJFSPorperties();
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), xml, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETSERVICEID)) {
                        if (this.isUseHA()) {
                            if (!this.m_schInfo.isUseHADataBinding()) {
                                this.m_serviceId = MetaUtilities.getProperty((Root)this.m_sc, "ServiceId");
                                this.m_schInfo.setUseHADataBinding(true);
                            }
                        } else if (this.m_schInfo.isUseHADataBinding()) {
                            this.m_serviceId = JMSUtilities.generatePrimaryId(this.m_schInfo.getFlowOrchestratorHost());
                            this.m_schInfo.setUseHADataBinding(false);
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), this.m_serviceId, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(ISHA)) {
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), this.isUseHA(), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(ISSCHEDULED)) {
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 2) {
                            jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), this.isScheduled(tokens[1]), id, property);
                            continue;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), false, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETFLOWPROP)) {
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), this.getSASJFSProperties(), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(RESCHFLOWXML)) {
                        inboundMsg = this.formatFlowDataForDat(inboundMsg);
                        String rc = "-1";
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 3) {
                            flowDefId = tokens[1];
                            String xml = tokens[2];
                            rc = this.rescheduleFlowXML(xml, flowDefId);
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), rc, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(POSTFLOWXML)) {
                        String flowDefId2 = "";
                        String[] tokens = (inboundMsg = this.formatFlowDataForDat(inboundMsg)).split(ARGSEPARATOR);
                        if (tokens.length >= 5) {
                            String flowname = tokens[1];
                            String userid = this.getUsernameNotBackSlashDataBinding(tokens[2]);
                            String xml = tokens[3];
                            boolean runNow = Boolean.parseBoolean(tokens[4]);
                            flowDefId2 = runNow ? this.saveRunNowFlow(flowname, userid, xml) : this.saveFlow(flowname, userid, xml);
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), flowDefId2, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(DELETEFLOWXML)) {
                        String flowDefId3 = inboundMsg.split(ARGSEPARATOR)[1];
                        boolean rc = this.deleteFlowXML(flowDefId3);
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), rc, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETGRIDCRED)) {
                        Object message;
                        String user = inboundMsg.split(ARGSEPARATOR)[1];
                        PasswordAuthentication pa = this.getGridAuthorization(user);
                        if (pa != null) {
                            message = this.toBytes(pa.getPassword());
                            jmsSupport.sendResponseToClient(jmsSupport.getBytesQueue(), message, id, property);
                            continue;
                        }
                        message = "";
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), message, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(POSTFLOWHISTORY)) {
                        this.configureSASJFSPorperties();
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 4) {
                            String flowDefId4 = tokens[1];
                            String historyXml = tokens[2];
                            String instanceId = tokens[3];
                            this.publishHistory(flowDefId4, historyXml);
                            this.publishFlowHistory(flowDefId4, instanceId);
                            m_cachedHistory.put(new Long(instanceId), historyXml);
                            jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                            continue;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), false, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(POSTJOBHISTORY)) {
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 3) {
                            String flowDefId5 = tokens[1];
                            String sasJobHistory = tokens[2];
                            this.persistJobHistory(flowDefId5, sasJobHistory);
                            jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                            continue;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), false, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(POSTRUNNINGJOBINST)) {
                        ArrayList<String> jobInstances = new ArrayList<String>();
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 3) {
                            flowName = tokens[1];
                            String jobGridId = tokens[2];
                            if (m_runningJobsforFlows.containsKey(flowName)) {
                                jobInstances = m_runningJobsforFlows.get(flowName);
                            }
                            jobInstances.add(jobGridId);
                            m_runningJobsforFlows.put(flowName, jobInstances);
                            jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                            continue;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), false, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(REMOVERUNNINGJOBINST)) {
                        ArrayList<Object> jobInstances = new ArrayList();
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 3) {
                            flowName = tokens[1];
                            String jobGridId = tokens[2];
                            if (m_runningJobsforFlows.containsKey(flowName)) {
                                if (m_runningJobsforFlows.get(flowName).size() > 0) {
                                    jobInstances = m_runningJobsforFlows.get(flowName);
                                    if (jobInstances.contains(jobGridId)) {
                                        jobInstances.remove(jobGridId);
                                    }
                                    if (jobInstances.size() == 0) {
                                        m_runningJobsforFlows.remove(flowName);
                                    }
                                } else {
                                    m_runningJobsforFlows.remove(flowName);
                                }
                            }
                            jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                            continue;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), false, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(KILLRUNNINGJOBINST)) {
                        ArrayList jobInstances = new ArrayList();
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 4) {
                            flowName = tokens[1];
                            String user = this.getUsernameNotBackSlashDataBinding(tokens[2]);
                            String pw = tokens[3];
                            this.killRunningJobs(flowName, user, pw, connTimeOut);
                            jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                            continue;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), false, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(FLOWSTATE)) {
                        String flowInst = inboundMsg.split(ARGSEPARATOR)[1];
                        String state = RUNNABLE;
                        if (m_killFlows.contains(flowInst)) {
                            state = KILL;
                        } else if (m_suspendFlows.contains(flowInst)) {
                            state = SUSPEND;
                        } else if (m_resumeFlows.contains(flowInst)) {
                            state = RESUME;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), state, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(KILLFLOWINST)) {
                        String flowInst = inboundMsg.split(ARGSEPARATOR)[1];
                        m_killFlows.add(flowInst);
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(SUSPENDFLOWINST)) {
                        String flowInst = inboundMsg.split(ARGSEPARATOR)[1];
                        m_suspendFlows.add(flowInst);
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(RESUMEFLOWINST)) {
                        String flowInst = inboundMsg.split(ARGSEPARATOR)[1];
                        m_resumeFlows.add(flowInst);
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(FLOWINSTKILLED)) {
                        String flowInst = inboundMsg.split(ARGSEPARATOR)[1];
                        m_killFlows.remove(flowInst);
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(FLOWINSTSUSPENDED)) {
                        String flowInst = inboundMsg.split(ARGSEPARATOR)[1];
                        m_suspendFlows.remove(flowInst);
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(FLOWINSTRESUMED)) {
                        String flowInst = inboundMsg.split(ARGSEPARATOR)[1];
                        m_resumeFlows.remove(flowInst);
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETFLOWHISORY)) {
                        HistorySearchOptions hisSearchOpt = HistorySearchOptions.createFromSerializedForm(inboundMsg.split(ARGSEPARATOR)[1]);
                        String history = this.getFlowHistory(hisSearchOpt).toString();
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), history, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETFLOWSHISORY)) {
                        String historiesString = "";
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 4) {
                            SASJFSFlowHistory[] histories;
                            String user = this.getUsernameNotBackSlashDataBinding(tokens[1]);
                            String[] flows = tokens[2].split(PARAMETERSEPARATOR);
                            int count = tokens[3].isEmpty() ? 0 : Integer.parseInt(tokens[3]);
                            for (SASJFSFlowHistory history : histories = this.getFlowHistories(user, flows, count)) {
                                historiesString = historiesString + history.toSerializedForm() + PARAMETERSEPARATOR;
                            }
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), historiesString, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETFLOWHISTORYINSTANCE)) {
                        String instanceId = inboundMsg.split(ARGSEPARATOR)[1];
                        String history = this.getHistoryOfInstance(instanceId);
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), history, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETSCHFLOW)) {
                        String userId = this.getUsernameNotBackSlashDataBinding(inboundMsg.split(ARGSEPARATOR)[1]);
                        String flowsXML = this.getScheduledFlows(userId);
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), flowsXML, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(VERIFYFLOWSCHED)) {
                        String flowDefId6 = inboundMsg.split(ARGSEPARATOR)[1];
                        boolean isFlowScheduled = this.verifyFlowScheduled(flowDefId6);
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), isFlowScheduled, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(SETTRIGGERID)) {
                        boolean setTrigger = false;
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 3) {
                            flowDefId = tokens[1];
                            String triggerDefId = tokens[2];
                            setTrigger = this.setTriggerId(flowDefId, triggerDefId);
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), setTrigger, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETFLOWTRIGGER)) {
                        String flowDefId7 = inboundMsg.split(ARGSEPARATOR)[1];
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), this.getTriggerXMLFromFlowXML(this.getFlowXML(flowDefId7)), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETFLOWTRIGGERID)) {
                        String flowDefId8 = inboundMsg.split(ARGSEPARATOR)[1];
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), this.getTriggerId(flowDefId8), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETFLOWID)) {
                        String flowId = "";
                        String flowDefId9 = inboundMsg.split(ARGSEPARATOR)[1];
                        flowId = this.getFlowId(flowDefId9);
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), String.valueOf(flowId), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETFLOWORCHCMD)) {
                        String command = this.getFlowOrchestratorCommand();
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), String.valueOf(command), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETTRIGGERCMD)) {
                        String command = this.getTriggerCommand();
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), String.valueOf(command), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETCRONTABPATH)) {
                        String path = this.getCronTabPath();
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), String.valueOf(path), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(SETSERVICEID)) {
                        String serviceId = inboundMsg.split(ARGSEPARATOR)[1];
                        if (this.isUseHA()) {
                            this.m_serviceId = serviceId;
                            MdObjectStore store = (MdObjectStore)this.m_sc.getObjectStore();
                            MetaUtilities.setProperty((Root)this.m_sc, "ServiceId", store.getFactory(), store, this.m_serviceId);
                            this.m_sc.updateMetadataAll();
                            jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                            continue;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), false, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(GETSGMGCONFIG)) {
                        jmsSupport.sendResponseToClient(jmsSupport.getStringQueue(), String.valueOf(this.sgmgConfigString), id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(SETSGMGCONFIG)) {
                        String[] tokens = inboundMsg.split(ARGSEPARATOR);
                        if (tokens.length >= 4) {
                            String user = tokens[1];
                            String pw = tokens[2];
                            String sgmgPath = tokens[3];
                            jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), this.configSGMGproperties(user, pw, sgmgPath, connTimeOut), id, property);
                            continue;
                        }
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), false, id, property);
                        continue;
                    }
                    if (inboundMsg.startsWith(DELSGMGCONFIG)) {
                        this.sgmgConfigString = "";
                        jmsSupport.sendResponseToClient(jmsSupport.getCheckQueue(), true, id, property);
                        continue;
                    }
                    LOGGER.debug("Unknown command: " + inboundMsg.split(ARGSEPARATOR)[0]);
                }
                catch (UncategorizedJmsException ue) {
                    LOGGER.debug("JMS Failure count" + ++jmsFailures);
                    LOGGER.debug(ue.toString());
                    if (jmsFailures >= 10) {
                        LOGGER.error(ue.toString());
                        LOGGER.debug("Re-initializing JMS service ...");
                        jmsSupport = new JMSServiceSupport(this.m_clientLogger, config);
                        jmsFailures = 0;
                        continue;
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    LOGGER.error(e.toString());
                }
            }
            LOGGER.debug("Client message 'exit' received. Server shutting down...");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    public String formatFlowDataForDat(String flowData) {
        return CLIHelper.normalizeSpace(flowData).replace("&quot;", "^^^");
    }

    public static String formatDatFlowForFlowInfo(String datFlow) {
        return datFlow.replace("\n", "").replace("^^^", "&quot;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean persistSASJFSProperties() {
        String properties = SASJFSProperties.toSerializedForm();
        boolean propertiesPersisted = false;
        BufferedWriter wr = (BufferedWriter)this.getFlowDefinitionWriter("", SASJFSPropertiesFile);
        if (wr != null) {
            try {
                if (!properties.isEmpty()) {
                    wr.append(properties);
                    wr.newLine();
                }
                propertiesPersisted = true;
            }
            catch (IOException e) {
                LOGGER.error("Error saving SGMG properties to DAV" + e.getMessage());
            }
            finally {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error saving SGMG properties to DAV" + e.getMessage());
                }
            }
        }
        return propertiesPersisted;
    }

    private boolean isUseHA() {
        try {
            if (this.m_sc == null) {
                this.m_sc = MetaUtilities.getSchedulerServer(this.m_schInfo, (MdStore)this.m_store, this.m_repos);
            }
            AssociationList properties = this.m_sc.getProperties(true);
            int propsize = properties.size();
            for (int i = 0; i < propsize; ++i) {
                Property property = (Property)properties.elementAt(i);
                if (!property.getPropertyName().equalsIgnoreCase("UseHA")) continue;
                return property.getDefaultValue().equalsIgnoreCase("1") || property.getDefaultValue().equalsIgnoreCase("true");
            }
        }
        catch (Exception e) {
            return this.m_schInfo.isUseHADataBinding();
        }
        return this.m_schInfo.isUseHADataBinding();
    }

    private boolean isScheduled(String flowId) {
        if (flowId == null || flowId.isEmpty()) {
            return false;
        }
        FilenameFilter emptyFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        };
        List<String> files = this.m_persistenceProvider.listFiles(FlowFolder, emptyFilter);
        for (String file : files) {
            String id;
            String flowXML = this.getFlowDef(FlowFolder, file);
            if (!flowXML.contains("xmlFlowDef") || !flowId.equals(id = this.getFlowDefId(flowXML))) continue;
            return true;
        }
        return false;
    }

    private void configureSASJFSPorperties() {
        SASJFSProperties prop = SASJFSProperties.getPropertiesFromString(this.getSASJFSProperties());
        maxFlowHistories = prop.getMaxFlowHistories();
        maxHistories = prop.getMaxHistories();
    }

    protected boolean killRunningJobs(String flowName, String user, String pw, int timeOut) {
        boolean rc = true;
        ArrayList<String> jobs = m_runningJobsforFlows.get(flowName);
        for (String jobId : jobs) {
            if (this.changeStateofRunningJobs(jobId, "canceled", user, pw, timeOut)) continue;
            rc = false;
        }
        return rc;
    }

    protected boolean changeStateofRunningJobs(String jobId, String command, String user, String pw, int timeOut) {
        boolean rc = false;
        String restApiPath = this.m_schInfo.getRestAPIPath();
        String procStatusUrl = "";
        if (restApiPath != null && !restApiPath.isEmpty()) {
            GridService grid = new GridService(restApiPath);
            procStatusUrl = GridService.getGridProcessesUrl() + "/" + jobId + "/state?value=" + command;
            LOGGER.info(String.format("Beginning status check for Job id: %s", jobId));
            try {
                Job job = grid.getJobStatus(procStatusUrl, new PasswordAuthentication(user, pw.toCharArray()), timeOut, timeOut);
                if (job.getProcessingInfo().getState() == command) {
                    rc = true;
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Error changing state of job for: " + procStatusUrl + e.getMessage());
            }
            catch (MalformedURLException e) {
                LOGGER.error("Error changing state of job for: " + procStatusUrl + e.getMessage());
            }
            catch (AuthenticationException e) {
                LOGGER.error("Error changing state of job for: " + procStatusUrl + e.getMessage());
            }
        }
        return rc;
    }

    protected Reader getFlowDefinitionReader(String folder, String fileName) {
        if (this.m_persistenceProvider == null) {
            return null;
        }
        return this.m_persistenceProvider.getReader(folder, fileName);
    }

    protected Writer getFlowDefinitionWriter(String folder, String fileName) {
        if (this.m_persistenceProvider == null) {
            return null;
        }
        return this.m_persistenceProvider.getWriter(folder, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Reader getFlowHistoryReader(String flow) {
        if (this.m_persistenceProvider == null) {
            Map<String, String> map = m_inMemoryHistoryHolder;
            synchronized (map) {
                String history = m_inMemoryHistoryHolder.get(flow);
                if (history == null) {
                    history = "";
                    m_inMemoryHistoryHolder.put(flow, history);
                }
                return new StringReader(history);
            }
        }
        return this.m_persistenceProvider.getReader(FlowFolder, flow);
    }

    public static String genFlowDefinitionId(String flowname, String userid) {
        if (userid != null && userid.trim().length() > 0 && !flowname.startsWith(userid + "_")) {
            flowname = userid + "_" + flowname;
        }
        return flowname;
    }

    private boolean configSGMGproperties(String user, String pw, String sgmgPath, int timeOUt) {
        boolean configured = false;
        GridService sgmgConfig = new GridService(sgmgPath);
        try {
            ResourceNames rsrcNames = sgmgConfig.getAllResources(new PasswordAuthentication(user, pw.toCharArray()), timeOUt, timeOUt);
            if (rsrcNames != null) {
                SGMGConfigurationUtilities sgmgConfg = new SGMGConfigurationUtilities();
                this.sgmgConfigString = sgmgConfg.toSerializedForm(rsrcNames);
                String[] splitString = this.sgmgConfigString.split(ARGSEPARATOR);
                if (splitString.length == 5) {
                    configured = true;
                }
            }
        }
        catch (SasPasswordEncodingException e) {
            LOGGER.error("Error retrieving SGMG properties for path: " + sgmgPath + e.getMessage());
            return configured;
        }
        catch (IOException e) {
            LOGGER.error("Error retrieving SGMG properties for path: " + sgmgPath + e.getMessage());
            return configured;
        }
        catch (AuthenticationException e) {
            LOGGER.error("Error retrieving SGMG properties for path: " + sgmgPath + e.getMessage());
            return configured;
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving SGMG properties for path: " + sgmgPath + e.getMessage());
            return configured;
        }
        return configured;
    }

    private String saveFlow(String flowname, String userid, String flowData) {
        return this.saveFlowXML(FlowFolder, flowData, JFSScheduleManager.genFlowDefinitionId(flowname, userid));
    }

    private String saveRunNowFlow(String flowname, String userid, String flowData) {
        return this.saveFlowXML(RunNowFlowFolder, flowData, JFSScheduleManager.genFlowDefinitionId(flowname, userid));
    }

    private String rescheduleFlowXML(String flowData, String flowDefId) {
        return this.saveFlowXML(FlowFolder, flowData, flowDefId);
    }

    private String saveFlowXML(String folder, String flowData, String flowDefId) {
        ArrayList<Object> flowDataRecords = new ArrayList();
        String fileName = "";
        try {
            fileName = String.format(FlowDefinitionFile, flowDefId);
            flowDataRecords = this.getFlowDatFileContents(folder, fileName);
        }
        catch (IOException e) {
            LOGGER.error("Error persisting FlowInfo: " + e.getMessage());
        }
        if (flowDataRecords.size() > 0) {
            flowDataRecords.set(0, flowData);
        } else {
            flowDataRecords.add(flowData);
        }
        this.persistFlowData(folder, fileName, flowDataRecords);
        return flowDefId;
    }

    private boolean deleteFlowXML(String flowDefId) {
        boolean delSchFlow = this.m_persistenceProvider.delete(FlowFolder, String.format(FlowDefinitionFile, flowDefId));
        boolean delRunNowFlow = this.m_persistenceProvider.delete(RunNowFlowFolder, String.format(FlowDefinitionFile, flowDefId));
        return delSchFlow || delRunNowFlow;
    }

    private String getRunNowFlowXML(String flowDefId) {
        return this.addSchSrvInfoToFlowXML(this.getFlowXML(RunNowFlowFolder, flowDefId));
    }

    private String getFlowXML(String flowDefId) {
        return this.addSchSrvInfoToFlowXML(this.getFlowXML(FlowFolder, flowDefId));
    }

    private String addSchSrvInfoToFlowXML(String flowXML) {
        String ssiId = this.getSchSrvInfoId(flowXML);
        if (!ssiId.isEmpty()) {
            try {
                SchedulerServerInfo ssi = new SchedulerServerInfo();
                ssi.setId(ssiId);
                Scheduler sch = MetaUtilities.getSchedulingServer(ssi, this.m_store);
                SchedulerServerInfo schSsi = sch.getServerComponent();
                flowXML = this.addSchSrvInfoToFlowXML(flowXML, schSsi);
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        }
        return flowXML;
    }

    private String getFlowId(String flowXML) {
        String flowXml = flowXML.split("<FlowDef")[1].split("Id=\\\"")[1].split("\"")[0];
        return flowXml;
    }

    private String getFlowDefId(String flowXML) {
        String flowXml = flowXML.split("<FlowDef")[1].split("FlowDefId=\\\"")[1].split("\"")[0];
        return flowXml;
    }

    private String getFlowXML(String folder, String flowDefId) {
        String flowData = null;
        if (this.m_persistenceProvider == null) {
            return flowData;
        }
        String message = MessageFormat.format(m_bundle.getString("JFSScheduleManager.loadFlowFromDav.Start.info.fmt"), this.m_persistenceProvider.getPath());
        LOGGER.info(message);
        long startTime = System.currentTimeMillis();
        flowData = this.getFlowDef(folder, String.format(FlowDefinitionFile, flowDefId));
        long endTime = System.currentTimeMillis();
        message = MessageFormat.format(m_bundle.getString("JFSScheduleManager.loadFlowFromDav.Finished.info.fmt"), endTime - startTime);
        LOGGER.info(message);
        return flowData;
    }

    private String addSchSrvInfoToFlowXML(String flowXML, SchedulerServerInfo ssi) throws SchedulerException {
        String[] schSplit = flowXML.split("<Scheduler");
        String flowInfo = schSplit[0] + "<" + "Scheduler" + " ";
        String[] schEndParamSplit = schSplit[1].split("/>");
        flowInfo = flowInfo + this.formatFlowDataForDat(SASJFSXMLFactory.generateSchedulerInfoXML(ssi));
        for (int i = 1; i < schEndParamSplit.length; ++i) {
            flowInfo = flowInfo + "/>";
            flowInfo = flowInfo + schEndParamSplit[i];
        }
        return flowInfo;
    }

    private String getSchSrvInfoId(String flowXML) {
        String[] schIdParamSplit;
        String[] schSplit = flowXML.split("<Scheduler");
        if (schSplit.length > 1 && (schIdParamSplit = schSplit[1].split(" Id=\"")).length > 1) {
            String[] schParamSplit = schIdParamSplit[1].split("\"");
            return schParamSplit[0];
        }
        return "";
    }

    private PasswordAuthentication getGridAuthorization(String user) {
        try {
            UserIdentityInterface uId = this.m_metadataUser.getAuthServer().generatePassword(user);
            String userId = (String)(uId != null ? uId.getPrincipal() : null);
            SealedString password = new SealedString(uId != null ? uId.getCredential().toString() : "");
            if (password != null) {
                MdFactory factory = this.mdFactorySupplier.getMdFactory();
                factory.setDebug(false);
                factory.setLoggingEnabled(false);
                factory.getUtil().setOutputStream((OutputStream)System.out);
                factory.getUtil().setLogStream((OutputStream)System.out);
                factory.makeOMRConnection(this.m_metahost, this.m_metaport, userId, String.valueOf(password.getCharacters()));
                String md_repos = null;
                List repositories = factory.getOMIUtil().getRepositories();
                for (int i = 0; i < repositories.size(); ++i) {
                    CMetadata repository = (CMetadata)repositories.get(i);
                    if (!repository.getName().equalsIgnoreCase("Foundation")) continue;
                    md_repos = repository.getId();
                }
                if (md_repos == null) {
                    md_repos = ((CMetadata)factory.getOMIUtil().getRepositories().get(0)).getId();
                }
                MdObjectStore md_store = factory.createObjectStore(null, "SASJFS_ScheduleManager");
                return MetaUtilities.getLoginIdentityForGrid(this.m_schInfo, user, (MdStore)md_store, md_repos);
            }
        }
        catch (SchedulerException e) {
            LOGGER.error(e.toString());
        }
        catch (ServiceException e) {
            LOGGER.error(e.toString());
        }
        catch (IllegalStateException e) {
            LOGGER.error(e.toString());
        }
        catch (RemoteException e) {
            LOGGER.error(e.toString());
        }
        catch (MdException e) {
            LOGGER.error(e.toString());
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return null;
    }

    private boolean setTriggerId(String flowDefId, String triggerId) {
        boolean isSaved = false;
        try {
            String flowXML = this.getFlowXML(flowDefId);
            if (flowXML != null) {
                String flowXMLWithTriggerId = this.addTriggerXMLToFlowXML(this.addTriggerIdToTriggerXML(this.getTriggerXMLFromFlowXML(flowXML), triggerId), flowXML);
                this.saveFlowXML(FlowFolder, flowXMLWithTriggerId, flowDefId);
                isSaved = true;
            }
        }
        catch (Exception e) {
            return isSaved;
        }
        return isSaved;
    }

    private String addTriggerXMLToFlowXML(String triggerXML, String flowXML) {
        String[] flowStrings = flowXML.split("<TriggerEvents");
        String[] triggerStrings = flowStrings[1].split("TriggerEvents>");
        return flowStrings[0] + triggerXML + triggerStrings[1];
    }

    private String getTriggerId(String flowDefId) {
        return this.getTriggerIdFromXML(this.getTriggerXMLFromFlowXML(this.getFlowXML(flowDefId)));
    }

    private String getTriggerXMLFromFlowXML(String flowXML) {
        String triggers = "<TriggerEvents";
        triggers = triggers + flowXML.split("TriggerEvents")[1];
        triggers = triggers + "TriggerEvents>";
        return triggers;
    }

    private String addTriggerIdToTriggerXML(String triggerXML, String triggerId) {
        String[] splitTrigger = triggerXML.split("Id=\\\"");
        String restOfString = splitTrigger[1];
        int index = restOfString.indexOf("\">");
        if (index > 0) {
            restOfString = restOfString.substring(index);
        } else {
            LOGGER.debug("TriggerID****:" + restOfString);
        }
        return splitTrigger[0] + "Id" + "=\"" + triggerId + restOfString;
    }

    private String getTriggerIdFromXML(String triggerXML) {
        return triggerXML.split("Id=\\\"")[1].split("\"")[0];
    }

    private boolean publishHistory(String flowDefId, String history) {
        ArrayList<Object> flowDataRecords = new ArrayList();
        String fileName = "";
        try {
            fileName = String.format(FlowDefinitionFile, flowDefId);
            flowDataRecords = this.getFlowDatFileContents(FlowFolder, fileName);
        }
        catch (IOException e) {
            LOGGER.error("Error persisting FlowHistory: " + e.getMessage());
        }
        if (flowDataRecords.isEmpty()) {
            flowDataRecords.add(0, " ");
            flowDataRecords.add(1, history);
        } else {
            flowDataRecords.add(1, history);
        }
        while (flowDataRecords.size() - 1 > maxFlowHistories) {
            SASJFSFlowHistory sasJFSHistory = new SASJFSFlowHistory(LOGGER);
            sasJFSHistory.initFromSerializedForm((String)flowDataRecords.get(maxFlowHistories));
            this.deleteJobHistory(String.valueOf(sasJFSHistory.getID()));
            flowDataRecords.remove(maxFlowHistories);
        }
        this.persistFlowData(FlowFolder, fileName, flowDataRecords);
        return true;
    }

    private boolean publishFlowHistory(String fileName, String instanceId) {
        ArrayList<Object> flowDataRecords = new ArrayList();
        String history = fileName + PARAMETERSEPARATOR + instanceId;
        try {
            flowDataRecords = this.getFlowDatFileContents("", FlowHistoryInstances);
        }
        catch (IOException e) {
            LOGGER.error("Error persisting FlowHistory: " + e.getMessage());
        }
        flowDataRecords.add(0, history);
        while (flowDataRecords.size() > maxHistories) {
            String[] attributes = ((String)flowDataRecords.get(maxHistories)).split(PARAMETERSEPARATOR);
            if (attributes.length == 2) {
                String HistoryFileName = attributes[0];
                String HistoryInstance = attributes[1];
                this.removeFlowHistoryInstanceFromFlow(HistoryFileName, HistoryInstance);
                this.deleteJobHistory(HistoryInstance);
                flowDataRecords.remove(maxHistories);
            }
            flowDataRecords.remove(maxHistories);
        }
        this.persistFlowData("", FlowHistoryInstances, flowDataRecords);
        return true;
    }

    private void removeFlowHistoryInstanceFromFlow(String fileName, String instanceId) {
        ArrayList<Object> flowDataRecords = new ArrayList();
        Long historyId = new Long(instanceId);
        try {
            flowDataRecords = this.getFlowDatFileContents(FlowFolder, fileName);
        }
        catch (IOException e) {
            LOGGER.error("Error removing FlowHistory instance: " + e.getMessage());
        }
        for (int i = flowDataRecords.size(); i > 1; --i) {
            SASJFSFlowHistory sasJFSHistory = new SASJFSFlowHistory(LOGGER);
            sasJFSHistory.initFromSerializedForm((String)flowDataRecords.get(i));
            if (sasJFSHistory.getID() != historyId.longValue()) continue;
            flowDataRecords.remove(i);
            this.persistFlowData(FlowFolder, fileName, flowDataRecords);
            return;
        }
    }

    private void deleteJobHistory(String flowInstanceId) {
        this.m_persistenceProvider.delete(FlowFolder, String.format(FlowInstanceFile, flowInstanceId));
    }

    private boolean persistJobHistory(String flowInstanceId, String sasJobHistory) {
        ArrayList<Object> flowDataRecords = new ArrayList();
        String fileName = "";
        try {
            fileName = String.format(FlowInstanceFile, flowInstanceId);
            flowDataRecords = this.getFlowDatFileContents(FlowFolder, fileName);
        }
        catch (IOException e) {
            LOGGER.error("Error persisting JobHistory: " + e.getMessage());
        }
        flowDataRecords.add(sasJobHistory);
        this.persistFlowData(FlowFolder, fileName, flowDataRecords);
        return true;
    }

    private void rebuildInstanceIndex() {
        List<String> historyStrings = this.getTopFlowHistoryFromFiles(this.getAllFlowFiles());
        try {
            for (String history : historyStrings) {
                SASJFSFlowHistory flowHistory = SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(history);
                if (!Pattern.compile(FlowDefinitionFile.replace("%s", ".*")).matcher(history).find()) continue;
                m_instanceLookup.put(history.split("_")[2], String.valueOf(flowHistory.getID()));
            }
        }
        catch (SchedulerException e) {
            LOGGER.error("SchedulerException: " + e.getMessage());
        }
    }

    private String searchIndexForHistoryInstance(String instanceId) {
        List<String> historyStrings = this.getAllFlowHistoriesFromFiles(this.getAllFlowFiles());
        try {
            for (String history : historyStrings) {
                SASJFSFlowHistory flowHistory = SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(history);
                m_cachedHistory.put(flowHistory.getID(), flowHistory.toString());
                if (new Long(instanceId).longValue() != flowHistory.getID()) continue;
                return flowHistory.toString();
            }
        }
        catch (SchedulerException e) {
            LOGGER.error("SchedulerException: " + e.getMessage());
        }
        return null;
    }

    private List<String> getAllFlowFiles() {
        FilenameFilter emptyFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        };
        return this.m_persistenceProvider.listFiles(FlowFolder, emptyFilter);
    }

    private List<String> getAllFlowHistoriesFromFiles(List<String> flowHistoryFiles) {
        ArrayList<String> flowHistory = new ArrayList<String>();
        for (String fileName : flowHistoryFiles) {
            try {
                flowHistory.addAll(this.getHistoryData(fileName));
            }
            catch (IOException e) {
                LOGGER.error("Error retrieving FlowHistory: " + e.getMessage());
            }
        }
        return flowHistory;
    }

    private List<String> getTopFlowHistoryFromFiles(List<String> flowHistoryFiles) {
        ArrayList<String> flowHistory = new ArrayList<String>();
        for (String fileName : flowHistoryFiles) {
            try {
                flowHistory.addAll(this.getHistoryData(fileName));
            }
            catch (IOException e) {
                LOGGER.error("Error persisting FlowHistory: " + e.getMessage());
            }
        }
        return flowHistory;
    }

    private boolean verifyFlowScheduled(String flowDefId) {
        return false;
    }

    private String getFlowOrchestratorCommand() {
        return this.m_schInfo.getFlowOrchestrationCommand();
    }

    private String getTriggerCommand() {
        return this.m_schInfo.getTriggerCommand();
    }

    private String getCronTabPath() {
        return this.m_schInfo.getOSCommandPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistFlowData(String folder, String fileName, ArrayList<String> flowRecords) {
        BufferedWriter wr = (BufferedWriter)this.getFlowDefinitionWriter(folder, fileName);
        if (wr != null) {
            try {
                for (int i = 0; i < flowRecords.size(); ++i) {
                    String entry = flowRecords.get(i);
                    if (entry.isEmpty()) continue;
                    wr.append(entry);
                    wr.newLine();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading FlowInfo: " + e.getMessage());
            }
            finally {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing Buffer Reader for FlowInfo: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFlowDef(String folder, String fileName) {
        StringBuffer buffer = new StringBuffer(200);
        BufferedReader br = (BufferedReader)this.getFlowDefinitionReader(folder, fileName);
        if (br != null) {
            try {
                String data = br.readLine();
                if (data == null) {
                    String string = null;
                    return string;
                }
                buffer.append(data);
            }
            catch (IOException e) {
                LOGGER.error("Error getting flowInfo: " + e.getMessage());
                String string = null;
                return string;
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing Buffer Reader for FlowInfo: " + e.getMessage());
                }
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getFlowDatFileContents(String folder, String fileName) throws IOException {
        ArrayList<String> flowDataLines = new ArrayList<String>();
        BufferedReader br = (BufferedReader)this.getFlowDefinitionReader(folder, fileName);
        if (br != null) {
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    flowDataLines.add(line);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading FlowInfo: " + e.getMessage());
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing Buffer Reader for FlowInfo: " + e.getMessage());
                }
            }
        }
        return flowDataLines;
    }

    private List<String> getHistoryData(String fileName) throws IOException {
        ArrayList<String> list = this.getFlowDatFileContents(FlowFolder, fileName);
        list.remove(0);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSASJFSProperties() {
        StringBuffer buffer = new StringBuffer(80);
        BufferedReader br = (BufferedReader)this.getFlowDefinitionReader("", SASJFSPropertiesFile);
        if (br != null) {
            try {
                String data = br.readLine();
                if (data == null) {
                    String string = null;
                    return string;
                }
                buffer.append(data);
            }
            catch (IOException e) {
                LOGGER.error("Error reading FlowInfo: " + e.getMessage());
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing Buffer Reader for FlowInfo: " + e.getMessage());
                }
            }
        }
        return buffer.toString();
    }

    private String getInstanceId(String flowDefId) {
        String instanceId = m_instanceLookup.get(flowDefId);
        if (instanceId == null) {
            instanceId = this.getInstanceId(flowDefId);
        }
        return instanceId;
    }

    private String getHistoryOfInstance(String instanceId) {
        String history = m_cachedHistory.get(new Long(instanceId));
        return history == null ? this.searchIndexForHistoryInstance(instanceId) : history;
    }

    private String getScheduledTriggers() {
        StringBuffer scheduledTriggersBuffer = new StringBuffer();
        for (String file : this.getUserFlowFiles("")) {
            String flowXML = this.getFlowDef(FlowFolder, file);
            if (!flowXML.contains("xmlFlowDef")) continue;
            String flowDefId = file.substring(FlowFolderPrefix.length(), file.indexOf(".dat"));
            String string = this.getTriggerXMLFromFlowXML(flowXML);
        }
        return scheduledTriggersBuffer.toString();
    }

    private String getScheduledFlows(String userId) {
        StringBuffer scheduledFlowsBuffer = new StringBuffer();
        List<String> files = userId.equals(this.m_serviceId) ? this.getAllFlowFiles() : this.getUserFlowFiles(userId);
        for (String file : files) {
            String flowXML = this.addSchSrvInfoToFlowXML(this.getFlowDef(FlowFolder, file));
            if (!flowXML.contains("xmlFlowDef")) continue;
            scheduledFlowsBuffer.append(flowXML);
            scheduledFlowsBuffer.append(PARAMETERSEPARATOR);
        }
        return scheduledFlowsBuffer.toString();
    }

    private List<String> getUserFlowFiles(String userId) {
        final String prefix = FlowFolderPrefix + userId;
        FilenameFilter userFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }
        };
        return this.m_persistenceProvider.listFiles(FlowFolder, userFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowHistory[] getFlowHistory(HistorySearchOptions options) {
        ArrayList<SASJFSFlowHistory> results = new ArrayList<SASJFSFlowHistory>();
        ArrayList<String> flowsToQuery = new ArrayList<String>();
        ArrayList<SASJFSFlowHistory> capturedHistory = new ArrayList<SASJFSFlowHistory>();
        JFSScheduleManager jFSScheduleManager = this;
        synchronized (jFSScheduleManager) {
            HashSet<String> flowsOfInterest = new HashSet<String>();
            if (options.getFlowIDs().size() == 0) {
                flowsOfInterest.addAll(m_allFlows.keySet());
            }
            for (String flowID : flowsOfInterest) {
                String aFlow = m_allFlows.get(flowID);
                try {
                    if (!flowsOfInterest.contains(SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(aFlow).getFlowID()) || options.getUser().length() != 0 && !options.getUser().equals(SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(aFlow).getInvoker())) continue;
                    flowsToQuery.add(SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(aFlow).getFlowID());
                }
                catch (SchedulerException e) {
                    LOGGER.error("Scheduler Exception: " + e.getMessage());
                }
            }
            if (options.getCompletionStatusMask() == 8) {
                for (String rFlow : m_runningFlows.values()) {
                    try {
                        capturedHistory.add(SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(rFlow));
                    }
                    catch (SchedulerException e) {
                        LOGGER.error("Scheduler Exception: " + e.getMessage());
                    }
                }
            }
        }
        if (options.getCompletionStatusMask() != 8) {
            SASJFSFlowHistory[] histories = this.getFlowHistories(options.getUser(), flowsToQuery.toArray(new String[0]), 0);
            capturedHistory.addAll(Arrays.asList(histories));
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (SASJFSFlowHistory record : capturedHistory) {
            if (options.getStartTime() != null) {
                // empty if block
            }
            if (options.getEndTime() != null) {
                // empty if block
            }
            if (options.getCompletionStatusMask() != 0) {
                // empty if block
            }
            if (options.getCountPerFlow() > 0) {
                String flowID;
                flowID = record.getFlowID();
                Integer currentCount = (Integer)countMap.get(flowID);
                if (currentCount == null) {
                    currentCount = new Integer(0);
                }
                if (currentCount >= options.getCountPerFlow()) continue;
                countMap.put(flowID, new Integer(currentCount + 1));
            }
            results.add(record);
        }
        return results.toArray(new FlowHistory[0]);
    }

    private String getUsernameNotBackSlashDataBinding(String user) {
        String[] splitUser;
        String separator = "\\";
        if (user.contains(separator) && (splitUser = user.split(Pattern.quote(separator))).length == 2) {
            return splitUser[1] + "@" + splitUser[0];
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SASJFSFlowHistory[] getFlowHistories(String user, String[] flowIDs, int countPerFlow) {
        List<Object> resultHistories = new ArrayList();
        ArrayList<SASJFSFlowHistory> runningFlowHistories = new ArrayList<SASJFSFlowHistory>();
        HashMap<String, Integer> historyRequestMap = new HashMap<String, Integer>();
        JFSScheduleManager jFSScheduleManager = this;
        synchronized (jFSScheduleManager) {
            if (countPerFlow < 0) {
                return resultHistories.toArray(new SASJFSFlowHistory[0]);
            }
            HashSet<String> flowSearchIDs = new HashSet<String>();
            for (int i = 0; i < flowIDs.length; ++i) {
                flowSearchIDs.add(flowIDs[i]);
            }
            for (String flow : m_runningFlows.values()) {
                try {
                    Integer currentRemaining;
                    SASJFSFlowHistory flowHistory = SASJFSXMLFactory.initSASJFSFlowHistoryFromRecord(flow);
                    if (!flowSearchIDs.contains(String.valueOf(flowHistory.getID())) || !flowHistory.getOwner().equals(user) || (currentRemaining = (Integer)historyRequestMap.get(flow)) != null && currentRemaining <= 0) continue;
                    runningFlowHistories.add(flowHistory);
                    if (currentRemaining == null) {
                        if (countPerFlow == 0) continue;
                        historyRequestMap.put(flow, new Integer(countPerFlow - 1));
                        continue;
                    }
                    historyRequestMap.put(flow, new Integer(currentRemaining - 1));
                }
                catch (SchedulerException e) {
                    LOGGER.error("Scheduler Exception: " + e.getMessage());
                }
            }
            for (int i = 0; i < flowIDs.length; ++i) {
                String flow;
                flow = m_allFlows.get(flowIDs[i]);
                if (flow == null) continue;
                Integer currentRemaining = (Integer)historyRequestMap.get(flow);
                if (currentRemaining == null) {
                    historyRequestMap.put(flow, new Integer(countPerFlow));
                    continue;
                }
                if (currentRemaining > 0) continue;
                historyRequestMap.remove(flow);
            }
        }
        try {
            resultHistories = this.getFlowHistory(historyRequestMap, user);
        }
        catch (RuntimeException e) {
            this.getLogger().logMessage(Level.WARNING, e);
        }
        ArrayList<SASJFSFlowHistory> finalFlowHistories = new ArrayList<SASJFSFlowHistory>();
        runningFlowHistories.addAll(resultHistories);
        HashSet<String> instanceIDs = new HashSet<String>();
        for (SASJFSFlowHistory history : runningFlowHistories) {
            if (instanceIDs.contains(String.valueOf(history.getID()))) continue;
            instanceIDs.add(history.getFlowID());
            finalFlowHistories.add(history);
        }
        return finalFlowHistories.toArray(new SASJFSFlowHistory[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SASJFSFlowHistory> getFlowHistory(Map<String, Integer> historyRequestMap, String user) {
        ArrayList<SASJFSFlowHistory> results = new ArrayList<SASJFSFlowHistory>();
        try {
            for (Map.Entry<String, Integer> entry : historyRequestMap.entrySet()) {
                int count;
                String flow = entry.getKey();
                int workingCount = count = entry.getValue().intValue();
                Object sync = SyncManager.getInstance().getSyncObject(flow);
                try {
                    Object object = sync;
                    synchronized (object) {
                        Reader aReader = this.getFlowHistoryReader(flow);
                        if (aReader != null) {
                            BufferedReader reader = new BufferedReader(aReader);
                            try {
                                List<SASJFSFlowHistory> tempResultHistories = SASJFSFlowHistory.GetHistoriesOfFlow(reader, flow, 0, this.m_clientLogger);
                                Iterator<SASJFSFlowHistory> iterator = tempResultHistories.iterator();
                                while (iterator.hasNext()) {
                                    if (count > 0 && workingCount <= 0) {
                                    }
                                    SASJFSFlowHistory history = iterator.next();
                                    results.add(history);
                                    --workingCount;
                                }
                            }
                            catch (Exception e) {
                                this.m_clientLogger.logMessage(Level.WARNING, e);
                            }
                            finally {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    this.m_clientLogger.logMessage(Level.WARNING, e);
                                }
                            }
                        } else {
                            String message = MessageFormat.format(m_bundle.getString("JFSScheduleManager.History.NoReaderFound.fmt"), flow);
                            this.m_clientLogger.logMessage(Level.FINE, message);
                        }
                    }
                }
                finally {
                    SyncManager.getInstance().releaseSyncObject(flow);
                }
            }
        }
        catch (Exception e) {
            this.m_clientLogger.logMessage(Level.WARNING, e);
        }
        return results;
    }

    private void buildFileEventCaches() {
    }

    private boolean checkNewFlow(String defId, String scheduleFlowXML) {
        return false;
    }

    private boolean checkUpdateFlow(String defId, String rescheduleFlowXML) {
        return false;
    }

    private boolean checkDeletedFlow(String defId) {
        return false;
    }

    private void launchFileChecker() {
        this.m_FileEventThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception ex = null;
                try {
                    while (true) {
                        Thread.sleep(30000L);
                    }
                }
                catch (InterruptedException e) {
                    ex = e;
                }
                catch (RuntimeException e) {
                    ex = e;
                }
                if (ex != null) {
                    LOGGER.error((Object)ex);
                }
            }
        }, "launchFileChecker-thread");
        this.m_FileEventThread.start();
    }

    private byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static class MdFactorySupplier {
        public MdFactory getMdFactory() throws RemoteException, MdException {
            return new MdFactoryImpl();
        }
    }
}

