/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.engine;

import com.sas.scheduler.api.servers.sasjfs.engine.ClientLogger;
import com.sas.scheduler.api.servers.sasjfs.engine.DAVOutputStream;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.IPersistenceProvider;
import com.sas.svcs.content.document.client.Document;
import com.sas.svcs.content.document.client.DocumentService;
import com.sas.svcs.content.folder.client.Folder;
import com.sas.svcs.content.folder.client.FolderService;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.navigation.client.NavigationService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class DAVPersistence
implements IPersistenceProvider {
    private ClientLogger mLogger;
    private Folder mRootFolder;
    private DocumentService mDocumentContentService;
    private FolderService mFolderContentService;
    private NavigationService mNavigationContentService;
    private static final String SASJFSROOT_FOLDER = "/sascontent/System/Applications/SAS Scheduler/SASJFSRoot";

    public DAVPersistence(DocumentService documentContentService, FolderService folderContentService, NavigationService navigationContentService, ClientLogger logger, String uniqueServerAreaName) throws IllegalStateException {
        this.mLogger = logger;
        this.mDocumentContentService = documentContentService;
        this.mFolderContentService = folderContentService;
        this.mNavigationContentService = navigationContentService;
        int MAX_TRIES = 60;
        int SLEEP_TIME = 30;
        int LOG_MESSAGE_PER_TRIES = 4;
        int retryCount = 0;
        boolean success = false;
        while (true) {
            block8: {
                try {
                    Folder baseFolder = this.mFolderContentService.getFolderByPath(SASJFSROOT_FOLDER, 79L);
                    this.mRootFolder = this.ensureFolderExists(baseFolder, uniqueServerAreaName);
                    if (this.mRootFolder.getPath().contains(uniqueServerAreaName)) {
                        success = true;
                        break;
                    }
                    if (++retryCount > MAX_TRIES) {
                        break;
                    }
                }
                catch (Exception e) {
                    if (++retryCount <= MAX_TRIES) break block8;
                    throw new IllegalStateException(e);
                }
            }
            try {
                Thread.sleep(SLEEP_TIME * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (retryCount % LOG_MESSAGE_PER_TRIES != 0) continue;
            this.mLogger.logMessage(Level.INFO, "Have received " + retryCount + " failures attempting to initialize DAV folders for Distributed-IP scheduler.");
        }
        if (!success) {
            throw new IllegalStateException("Failed in all attempts to initialize DAV folders for Distributed-IP scheduler.");
        }
        this.mLogger.logMessage(Level.INFO, "Successfully initialized DAV folders for Distributed-IP scheduler.");
    }

    private Folder ensureFolderExists(Folder startFolder, String dirPath) {
        try {
            Folder folder = this.mFolderContentService.getFolderByPath(startFolder.getPath() + "/" + dirPath, 79L);
            if (folder != null) {
                return folder;
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.INFO, e);
        }
        String[] segments = dirPath.split("/");
        Folder parent = startFolder;
        try {
            for (int i = 0; i < segments.length; ++i) {
                String segment = segments[i].trim();
                if (segment.length() == 0) continue;
                Folder testFolder = null;
                try {
                    testFolder = this.mFolderContentService.getFolderByPath(parent.getPath() + "/" + segment, 79L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                parent = testFolder == null ? this.mFolderContentService.createFolder(parent, segment, "") : testFolder;
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.INFO, e);
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addData(String baseDir, String fileName, byte[] data) {
        FilterOutputStream bos = null;
        try {
            Folder parent = this.createFolder(baseDir, fileName);
            String localFileName = this.getNameFromPath(fileName);
            Document doc = this.mDocumentContentService.getDocumentByPath(parent.getPath() + "/" + localFileName);
            DAVOutputStream os = null;
            if (doc == null) {
                doc = new Document();
                doc.setContentStream(new byte[0]);
                doc.setAuthor("SASJFS");
                doc.setContentType("text");
                doc.setDescription("");
                doc.setName(localFileName);
                doc = this.mDocumentContentService.createDocument(parent, doc);
                os = new DAVOutputStream(this.mDocumentContentService, doc, this.mLogger);
            } else {
                byte[] savedBytes = doc.getContentStream();
                os = new DAVOutputStream(this.mDocumentContentService, doc, this.mLogger);
                os.write(savedBytes);
            }
            os.write(data);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }
    }

    private String generateDirPath(String dir, String fileName) {
        int lastSlash = fileName.lastIndexOf(47);
        if (lastSlash > 0) {
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            dir = dir + fileName.substring(0, lastSlash);
            fileName = fileName.substring(lastSlash + 1);
        }
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        return dir;
    }

    private Folder createFolder(String dir, String fileName) {
        dir = this.generateDirPath(dir, fileName);
        return this.ensureFolderExists(this.mRootFolder, dir);
    }

    private String combineSegments(String dir, String fileName) {
        String result = dir;
        if (result.length() > 0 && !result.endsWith("/")) {
            result = result + "/";
        }
        result = result + fileName;
        return result;
    }

    @Override
    public boolean delete(String dir, String fileName) {
        try {
            Document doc = this.mDocumentContentService.getDocumentByPath(this.mRootFolder.getPath() + "/" + this.combineSegments(dir, fileName));
            if (doc != null) {
                this.mDocumentContentService.deleteDocument(doc);
                return true;
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        return false;
    }

    @Override
    public void deleteDir(String startDir, String subDir) {
        try {
            Folder targetDir = this.mFolderContentService.getFolderByPath(this.mRootFolder.getPath() + "/" + this.combineSegments(startDir, subDir), 79L);
            if (targetDir != null) {
                this.deleteTree(targetDir);
                this.mFolderContentService.deleteFolder(targetDir);
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
    }

    private void deleteTree(Folder root) {
        try {
            ContainerNode targetDir = (ContainerNode)this.mNavigationContentService.getObjectByPath(root.getPath(), 79L);
            List children = this.mNavigationContentService.getChildren(targetDir);
            for (NavigationNode node : children) {
                if (node.getContentObject().getObjectType() == 79L) {
                    Folder childFolder = this.mFolderContentService.getFolderByPath(node.getNavigationPath(), 79L);
                    this.deleteTree(childFolder);
                    this.mFolderContentService.deleteFolder(childFolder);
                    continue;
                }
                Document doc = this.mDocumentContentService.getDocumentByPath(node.getNavigationPath());
                this.mDocumentContentService.deleteDocument(doc);
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getData(String relativePath, String fileName, long fileIndex, int maxChars, StringBuffer outputBuffer) {
        BufferedReader br = null;
        try {
            Document doc = this.mDocumentContentService.getDocumentByPath(this.combineSegments(this.mRootFolder.getPath() + "/" + relativePath, fileName));
            if (doc == null) {
                this.mLogger.logMessage(Level.FINER, "No job output at: " + relativePath + fileName);
                int n = -1;
                return n;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(doc.getContentStream());
            br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            br.skip(fileIndex);
            CharBuffer target = CharBuffer.allocate(maxChars);
            int charsRead = br.read(target);
            target.flip();
            outputBuffer.append(target.toString());
            int n = charsRead;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return -1;
    }

    @Override
    public String getPath() {
        try {
            return this.mRootFolder.getPath();
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
            return "Unknown path";
        }
    }

    @Override
    public Reader getReader(String dir, String fileName) {
        try {
            Document doc = this.mDocumentContentService.getDocumentByPath(this.mRootFolder.getPath() + "/" + this.combineSegments(dir, fileName));
            if (doc != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(doc.getContentStream());
                InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
                return new BufferedReader(isr);
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        return null;
    }

    @Override
    public Writer getWriter(String dir, String fileName) {
        try {
            Folder parent = this.createFolder(dir, fileName);
            String localFileName = this.getNameFromPath(fileName);
            Document doc = this.mDocumentContentService.getDocumentByPath(parent.getPath() + "/" + localFileName);
            if (doc == null) {
                doc = new Document();
                doc.setContentStream(new byte[0]);
                doc.setAuthor("SASJFS");
                doc.setContentType("text");
                doc.setDescription("");
                doc.setName(localFileName);
                doc = this.mDocumentContentService.createDocument(parent, doc);
            }
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new DAVOutputStream(this.mDocumentContentService, doc, this.mLogger), "UTF-8"));
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
            return null;
        }
    }

    @Override
    public List<String> listFiles(String startDir, FilenameFilter nameFilter) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            ContainerNode targetDir = (ContainerNode)this.mNavigationContentService.getObjectByPath(this.mRootFolder.getPath() + "/" + startDir, 79L);
            if (targetDir != null) {
                List children = this.mNavigationContentService.getChildren(targetDir);
                for (NavigationNode child : children) {
                    String fileName = this.getNameFromPath(child.getNavigationPath());
                    if (!nameFilter.accept(new File(""), fileName)) continue;
                    results.add(fileName);
                }
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.INFO, e);
        }
        return results;
    }

    private String getNameFromPath(String navigationPath) {
        String fileName = navigationPath;
        int index = navigationPath.lastIndexOf("/");
        if (index >= 0) {
            fileName = navigationPath.substring(index + 1);
        }
        return fileName;
    }

    @Override
    public boolean rename(String startDir, String fileName, String newFileName) {
        try {
            Document doc = this.mDocumentContentService.getDocumentByPath(this.mRootFolder.getPath() + "/" + this.combineSegments(startDir, fileName));
            if (doc != null) {
                doc.setName(newFileName);
                Document newDoc = this.mDocumentContentService.updateDocument(doc);
                return newDoc != null;
            }
            return false;
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
            return false;
        }
    }

    @Override
    public boolean isAppendSupported() {
        return false;
    }
}

