/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq;

import com.sas.entities.GUID;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.ExecutionContext;
import com.sas.scheduler.api.servers.ip.engine.ExecutionProviderBase;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.IPUtilities;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.MasterServer;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlowIDInfo;
import com.sas.scheduler.api.servers.ip.engine.UserInfo;
import com.sas.scheduler.api.servers.ip.engine.jgroups.ResponseHolder;
import com.sas.scheduler.api.servers.ip.engine.mq.JMSExecutionProvider;
import com.sas.scheduler.api.servers.ip.engine.mq.JMSMasterServer;
import com.sas.scheduler.api.servers.ip.engine.mq.OutputHolder;
import com.sas.scheduler.api.servers.ip.engine.mq.Utilities;
import com.sas.scheduler.api.servers.ip.engine.threadpool.ThreadPool;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class JMSClusterSupport
extends ClusterSupport {
    public static final String Topic_Cluster = "jms/scheduler.pip.clusterTopic";
    public static final String Queue_ClusterRequest = "jms/scheduler.pip.clusterRequestQueue";
    public static final String Queue_ClusterResponse = "jms/scheduler.pip.clusterResponseQueue";
    public static final String Op_StartFindMaster = "Op_StartFindMaster";
    public static final String Op_NodeInfo = "Op_NodeInfo";
    public static final String Op_MasterPing = "Op_MasterPing";
    public static final String Op_MasterSharedData = "Op_MasterSharedData";
    public static final String Cluster_Master_Wait_Key = "sas.dip.MasterWaitTimeMS";
    public static final String Cluster_Timeout_Key = "sas.dip.ClusterTimeoutMS";
    protected boolean mIsEligibleMaster;
    protected static final String MasterKey = "MasterKey";
    protected static final String SessionKey = "SessionKey";
    protected static final String UserKey = "UserKey";
    protected volatile boolean mIsMaster;
    private JmsTemplate mRequestQueue;
    private JmsTemplate mResponseQueue;
    protected JmsTemplate mClusterTopic;
    protected TopicConnection mTopicConnection;
    protected TopicSession mTopicSession;
    protected TopicPublisher mClusterTopicProducer;
    protected DefaultMessageListenerContainer mClusterTopicConsumer;
    protected ConnectionFactory mTopicFactory;
    protected ConnectionFactory mQueueFactory;
    protected Thread mMasterServiceThread;
    protected Thread mResponseThread;
    protected String mClusterID;
    protected boolean mShuttingDown = false;
    protected String mNodeID;
    private Properties mConfiguration;
    protected long mServerStartTime;
    protected long mClusterTimeout = 25000L;
    protected long mMasterWaitTime = 8000L;
    protected TimerTask mMasterDelayTask;
    protected TimerTask mMasterAliveTask;
    protected TimerTask mMasterPingTask;
    protected Timer mUtilityTimer;
    public static final Object GlobalJMSSyncObject = new Object();
    protected Map<String, ResponseHolder> mResponderMap;
    protected Map<String, String> mSessionMap;
    protected Map<String, String> mUserMap;
    protected String mEarliestMasterName = null;
    protected long mEarliestMasterTime = Long.MAX_VALUE;
    protected boolean mDeterminingMaster = false;

    public JMSClusterSupport(Properties configuration, String clusterName, boolean canBeMaster) {
        this.mIsEligibleMaster = canBeMaster;
        this.mConfiguration = configuration;
        this.mNodeID = GUID.newGUID();
        this.mServerStartTime = System.currentTimeMillis();
        this.mIsMaster = false;
        this.mClusterID = clusterName;
        this.mResponderMap = new HashMap<String, ResponseHolder>();
        this.mUtilityTimer = new Timer();
        long value = 8000L;
        if (System.getProperty("sas.dip.RecoverOnTimerFailure") != null) {
            value = 16000L;
        }
        this.setMasterWaitTimeout(IPUtilities.getLongValue(System.getProperties(), Cluster_Master_Wait_Key, value, this.getLogger()));
        this.getLogger().logMessage(Level.FINE, "MasterWaitTimeout: " + this.mMasterWaitTime);
        this.setClusterTimeout(IPUtilities.getLongValue(System.getProperties(), Cluster_Timeout_Key, 25000L, this.getLogger()));
        this.getLogger().logMessage(Level.FINE, "ClusterTimeout: " + this.mClusterTimeout);
    }

    public String getNodeID() {
        return this.mNodeID;
    }

    public String getClusterID() {
        return this.mClusterID;
    }

    @Override
    protected void setManager(FlowManager manager) {
        super.setManager(manager);
        this.getLogger().logMessage(Level.FINE, "DIP: JMS Cluster node initializing id: " + this.getNodeID() + " in cluster: " + this.getClusterID());
        this.initialize();
    }

    protected void initJMS(int attempts) {
        if (attempts <= 0) {
            attempts = 1;
        }
        int SLEEP_TIME = 30;
        int LOG_MESSAGE_PER_TRIES = 4;
        int retryCount = 0;
        while (true) {
            block10: {
                try {
                    this.cleanupJMSObjects();
                    this.mIsMaster = false;
                    InitialContext jmsContext = this.initJMSContext();
                    this.mRequestQueue = new JmsTemplate(this.mQueueFactory);
                    JMSExecutionProvider.configureQueue(jmsContext, this.mRequestQueue, Queue_ClusterRequest, this.getLogger());
                    this.mRequestQueue.setReceiveTimeout(5000L);
                    this.mRequestQueue.setTimeToLive(1800000L);
                    this.mRequestQueue.setExplicitQosEnabled(true);
                    this.mRequestQueue.setDeliveryMode(1);
                    this.mResponseQueue = new JmsTemplate(this.mQueueFactory);
                    JMSExecutionProvider.configureQueue(jmsContext, this.mResponseQueue, Queue_ClusterResponse, this.getLogger());
                    this.mResponseQueue.setReceiveTimeout(5000L);
                    this.mResponseQueue.setTimeToLive(1800000L);
                    this.mResponseQueue.setExplicitQosEnabled(true);
                    this.mResponseQueue.setDeliveryMode(1);
                    this.initJMSTopic(jmsContext);
                    break;
                }
                catch (NamingException e) {
                    if (++retryCount > attempts) {
                        throw new IllegalStateException("Failed to lookup required JMS objects in JNDI.", e);
                    }
                }
                catch (JMSException e) {
                    if (++retryCount > attempts) {
                        throw new IllegalStateException("Failed to initialize required JMS objects.", e);
                    }
                }
                catch (IllegalStateException e) {
                    if (++retryCount <= attempts) break block10;
                    throw e;
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (retryCount % 4 != 0) continue;
            this.getLogger().logMessage(Level.INFO, "Have received " + retryCount + " failures attempting to initialize required JMS objects for Distributed-IP scheduler.");
        }
        this.getLogger().logMessage(Level.INFO, "Successfully initialized required JMS objects for Distributed-IP scheduler (cluster support).");
    }

    private InitialContext initJMSContext() throws NamingException {
        InitialContext jmsContext = JMSExecutionProvider.initializeJMSContext(this.mConfiguration);
        this.mQueueFactory = JMSExecutionProvider.getFactory(jmsContext, "jms/QueueConnectionFactory", JMSExecutionProvider.Queue_Factory_Simple);
        this.mTopicFactory = JMSExecutionProvider.getFactory(jmsContext, "jms/TopicConnectionFactory", JMSExecutionProvider.Topic_Factory_Simple);
        if (JMSExecutionProvider.areCredentialsProvided(this.mConfiguration)) {
            this.mQueueFactory = JMSExecutionProvider.configureSecurity(this.mQueueFactory, this.mConfiguration);
            this.mTopicFactory = JMSExecutionProvider.configureSecurity(this.mTopicFactory, this.mConfiguration);
        }
        return jmsContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initJMSTopic(InitialContext jmsContext) throws JMSException, NamingException {
        Object object = GlobalJMSSyncObject;
        synchronized (object) {
            if (this.mTopicSession != null) {
                try {
                    MapMessage tempMessage = this.mTopicSession.createMapMessage();
                    return;
                }
                catch (Exception tempMessage) {
                    // empty catch block
                }
            }
            this.cleanupJMSTopic();
            if (this.mIsEligibleMaster) {
                this.mTopicConnection = (TopicConnection)this.mTopicFactory.createConnection();
                if (this.mTopicConnection == null) {
                    throw new IllegalStateException("Failed to create JMS topic connection.");
                }
                this.mClusterTopic = new JmsTemplate(this.mTopicFactory);
                this.mTopicSession = this.mTopicConnection.createTopicSession(false, 1);
                if (this.mTopicSession == null) {
                    throw new IllegalStateException("Failed to create JMS topic session.");
                }
                Topic broadcastTopic = JMSExecutionProvider.configureTopic(jmsContext, this.mClusterTopic, this.mTopicSession, Topic_Cluster, this.getLogger());
                this.mClusterTopicProducer = this.mTopicSession.createPublisher(broadcastTopic);
                if (this.mClusterTopicProducer == null) {
                    throw new IllegalStateException("Failed to create broadcast JMS topic publisher.");
                }
                this.mClusterTopicProducer.setTimeToLive(600000L);
                this.mClusterTopicProducer.setDeliveryMode(1);
                TopicSession consumerSession = this.mTopicConnection.createTopicSession(false, 1);
                if (consumerSession == null) {
                    throw new IllegalStateException("Failed to create JMS topic session.");
                }
                Topic broadcastTopic2 = JMSExecutionProvider.configureTopic(jmsContext, this.mClusterTopic, consumerSession, Topic_Cluster, this.getLogger());
                this.mClusterTopicConsumer = new DefaultMessageListenerContainer();
                this.mClusterTopicConsumer.setConnectionFactory(this.mTopicFactory);
                this.mClusterTopicConsumer.setDestination((Destination)broadcastTopic2);
                this.mClusterTopicConsumer.setMessageListener((Object)new MessageListener(){

                    public void onMessage(Message msg) {
                        JMSClusterSupport.this.processBroadcastMessage(msg);
                    }
                });
                this.mClusterTopicConsumer.afterPropertiesSet();
                this.mClusterTopicConsumer.start();
                this.mTopicConnection.start();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanupJMSTopic() {
        Object object = GlobalJMSSyncObject;
        synchronized (object) {
            try {
                if (this.mTopicConnection != null) {
                    this.mTopicConnection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mTopicSession != null) {
                    this.mTopicSession.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mClusterTopicProducer != null) {
                    this.mClusterTopicProducer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mClusterTopicConsumer != null) {
                    this.mClusterTopicConsumer.stop();
                    this.mClusterTopicConsumer.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mClusterTopicConsumer = null;
            this.mTopicConnection = null;
            this.mClusterTopicProducer = null;
            this.mClusterTopic = null;
            this.mTopicSession = null;
        }
    }

    private synchronized void cleanupJMSObjects() {
        this.cleanupJMSTopic();
        this.mRequestQueue = null;
        this.mResponseQueue = null;
        this.mTopicFactory = null;
        this.mQueueFactory = null;
    }

    protected void initialize() {
        this.initJMS(60);
        if (this.mIsEligibleMaster) {
            try {
                this.startMasterDetermination();
            }
            catch (Exception e) {
                this.getLogger().logMessage(Level.WARNING, e);
            }
        }
        this.createResponseThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMasterDetermination() throws JMSException, NamingException {
        JMSClusterSupport jMSClusterSupport = this;
        synchronized (jMSClusterSupport) {
            if (this.mDeterminingMaster) {
                this.getLogger().logMessage(Level.FINE, "Canceling start master determination; already in progress: " + this.mClusterID + ":" + this.mNodeID);
                return;
            }
            this.mEarliestMasterName = null;
            this.mEarliestMasterTime = Long.MAX_VALUE;
        }
        try {
            this.getLogger().logMessage(Level.FINE, "Starting to determine master: " + this.mClusterID + ":" + this.mNodeID);
            jMSClusterSupport = this;
            synchronized (jMSClusterSupport) {
                MapMessage startMessage = this.safeCreateMapMessage();
                startMessage.setStringProperty("operation", Op_StartFindMaster);
                startMessage.setStringProperty("CallbackServer", this.mClusterID);
                startMessage.setLongProperty("mainData", System.currentTimeMillis());
                this.mClusterTopicProducer.publish((Message)startMessage);
            }
        }
        finally {
            this.getUtilityTimer().schedule(this.createMasterDeadTask(), this.mClusterTimeout);
        }
    }

    protected Timer getUtilityTimer() {
        return this.mUtilityTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishMasterDetermination() {
        FlowManager flowManager = this.getManager();
        synchronized (flowManager) {
            this.mDeterminingMaster = false;
            this.getLogger().logMessage(Level.FINE, "finishMasterDetermination(). mDeterminingMaster set to false: mNodeID" + this.mNodeID);
            this.becomeMaster(true);
            if (!this.isMasterServer()) {
                this.getLogger().logMessage(Level.FINE, "This node is not the master (Master Determination): " + this.mClusterID + ":" + this.mNodeID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBroadcastMessage(Message msg) {
        block31: {
            JMSClusterSupport jMSClusterSupport = this;
            synchronized (jMSClusterSupport) {
                if (this.mShuttingDown) {
                    this.getLogger().logMessage(Level.FINE, "Shutting down: " + this.mClusterID + ":" + this.mNodeID);
                    return;
                }
            }
            try {
                String pipServer = msg.getStringProperty("CallbackServer");
                this.getLogger().logMessage(Level.FINE, "JMSExecutionProvider.Tag_CallbackServer: " + pipServer);
                if (!this.mClusterID.equals(pipServer)) {
                    return;
                }
                String opName = msg.getStringProperty("operation");
                this.getLogger().logMessage(Level.FINE, "JMSMasterServer.Tag_Operation: " + opName);
                if (opName.equals(Op_StartFindMaster)) {
                    JMSClusterSupport jMSClusterSupport2 = this;
                    synchronized (jMSClusterSupport2) {
                        if (this.mDeterminingMaster) {
                            this.getLogger().logMessage(Level.FINE, "Canceling master determination; already in progress: " + this.mClusterID + ":" + this.mNodeID);
                            return;
                        }
                    }
                    this.getLogger().logMessage(Level.FINE, "Before sending out self info (Master Determination): " + this.mClusterID + ":" + this.mNodeID);
                    jMSClusterSupport2 = this;
                    synchronized (jMSClusterSupport2) {
                        this.getLogger().logMessage(Level.FINE, "Setting mDeterminingMast to true: " + this.mClusterID + ":" + this.mNodeID);
                        this.mDeterminingMaster = true;
                        this.mEarliestMasterName = this.mNodeID;
                        this.mEarliestMasterTime = this.mServerStartTime;
                    }
                    jMSClusterSupport2 = this;
                    synchronized (jMSClusterSupport2) {
                        MapMessage startMessage = this.safeCreateMapMessage();
                        startMessage.setStringProperty("operation", Op_NodeInfo);
                        startMessage.setLongProperty("mainData", this.mServerStartTime);
                        startMessage.setStringProperty("clusterNodeID", this.mNodeID);
                        startMessage.setStringProperty("CallbackServer", this.mClusterID);
                        this.mClusterTopicProducer.publish((Message)startMessage);
                        this.getLogger().logMessage(Level.FINE, "Sending out self info (Master Determination): " + this.mClusterID + ":" + this.mNodeID);
                    }
                    this.getUtilityTimer().schedule(this.createMasterRealizationTask(), this.mMasterWaitTime);
                    break block31;
                }
                if (opName.equals(Op_NodeInfo)) {
                    this.getLogger().logMessage(Level.FINE, "Receiving node info (Master Determination): " + this.mClusterID + ":" + this.mNodeID);
                    long nodeStartTime = msg.getLongProperty("mainData");
                    JMSClusterSupport jMSClusterSupport3 = this;
                    synchronized (jMSClusterSupport3) {
                        if (this.mEarliestMasterName == null || nodeStartTime < this.mEarliestMasterTime) {
                            this.mEarliestMasterName = msg.getStringProperty("clusterNodeID");
                            this.mEarliestMasterTime = nodeStartTime;
                            this.getLogger().logMessage(Level.FINE, "Updating proposed master (Master Determination): " + this.mClusterID + ":" + this.mNodeID + "  Earliest: " + this.mEarliestMasterName);
                        }
                        break block31;
                    }
                }
                if (opName.equals(Op_MasterPing)) {
                    this.getLogger().logMessage(Level.FINEST, "Receiving master ping: " + this.mClusterID + ":" + this.mNodeID);
                    JMSClusterSupport jMSClusterSupport4 = this;
                    synchronized (jMSClusterSupport4) {
                        this.getUtilityTimer().schedule(this.createMasterDeadTask(), this.mClusterTimeout);
                        String currentMaster = msg.getStringProperty("clusterNodeID");
                        if (this.mEarliestMasterName == null || !this.mEarliestMasterName.equals(currentMaster)) {
                            this.startMasterDetermination();
                        }
                        break block31;
                    }
                }
                if (!opName.equals(Op_MasterSharedData)) break block31;
                this.getLogger().logMessage(Level.FINE, "Receiving shared data from master: " + this.mClusterID + ":" + this.mNodeID);
                JMSClusterSupport jMSClusterSupport5 = this;
                synchronized (jMSClusterSupport5) {
                    this.mUserMap = Utilities.getMapFromEncodedString(msg.getStringProperty("mainData"));
                    this.mSessionMap = Utilities.getMapFromEncodedString(msg.getStringProperty("auxData1"));
                }
            }
            catch (Exception e) {
                this.getLogger().logMessage(Level.WARNING, e);
            }
        }
    }

    protected synchronized TimerTask createMasterDeadTask() {
        if (this.mMasterAliveTask != null) {
            this.mMasterAliveTask.cancel();
        }
        this.mMasterAliveTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JMSClusterSupport jMSClusterSupport = JMSClusterSupport.this;
                synchronized (jMSClusterSupport) {
                    if (JMSClusterSupport.this.mShuttingDown) {
                        return;
                    }
                }
                JMSClusterSupport.this.getLogger().logMessage(Level.FINE, "Master not heard from--find a master: " + JMSClusterSupport.this.mClusterID);
                try {
                    JMSClusterSupport.this.startMasterDetermination();
                }
                catch (Exception e) {
                    JMSClusterSupport.this.getLogger().logMessage(Level.WARNING, e);
                }
            }
        };
        return this.mMasterAliveTask;
    }

    protected TimerTask createMasterRealizationTask() {
        this.getLogger().logMessage(Level.FINE, "createMasterRealizationTask. mMasterDelayTask is not null: " + (this.mMasterDelayTask != null));
        if (this.mMasterDelayTask != null) {
            this.mMasterDelayTask.cancel();
        }
        this.mMasterDelayTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JMSClusterSupport jMSClusterSupport = JMSClusterSupport.this;
                synchronized (jMSClusterSupport) {
                    if (JMSClusterSupport.this.mShuttingDown) {
                        JMSClusterSupport.this.getLogger().logMessage(Level.FINE, "mShuttingDown is true");
                        return;
                    }
                }
                JMSClusterSupport.this.getLogger().logMessage(Level.FINE, "Deadline reached for determining master: " + JMSClusterSupport.this.mClusterID + ":" + JMSClusterSupport.this.mNodeID);
                JMSClusterSupport.this.finishMasterDetermination();
            }
        };
        return this.mMasterDelayTask;
    }

    protected TimerTask createMasterPingTask() {
        if (this.mMasterPingTask != null) {
            this.mMasterPingTask.cancel();
        }
        this.mMasterPingTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (JMSClusterSupport.this.isMasterServer()) {
                    Object object = JMSClusterSupport.this;
                    synchronized (object) {
                        if (JMSClusterSupport.this.mShuttingDown) {
                            JMSClusterSupport.this.getLogger().logMessage(Level.FINE, "mShuttingDown is true");
                            return;
                        }
                    }
                    try {
                        JMSClusterSupport.this.getLogger().logMessage(Level.FINE, "Master sending ping: " + JMSClusterSupport.this.mClusterID + ":" + JMSClusterSupport.this.mNodeID);
                        object = this;
                        synchronized (object) {
                            MapMessage startMessage = JMSClusterSupport.this.safeCreateMapMessage();
                            startMessage.setStringProperty("operation", JMSClusterSupport.Op_MasterPing);
                            startMessage.setStringProperty("CallbackServer", JMSClusterSupport.this.mClusterID);
                            startMessage.setStringProperty("clusterNodeID", JMSClusterSupport.this.mNodeID);
                            startMessage.setLongProperty("mainData", System.currentTimeMillis());
                            JMSClusterSupport.this.mClusterTopicProducer.send((Message)startMessage);
                        }
                    }
                    catch (Exception e) {
                        JMSClusterSupport.this.getLogger().logMessage(Level.WARNING, e);
                    }
                }
            }
        };
        return this.mMasterPingTask;
    }

    @Override
    public ExecutionContext assignExecutionContext(RunningJob rj) {
        return this.getManager().getExecutionProvider().assignExecutionContext(rj);
    }

    @Override
    public void killJob(RunningJob rj, boolean force) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMasterServer() {
        this.getLogger().logMessage(Level.FINE, "Is MasterServer: mIsEligibleMaster: " + this.mIsEligibleMaster + ", mDeterminingMaster:" + this.mDeterminingMaster + ", mShuttingDown:" + this.mShuttingDown + "mNodeID:" + this.mNodeID + ", mEarliestMasterName:" + this.mEarliestMasterName);
        if (!this.mIsEligibleMaster) {
            return false;
        }
        JMSClusterSupport jMSClusterSupport = this;
        synchronized (jMSClusterSupport) {
            if (this.mDeterminingMaster) {
                return false;
            }
            if (this.mShuttingDown) {
                return false;
            }
            if (this.mNodeID.equals(this.mEarliestMasterName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public MasterServer getMasterServer() {
        this.getLogger().logMessage(Level.FINE, "Getting Master Server");
        return new JMSMasterServer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMasterStatus(String currentMaster, boolean allowInit) {
        if (currentMaster != null && this.mNodeID.equals(currentMaster)) {
            int attempts = 6;
            while (attempts > 0) {
                try {
                    this.getManager().getExecutionProvider().assumeMastership();
                    break;
                }
                catch (Exception e) {
                    this.getLogger().logMessage(Level.FINE, e);
                    --attempts;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            if (!this.mIsMaster && allowInit) {
                if (this.mMasterPingTask != null) {
                    this.getLogger().logMessage(Level.INFO, "Stopping timer: " + this.mClusterID + ":" + this.mNodeID);
                    this.mMasterPingTask.cancel();
                }
                this.updateWithMasterServerData();
                if (this.mMasterServiceThread == null) {
                    this.getLogger().logMessage(Level.INFO, "Creating master thread...");
                    this.createMasterServiceThread();
                }
                this.getLogger().logMessage(Level.INFO, "This node is now the master: " + this.mClusterID + ":" + this.mNodeID);
                this.getLogger().logMessage(Level.INFO, "Creating new timer...");
                this.getUtilityTimer().schedule(this.createMasterPingTask(), 1L, this.mClusterTimeout / 2L);
            } else if (this.mIsMaster) {
                this.getLogger().logMessage(Level.INFO, "This node continues as the master: " + this.mClusterID + ":" + this.mNodeID);
                if (System.getProperty("sas.dip.RecoverOnTimerFailure") != null) {
                    this.mManager.getExecutionProvider().performDataCleanup();
                    this.mManager.initialize();
                    if (this.mMasterServiceThread == null) {
                        this.createMasterServiceThread();
                    }
                    if (this.mMasterPingTask == null) {
                        this.getLogger().logMessage(Level.INFO, "restarting thread.");
                        this.getUtilityTimer().schedule(this.createMasterPingTask(), 1L, this.mClusterTimeout / 2L);
                    }
                }
            }
            this.mIsMaster = true;
            String userData = "";
            String sessionData = "";
            JMSClusterSupport jMSClusterSupport = this;
            synchronized (jMSClusterSupport) {
                userData = Utilities.createStringFromMap(this.mUserMap);
                sessionData = Utilities.createStringFromMap(this.mSessionMap);
            }
            this.sendSharedData(userData, sessionData);
            this.getUtilityTimer().schedule(this.createMasterDeadTask(), this.mClusterTimeout);
        } else {
            this.getLogger().logMessage(Level.FINE, "Node not master, cleaning up: " + this.mClusterID + ":" + this.mNodeID);
            if (this.mMasterPingTask != null) {
                this.mMasterPingTask.cancel();
            }
            this.mIsMaster = false;
            if (this.mManager != null) {
                this.mManager.getExecutionProvider().loseMastership();
            }
        }
    }

    protected ClientLogger getLogger() {
        FlowManager manager = this.getManager();
        if (manager != null) {
            return manager.getLogger();
        }
        return FlowManager.getDefaultLogger();
    }

    private void createResponseThread() {
        final String messageSelector = "clusterNodeID='" + this.mNodeID + "'";
        this.mResponseThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean exceptionOccurred = false;
                block12: while (true) {
                    try {
                        while (true) {
                            JMSClusterSupport jMSClusterSupport = JMSClusterSupport.this;
                            synchronized (jMSClusterSupport) {
                                if (JMSClusterSupport.this.mShuttingDown) {
                                    break block12;
                                }
                            }
                            Message removedMessage = JMSClusterSupport.this.getResponseQueue().receiveSelected(messageSelector);
                            if (removedMessage != null) {
                                Object o = removedMessage.getObjectProperty("mainData");
                                String opName = removedMessage.getStringProperty("operation");
                                Object object = o;
                                JMSClusterSupport.this.getLogger().logMessage(Level.FINER, "Retrieving cluster response from queue: " + JMSClusterSupport.this.mClusterID + " for operation: " + opName);
                                if (opName != null && o instanceof String && (opName.equals("GetErrorData") || opName.equals("GetOutputData"))) {
                                    String data = (String)o;
                                    int charsRead = removedMessage.getIntProperty("auxData1");
                                    object = new OutputHolder(charsRead, data);
                                }
                                String guid = removedMessage.getStringProperty("requestID");
                                JMSClusterSupport.this.setResponse(guid, object);
                            }
                            exceptionOccurred = false;
                        }
                    }
                    catch (Exception e) {
                        if (!exceptionOccurred) {
                            JMSClusterSupport.this.getManager().getLogger().logMessage(Level.WARNING, e);
                        } else {
                            JMSClusterSupport.this.getManager().getLogger().logMessage(Level.FINE, e);
                        }
                        exceptionOccurred = true;
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!(e instanceof JMSException) && !(e instanceof JmsException)) continue;
                        try {
                            JMSClusterSupport jMSClusterSupport = JMSClusterSupport.this;
                            synchronized (jMSClusterSupport) {
                                JMSClusterSupport.this.initJMS(1);
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    break;
                }
            }
        }, "ResponseThread-" + this.mNodeID);
        this.mResponseThread.start();
    }

    private void createMasterServiceThread() {
        final String messageSelector = "CallbackServer='" + this.mClusterID + "'";
        this.mMasterServiceThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JMSClusterSupport.this.getLogger().logMessage(Level.FINE, "JMS Master service request thread created");
                block5: while (true) {
                    try {
                        while (true) {
                            String flowInstanceID;
                            int maxChars;
                            Long startPos;
                            String jobID;
                            String flowID;
                            String[] flowIDs;
                            JMSClusterSupport jMSClusterSupport = JMSClusterSupport.this;
                            synchronized (jMSClusterSupport) {
                                if (JMSClusterSupport.this.mShuttingDown) {
                                    break block5;
                                }
                            }
                            if (!JMSClusterSupport.this.isMasterServer()) {
                                JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "JMS Master service request thread -- sleeping, not master");
                                Thread.sleep(10000L);
                                continue;
                            }
                            JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "JMS Master service request thread -- checking messages");
                            Message removedMessage = JMSClusterSupport.this.getRequestQueue().receiveSelected(messageSelector);
                            if (removedMessage == null) continue;
                            JMSClusterSupport.this.getLogger().logMessage(Level.FINE, "Removed message from cluster request queue: " + JMSClusterSupport.this.mClusterID);
                            final String opName = removedMessage.getStringProperty("operation");
                            final String operationGUID = removedMessage.getStringProperty("requestID");
                            final String sessionID = removedMessage.getStringProperty("sessionID");
                            final String callerID = removedMessage.getStringProperty("clusterNodeID");
                            if (opName.equals("GetMasterServerConfig")) {
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        Properties props = JMSClusterSupport.this.getManager().getServerConfig();
                                        if (props == null) {
                                            props = new Properties();
                                        }
                                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                                        try {
                                            props.store(out, "");
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                        final String propString = out.toString();
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", propString);
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetFlowHistories")) {
                                flowIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                final int countPerFlow = removedMessage.getIntProperty("auxData1");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        FlowHistory[] histories = JMSClusterSupport.this.getManager().getFlowHistories(sessionID, flowIDs, countPerFlow);
                                        final ArrayList<String> resultList = new ArrayList<String>();
                                        for (int i = 0; i < histories.length; ++i) {
                                            FlowHistory history = histories[i];
                                            resultList.add(history.toSerializedForm());
                                        }
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(resultList.toArray(new String[0])));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("SearchHistory")) {
                                final String searchOptionsString = removedMessage.getStringProperty("mainData");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        HistorySearchOptions options = HistorySearchOptions.createFromSerializedForm(searchOptionsString);
                                        final ArrayList<String> resultList = new ArrayList<String>();
                                        if (options != null) {
                                            FlowHistory[] histories = JMSClusterSupport.this.getManager().getFlowHistory(sessionID, options);
                                            for (int i = 0; i < histories.length; ++i) {
                                                FlowHistory history = histories[i];
                                                resultList.add(history.toSerializedForm());
                                            }
                                        }
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(resultList.toArray(new String[0])));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetFlowDefinitions")) {
                                flowIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        TopLevelFlow[] flows = JMSClusterSupport.this.getManager().getFlowDefinitions(sessionID, flowIDs);
                                        final ArrayList<String> resultList = new ArrayList<String>();
                                        for (int i = 0; i < flows.length; ++i) {
                                            TopLevelFlow flow = flows[i];
                                            resultList.add(flow.toSerializedForm());
                                        }
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(resultList.toArray(new String[0])));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetInstanceDefinitions")) {
                                final String[] instanceIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        FlowInstance[] flows = JMSClusterSupport.this.getManager().getInstanceDefinitions(sessionID, instanceIDs);
                                        final ArrayList<String> resultList = new ArrayList<String>();
                                        for (int i = 0; i < flows.length; ++i) {
                                            FlowInstance flowInstance = flows[i];
                                            resultList.add(flowInstance.toSerializedForm());
                                        }
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(resultList.toArray(new String[0])));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetFlowByName")) {
                                final String flowName = removedMessage.getStringProperty("mainData");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final String flowID = JMSClusterSupport.this.getManager().getFlowID(sessionID, flowName);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", flowID);
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetOutputData")) {
                                flowID = removedMessage.getStringProperty("mainData");
                                final String instanceID = removedMessage.getStringProperty("auxData1");
                                jobID = removedMessage.getStringProperty("auxData2");
                                startPos = removedMessage.getLongProperty("auxData3");
                                maxChars = removedMessage.getIntProperty("auxData4");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        StringBuffer buffer = new StringBuffer();
                                        final int charsRead = JMSClusterSupport.this.getManager().getOutputStreamData(sessionID, flowID, instanceID, jobID, startPos, maxChars, buffer);
                                        final String bufferData = buffer.toString();
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", bufferData);
                                                message.setIntProperty("auxData1", charsRead);
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetRendererSnapshots")) {
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        Collection<JobRendererInfo> infos = JMSClusterSupport.this.getManager().getJobRendererSnapshots();
                                        final ArrayList<String> serInfos = new ArrayList<String>();
                                        for (JobRendererInfo info : infos) {
                                            serInfos.add(info.serialize());
                                        }
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(serInfos.toArray(new String[0])));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetErrorData")) {
                                flowID = removedMessage.getStringProperty("mainData");
                                final String instanceID = removedMessage.getStringProperty("auxData1");
                                jobID = removedMessage.getStringProperty("auxData2");
                                startPos = removedMessage.getLongProperty("auxData3");
                                maxChars = removedMessage.getIntProperty("auxData4");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        StringBuffer buffer = new StringBuffer();
                                        final int charsRead = JMSClusterSupport.this.getManager().getErrorStreamData(sessionID, flowID, instanceID, jobID, startPos, maxChars, buffer);
                                        final String bufferData = buffer.toString();
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", bufferData);
                                                message.setIntProperty("auxData1", charsRead);
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("CreateSession")) {
                                final String userID = removedMessage.getStringProperty("userID");
                                final SealedString password = removedMessage.getStringProperty("password") != null ? new SealedString(removedMessage.getStringProperty("password")) : null;
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final AbstractUserSession session = JMSClusterSupport.this.getManager().createSession(userID, password);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("CallbackServer", JMSClusterSupport.this.getClusterID());
                                                message.setStringProperty("clusterNodeID", callerID);
                                                if (session != null) {
                                                    message.setStringProperty("mainData", session.toSerializedForm());
                                                }
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("TerminateSession")) {
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final boolean success = JMSClusterSupport.this.getManager().terminateSession(sessionID);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setBooleanProperty("mainData", Boolean.valueOf(success).booleanValue());
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("AddFlows")) {
                                final String[] flowDefs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        ArrayList<TopLevelFlow> newFlows = new ArrayList<TopLevelFlow>();
                                        for (int i = 0; i < flowDefs.length; ++i) {
                                            String flowString = flowDefs[i];
                                            try {
                                                TopLevelFlow flow = TopLevelFlow.createFromXML(new BufferedReader(new StringReader(flowString)), JMSClusterSupport.this.getLogger());
                                                newFlows.add(flow);
                                                continue;
                                            }
                                            catch (Exception e) {
                                                JMSClusterSupport.this.getLogger().logMessage(Level.WARNING, e);
                                            }
                                        }
                                        final String[] flowIDs = JMSClusterSupport.this.getManager().addFlows(sessionID, newFlows.toArray(new TopLevelFlow[0]));
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(flowIDs));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("UpdateFlow")) {
                                final String flowDef = removedMessage.getStringProperty("mainData");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        boolean success = false;
                                        try {
                                            TopLevelFlow flow = TopLevelFlow.createFromXML(new BufferedReader(new StringReader(flowDef)), JMSClusterSupport.this.getLogger());
                                            success = JMSClusterSupport.this.getManager().updateFlow(sessionID, flow);
                                        }
                                        catch (Exception e) {
                                            JMSClusterSupport.this.getLogger().logMessage(Level.WARNING, e);
                                        }
                                        final boolean finalSuccess = success;
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setBooleanProperty("mainData", Boolean.valueOf(finalSuccess).booleanValue());
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("KillFlows")) {
                                final String[] flowInstanceIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                final boolean force = removedMessage.getBooleanProperty("auxData1");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final String[] failedIDs = JMSClusterSupport.this.getManager().killFlowInstances(sessionID, flowInstanceIDs, force);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(failedIDs));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("HoldFlows")) {
                                flowIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final String[] successfulIDs = JMSClusterSupport.this.getManager().holdFlows(sessionID, flowIDs);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(successfulIDs));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("ReleaseFlows")) {
                                flowIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final String[] successfulIDs = JMSClusterSupport.this.getManager().releaseFlows(sessionID, flowIDs);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(successfulIDs));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("KillExecutionItem")) {
                                flowInstanceID = removedMessage.getStringProperty("mainData");
                                final String subItemID = removedMessage.getStringProperty("auxData1");
                                final Boolean force = removedMessage.getBooleanProperty("auxData2");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final boolean success = JMSClusterSupport.this.getManager().killExecutionItem(sessionID, flowInstanceID, subItemID, force);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setBooleanProperty("mainData", Boolean.valueOf(success).booleanValue());
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("TriggerExecutionItem")) {
                                flowInstanceID = removedMessage.getStringProperty("mainData");
                                final String subItemID = removedMessage.getStringProperty("auxData1");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final boolean success = JMSClusterSupport.this.getManager().triggerExecutionItem(sessionID, flowInstanceID, subItemID);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setBooleanProperty("mainData", Boolean.valueOf(success).booleanValue());
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("DeleteFlows")) {
                                flowIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final String[] failedIDs = JMSClusterSupport.this.getManager().deleteFlows(sessionID, flowIDs);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(failedIDs));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("RunFlows")) {
                                flowIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final String[] newInstanceIDs = JMSClusterSupport.this.getManager().runFlows(sessionID, flowIDs);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(newInstanceIDs));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("IsAdministrator")) {
                                final Boolean result = JMSClusterSupport.this.getManager().isAdministrator(sessionID);
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setBooleanProperty("mainData", result.booleanValue());
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetAllFlowIDs")) {
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        TopLevelFlowIDInfo[] idInfos = JMSClusterSupport.this.getManager().getAllFlowIDs(sessionID);
                                        final ArrayList<String> results = new ArrayList<String>();
                                        for (int i = 0; i < idInfos.length; ++i) {
                                            TopLevelFlowIDInfo info = idInfos[i];
                                            results.add(info.toSerializedForm());
                                        }
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(results.toArray(new String[0])));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetNextTriggerTimes")) {
                                flowIDs = Utilities.getArrayFromEncodedString(removedMessage.getStringProperty("mainData"));
                                long startTime = removedMessage.getLongProperty("auxData1");
                                final Calendar startCal = Calendar.getInstance();
                                startCal.setTimeInMillis(startTime);
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        ArrayList<String> inputs = new ArrayList<String>();
                                        inputs.addAll(Arrays.asList(flowIDs));
                                        List<Long> results = JMSClusterSupport.this.getManager().getNextTriggerTimes(inputs, startCal);
                                        final Long[] numbers = results.toArray(new Long[0]);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", Utilities.createStringFromArray(numbers));
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("GetJobRoutingRules")) {
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final String routingXML = JMSClusterSupport.this.getManager().getJobRoutingRulesXML(sessionID);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setStringProperty("mainData", routingXML);
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            if (opName.equals("SetJobRoutingRules")) {
                                final String xmlData = removedMessage.getStringProperty("mainData");
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        JMSClusterSupport.this.getLogger().logMessage(Level.FINEST, "Using thread to perform MQ cluster operation: " + opName);
                                        final boolean success = JMSClusterSupport.this.getManager().setJobRoutingRulesXML(sessionID, xmlData);
                                        JMSClusterSupport.this.getResponseQueue().convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("clusterNodeID", callerID);
                                                message.setBooleanProperty("mainData", success);
                                                message.setStringProperty("requestID", operationGUID);
                                                message.setStringProperty("operation", opName);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            JMSClusterSupport.this.getLogger().logMessage(Level.WARNING, "Unknown operation attempted: " + opName);
                        }
                    }
                    catch (Exception e) {
                        JMSClusterSupport.this.getManager().getLogger().logMessage(Level.WARNING, e);
                        continue;
                    }
                    break;
                }
            }
        }, "MasterServiceThread-" + this.mNodeID);
        this.mMasterServiceThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWithMasterServerData() {
        HashMap<String, AbstractUserSession> realSessionMap = new HashMap<String, AbstractUserSession>();
        HashMap<String, UserInfo> realUserMap = new HashMap<String, UserInfo>();
        JMSClusterSupport jMSClusterSupport = this;
        synchronized (jMSClusterSupport) {
            if (this.mUserMap != null) {
                for (String userData : this.mUserMap.values()) {
                    UserInfo info = UserInfo.createFromData(userData);
                    if (info == null) continue;
                    realUserMap.put(info.getUserID(), info);
                }
            }
            if (this.mSessionMap != null) {
                for (String sessionData : this.mSessionMap.values()) {
                    AbstractUserSession session = this.mManager.getExecutionProvider().constructSession(sessionData);
                    if (session == null) continue;
                    session.setFlowManager(this.getManager());
                    realSessionMap.put(session.getSessionID(), session);
                }
            }
        }
        try {
            ((ExecutionProviderBase)this.mManager.getExecutionProvider()).resetUserAndSessionMaps(realUserMap, realSessionMap);
            this.mManager.initialize();
        }
        catch (IllegalArgumentException e) {
            this.mManager.getLogger().logMessage(Level.WARNING, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistSessionHook(UserInfo user, AbstractUserSession session) {
        String sessionData;
        String userData;
        JMSClusterSupport jMSClusterSupport = this;
        synchronized (jMSClusterSupport) {
            if (this.mSessionMap == null) {
                this.mSessionMap = new HashMap<String, String>();
            }
            if (this.mUserMap == null) {
                this.mUserMap = new HashMap<String, String>();
            }
            this.mSessionMap.put(session.getSessionID(), session.toSerializedForm());
            this.mUserMap.put(user.getUserID(), user.toSerializedForm());
            userData = Utilities.createStringFromMap(this.mUserMap);
            sessionData = Utilities.createStringFromMap(this.mSessionMap);
        }
        this.sendSharedData(userData, sessionData);
    }

    private synchronized MapMessage safeCreateMapMessage() throws JMSException, NamingException {
        if (this.mTopicSession == null) {
            this.getLogger().logMessage(Level.FINE, this.getClass().getName() + ": TopicSession is null.  Reconnecting to JMS.");
            this.initJMSTopic(this.initJMSContext());
        }
        MapMessage message = null;
        try {
            message = this.mTopicSession.createMapMessage();
        }
        catch (jakarta.jms.IllegalStateException e) {
            this.getLogger().logMessage(Level.FINE, this.getClass().getName() + ": TopicSession is closed.  Reconnecting to JMS.");
            this.initJMSTopic(this.initJMSContext());
            message = this.mTopicSession.createMapMessage();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSharedData(String userData, String sessionData) {
        try {
            JMSClusterSupport jMSClusterSupport = this;
            synchronized (jMSClusterSupport) {
                MapMessage startMessage = this.safeCreateMapMessage();
                startMessage.setStringProperty("operation", Op_MasterSharedData);
                startMessage.setStringProperty("mainData", userData);
                startMessage.setStringProperty("auxData1", sessionData);
                startMessage.setStringProperty("clusterNodeID", this.mNodeID);
                startMessage.setStringProperty("CallbackServer", this.mClusterID);
                this.mClusterTopicProducer.send((Message)startMessage);
            }
        }
        catch (Exception e) {
            this.getLogger().logMessage(Level.WARNING, e);
        }
    }

    public void becomeMaster(boolean reinit) {
        if (this.mIsEligibleMaster && this.getManager() != null) {
            try {
                this.updateMasterStatus(this.mEarliestMasterName, reinit);
            }
            catch (Exception e) {
                this.getLogger().logMessage(Level.FINE, e);
                this.getLogger().logMessage(Level.FINE, "Node failed to become master: " + this.mNodeID);
            }
        }
    }

    public JmsTemplate getRequestQueue() {
        return this.mRequestQueue;
    }

    public JmsTemplate getResponseQueue() {
        return this.mResponseQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponder(Thread waitingThread, String guid) {
        Map<String, ResponseHolder> map = this.mResponderMap;
        synchronized (map) {
            this.mResponderMap.put(guid, new ResponseHolder(waitingThread));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(String guid, Object result) {
        Map<String, ResponseHolder> map = this.mResponderMap;
        synchronized (map) {
            ResponseHolder holder = this.mResponderMap.get(guid);
            if (holder != null) {
                holder.setResult(result);
                holder.clearThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResponse(String guid) {
        Map<String, ResponseHolder> map = this.mResponderMap;
        synchronized (map) {
            ResponseHolder holder = this.mResponderMap.remove(guid);
            if (holder != null) {
                return holder.getResult();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResponse(String guid) {
        Map<String, ResponseHolder> map = this.mResponderMap;
        synchronized (map) {
            ResponseHolder holder = this.mResponderMap.get(guid);
            if (holder != null) {
                return holder.isValueSet();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShuttingDown() {
        JMSClusterSupport jMSClusterSupport = this;
        synchronized (jMSClusterSupport) {
            return this.mShuttingDown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        JMSClusterSupport jMSClusterSupport = this;
        synchronized (jMSClusterSupport) {
            this.mShuttingDown = true;
            this.mUtilityTimer.cancel();
            this.mEarliestMasterName = null;
            this.becomeMaster(false);
        }
        this.getLogger().logMessage(Level.INFO, "Shutting down scheduling server cluster module (JMS)");
        this.cleanupJMSObjects();
        super.cleanup();
    }

    public void setMasterWaitTimeout(long timeMS) {
        if (timeMS >= 1000L) {
            this.mMasterWaitTime = timeMS;
        }
    }

    public void setClusterTimeout(long timeMS) {
        if (timeMS >= 1000L) {
            this.mClusterTimeout = timeMS;
        }
    }
}

