/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.PredefinedCalendar;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.scheduler.model.SchedulerException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeDependency
extends RunCondition {
    private IRecurrenceInfo mRecurrence = new DailyRecurrence();
    private String mCalendarID = null;
    private String mHours;
    private String mMinutes;
    private int mValidWindowLength;
    private String mTimeZoneID;
    private transient TimeZone mTimeZone;
    private transient List<Integer> mExplodedMinutes;
    private transient List<Integer> mExplodedHours;
    public static final String XML_TimeDependency_Tag = "TimeDependency";
    public static final String XML_Hours_Tag = "Hours";
    public static final String XML_Minutes_Tag = "Minutes";
    public static final String XML_WindowLength_Tag = "WindowLength";
    public static final String XML_TimeZoneID_Tag = "TimeZoneID";
    public static final String XML_CalendarID_Tag = "CalendarID";

    public TimeDependency(String hours, String minutes, int validWindowLength, String timeZoneID, ClientLogger logger) {
        super(logger);
        this.mHours = hours;
        this.mMinutes = minutes;
        this.mValidWindowLength = Math.max(1, validWindowLength);
        this.mTimeZoneID = timeZoneID;
        this.mTimeZone = TimeZone.getTimeZone(this.mTimeZoneID);
        this.processTimes(hours, minutes);
    }

    public String getHours() {
        return this.mHours;
    }

    public String getMinutes() {
        return this.mMinutes;
    }

    public void setTimes(String hours, String minutes) {
        if (hours != null && minutes != null) {
            this.mHours = hours;
            this.mMinutes = minutes;
            this.processTimes(this.mHours, this.mMinutes);
        }
    }

    public void setCalendarID(String calendarID) {
        this.mCalendarID = calendarID;
        if (calendarID != null) {
            this.mRecurrence = null;
        }
    }

    public int getValidWindowLength() {
        return this.mValidWindowLength;
    }

    public void setValidWindowLength(int validWindowLength) {
        if (validWindowLength >= 1) {
            this.mValidWindowLength = validWindowLength;
        }
    }

    public String getTimeZoneID() {
        return this.mTimeZoneID;
    }

    public void setTimeZoneID(String timeZoneID) {
        if (timeZoneID == null) {
            return;
        }
        this.mTimeZoneID = timeZoneID;
        this.mTimeZone = TimeZone.getTimeZone(this.mTimeZoneID);
    }

    public static void findTimeDependencies(RunCondition condition, List<TimeDependency> output) {
        if (condition instanceof TimeDependency) {
            output.add((TimeDependency)condition);
        } else if (condition instanceof RunConditions) {
            for (RunCondition subCondition : ((RunConditions)condition).getSubConditions()) {
                TimeDependency.findTimeDependencies(subCondition, output);
            }
        }
    }

    public IRecurrenceInfo getRecurrence() {
        return this.mRecurrence;
    }

    public void setRecurrence(IRecurrenceInfo recurrence) {
        this.mRecurrence = recurrence;
        if (recurrence != null) {
            this.mCalendarID = null;
        }
    }

    private void processTimes(String hours, String minutes) {
        this.mExplodedMinutes = new ArrayList<Integer>();
        this.mExplodedHours = new ArrayList<Integer>();
        this.parseTimeString(hours, 24, this.mExplodedHours);
        this.parseTimeString(minutes, 60, this.mExplodedMinutes);
    }

    private void parseTimeString(String times, int dataRange, List<Integer> explodedList) {
        String subString;
        int index = times.indexOf(44);
        int lastIndex = 0;
        while (index >= 0) {
            subString = times.substring(lastIndex, index);
            this.addNumbersForString(subString, dataRange, explodedList);
            lastIndex = index + 1;
            index = times.indexOf(44, lastIndex);
        }
        subString = times.substring(lastIndex);
        this.addNumbersForString(subString, dataRange, explodedList);
        Collections.sort(explodedList);
        ArrayList<Integer> itemsToRemove = new ArrayList<Integer>();
        int lastValue = -1;
        index = 0;
        for (Integer integer : explodedList) {
            int currentValue = integer;
            if (currentValue == lastValue) {
                itemsToRemove.add(new Integer(index));
            } else {
                lastValue = currentValue;
            }
            ++index;
        }
        for (int i = itemsToRemove.size() - 1; i >= 0; --i) {
            int indexToRemove = (Integer)itemsToRemove.get(i);
            explodedList.remove(indexToRemove);
        }
    }

    private void addNumbersForString(String subString, int dataRange, List<Integer> explodedList) {
        int dashPos = subString.indexOf(45);
        if (dashPos >= 0) {
            int higherNum;
            String firstNum = subString.substring(0, dashPos);
            String secondNum = subString.substring(dashPos + 1);
            int lowerNum = Integer.parseInt(firstNum.trim());
            if (lowerNum < (higherNum = Integer.parseInt(secondNum.trim())) && lowerNum >= 0 && higherNum < dataRange) {
                for (int i = lowerNum; i <= higherNum; ++i) {
                    explodedList.add(new Integer(i));
                }
            }
        } else if (subString.equals("*")) {
            for (int i = 0; i < dataRange; ++i) {
                explodedList.add(new Integer(i));
            }
        } else {
            int num = Integer.parseInt(subString.trim());
            explodedList.add(new Integer(num));
        }
    }

    @Override
    public boolean willNotRun(FlowManager manager, Calendar startTime, Calendar deadlineTime) {
        return false;
    }

    @Override
    public int canExecute(FlowManager manager, Calendar serverTime, Map<String, Long> usedTimes, Map<String, Long> outputUsedTimes, Calendar outputNextTriggerTime, boolean defaultValue) {
        try {
            Long lastTimeObject;
            IRecurrenceInfo recurrence = this.mRecurrence;
            if (recurrence == null && this.mCalendarID != null) {
                PredefinedCalendar schedule = manager.getCalendarForID(this.mCalendarID);
                recurrence = schedule.getRecurrence();
            }
            if (recurrence == null) {
                return 58;
            }
            if (this.mHours == null || this.mMinutes == null) {
                return 58;
            }
            if (this.mExplodedHours.size() == 0 || this.mExplodedMinutes.size() == 0) {
                return 58;
            }
            serverTime.setTimeZone(this.mTimeZone);
            Calendar executionTime = (Calendar)serverTime.clone();
            executionTime.add(12, -this.mValidWindowLength);
            ArrayList<Calendar> datesToCheck = null;
            if (!RecurrenceBaseClass.isEqualByDay((Calendar)executionTime, (Calendar)serverTime)) {
                datesToCheck = recurrence.getNextDates(executionTime, serverTime, 0);
            } else {
                boolean possibleDate = recurrence.includesDate(serverTime);
                datesToCheck = new ArrayList<Calendar>();
                if (possibleDate) {
                    datesToCheck.add(executionTime);
                }
            }
            Long lastUsedTime = new Long(0L);
            if (usedTimes != null && (lastTimeObject = usedTimes.get(this.getID())) != null) {
                lastUsedTime = lastTimeObject;
            }
            for (Calendar executionDate : datesToCheck) {
                for (Integer hourInt : this.mExplodedHours) {
                    int hour = hourInt;
                    for (Integer minuteInt : this.mExplodedMinutes) {
                        int minute = minuteInt;
                        executionDate.set(11, hour);
                        executionDate.set(12, minute);
                        executionDate.set(13, 0);
                        executionDate.set(14, 0);
                        Long timeCode = null;
                        if (usedTimes != null) {
                            timeCode = this.generateTimeCode(executionDate);
                        }
                        if (usedTimes != null && (timeCode == null || timeCode <= lastUsedTime)) continue;
                        if (!RecurrenceBaseClass.isBeforeByMinute((Calendar)serverTime, (Calendar)executionDate)) {
                            executionDate.add(12, this.mValidWindowLength);
                            if (RecurrenceBaseClass.isAfterByMinute((Calendar)serverTime, (Calendar)executionDate)) continue;
                            if (outputUsedTimes != null) {
                                outputUsedTimes.put(this.getID(), timeCode);
                            }
                            if (outputNextTriggerTime != null) {
                                outputNextTriggerTime.setTimeInMillis(serverTime.getTimeInMillis());
                                outputNextTriggerTime.add(12, 1);
                                outputNextTriggerTime.set(13, 0);
                                outputNextTriggerTime.set(14, 0);
                            }
                            return 56;
                        }
                        outputNextTriggerTime.setTimeInMillis(executionDate.getTimeInMillis());
                        return 57;
                    }
                }
            }
            Calendar queryDate = (Calendar)serverTime.clone();
            queryDate.add(5, 1);
            Calendar endQueryDate = (Calendar)queryDate.clone();
            endQueryDate.add(1, 2);
            List nextDates = recurrence.getNextDates(queryDate, endQueryDate, 1);
            if (nextDates.size() == 0) {
                outputNextTriggerTime.setTimeInMillis(endQueryDate.getTimeInMillis());
            } else {
                Calendar nextDate = (Calendar)nextDates.get(0);
                outputNextTriggerTime.setTimeInMillis(nextDate.getTimeInMillis());
                outputNextTriggerTime.set(11, this.mExplodedHours.get(0));
                outputNextTriggerTime.set(12, this.mExplodedMinutes.get(0));
            }
            outputNextTriggerTime.set(13, 0);
            outputNextTriggerTime.set(14, 0);
        }
        catch (InvalidRecurrenceException invalidRecurrenceException) {
            // empty catch block
        }
        return 57;
    }

    private Long generateTimeCode(Calendar usedTime) {
        Calendar tempTime = (Calendar)usedTime.clone();
        tempTime.set(13, 0);
        tempTime.set(14, 0);
        Long returnVal = new Long(tempTime.getTimeInMillis());
        return returnVal;
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_TimeDependency_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_Hours_Tag, this.mHours);
        tag.setAttribute(XML_Minutes_Tag, this.mMinutes);
        tag.setAttribute(XML_WindowLength_Tag, Integer.toString(this.mValidWindowLength));
        tag.setAttribute(XML_TimeZoneID_Tag, this.mTimeZoneID);
        if (this.mCalendarID != null) {
            tag.setAttribute(XML_CalendarID_Tag, this.mCalendarID);
        }
        if (this.mRecurrence != null) {
            this.mRecurrence.serialize(doc, (Node)tag);
        }
    }

    @Override
    public RunCondition copy() {
        TimeDependency newCopy = new TimeDependency(this.mHours, this.mMinutes, this.mValidWindowLength, this.mTimeZoneID, this.mLogger);
        if (this.mRecurrence != null) {
            newCopy.mRecurrence = this.mRecurrence.copy();
        }
        newCopy.setCalendarID(this.mCalendarID);
        newCopy.copyFrom(this);
        return newCopy;
    }

    @Override
    public String toString() {
        StringBuffer printString = new StringBuffer();
        if (this.mCalendarID != null) {
            printString.append("Predefined Calendar (" + this.mCalendarID + ")");
        } else if (this.mRecurrence != null) {
            String recurrenceString = this.mRecurrence.toString();
            printString.append(recurrenceString);
        }
        printString.append(" @ Hours: " + this.mHours + " Minutes: " + this.mMinutes + " Window Length (in minutes): " + this.mValidWindowLength + " TimeZone: " + this.mTimeZoneID);
        return printString.toString();
    }

    public String getCalendarID() {
        return this.mCalendarID;
    }

    @Override
    boolean isTimeDominant() {
        return true;
    }

    public static TimeDependency processTimeCondition(Node node, ClientLogger logger) throws SchedulerException {
        NamedNodeMap attributes = node.getAttributes();
        Node hoursNode = attributes.getNamedItem(XML_Hours_Tag);
        String hours = "";
        if (hoursNode != null) {
            hours = hoursNode.getNodeValue();
        }
        Node minutesNode = attributes.getNamedItem(XML_Minutes_Tag);
        String minutes = "";
        if (minutesNode != null) {
            minutes = minutesNode.getNodeValue();
        }
        Node windowLengthNode = attributes.getNamedItem(XML_WindowLength_Tag);
        int windowLength = 0;
        if (windowLengthNode != null) {
            windowLength = Integer.valueOf(windowLengthNode.getNodeValue());
        }
        Node timeZoneNode = attributes.getNamedItem(XML_TimeZoneID_Tag);
        String timeZoneID = "";
        if (timeZoneNode != null) {
            timeZoneID = timeZoneNode.getNodeValue();
        }
        TimeDependency dependency = new TimeDependency(hours, minutes, windowLength, timeZoneID, logger);
        dependency.processAttributes(attributes);
        Node calendarIDNode = attributes.getNamedItem(XML_CalendarID_Tag);
        if (calendarIDNode != null) {
            String calendarID = calendarIDNode.getNodeValue();
            dependency.setCalendarID(calendarID);
        }
        NodeList children = node.getChildNodes();
        int listLength = children.getLength();
        for (int i = 0; i < listLength; ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (!tagName.equals("schedule")) continue;
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processScheduleTag((Node)child);
            dependency.setRecurrence(recurrence);
        }
        return dependency;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TimeDependency)) {
            return false;
        }
        TimeDependency other = (TimeDependency)obj;
        if (other.mCalendarID != null && this.mCalendarID != null ? !other.mCalendarID.equals(this.mCalendarID) : other.mCalendarID != this.mCalendarID) {
            return false;
        }
        if (!other.mHours.equals(this.mHours)) {
            return false;
        }
        if (!other.mMinutes.equals(this.mMinutes)) {
            return false;
        }
        if (other.mValidWindowLength != this.mValidWindowLength) {
            return false;
        }
        if (other.mRecurrence != null && this.mRecurrence != null ? !other.mRecurrence.equals((Object)this.mRecurrence) : other.mRecurrence != this.mRecurrence) {
            return false;
        }
        if (!other.mTimeZoneID.equals(this.mTimeZoneID)) {
            return false;
        }
        return super.equals(obj);
    }
}

