/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import java.util.HashMap;
import java.util.Map;

public class SyncManager {
    private static SyncManager mInstance;
    private Map<String, SyncObject> mHashObjects = new HashMap<String, SyncObject>();

    private SyncManager() {
    }

    public static synchronized SyncManager getInstance() {
        if (mInstance == null) {
            mInstance = new SyncManager();
        }
        return mInstance;
    }

    public synchronized Object getSyncObject(String key) {
        SyncObject o = this.mHashObjects.get(key);
        if (o == null) {
            o = new SyncObject();
            this.mHashObjects.put(key, o);
        }
        o.inc();
        return o;
    }

    public synchronized void releaseSyncObject(String key) {
        SyncObject o = this.mHashObjects.get(key);
        if (o == null) {
            System.err.println("DIP Scheduler: Object synchronization count off");
        } else {
            o.dec();
            if (o.isEmpty()) {
                this.mHashObjects.remove(key);
            }
        }
    }

    private static class SyncObject {
        private int mRefCount = 0;

        private SyncObject() {
        }

        void inc() {
            ++this.mRefCount;
        }

        void dec() {
            --this.mRefCount;
        }

        public boolean isEmpty() {
            return this.mRefCount <= 0;
        }
    }
}

