/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.DeferredManagerAction;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.FileDependency;
import com.sas.scheduler.api.servers.ip.engine.Flow;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.JobDependency;
import com.sas.scheduler.api.servers.ip.engine.PredefinedCalendar;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.ShutdownException;
import com.sas.scheduler.api.servers.ip.engine.TaskEventInterface;
import com.sas.scheduler.api.servers.ip.engine.TimeDependency;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;

public class RunningFlow
extends RunningItem
implements TaskEventInterface {
    private List<RunningItem> mSubItems;
    private Flow mFlow;
    private String mID;
    private String mInvokingUser;
    private boolean mTriggered;
    private boolean mDeleted;
    private boolean mKilled;
    private transient int mCachedExitCode = Integer.MIN_VALUE;
    public static final int Exit_Code_Sum = 0;
    public static final int Exit_Code_Max = 1;
    public static final int Exit_Code_First = 2;

    public RunningFlow(FlowManager manager, TopLevelFlow flow, String invokingUserID) {
        super(manager);
        HashMap<String, RunningItem> map = new HashMap<String, RunningItem>();
        this.initialize(true, flow, flow.getOwner(), map);
        this.mTriggered = false;
        this.mDeleted = false;
        this.mInvokingUser = invokingUserID;
        this.mKilled = false;
        this.patchUpDependencies(map);
    }

    public boolean isDeleted() {
        return this.mDeleted;
    }

    public String getInvokingUser() {
        return this.mInvokingUser;
    }

    public void setDeleted(boolean deleted) {
        this.mDeleted = deleted;
    }

    private RunningFlow(FlowManager manager) {
        super(manager);
        this.mInvokingUser = "";
    }

    private void patchUpDependencies(Map<String, RunningItem> jobIDMap) {
        for (RunningItem runItem : this.getSubItems()) {
            RunCondition condition = null;
            if (runItem instanceof RunningJob) {
                condition = ((RunningJob)runItem).getJob().getRunConditions();
            } else if (runItem instanceof RunningFlow) {
                ((RunningFlow)runItem).patchUpDependencies(jobIDMap);
                condition = ((RunningFlow)runItem).getFlow().getRunConditions();
            }
            if (condition == null) continue;
            ArrayList<JobDependency> jobDependencies = new ArrayList<JobDependency>();
            JobDependency.findJobDependencies(condition, jobDependencies);
            for (JobDependency jobDep : jobDependencies) {
                RunningItem item = jobIDMap.get(jobDep.getJobID());
                if (item == null) continue;
                jobDep.setDependentItem(item);
            }
            ArrayList<TimeDependency> timeDependencies = new ArrayList<TimeDependency>();
            TimeDependency.findTimeDependencies(condition, timeDependencies);
            for (TimeDependency timeDep : timeDependencies) {
                PredefinedCalendar schedule;
                if (timeDep.getCalendarID() == null || (schedule = runItem.getFlowManager().getCalendarForID(timeDep.getCalendarID())) == null) continue;
                timeDep.setRecurrence(schedule.getRecurrence().copy());
            }
        }
    }

    private void initialize(boolean topLevel, Flow flow, String runAsUserName, Map<String, RunningItem> jobIDMap) {
        this.mCompletionCode = 16;
        this.mFlow = flow.copy(false);
        this.mID = topLevel ? this.getFlowManager().getExecutionProvider().getNewFlowInstanceID(this.mFlow) : "";
        if (this.mFlow.getUserName().length() == 0) {
            this.mFlow.setUserName(runAsUserName);
        } else {
            runAsUserName = this.mFlow.getUserName();
        }
        jobIDMap.put(this.mFlow.getUniqueID(), this);
        this.mSubItems = new ArrayList<RunningItem>();
        List<ExecutionItem> subItems = flow.getSubItems();
        for (ExecutionItem item : subItems) {
            RunningItem obj = null;
            if (item instanceof Flow) {
                obj = new RunningFlow(this.getFlowManager());
                ((RunningFlow)obj).initialize(false, (Flow)item, runAsUserName, jobIDMap);
                this.mFlow.addSubItem(((RunningFlow)obj).getFlow());
            } else if (item instanceof Job) {
                obj = new RunningJob(this.getFlowManager(), (Job)item);
                Job jobCopy = ((RunningJob)obj).getJob();
                if (jobCopy.getUserName().length() == 0) {
                    jobCopy.setUserName(runAsUserName);
                }
                this.mFlow.addSubItem(((RunningJob)obj).getJob());
                jobIDMap.put(((Job)item).getUniqueID(), obj);
            }
            if (obj == null) continue;
            obj.mParent = this;
            obj.addTaskEventListener(this);
            this.addChild(obj);
        }
    }

    public void trigger() {
        this.mTriggered = true;
    }

    @Override
    public int getExitCode() {
        if (!this.mComplete) {
            return 0;
        }
        return this.mCachedExitCode;
    }

    private void cacheExitCode(int completionCode) {
        int exitCodeCalcStyle = this.getFlowManager().getFlowExitCodeCalcStyle();
        this.mCachedExitCode = 0;
        if (completionCode == 4 || completionCode == 2) {
            long finishTimeOfCapturedItem = Long.MAX_VALUE;
            block4: for (RunningItem item : this.mSubItems) {
                if (!item.isComplete()) continue;
                int foundExitCode = 0;
                if (item instanceof RunningJob) {
                    foundExitCode = ((RunningJob)item).getReturnCode();
                } else if (item instanceof RunningFlow) {
                    foundExitCode = ((RunningFlow)item).getExitCode();
                }
                switch (exitCodeCalcStyle) {
                    case 0: {
                        this.mCachedExitCode += foundExitCode;
                        continue block4;
                    }
                    case 2: {
                        if (foundExitCode == 0 || item.getFinishTime() == null || item.getFinishTime().getTimeInMillis() >= finishTimeOfCapturedItem) continue block4;
                        finishTimeOfCapturedItem = item.getFinishTime().getTimeInMillis();
                        this.mCachedExitCode = foundExitCode;
                        continue block4;
                    }
                }
                this.mCachedExitCode = Math.max(this.mCachedExitCode, foundExitCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Calendar serverTime, String instanceID, Calendar outputNextCheckTime, List<RunningJob> outputJobsToDeploy) {
        FlowManager flowManager = this.getFlowManager();
        synchronized (flowManager) {
            if (!this.mTriggered) {
                return false;
            }
            if (this.mHeld) {
                return false;
            }
            if (!this.areAllSubItemsFinished()) {
                if (this.mStartTime == null) {
                    if (this.getFlow() instanceof TopLevelFlow) {
                        this.getFlowManager().getLogger().logMessage(Level.FINEST, FlowManager.generateLogString("Execution", this, "Starting to execute flow."));
                    } else {
                        this.getFlowManager().getLogger().logMessage(Level.FINEST, FlowManager.generateLogString("Execution", this, "Starting to execute subflow: " + this.getFlow().getUniqueID()));
                    }
                    this.mCompletionCode = 8;
                    this.mStartTime = new GregorianCalendar();
                    if (this.getFlow().getMaximumRunTime() > 0) {
                        this.mDeadlineTime = (Calendar)this.mStartTime.clone();
                        this.mDeadlineTime.add(12, this.getFlow().getMaximumRunTime());
                        outputNextCheckTime.setTimeInMillis(this.mDeadlineTime.getTimeInMillis());
                    }
                    this.notifyTaskListeners(true);
                } else {
                    if (this.mDeadlineTime != null) {
                        if (serverTime.getTimeInMillis() >= this.mDeadlineTime.getTimeInMillis()) {
                            this.getFlowManager().getLogger().logMessage(Level.FINE, FlowManager.generateLogString("Execution", this, "Flow has run out of time; attempting to kill."));
                            this.kill(false);
                            this.getFlowManager().getUtilityTimer().schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    RunningFlow.this.getFlowManager().addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(RunningFlow.this.getFlowManager()){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void execute() throws ShutdownException {
                                            FlowManager flowManager = RunningFlow.this.getFlowManager();
                                            synchronized (flowManager) {
                                                RunningFlow.this.kill(true);
                                            }
                                        }
                                    });
                                }
                            }, this.getFlowManager().getReluctantKillWait());
                        } else if (outputNextCheckTime.getTimeInMillis() == 0L || this.mDeadlineTime.getTimeInMillis() < outputNextCheckTime.getTimeInMillis()) {
                            outputNextCheckTime.setTimeInMillis(this.mDeadlineTime.getTimeInMillis());
                        }
                    }
                    this.completed(null);
                }
                for (RunningItem item : this.mSubItems) {
                    RunningFlow flow;
                    int code;
                    Calendar nextRunTime;
                    boolean canExecute;
                    if (item instanceof RunningJob) {
                        if (item.isComplete()) continue;
                        RunningJob job = (RunningJob)item;
                        canExecute = false;
                        if (job.getConditionSatisfied()) {
                            canExecute = true;
                        } else {
                            nextRunTime = (Calendar)outputNextCheckTime.clone();
                            code = job.getJob().getRunConditions().canRunNow(this.getFlowManager(), serverTime, nextRunTime);
                            if (nextRunTime.getTimeInMillis() > serverTime.getTimeInMillis() && (outputNextCheckTime.getTimeInMillis() == 0L || nextRunTime.getTimeInMillis() < outputNextCheckTime.getTimeInMillis())) {
                                outputNextCheckTime.setTimeInMillis(nextRunTime.getTimeInMillis());
                            }
                            if (code == 58) {
                                job.markNotRunnable();
                            } else if (code == 56) {
                                canExecute = true;
                            }
                        }
                        if (!canExecute) continue;
                        if (job.getConditionSatisfied()) {
                            if (job.getStartTime() == null) {
                                outputJobsToDeploy.add(job);
                                continue;
                            }
                            job.execute(serverTime, instanceID, outputNextCheckTime);
                            continue;
                        }
                        outputJobsToDeploy.add(job);
                        continue;
                    }
                    if (!(item instanceof RunningFlow) || (flow = (RunningFlow)item).areAllSubItemsFinished() && flow.isComplete()) continue;
                    canExecute = false;
                    if (flow.isTriggered()) {
                        canExecute = true;
                    } else {
                        nextRunTime = (Calendar)outputNextCheckTime.clone();
                        code = flow.getFlow().getRunConditions().canRunNow(flow.getFlowManager(), serverTime, nextRunTime);
                        if (nextRunTime.getTimeInMillis() > serverTime.getTimeInMillis() && (outputNextCheckTime.getTimeInMillis() == 0L || nextRunTime.getTimeInMillis() < outputNextCheckTime.getTimeInMillis())) {
                            outputNextCheckTime.setTimeInMillis(nextRunTime.getTimeInMillis());
                        }
                        if (code == 58) {
                            flow.markNotRunnable();
                        } else if (code == 56) {
                            canExecute = true;
                        }
                    }
                    if (!canExecute) continue;
                    flow.trigger();
                    nextRunTime = (Calendar)outputNextCheckTime.clone();
                    flow.execute(serverTime, instanceID, nextRunTime, outputJobsToDeploy);
                    if (nextRunTime.getTimeInMillis() <= serverTime.getTimeInMillis() || outputNextCheckTime.getTimeInMillis() != 0L && nextRunTime.getTimeInMillis() >= outputNextCheckTime.getTimeInMillis()) continue;
                    outputNextCheckTime.setTimeInMillis(nextRunTime.getTimeInMillis());
                }
                if (this.mSubItems.size() == 0) {
                    this.mCompletionCode = 4;
                    this.markCompleted();
                }
                return true;
            }
            if (this.mSubItems.size() == 0 && !this.mComplete) {
                this.mCompletionCode = 4;
                this.markCompleted();
            }
            return false;
        }
    }

    private boolean isTriggered() {
        return this.mTriggered;
    }

    boolean addChild(RunningItem runItem) {
        this.mSubItems.add(runItem);
        return true;
    }

    @Override
    public String getName() {
        return this.mFlow.getName();
    }

    public void addTaskEventListener(TaskEventInterface completionInterface, boolean recursive) {
        super.addTaskEventListener(completionInterface);
        if (recursive) {
            for (RunningItem item : this.mSubItems) {
                if (item instanceof RunningFlow) {
                    ((RunningFlow)item).addTaskEventListener(completionInterface, recursive);
                    continue;
                }
                item.addTaskEventListener(completionInterface);
            }
        }
    }

    @Override
    public void started(RunningItem completedItem) {
    }

    @Override
    public void completed(RunningItem completedItem) {
        if (completedItem != null) {
            this.getFlowManager().getLogger().logMessage(Level.FINEST, FlowManager.generateLogString("Execution", this, "Item :" + completedItem.getUniqueID() + " has completed."));
        }
        if (this.isComplete()) {
            this.markCompleted();
            return;
        }
        List<String> requiredItems = this.mFlow.getRequiredSubItems();
        boolean requireAll = this.mFlow.getAllMustComplete();
        boolean flowIsCompleted = requiredItems == null || requireAll;
        boolean anyIncomplete = false;
        for (RunningItem item : this.mSubItems) {
            if (item.isComplete()) {
                int completionCode = item.getCompletionCode();
                if ((completionCode == 1 || completionCode == 2 || completionCode == 128 || completionCode == 32) && requiredItems == null) {
                    flowIsCompleted = true;
                    break;
                }
                if (requiredItems == null || requireAll || requiredItems.size() != 0 && !requiredItems.contains(item.getUniqueID())) continue;
                flowIsCompleted = true;
                break;
            }
            anyIncomplete = true;
            if (requiredItems == null) {
                flowIsCompleted = false;
                continue;
            }
            if (!requireAll || requiredItems.size() != 0 && !requiredItems.contains(item.getUniqueID())) continue;
            flowIsCompleted = false;
            break;
        }
        if (this.mSubItems.size() == 0 || !anyIncomplete) {
            flowIsCompleted = true;
        }
        if (flowIsCompleted) {
            boolean killRemainingJobs = this.mFlow.getKillRunningItemsWhenComplete();
            boolean someFailed = false;
            boolean allKilled = true;
            for (RunningItem item : this.mSubItems) {
                if (!item.isComplete()) {
                    if (!killRemainingJobs) continue;
                    this.killRemainingJobs(item);
                    continue;
                }
                int completionCode = item.getCompletionCode();
                if (completionCode != 1) {
                    allKilled = false;
                }
                if (completionCode == 1 || completionCode == 2 || completionCode == 128) {
                    someFailed = true;
                }
                if (!killRemainingJobs) continue;
                this.killRemainingJobs(item);
            }
            if (this.mKilled) {
                this.mCompletionCode = 1;
            } else if (this.mCompletionCode == 8 || this.mCompletionCode == 16) {
                this.mCompletionCode = allKilled ? 1 : (someFailed ? 2 : 4);
            }
            this.cacheExitCode(this.mCompletionCode);
            this.markCompleted();
        }
    }

    private void killRemainingJobs(RunningItem item) {
        if (item.getStartTime() != null) {
            item.kill(false);
        } else {
            item.markNotRunnable(false);
        }
    }

    boolean areAllSubItemsFinished() {
        for (RunningItem item : this.mSubItems) {
            boolean areSubitemsDone = true;
            if (item instanceof RunningJob) {
                areSubitemsDone = ((RunningJob)item).isComplete();
            } else if (item instanceof RunningFlow) {
                areSubitemsDone = ((RunningFlow)item).areAllSubItemsFinished();
            }
            if (areSubitemsDone) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markCompleted() {
        FlowManager flowManager = this.getFlowManager();
        synchronized (flowManager) {
            if (!this.mComplete) {
                this.mComplete = true;
                if (this.mStartTime != null) {
                    this.mFinishTime = new GregorianCalendar();
                }
            }
            this.notifyTaskListeners(false);
        }
    }

    public String getID() {
        return this.mID;
    }

    @Override
    public String getUserName() {
        return this.mFlow.getUserName();
    }

    @Override
    public int getCompletionCode() {
        return this.mCompletionCode;
    }

    public Flow getFlow() {
        return this.mFlow;
    }

    public List<RunningItem> getSubItems() {
        return this.mSubItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean kill(boolean force) {
        FlowManager flowManager = this.getFlowManager();
        synchronized (flowManager) {
            if (!this.mComplete) {
                this.mKilled = true;
            }
            for (RunningItem item : this.mSubItems) {
                item.kill(force);
            }
        }
        return true;
    }

    public boolean kill(String subItemID, boolean force) {
        boolean found = false;
        for (RunningItem item : this.mSubItems) {
            RunningJob job;
            if (item instanceof RunningFlow) {
                RunningFlow flow = (RunningFlow)item;
                if (flow.getFlow().getUniqueID().equals(subItemID)) {
                    found = true;
                    flow.kill(force);
                    break;
                }
                found = flow.kill(subItemID, force);
                if (!found) continue;
                break;
            }
            if (!(item instanceof RunningJob) || !(job = (RunningJob)item).getJob().getUniqueID().equals(subItemID)) continue;
            found = true;
            job.kill(force);
            break;
        }
        return found;
    }

    public boolean trigger(String subItemID) {
        boolean found = false;
        for (RunningItem item : this.mSubItems) {
            RunningJob job;
            if (item instanceof RunningFlow) {
                RunningFlow flow = (RunningFlow)item;
                if (flow.getFlow().getUniqueID().equals(subItemID)) {
                    found = true;
                    flow.trigger();
                    break;
                }
                found = flow.trigger(subItemID);
                if (!found) continue;
                break;
            }
            if (!(item instanceof RunningJob) || !(job = (RunningJob)item).getJob().getUniqueID().equals(subItemID)) continue;
            found = true;
            job.setConditionSatisifed(true);
            break;
        }
        return found;
    }

    @Override
    public String getUniqueID() {
        return this.mFlow.getUniqueID();
    }

    @Override
    protected RunningItem copy() {
        RunningFlow newFlow = new RunningFlow(this.getFlowManager());
        newFlow.copyFrom(this);
        return newFlow;
    }

    @Override
    protected void copyFrom(RunningItem sourceItem) {
        super.copyFrom(sourceItem);
        if (sourceItem instanceof RunningFlow) {
            RunningFlow rFlow = (RunningFlow)sourceItem;
            this.mDeleted = rFlow.mDeleted;
            this.mID = rFlow.mID;
            this.mInvokingUser = rFlow.mInvokingUser;
            this.mKilled = rFlow.mKilled;
            this.mTriggered = rFlow.mTriggered;
            for (RunningItem subItem : rFlow.mSubItems) {
                RunningItem copiedItem = subItem.copy();
                copiedItem.mParent = this;
            }
        }
    }

    @Override
    public String toString() {
        String parentString = super.toString();
        StringBuffer buffer = new StringBuffer();
        buffer.append(parentString);
        buffer.append("ID: " + this.mID);
        buffer.append("Deleted?: " + this.mDeleted);
        buffer.append("Invoking user: " + this.mInvokingUser);
        buffer.append("Killed? :" + this.mKilled);
        buffer.append("Subitem count: " + this.mSubItems.size());
        buffer.append("Triggered: " + this.mTriggered);
        return buffer.toString();
    }

    public void initializeFromHistory(FlowHistory hist) {
        this.mStartTime = hist.getStartTime();
        this.mFinishTime = hist.getFinishTime();
        this.mComplete = true;
        this.mCompletionCode = hist.getCompletionCode();
        if (this.mCompletionCode == 1) {
            this.mKilled = true;
        }
        this.mInvokingUser = hist.getInvoker();
        this.mDeleted = false;
        this.mHeld = false;
        this.mID = hist.getID();
        if (this.getParent() == null && this.mCompletionCode == 16) {
            this.mCompletionCode = 8;
        }
        this.mDeadlineTime = null;
        if (this.mCompletionCode == 8) {
            this.mTriggered = true;
            this.mComplete = false;
            if (this.mStartTime == null) {
                this.mStartTime = new GregorianCalendar();
            }
            if (this.getFlow().getMaximumRunTime() > 0) {
                this.mDeadlineTime = (Calendar)this.mStartTime.clone();
                this.mDeadlineTime.add(12, this.getFlow().getMaximumRunTime());
            }
        }
    }

    public List<FileDependency> findActiveFileConditions() {
        ArrayList<FileDependency> results = new ArrayList<FileDependency>();
        for (RunningItem item : this.mSubItems) {
            RunningJob rj;
            if (item instanceof RunningFlow) {
                RunningFlow rf = (RunningFlow)item;
                if (!rf.isTriggered()) {
                    FileDependency.findAllFileDependencies(rf.getFlow().getRunConditions(), results);
                }
                List<FileDependency> otherDeps = rf.findActiveFileConditions();
                results.addAll(otherDeps);
                continue;
            }
            if (!(item instanceof RunningJob) || (rj = (RunningJob)item).getCompletionCode() != 16) continue;
            FileDependency.findAllFileDependencies(rj.getJob().getRunConditions(), results);
        }
        return results;
    }
}

