/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.JobDependency;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RunItemFinishedDependency
extends JobDependency {
    private int mSeconds = 0;
    private int mComparisonCode = 10;
    static final String XML_RunItemFinishedDependency_Tag = "RunItemFinishedDependency";
    private static final String XML_Seconds_Tag = "LengthInSeconds";

    public RunItemFinishedDependency(ClientLogger logger) {
        super(logger);
    }

    public int getComparisonCode() {
        return this.mComparisonCode;
    }

    public int getSeconds() {
        return this.mSeconds;
    }

    public void setExecutionLength(int durationInSeconds, int comparisonCode) {
        if (durationInSeconds >= 0 && (comparisonCode == 12 || comparisonCode == 15 || comparisonCode == 10 || comparisonCode == 13 || comparisonCode == 11 || comparisonCode == 14)) {
            this.mSeconds = durationInSeconds;
            this.mComparisonCode = comparisonCode;
        }
    }

    @Override
    public RunCondition copy() {
        RunItemFinishedDependency dep = new RunItemFinishedDependency(this.mLogger);
        dep.mSeconds = this.mSeconds;
        dep.mComparisonCode = this.mComparisonCode;
        dep.copyFrom(this);
        return dep;
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_RunItemFinishedDependency_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_Seconds_Tag, Integer.toString(this.mSeconds));
        tag.setAttribute("ComparisonCode", Integer.toString(this.mComparisonCode));
        tag.setAttribute("JobID", this.getJobID());
    }

    @Override
    public String toString() {
        StringBuffer printString = new StringBuffer();
        printString.append("Waits for job: " + this.getJobID() + " to finish after taking ");
        switch (this.mComparisonCode) {
            case 12: {
                printString.append("=");
                break;
            }
            case 15: {
                printString.append("!=");
                break;
            }
            case 10: {
                printString.append(">");
                break;
            }
            case 13: {
                printString.append(">=");
                break;
            }
            case 11: {
                printString.append("<");
                break;
            }
            case 14: {
                printString.append("<=");
            }
        }
        printString.append(this.mSeconds);
        printString.append(" seconds.");
        return printString.toString();
    }

    @Override
    public int canExecute(FlowManager manager, Calendar currentTime, Map<String, Long> usedTimes, Map<String, Long> outputUsedTimes, Calendar outputNextTriggerTime, boolean defaultValue) {
        this.setTimeForFutureCheck(currentTime, outputNextTriggerTime);
        if (this.getDependentItem() == null) {
            return defaultValue ? 56 : 58;
        }
        if (this.getDependentItem().isComplete()) {
            if (this.mSeconds > 0) {
                Calendar startTime = this.getDependentItem().getStartTime();
                Calendar endTime = this.getDependentItem().getFinishTime();
                if (startTime == null || endTime == null) {
                    return 58;
                }
                long timeTaken = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 1000L;
                switch (this.mComparisonCode) {
                    case 10: {
                        if (timeTaken <= (long)this.mSeconds) break;
                        return 56;
                    }
                    case 11: {
                        if (timeTaken >= (long)this.mSeconds) break;
                        return 56;
                    }
                    case 14: {
                        if (timeTaken > (long)this.mSeconds) break;
                        return 56;
                    }
                    case 13: {
                        if (timeTaken < (long)this.mSeconds) break;
                        return 56;
                    }
                    case 12: {
                        if (timeTaken != (long)this.mSeconds) break;
                        return 56;
                    }
                    case 15: {
                        if (timeTaken == (long)this.mSeconds) break;
                        return 56;
                    }
                }
                return 58;
            }
            return 56;
        }
        return 57;
    }

    static RunCondition processFinishedCondition(Node node, ClientLogger logger) {
        Node jobIDNode;
        RunItemFinishedDependency dependency = new RunItemFinishedDependency(logger);
        NamedNodeMap attributes = node.getAttributes();
        dependency.processAttributes(attributes);
        Node comparisonNode = attributes.getNamedItem("ComparisonCode");
        int comparisonCode = -1;
        if (comparisonNode != null) {
            try {
                comparisonCode = Integer.valueOf(comparisonNode.getNodeValue());
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        if ((jobIDNode = attributes.getNamedItem("JobID")) != null) {
            dependency.setDependentJobID(jobIDNode.getNodeValue());
        }
        Node secondsNode = attributes.getNamedItem(XML_Seconds_Tag);
        int seconds = 0;
        if (secondsNode != null) {
            try {
                seconds = Integer.valueOf(secondsNode.getNodeValue());
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        dependency.setExecutionLength(seconds, comparisonCode);
        return dependency;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RunItemFinishedDependency)) {
            return false;
        }
        RunItemFinishedDependency other = (RunItemFinishedDependency)obj;
        if (other.mSeconds != this.mSeconds) {
            return false;
        }
        if (other.mComparisonCode != this.mComparisonCode) {
            return false;
        }
        return super.equals(obj);
    }
}

