/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.JobDependency;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RunItemExitCodeDependency
extends JobDependency {
    private int mExitCode;
    private int mComparisonCode;
    static final String XML_RunItemExitCodeDependency_Tag = "RunItemCodeDependency";
    private static final String XML_ExitCode_Tag = "ExitCode";

    public RunItemExitCodeDependency(ClientLogger logger) {
        super(logger);
        this.mExitCode = 0;
        this.mComparisonCode = 12;
    }

    public RunItemExitCodeDependency(int exitCode, int compareCode, ClientLogger logger) {
        super(logger);
        this.mExitCode = exitCode;
        this.mComparisonCode = compareCode;
    }

    public int getExitCode() {
        return this.mExitCode;
    }

    public void setExitCode(int exitCode) {
        this.mExitCode = exitCode;
    }

    public int getComparisonCode() {
        return this.mComparisonCode;
    }

    public void setComparisonCode(int comparisonCode) {
        if (comparisonCode == 12 || comparisonCode == 15 || comparisonCode == 10 || comparisonCode == 13 || comparisonCode == 11 || comparisonCode == 14) {
            this.mComparisonCode = comparisonCode;
        }
    }

    @Override
    public RunCondition copy() {
        RunItemExitCodeDependency dep = new RunItemExitCodeDependency(this.mLogger);
        dep.setExitCode(this.mExitCode);
        dep.setComparisonCode(this.mComparisonCode);
        dep.copyFrom(this);
        return dep;
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_RunItemExitCodeDependency_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_ExitCode_Tag, Integer.toString(this.mExitCode));
        tag.setAttribute("ComparisonCode", Integer.toString(this.mComparisonCode));
        tag.setAttribute("JobID", this.getJobID());
    }

    @Override
    public String toString() {
        StringBuffer printString = new StringBuffer();
        printString.append("Waits for job: " + this.getJobID() + " to finish with return code ");
        switch (this.mComparisonCode) {
            case 12: {
                printString.append("=");
                break;
            }
            case 15: {
                printString.append("!=");
                break;
            }
            case 10: {
                printString.append(">");
                break;
            }
            case 13: {
                printString.append(">=");
                break;
            }
            case 11: {
                printString.append("<");
                break;
            }
            case 14: {
                printString.append("<=");
            }
        }
        printString.append(this.mExitCode);
        return printString.toString();
    }

    @Override
    public int canExecute(FlowManager manager, Calendar currentTime, Map<String, Long> usedTimes, Map<String, Long> outputUsedTimes, Calendar outputNextTriggerTime, boolean defaultValue) {
        this.setTimeForFutureCheck(currentTime, outputNextTriggerTime);
        if (this.getDependentItem() == null) {
            return defaultValue ? 56 : 58;
        }
        if (this.getDependentItem().isComplete()) {
            RunningItem item = this.getDependentItem();
            if (item.getCompletionCode() == 4 || item.getCompletionCode() == 2) {
                int rc = item.getExitCode();
                switch (this.mComparisonCode) {
                    case 12: {
                        if (rc != this.mExitCode) break;
                        return 56;
                    }
                    case 15: {
                        if (rc == this.mExitCode) break;
                        return 56;
                    }
                    case 10: {
                        if (rc <= this.mExitCode) break;
                        return 56;
                    }
                    case 11: {
                        if (rc >= this.mExitCode) break;
                        return 56;
                    }
                    case 14: {
                        if (rc > this.mExitCode) break;
                        return 56;
                    }
                    case 13: {
                        if (rc < this.mExitCode) break;
                        return 56;
                    }
                }
            }
            return 58;
        }
        return 57;
    }

    static RunCondition processExitCodeCondition(Node node, ClientLogger logger) {
        Node exitCodeNode;
        Node jobIDNode;
        RunItemExitCodeDependency dependency = new RunItemExitCodeDependency(logger);
        NamedNodeMap attributes = node.getAttributes();
        dependency.processAttributes(attributes);
        Node comparisonNode = attributes.getNamedItem("ComparisonCode");
        if (comparisonNode != null) {
            try {
                dependency.setComparisonCode(Integer.valueOf(comparisonNode.getNodeValue()));
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        if ((jobIDNode = attributes.getNamedItem("JobID")) != null) {
            dependency.setDependentJobID(jobIDNode.getNodeValue());
        }
        if ((exitCodeNode = attributes.getNamedItem(XML_ExitCode_Tag)) != null) {
            try {
                dependency.setExitCode(Integer.valueOf(exitCodeNode.getNodeValue()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dependency;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RunItemExitCodeDependency)) {
            return false;
        }
        RunItemExitCodeDependency other = (RunItemExitCodeDependency)obj;
        if (other.mExitCode != this.mExitCode) {
            return false;
        }
        if (other.mComparisonCode != this.mComparisonCode) {
            return false;
        }
        return super.equals(obj);
    }
}

