/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FileAgeDependency;
import com.sas.scheduler.api.servers.ip.engine.FileExistsDependency;
import com.sas.scheduler.api.servers.ip.engine.FileSizeDependency;
import com.sas.scheduler.api.servers.ip.engine.FileStatusListener;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import com.sas.scheduler.api.servers.ip.engine.RunItemExitCodeDependency;
import com.sas.scheduler.api.servers.ip.engine.RunItemFinishedDependency;
import com.sas.scheduler.api.servers.ip.engine.RunItemStartedDependency;
import com.sas.scheduler.api.servers.ip.engine.RunItemStatusDependency;
import com.sas.scheduler.api.servers.ip.engine.TimeDependency;
import com.sas.scheduler.model.SchedulerException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RunCondition {
    public static final int Comparison_GT = 10;
    public static final int Comparison_LT = 11;
    public static final int Comparison_EQ = 12;
    public static final int Comparison_GTEQ = 13;
    public static final int Comparison_LTEQ = 14;
    public static final int Comparison_NE = 15;
    static final String XML_ComparisonCode_Tag = "ComparisonCode";
    static final String XML_ID_Tag = "ID";
    public static final int CanRunNow_YES = 56;
    public static final int CanRunNow_NO = 57;
    public static final int CanRunNow_NEVER = 58;
    protected ClientLogger mLogger;
    protected String mID;
    private static Map<String, XMLRunConditionMapVector> mXMLParseVector = new HashMap<String, XMLRunConditionMapVector>();

    public RunCondition(ClientLogger logger) {
        this.mLogger = logger;
        this.mID = "";
    }

    void findRequiredFileTimers(boolean timeIsDominant, List<FileStatusListener> results) {
    }

    boolean isTimeDominant() {
        return false;
    }

    public int canRunNow(FlowManager manager, Calendar currentTime, Calendar outputNextRunTime) {
        return this.canExecute(manager, currentTime, null, null, outputNextRunTime, true);
    }

    public abstract int canExecute(FlowManager var1, Calendar var2, Map<String, Long> var3, Map<String, Long> var4, Calendar var5, boolean var6);

    public boolean canTriggerNow(FlowManager manager, Calendar currentTime, Map<String, Long> usedTimes, Map<String, Long> outputUsedTimes, Calendar outputNextTriggerTime) {
        return this.canExecute(manager, currentTime, usedTimes, outputUsedTimes, outputNextTriggerTime, false) == 56;
    }

    public boolean willNotRun(FlowManager manager, Calendar startTime, Calendar deadlineTime) {
        return false;
    }

    protected void injectXML(Document doc, Element parent) {
        parent.setAttribute(XML_ID_Tag, this.mID);
    }

    public abstract RunCondition copy();

    protected void copyFrom(RunCondition cond) {
        this.mID = cond.mID;
        this.mLogger = cond.mLogger;
    }

    public void triggerHasBeenUsed() {
    }

    public String toString() {
        return this.toSerializedForm();
    }

    public static RunCondition processConditionDirectly(Node conditionNode, ClientLogger logger) {
        String tagName = conditionNode.getNodeName();
        RunCondition returnValue = null;
        XMLRunConditionMapVector vector = mXMLParseVector.get(tagName);
        if (vector != null) {
            returnValue = vector.getCondition(conditionNode, logger);
        }
        if (returnValue != null) {
            return returnValue;
        }
        return null;
    }

    public static RunCondition processCondition(Node conditionNode, ClientLogger logger) {
        NodeList children = conditionNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            RunCondition returnValue = RunCondition.processConditionDirectly(child, logger);
            if (returnValue == null) continue;
            return returnValue;
        }
        return null;
    }

    protected void processAttributes(NamedNodeMap attributes) {
        Node idNode = attributes.getNamedItem(XML_ID_Tag);
        if (idNode != null) {
            String id;
            this.mID = id = idNode.getNodeValue();
        }
    }

    public String toSerializedForm() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            this.serialize(doc, doc);
            return FlowInstance.emitXML(doc, this.mLogger);
        }
        catch (ParserConfigurationException e) {
            this.mLogger.logMessage(Level.WARNING, e);
            return "";
        }
    }

    public String getID() {
        return this.mID;
    }

    public void recalculateID(String parentConditionID) {
        StringBuffer buffer = new StringBuffer();
        if (parentConditionID != null) {
            buffer.append(parentConditionID);
            buffer.append('_');
        }
        this.mID = "";
        buffer.append(Integer.toString(this.toSerializedForm().hashCode()));
        this.mID = buffer.toString();
    }

    public abstract void serialize(Document var1, Node var2);

    public boolean equals(Object obj) {
        if (!(obj instanceof RunCondition)) {
            return false;
        }
        RunCondition other = (RunCondition)obj;
        return other.mID.equals(this.mID);
    }

    static {
        mXMLParseVector.put("RunConditions", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                return RunConditions.processConditions(conditionNode, logger);
            }
        });
        mXMLParseVector.put("TimeDependency", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                try {
                    return TimeDependency.processTimeCondition(conditionNode, logger);
                }
                catch (SchedulerException e) {
                    return null;
                }
            }
        });
        mXMLParseVector.put("FileExistsDependency", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                return FileExistsDependency.processExistsCondition(conditionNode, logger);
            }
        });
        mXMLParseVector.put("FileSizeDependency", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                return FileSizeDependency.processSizeCondition(conditionNode, logger);
            }
        });
        mXMLParseVector.put("FileAgeDependency", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                return FileAgeDependency.processAgeCondition(conditionNode, logger);
            }
        });
        mXMLParseVector.put("RunItemCodeDependency", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                return RunItemExitCodeDependency.processExitCodeCondition(conditionNode, logger);
            }
        });
        mXMLParseVector.put("RunItemFinishedDependency", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                return RunItemFinishedDependency.processFinishedCondition(conditionNode, logger);
            }
        });
        mXMLParseVector.put("RunItemStartedDependency", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                return RunItemStartedDependency.processStartedCondition(conditionNode, logger);
            }
        });
        mXMLParseVector.put("RunItemStatusDependency", new XMLRunConditionMapVector(){

            @Override
            public RunCondition getCondition(Node conditionNode, ClientLogger logger) {
                return RunItemStatusDependency.processStatusCondition(conditionNode, logger);
            }
        });
    }

    private static interface XMLRunConditionMapVector {
        public RunCondition getCondition(Node var1, ClientLogger var2);
    }
}

