/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;

public class InProcessUserSession
extends AbstractUserSession {
    private String mUserID = "";
    private FlowManager mManager = null;

    InProcessUserSession(String sessionID) {
        super(sessionID);
    }

    @Override
    public FlowManager getFlowManager() {
        return this.mManager;
    }

    public static InProcessUserSession CreateUserSession(FlowManager manager, String sessionID, String userID) {
        if (userID == null) {
            return null;
        }
        InProcessUserSession session = new InProcessUserSession(sessionID);
        session.setUserID(userID);
        session.setFlowManager(manager);
        return session;
    }

    @Override
    public void setFlowManager(FlowManager manager) {
        if (this.mManager == null) {
            this.mManager = manager;
        }
    }

    private void setUserID(String userName) {
        this.mUserID = userName;
    }

    @Override
    public String getUserID() {
        return this.mUserID;
    }

    @Override
    public String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toSerializedForm());
        buffer.append("\n");
        buffer.append(this.getUserID());
        return buffer.toString();
    }

    public static AbstractUserSession CreateFromSerializedForm(String serializedUserSession) {
        try {
            String[] dataItems = serializedUserSession.split("\n");
            if (dataItems.length >= 2) {
                InProcessUserSession session = new InProcessUserSession("");
                session.mSessionID = dataItems[0];
                session.mLastUsedTime = Long.parseLong(dataItems[1]);
                session.mUserID = dataItems.length >= 3 ? dataItems[2] : "";
                return session;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

