/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.ProcessOutputReader;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlowIDInfo;
import java.io.Reader;
import java.util.Calendar;
import java.util.List;

public abstract class AbstractUserSession {
    protected long mLastUsedTime = 0L;
    protected String mSessionID;

    public abstract FlowManager getFlowManager();

    public abstract void setFlowManager(FlowManager var1);

    public String getSessionID() {
        return this.mSessionID;
    }

    public AbstractUserSession(String sessionID) {
        this.mSessionID = sessionID;
    }

    public boolean terminateSession() {
        return this.getFlowManager().terminateSession(this.getSessionID());
    }

    public void shutDownServer() {
        try {
            this.getFlowManager().shutDownServer(this.getSessionID());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] addFlows(TopLevelFlow[] newFlows) {
        return this.getFlowManager().addFlows(this.mSessionID, newFlows);
    }

    public String[] deleteFlows(String[] flowIDs) {
        return this.getFlowManager().deleteFlows(this.getSessionID(), flowIDs);
    }

    public String[] killFlowInstances(String[] flowInstanceIDs, boolean force) {
        return this.getFlowManager().killFlowInstances(this.getSessionID(), flowInstanceIDs, force);
    }

    public boolean killExecutionItem(String flowInstanceID, String subItemID, boolean force) {
        return this.getFlowManager().killExecutionItem(this.getSessionID(), flowInstanceID, subItemID, force);
    }

    public String[] runFlows(String[] flowIDs) {
        return this.getFlowManager().runFlows(this.getSessionID(), flowIDs);
    }

    public boolean triggerExecutionItem(String flowInstanceID, String subItemID) {
        return this.getFlowManager().triggerExecutionItem(this.getSessionID(), flowInstanceID, subItemID);
    }

    public FlowHistory[] getFlowHistory(String[] flowIDs, int count) {
        return this.getFlowManager().getFlowHistories(this.getSessionID(), flowIDs, count);
    }

    public FlowHistory[] getFlowHistory(HistorySearchOptions options) {
        FlowHistory[] histories = this.getFlowManager().getFlowHistory(this.getSessionID(), options);
        return histories;
    }

    public TopLevelFlowIDInfo[] getAllFlowIDs() {
        TopLevelFlowIDInfo[] flowInfos = this.getFlowManager().getAllFlowIDs(this.getSessionID());
        return flowInfos;
    }

    public TopLevelFlow[] getFlowDefinitions(String[] flowIDs) {
        TopLevelFlow[] flowDefs = this.getFlowManager().getFlowDefinitions(this.getSessionID(), flowIDs);
        return flowDefs;
    }

    public FlowInstance[] getInstanceDefinitions(String[] instanceIDs) {
        FlowInstance[] flowInstances = this.getFlowManager().getInstanceDefinitions(this.getSessionID(), instanceIDs);
        return flowInstances;
    }

    public boolean updateFlow(TopLevelFlow updatedFlow) {
        return this.getFlowManager().updateFlow(this.getSessionID(), updatedFlow);
    }

    public Reader getOutputStreamData(String flowID, String instanceID, String uniqueSubitemID) {
        return new ProcessOutputReader(this, flowID, instanceID, uniqueSubitemID, true);
    }

    public Reader getErrorStreamData(String flowID, String instanceID, String uniqueSubitemID) {
        return new ProcessOutputReader(this, flowID, instanceID, uniqueSubitemID, false);
    }

    String getID() {
        return this.getSessionID();
    }

    public abstract String getUserID();

    public String getFlowID(String flowName) {
        return this.getFlowManager().getFlowID(this.getSessionID(), flowName);
    }

    public boolean isAdministrator() {
        return this.getFlowManager().isAdministrator(this.getSessionID());
    }

    long getLastUsedTime() {
        return this.mLastUsedTime;
    }

    void updateUsedTime() {
        this.mLastUsedTime = System.currentTimeMillis();
    }

    public String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.mSessionID);
        buffer.append("\n");
        buffer.append(Long.toString(this.mLastUsedTime));
        return buffer.toString();
    }

    public List<Long> getNextTriggerTimes(List<String> flowIDs, Calendar startTime) {
        return this.getFlowManager().getNextTriggerTimes(flowIDs, startTime);
    }

    public List<Long> getScheduledTriggerTimes(String flowID, Calendar startTime, Calendar endTime, int count) {
        return this.getFlowManager().getScheduleOfTriggerTimes(this.getSessionID(), flowID, startTime, endTime, count);
    }

    public String[] holdFlows(String[] flowIDs) {
        return this.getFlowManager().holdFlows(this.mSessionID, flowIDs);
    }

    public String[] releaseFlows(String[] flowIDs) {
        return this.getFlowManager().releaseFlows(this.mSessionID, flowIDs);
    }

    public String getJobRoutingXML() {
        return this.getFlowManager().getJobRoutingRulesXML(this.mSessionID);
    }

    public boolean setJobRoutingXML(String newXML) {
        return this.getFlowManager().setJobRoutingRulesXML(this.mSessionID, newXML);
    }
}

