/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ExtraRunItemOptions {
    private int mMaxRunTime = 360;

    protected ExtraRunItemOptions() {
    }

    public String toSerializedForm(ClientLogger logger) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            this.serialize(doc, doc);
            return FlowInstance.emitXML(doc, logger);
        }
        catch (ParserConfigurationException e) {
            logger.logMessage(Level.WARNING, e);
            return "";
        }
    }

    public String toString() {
        return this.toSerializedForm(FlowManager.getDefaultLogger());
    }

    protected void injectXML(Document doc, Element options) {
        options.setAttribute("MaxRuntime", Long.toString(this.mMaxRunTime));
    }

    protected abstract void serialize(Document var1, Node var2);

    public int getMaxRunTime() {
        return this.mMaxRunTime;
    }

    public void setMaxRunTime(int maxRunTime) {
        if (maxRunTime >= 0) {
            this.mMaxRunTime = maxRunTime;
        }
    }

    public static void processRunItemOptionsTag(ExtraRunItemOptions options, Node node, ClientLogger logger) {
        NamedNodeMap attributes = node.getAttributes();
        Node countNode = attributes.getNamedItem("MaxRuntime");
        if (countNode != null) {
            try {
                options.setMaxRunTime(Integer.parseInt(countNode.getNodeValue()));
            }
            catch (Exception e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExtraRunItemOptions)) {
            return false;
        }
        return this.mMaxRunTime == ((ExtraRunItemOptions)obj).mMaxRunTime;
    }
}

