/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.deployjob.DataStepProgramDeployer;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.IConsole;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.ip.DIPServiceProxy;
import com.sas.scheduler.api.servers.ip.IPScheduler;
import com.sas.scheduler.api.servers.ip.PIPScheduler;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.services.ServiceException;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.information.OMIServer;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.omg.CORBA.StringHolder;

public abstract class SchedulerIMPL
implements Scheduler {
    private static final ResourceBundle m_bundle;
    protected SchedulerServerInfo m_schedulingServer;
    protected String m_subType = null;
    protected String m_productName = null;
    protected String m_softwareVersion = null;
    protected int m_majorVersion = 0;
    protected int m_minorVersion = 0;
    protected boolean m_appServerResource = false;
    protected boolean m_connected = false;
    protected boolean m_defaultsSet = false;
    public static final int DefaultLineBufferSize = 1024;
    public static final String INVALIDCHARACTERS;
    public static final String INVALIDFILENAMECHARACTERS;
    public static final String INVALIDFLOWNAMECHARACTERS;
    public static final String INVALIDJOBNAMECHARACTERS;
    public static final char SUBCHAR;

    public SchedulerIMPL() {
    }

    public SchedulerIMPL(SchedulerServerInfo info) {
        this.m_schedulingServer = info;
    }

    @Override
    public boolean areDefaultsSet() {
        return this.m_defaultsSet;
    }

    @Override
    public void setDefaultsSet(boolean value) {
        this.m_defaultsSet = value;
    }

    @Override
    public String createFileConditionString(String filename, int type, int operator, long value) throws SchedulerException {
        if (filename != null) {
            FileEventInfo fei = new FileEventInfo(this.m_schedulingServer, filename, type, operator, value);
            return fei.generateDefinition();
        }
        throw new SchedulerException("MISSING FILENAME IN createFileConditionString()");
    }

    @Override
    public String getFileNameFromConditionString(String conditionString) {
        FileEventInfo fei = new FileEventInfo();
        fei.initFromDefinition(conditionString);
        return fei.getFileName();
    }

    @Override
    public int getFileTypeFromConditionString(String conditionString) {
        FileEventInfo fei = new FileEventInfo();
        fei.initFromDefinition(conditionString);
        return fei.getEventType();
    }

    @Override
    public int getFileOperatorFromConditionString(String conditionString) {
        FileEventInfo fei = new FileEventInfo();
        fei.initFromDefinition(conditionString);
        return fei.getOperator();
    }

    @Override
    public long getFileValueFromConditionString(String conditionString) {
        FileEventInfo fei = new FileEventInfo();
        fei.initFromDefinition(conditionString);
        return fei.getValue();
    }

    @Override
    public String createConditionString(String calname, String username, String hour, String minutes, String duration) {
        return this.createConditionString(calname, username, hour, minutes, duration, null, null);
    }

    @Override
    public String createConditionString(String calname, String username, String hour, String minutes, String duration, String timezone) {
        return this.createConditionString(calname, username, hour, minutes, duration, null, timezone);
    }

    @Override
    public String createConditionString(String calname, String username, String hour, String minutes, String duration, String occur, String timezone) {
        Object[] args = new Object[]{calname, username, hour, minutes, duration};
        return MessageFormat.format("{0}@{1}:{2}:{3}:{4}", args);
    }

    @Override
    public String getCalNameFromConditionString(String conditionString) {
        int endindex = conditionString.indexOf("@");
        if (endindex <= 0) {
            return null;
        }
        String calname = conditionString.substring(0, endindex).trim();
        return calname;
    }

    @Override
    public String getUserNameFromConditionString(String conditionString) {
        int startindex = conditionString.indexOf("@");
        if (startindex <= 0) {
            return null;
        }
        String user = conditionString.substring(startindex);
        int endindex = user.indexOf(":");
        if (endindex < 0) {
            return null;
        }
        user = user.substring(1, endindex);
        return user;
    }

    @Override
    public String getHourFromConditionString(String conditionString) {
        int startindex = conditionString.indexOf("@");
        if (startindex <= 0) {
            return null;
        }
        String temp = conditionString.substring(startindex);
        if ((startindex = temp.indexOf(":")) < 0) {
            return null;
        }
        int endindex = (temp = temp.substring(startindex + 1)).indexOf(":");
        if (endindex < 0) {
            return null;
        }
        String hour = GeneralUtilities.replaceString((String)temp.substring(0, endindex), (String)";", (String)",");
        return hour;
    }

    @Override
    public int[] getListFromHourMinuteStr(String str) {
        if (str.indexOf(42) >= 0) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        }
        if (str.indexOf(",") > 0) {
            String[] strlist = str.split(",");
            int[] list = new int[strlist.length];
            for (int x = 0; x < strlist.length; ++x) {
                list[x] = Integer.valueOf(strlist[x]);
            }
            return list;
        }
        if (str.indexOf("-") > 0) {
            int dash = str.indexOf("-");
            Integer firstNum = Integer.valueOf(str.substring(0, dash));
            Integer lastNum = Integer.valueOf(str.substring(dash + 1));
            int[] list = new int[lastNum - firstNum];
            for (int x = firstNum.intValue(); x <= lastNum; ++x) {
                list[x - firstNum.intValue()] = x;
            }
            return list;
        }
        return new int[]{Integer.valueOf(str)};
    }

    @Override
    public String getMinuteFromConditionString(String conditionString) {
        int startindex = conditionString.indexOf("@");
        if (startindex <= 0) {
            return null;
        }
        String temp = conditionString.substring(startindex);
        if ((startindex = temp.indexOf(":")) < 0) {
            return null;
        }
        if ((startindex = (temp = temp.substring(startindex + 1)).indexOf(":")) < 0) {
            return null;
        }
        int endindex = (temp = temp.substring(startindex + 1)).indexOf(":");
        if (endindex < 0) {
            return null;
        }
        String minute = GeneralUtilities.replaceString((String)temp.substring(0, endindex), (String)";", (String)",");
        return minute;
    }

    @Override
    public String getDurationFromConditionString(String conditionString) {
        int startindex = conditionString.indexOf("@");
        if (startindex <= 0) {
            return null;
        }
        String duration = null;
        String temp = conditionString;
        startindex = temp.indexOf(":");
        if (startindex < 0) {
            return null;
        }
        if ((startindex = (temp = temp.substring(startindex + 1)).indexOf(":")) < 0) {
            return null;
        }
        if ((startindex = (temp = temp.substring(startindex + 1)).indexOf(":")) < 0) {
            return null;
        }
        int endindex = (temp = temp.substring(startindex + 1)).indexOf(":");
        duration = endindex < 0 ? temp : temp.substring(0, endindex);
        return duration;
    }

    @Override
    public String getOccurrenceFromConditionString(String conditionString) {
        return null;
    }

    @Override
    public String getTimezoneFromConditionString(String conditionString) {
        return null;
    }

    @Override
    public boolean removeFlow(DeployedFlow flow) throws SchedulerException {
        return this.removeFlow(flow.getInfo(), null);
    }

    @Override
    public boolean removeFlow(FlowInfo flow) throws SchedulerException {
        return this.removeFlow(flow, null);
    }

    public boolean removeFlow(FlowInfo flow, String triggerType) throws SchedulerException {
        return this.removeFlow(this.genFlowName(flow, this));
    }

    protected static PasswordAuthentication getUserConnection(SchedulerServerInfo schedulingServer) {
        block8: {
            try {
                SessionContextInterface sessionContext = MetaUtilities.getSessionContext();
                if (sessionContext == null) break block8;
                UserContextInterface userContext = sessionContext.getUserContext();
                String domain = MetaUtilities.getDomain(schedulingServer);
                if (domain != null) {
                    UserIdentityInterface uId = userContext.getIdentityByDomain(domain);
                    if (uId != null) {
                        String user = (String)uId.getPrincipal();
                        return new PasswordAuthentication(user.toString(), SasPasswordString.decode((String)((String)uId.getCredential())).toCharArray());
                    }
                    break block8;
                }
                try {
                    String user = userContext.getResolvedUserId();
                    OMIServer server = (OMIServer)userContext.getAuthServer();
                    return new PasswordAuthentication(user, SasPasswordString.decode((String)server.getCredentials(user)).toCharArray());
                }
                catch (ServiceException e) {
                    e.toString();
                }
            }
            catch (SecurityException e) {
                e.toString();
            }
            catch (SasPasswordEncodingException e) {
                e.toString();
            }
            catch (Exception ex) {
                ex.toString();
            }
        }
        return null;
    }

    public void setAlternativeUserContext(UserContextInterface user, String domain) {
    }

    public boolean connectToSchedulingServer() throws SchedulerException {
        return this.maketheConnection();
    }

    @Override
    public boolean connectToSchedulingServer(PromptCallbackInterface prompt) {
        int rc = 0;
        while (rc == 0) {
            try {
                rc = this.makeConnection(prompt);
            }
            catch (InvalidParameterException ex) {
                prompt.showResults(m_bundle.getString("SchedulerIMPL.CannotConnectToSchedulerTitle.txt"), new SchedulerResultSet(0, ex.getLocalizedMessage(), (DisplayInfo)this.m_schedulingServer));
                return false;
            }
            catch (SchedulerException ex) {
                Object[] options = new Object[]{m_bundle.getString("SchedulerIMPL.Option.Okay.txt"), m_bundle.getString("SchedulerIMPL.Option.Cancel.txt")};
                int response = prompt.promptMessage(ex.getLocalizedMessage(), m_bundle.getString("SchedulerIMPL.CannotConnectToSchedulerTitle.txt"), options);
                if (response != 1) continue;
                return false;
            }
        }
        if (rc == 1) {
            return true;
        }
        if (rc == 4) {
            String name = null;
            name = this.m_schedulingServer.getName();
            prompt.showResults(m_bundle.getString("SchedulerIMPL.CannotConnectToSchedulerTitle.txt"), new SchedulerResultSet(0, MessageFormat.format(m_bundle.getString("SchedulerIMPL.UnsupportedSchedulerOperation.fmt"), name), (DisplayInfo)this.m_schedulingServer));
            return false;
        }
        return false;
    }

    @Override
    public int makeConnection(PromptCallbackInterface prompt) throws SchedulerException {
        int rc;
        if (this.isConnected()) {
            rc = 1;
        } else {
            rc = 0;
            if (this.maketheConnection()) {
                this.m_connected = true;
                rc = 1;
            } else if (prompt == null) {
                this.m_connected = false;
                rc = 4;
            } else if (this instanceof IPScheduler && !(this instanceof PIPScheduler) && !(this instanceof DIPServiceProxy)) {
                rc = 4;
            } else if (this instanceof LSFScheduler && !LSFScheduler.getJSLoginRequired()) {
                rc = 3;
            } else {
                String loginTitle = MessageFormat.format(m_bundle.getString("SchedulerIMPL.Logon.title.fmt"), this.m_schedulingServer.getName());
                String[] cred = prompt.promptLogin(loginTitle, this.m_schedulingServer.getUsername(), this.m_schedulingServer.getPassword());
                int promptrc = Integer.valueOf(cred[0]);
                if (promptrc == 1) {
                    this.m_schedulingServer.setUsername(cred[1]);
                    this.m_schedulingServer.setPassword(cred[2]);
                    if (cred[1].trim().length() == 0) {
                        this.m_connected = false;
                        rc = 0;
                    } else if (this.maketheConnection()) {
                        this.m_connected = true;
                        if (!MetaUtilities.isAllowPasswordCache()) {
                            this.m_schedulingServer.setPassword(null);
                        }
                        rc = 1;
                    }
                } else {
                    this.m_connected = false;
                    rc = 2;
                }
            }
        }
        return rc;
    }

    @Override
    @Deprecated
    public int makeConnection(String user, String pass) throws SchedulerException {
        return this.makeConnection(user, pass != null ? new SealedString(pass) : null);
    }

    @Override
    public int makeConnection(String user, SealedString pass) throws SchedulerException {
        boolean tryConnection = false;
        String oldUser = this.m_schedulingServer.getUsername();
        if (oldUser == null || oldUser.compareTo(user) != 0 || !this.m_connected) {
            tryConnection = true;
        }
        if (tryConnection) {
            if ((pass != null ? pass.getCharacters().length : 0) == 0) {
                return 3;
            }
            if (this.m_connected) {
                this.closeConnection();
            }
            this.m_connected = this.maketheConnection(user, pass);
        }
        if (this.m_connected) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean closeConnection() {
        this.m_connected = false;
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.m_connected;
    }

    @Override
    public String getCurrentUserID() {
        return this.m_schedulingServer.getUsername();
    }

    @Override
    public String getName() throws SchedulerException {
        return this.m_schedulingServer.getName();
    }

    public String getHost() {
        return this.m_schedulingServer.getHost();
    }

    public static String getOutfile(BatchServerInfo bs, String infile) {
        String outfile = null;
        outfile = infile.endsWith("\"") ? infile.substring(0, infile.length() - 1) + ".out\"" : infile + ".out";
        return outfile;
    }

    public static String getOutfile(String path, String infile) {
        String fileName;
        String baseName;
        String outfile = null;
        String sep = "/";
        if (path.endsWith("/")) {
            sep = "";
        }
        String normFilename = CommandUtilities.normalizePath(infile, -1);
        int index = normFilename.lastIndexOf(47);
        outfile = (baseName = (fileName = normFilename.substring(++index))).endsWith("\"") ? path + sep + baseName.substring(0, baseName.length() - 1) + ".out\"" : path + sep + baseName + ".out";
        return outfile;
    }

    @Deprecated
    public static boolean validateVersion(ServerComponent schedulingServer, String user, String password) throws SchedulerException {
        return SchedulerIMPL.validateVersion(schedulingServer, user, password != null ? new SealedString(password) : null);
    }

    public static boolean validateVersion(ServerComponent schedulingServer, String user, SealedString password) throws SchedulerException {
        if (schedulingServer == null) {
            return false;
        }
        try {
            Scheduler scheduler = MetaUtilities.getSchedulingServer(schedulingServer);
            SchedulerServerInfo info = scheduler.getServerComponent();
            info.setUsername(user);
            info.setPassword(password != null ? String.valueOf(password.getCharacters()) : null);
            if (scheduler.checkVersion((SchedulerIMPL)scheduler)) {
                schedulingServer.setProductName(scheduler.getProductName());
                schedulingServer.setSoftwareVersion(scheduler.getSoftwareVersion());
                schedulingServer.setMajor(scheduler.getMajorVersion());
                schedulingServer.setMinor(scheduler.getMinorVersion());
                schedulingServer.updateMetadataAll();
            }
            if (!MetaUtilities.isAllowPasswordCache()) {
                info.setPassword(null);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getSubtype() {
        return this.m_subType;
    }

    public boolean setSubtype(String type) {
        this.m_subType = type;
        return true;
    }

    @Override
    public int getMajorVersion() {
        return this.m_majorVersion;
    }

    public boolean setMajorVersion(int version) {
        this.m_majorVersion = version;
        return true;
    }

    @Override
    public int getMinorVersion() {
        return this.m_minorVersion;
    }

    public boolean setMinorVersion(int version) {
        this.m_minorVersion = version;
        return true;
    }

    @Override
    public String getProductName() {
        return this.m_productName;
    }

    public boolean setProductName(String name) {
        this.m_productName = name;
        return true;
    }

    @Override
    public String getSoftwareVersion() {
        return this.m_softwareVersion;
    }

    public boolean setSoftwareVersion(String version) {
        this.m_softwareVersion = version;
        return true;
    }

    public boolean getAppServerResource() {
        return this.m_appServerResource;
    }

    public boolean setAppServerResource(boolean flag) {
        this.m_appServerResource = flag;
        return true;
    }

    @Override
    public abstract boolean checkVersion(SchedulerIMPL var1) throws SchedulerException;

    public void checkCircularDependencies(FlowInfo flow, String id) throws SchedulerException, InvalidParameterException {
        MetaUtilities.checkCircularDependencies(flow, id);
    }

    public boolean isDebug() {
        return MetaUtilities.isDebug();
    }

    public static String createCircularDependencyMessage(String firstSentence, String successorObjects, FlowInfo flow) throws SchedulerException {
        return FlowInfo.createCircularDependencyMessage((String)firstSentence, (String)successorObjects, (FlowInfo)flow);
    }

    public void writeJCLFile(JobInfo job, String physicalName, PasswordAuthentication pa) throws SchedulerException {
        try {
            ServerComponent sc = null;
            IWorkspace workspace = null;
            String user = pa.getUserName();
            SealedString password = pa.getPassword() != null ? new SealedString(pa.getPassword()) : null;
            try {
                int port;
                JFJob jfjob = MetaUtilities.getJFJob(job.getId());
                sc = CommandUtilities.getServerComponentForJob(jfjob);
                TCPIPConnection connection = IWorkspaceServer.getTCPIPConnection(sc, "440196D4-90F0-11D0-9F41-00A024BB830C");
                if (connection == null) {
                    throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
                }
                String host = connection.getHostName();
                IWorkspaceServer workspaceServer = new IWorkspaceServer(null, "440196D4-90F0-11D0-9F41-00A024BB830C", host, port = connection.getPort());
                if (!workspaceServer.makeConnection(user, password)) {
                    throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
                }
                workspace = workspaceServer.getWorkspace();
            }
            catch (InvalidCredentialsException e) {
                throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
            }
            catch (FatalConnectionFactoryException e) {
                throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
            }
            catch (MdException e) {
                throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
            }
            catch (RemoteException e) {
                throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
            }
            IFileService rio = workspace.FileService();
            String template = CommandUtilities.getCommandLineFromBatchServer(sc);
            String jcl = DataStepProgramDeployer.GenerateJCLFromBatchServer(physicalName, user, template, workspace);
            String filerefName = "LSFTMP0";
            String accessMethodOrDevice = "DISK";
            String hostOptions = "";
            StringHolder assignedName = new StringHolder(filerefName);
            IFileref fileref = rio.AssignFileref(filerefName, accessMethodOrDevice, physicalName, hostOptions, assignedName);
            ITextStream file = fileref.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, Short.MAX_VALUE);
            file.Write(jcl);
            file.Close();
        }
        catch (NullPointerException npe) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
        }
        catch (GenericError ge) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
        }
        catch (MdException e) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
        }
        catch (RemoteException e) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
        }
    }

    public void writeJCLFile(JobInfo job, String physicalName, IWorkspace workspace) throws SchedulerException {
        try {
            String user = job.getUserId();
            JFJob jfjob = MetaUtilities.getJFJob(job.getId());
            ServerComponent sc = CommandUtilities.getServerComponentForJob(jfjob);
            String template = CommandUtilities.getCommandLineFromBatchServer(sc);
            String jcl = DataStepProgramDeployer.GenerateJCLFromBatchServer(physicalName, user, template, workspace);
            String filerefName = "LSFTMP0";
            String accessMethodOrDevice = "DISK";
            String hostOptions = "";
            StringHolder assignedName = new StringHolder(filerefName);
            IFileService rio = workspace.FileService();
            IFileref fileref = rio.AssignFileref(filerefName, accessMethodOrDevice, physicalName, hostOptions, assignedName);
            ITextStream file = fileref.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, Short.MAX_VALUE);
            file.Write(jcl);
            file.Close();
        }
        catch (NullPointerException npe) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
        }
        catch (GenericError ge) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
        }
        catch (MdException e) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
        }
        catch (RemoteException e) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("SchedulerIMPL.SchedulingDetailsError.fmt"), job.getName()));
        }
    }

    public static String replaceInvalidCharacters(String s) {
        String exp = m_bundle.getString("SchedulerIMPL.invalidCharactersExpression.lcl");
        return s.replaceAll(exp, m_bundle.getString("SchedulerIMPL.substitutionCharacter.txt"));
    }

    public static String replaceInvalidCharactersInFileName(String s) {
        String exp = m_bundle.getString("SchedulerIMPL.invalidFileNameCharactersExpression.lcl");
        return s.replaceAll(exp, m_bundle.getString("SchedulerIMPL.substitutionCharacter.txt"));
    }

    public static String replaceInvalidCharactersInFlowName(String s) {
        String subchar = m_bundle.getString("SchedulerIMPL.substitutionCharacter.txt");
        String exp = m_bundle.getString("SchedulerIMPL.invalidFlowNameCharactersExpression.lcl");
        if (Character.isUnicodeIdentifierStart(s.charAt(0))) {
            s = subchar + s;
        }
        return s.replaceAll(exp, subchar);
    }

    public static String replaceInvalidCharactersInJobName(String s) {
        String exp = m_bundle.getString("SchedulerIMPL.invalidJobNameCharactersExpression.lcl");
        return s.replaceAll(exp, m_bundle.getString("SchedulerIMPL.substitutionCharacter.txt"));
    }

    @Override
    public abstract boolean isValidFlowName(String var1);

    @Override
    public String makeValidFlowname(String nameStr) {
        return MetaUtilities.makeValidFlowName(nameStr);
    }

    @Override
    public SchedulerServerInfo getServerComponent() {
        return this.m_schedulingServer;
    }

    @Override
    public boolean isConnectionNeededForTimeEvents() {
        return false;
    }

    @Override
    public boolean isConnectionNeededForAdvanceProperties() {
        return false;
    }

    @Override
    public boolean areQueues() {
        return false;
    }

    @Override
    public List<String> getQueues() {
        return null;
    }

    @Override
    public Calendar getCalendar(String schedulerCalenderName) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public String getCalendarName(IRecurrenceInfo info) {
        return info.toShortUniqueString() + "@SYS";
    }

    @Override
    public Calendar getCalendar(IRecurrenceInfo info) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public Calendar createCalendar(IRecurrenceInfo info) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public String getCalAdminID() {
        return null;
    }

    public Object getCalendarManager() {
        return null;
    }

    @Override
    public Calendar createCalendar(String calname, String expression) throws SchedulerException {
        return null;
    }

    @Override
    public List<Calendar> getCalendars() throws SchedulerException {
        return null;
    }

    @Override
    public boolean removeCalendar(Calendar cal) throws SchedulerException {
        return false;
    }

    @Override
    public boolean addCalendar(Calendar cal) throws SchedulerException {
        return false;
    }

    @Override
    public abstract String getClassId();

    @Override
    public int rescheduleFlow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException {
        return this.rescheduleFlow(flow, false);
    }

    @Override
    public int rescheduleFlow(FlowInfo flow, boolean errorOnDelete) throws SchedulerException, UnsupportedOperationException {
        int rc = 0;
        try {
            if (!this.removeFlow(flow)) {
                rc = 1;
            }
        }
        catch (UnsupportedOperationException ex) {
            if (this.scheduleFlow(flow)) {
                throw ex;
            }
            return 2;
        }
        catch (SchedulerException ex) {
            if (errorOnDelete) {
                throw ex;
            }
            rc = 1;
        }
        if (errorOnDelete && rc == 1) {
            return rc;
        }
        if (!this.scheduleFlow(flow)) {
            rc = 2;
        }
        if (rc == 0) {
            flow.setScheduledUserIdDataBinding(this.m_schedulingServer.getUsername());
        }
        return rc;
    }

    @Override
    public boolean scheduleFlow(FlowInfo flow) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public boolean scheduleFlowNow(FlowInfo flow) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public String runNowName(String flowname) {
        return flowname;
    }

    @Override
    public boolean removeFlow(String flowName) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public long getFlowInstance(FlowInfo flow) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public boolean killFlowInstance(FlowHistory flowInstance) throws SchedulerException {
        if (this instanceof IConsole) {
            return ((IConsole)((Object)this)).killFlowInstance(flowInstance.getInstanceName());
        }
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public boolean pauseFlowInstance(FlowHistory flowInstance) throws SchedulerException {
        if (this instanceof IConsole) {
            return ((IConsole)((Object)this)).pauseFlowInstance(flowInstance.getInstanceName());
        }
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public boolean resumeFlowInstance(FlowHistory flowInstance) throws SchedulerException {
        if (this instanceof IConsole) {
            return ((IConsole)((Object)this)).resumeFlowInstance(flowInstance.getInstanceName());
        }
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public int getMaxFlowHistoryCount() throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public FlowHistory getFlowHistory(DeployedFlow flow) throws SchedulerException {
        return this.getFlowHistory(flow.getInfo());
    }

    @Override
    public FlowHistory getFlowHistory(FlowInfo flow) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public List<FlowHistory> getAllFlowHistory() throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, int count) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(FlowInfo flow, int count) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, List<FlowInfo> flowList, int count) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(FlowInfo flow) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public Date getFinishTime(long id) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public Date getStartTime(long id) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public int getState(long id) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public int getStatus(long id) throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    @Override
    public abstract boolean isFlowScheduled(String var1);

    @Override
    public abstract boolean isFlowScheduled(FlowInfo var1);

    @Override
    public abstract boolean verifyFlowScheduled(FlowInfo var1) throws SchedulerException;

    @Override
    public abstract boolean isValidJobName(String var1);

    @Override
    public String makeValidJobName(String nameStr) {
        return MetaUtilities.makeValidJobName(nameStr);
    }

    @Override
    public abstract String getInvalidChars(boolean var1);

    @Override
    public char getSubstitutionChar() {
        return MetaUtilities.SUBCHAR;
    }

    @Override
    public int getMaxJobPriority() {
        return -1;
    }

    @Override
    public String genResourceSyntax(String resource) {
        return null;
    }

    @Override
    public boolean doesRunNowLeaveDefinition() throws InvalidParameterException {
        return false;
    }

    @Override
    public abstract boolean isHistorySupported() throws InvalidParameterException;

    @Override
    public boolean isDependenciesEnabled() throws InvalidParameterException {
        return this.isTimeDependenciesEnabled() || this.isFileDependenciesEnabled() || this.isJobDependenciesEnabled();
    }

    @Override
    public abstract boolean isJobDependenciesEnabled() throws InvalidParameterException;

    @Override
    public abstract boolean isTimeDependenciesEnabled() throws InvalidParameterException;

    @Override
    public abstract boolean isFileDependenciesEnabled() throws InvalidParameterException;

    public List<FlowInfo> getDeployedFlowsForServerComponent(MdObjectStore store) throws SchedulerException {
        return MetaUtilities.getDeployedFlowsForServerComponent(this.m_schedulingServer, store);
    }

    @Override
    public String clearJobPropertyOnMatch(String name, String schedulerDetails, String propertyName, String propertyValue) {
        return schedulerDetails;
    }

    protected boolean maketheConnection() throws SchedulerException {
        String userid = this.m_schedulingServer.getUsername();
        SealedString password = this.getSchServerInfoPasswordSealedString();
        if (userid == null || password == null) {
            try {
                PasswordAuthentication l = SchedulerIMPL.getLoginIdentity(this.getServerComponent());
                if (l != null) {
                    userid = l.getUserName();
                    try {
                        password = l.getPassword() != null ? new SealedString(SasPasswordString.encodeChars((char[])l.getPassword())) : null;
                    }
                    catch (SasPasswordEncodingException e) {
                        password = l.getPassword() != null ? new SealedString(l.getPassword()) : null;
                    }
                }
                return this.maketheConnection(userid, password);
            }
            catch (SchedulerException ex) {
                return false;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
        return this.maketheConnection(userid, password);
    }

    public static PasswordAuthentication getLoginIdentity(SchedulerServerInfo server) throws SchedulerException {
        return MetaUtilities.getLoginIdentity(server);
    }

    @Override
    public String genFlowName(FlowInfo info) {
        try {
            return this.genFlowName(info, this);
        }
        catch (SchedulerException se) {
            return info.getName();
        }
    }

    protected String genFlowName(FlowInfo info, Scheduler schedulingServer) throws SchedulerException {
        String flowname = info.getName();
        if (flowname.indexOf(":") <= 0) {
            String userid = info.getScheduledUser();
            if (userid == null) {
                userid = this.m_schedulingServer.getUsername();
            }
            if (userid != null && userid.length() > 0) {
                flowname = userid + ":" + flowname;
            } else {
                PasswordAuthentication l = null;
                l = SchedulerIMPL.getLoginIdentity(this.m_schedulingServer);
                if (l != null) {
                    userid = l.getUserName();
                    this.m_schedulingServer.setUsername(userid);
                    try {
                        this.m_schedulingServer.setPassword(String.valueOf(SasPasswordString.encodeChars((char[])l.getPassword())));
                    }
                    catch (SasPasswordEncodingException e) {
                        this.m_schedulingServer.setPassword(String.valueOf(l.getPassword()));
                    }
                    if (userid != null && userid.length() > 0) {
                        flowname = userid + ":" + flowname;
                    }
                }
            }
        }
        return flowname;
    }

    @Deprecated
    protected boolean maketheConnection(String user, String pass) throws SchedulerException {
        return this.maketheConnection(user, pass != null ? new SealedString(pass) : null);
    }

    protected boolean maketheConnection(String user, SealedString pass) throws SchedulerException {
        this.m_schedulingServer.setUsername(user);
        this.m_schedulingServer.setPassword(pass != null ? String.valueOf(pass.getCharacters()) : null);
        return this.__maketheconnection();
    }

    protected boolean __maketheconnection() throws SchedulerException {
        throw new SchedulerException("NOT IMPLEMENTED");
    }

    public SealedString getSchServerInfoPasswordSealedString() {
        return this.m_schedulingServer.getPassword() != null ? new SealedString(this.m_schedulingServer.getPassword()) : null;
    }

    static {
        String strClassName = SchedulerIMPL.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        INVALIDCHARACTERS = m_bundle.getString("SchedulerIMPL.invalidCharacters.lcl");
        INVALIDFILENAMECHARACTERS = m_bundle.getString("SchedulerIMPL.invalidFileNameCharacters.lcl");
        INVALIDFLOWNAMECHARACTERS = m_bundle.getString("SchedulerIMPL.invalidFlowNameCharacters.lcl");
        INVALIDJOBNAMECHARACTERS = m_bundle.getString("SchedulerIMPL.invalidJobNameCharacters.lcl");
        SUBCHAR = m_bundle.getString("SchedulerIMPL.substitutionCharacter.txt").charAt(0);
    }
}

