/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TransformationStep;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class EventListItem {
    private ArrayList<CMetadata> m_alMetadataObjects;
    private HashMap<String, Object> m_hmProperties;
    private String m_sDisplayName = "";
    private Event m_event;

    public EventListItem() {
        this.init();
    }

    public EventListItem(String sDisplayName) {
        if (sDisplayName != null) {
            this.m_sDisplayName = sDisplayName;
        }
        this.init();
    }

    private void init() {
        this.m_alMetadataObjects = new ArrayList(8);
        this.m_hmProperties = new HashMap(16);
    }

    public String toString() {
        return this.m_sDisplayName;
    }

    public void addMetadataObject(CMetadata object) {
        this.m_alMetadataObjects.add(object);
    }

    public ArrayList<CMetadata> getMetadataObjects() {
        return this.m_alMetadataObjects;
    }

    public void putProperty(String sName, Object value) {
        this.m_hmProperties.put(sName, value);
    }

    public Object getProperty(String sName) {
        return this.m_hmProperties.get(sName);
    }

    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    public String getDependencyID() {
        String id = null;
        try {
            Event cacheEvent = this.getEvent();
            if (cacheEvent != null) {
                id = cacheEvent.getCondition();
            } else {
                TransformationStep step = this.getTransformationStep();
                if (step != null) {
                    JFJob jfjob = (JFJob)step.getTransformations().get(0);
                    String jobID = jfjob != null ? jfjob.getFQID() : "";
                    id = this.m_sDisplayName + jobID;
                } else {
                    id = this.m_sDisplayName;
                }
            }
            return id;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.m_sDisplayName;
        }
        catch (RemoteException ex) {
            return this.m_sDisplayName;
        }
        catch (MdException ex) {
            return this.m_sDisplayName;
        }
    }

    public void setDisplayName(String sDisplayName) {
        this.m_sDisplayName = sDisplayName;
    }

    public String getCondition() throws RemoteException {
        if (this.m_event == null) {
            this.getEvent();
        }
        if (this.m_event != null) {
            return this.m_event.getCondition();
        }
        return null;
    }

    public boolean setCondition(String condition) throws RemoteException {
        if (this.m_event == null) {
            this.getEvent();
        }
        if (this.m_event != null) {
            this.m_event.setCondition(condition);
            return true;
        }
        return false;
    }

    public String getDescription() throws RemoteException {
        if (this.m_event == null) {
            this.getEvent();
        }
        if (this.m_event != null) {
            return this.m_event.getDesc();
        }
        return null;
    }

    public boolean setDescription(String description) throws RemoteException {
        if (this.m_event == null) {
            this.getEvent();
        }
        if (this.m_event != null) {
            this.m_event.setDesc(description);
            return true;
        }
        return false;
    }

    public Event getEvent() {
        Iterator<CMetadata> it = this.m_alMetadataObjects.iterator();
        Object event = null;
        while (it.hasNext() && event == null) {
            CMetadata obj = it.next();
            if (!(obj instanceof Event)) continue;
            this.m_event = (Event)obj;
        }
        return this.m_event;
    }

    public String getEventProperty(String name) throws RemoteException, MdException {
        if (this.m_event == null) {
            this.getEvent();
        }
        if (this.m_event != null) {
            return MetaUtilities.getProperty((Root)this.m_event, name);
        }
        return null;
    }

    public boolean setEventProperty(String name, String value) throws RemoteException, MdException {
        if (this.m_event == null) {
            this.getEvent();
        }
        if (this.m_event != null) {
            MdObjectStore store = (MdObjectStore)this.m_event.getObjectStore();
            MdFactory factory = store.getFactory();
            return MetaUtilities.setStringProperty((Root)this.m_event, name, factory, store, value) != null;
        }
        return false;
    }

    public TransformationStep getTransformationStep() {
        Iterator<CMetadata> it = this.m_alMetadataObjects.iterator();
        TransformationStep ts = null;
        while (it.hasNext() && ts == null) {
            CMetadata obj = it.next();
            if (!(obj instanceof TransformationStep)) continue;
            ts = (TransformationStep)obj;
        }
        return ts;
    }

    public SyncStep getSyncStep() {
        Iterator<CMetadata> it = this.m_alMetadataObjects.iterator();
        SyncStep ss = null;
        while (it.hasNext() && ss == null) {
            CMetadata obj = it.next();
            if (!(obj instanceof SyncStep)) continue;
            ss = (SyncStep)obj;
        }
        return ss;
    }

    public StepPrecedence getStepPrecedence() {
        Iterator<CMetadata> it = this.m_alMetadataObjects.iterator();
        StepPrecedence sp = null;
        while (it.hasNext() && sp == null) {
            CMetadata obj = it.next();
            if (!(obj instanceof StepPrecedence)) continue;
            sp = (StepPrecedence)obj;
        }
        return sp;
    }

    public boolean resetDependent(DeployedJob newstep, DeployedFlow flow) {
        try {
            StepPrecedence sp = this.getStepPrecedence();
            AssociationList list = sp.getPredecessors();
            list.removeAllElements();
            TransformationStep step = newstep.getLogicalJob(flow.getTA());
            list.add((Object)step);
        }
        catch (MdException ex) {
            return false;
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (RuntimeException ex) {
            return false;
        }
        return true;
    }

    public void deleteStepPrecedence() throws RemoteException {
        StepPrecedence sp = this.getStepPrecedence();
        if (sp != null) {
            this.m_alMetadataObjects.remove(sp);
            sp.delete();
        }
    }

    public void deleteSyncStep() throws RemoteException {
        SyncStep step = this.getSyncStep();
        if (step != null) {
            this.m_alMetadataObjects.remove(step);
            step.delete();
        }
    }

    public Property getProperty() {
        Iterator<CMetadata> it = this.m_alMetadataObjects.iterator();
        Property prop = null;
        while (it.hasNext() && prop == null) {
            CMetadata obj = it.next();
            if (!(obj instanceof Property)) continue;
            prop = (Property)obj;
        }
        return prop;
    }
}

